/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.domain.smartcontract;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import software.crldev.elrondspringbootstarterreactive.domain.account.Address;
import software.crldev.elrondspringbootstarterreactive.domain.common.Balance;
import software.crldev.elrondspringbootstarterreactive.domain.smartcontract.FunctionArgs;
import software.crldev.elrondspringbootstarterreactive.domain.smartcontract.FunctionName;

public final class ScQuery {
    @NonNull
    private final Address smartContractAddress;
    @NonNull
    private final FunctionName functionName;
    @NonNull
    private final FunctionArgs args;
    private final Address callerAddress;
    private final Balance value;

    public Sendable toSendable() {
        return Sendable.builder().smartContractAddress(this.smartContractAddress.getBech32()).functionName(this.functionName.getValue()).args(this.args.getValue().toArray(new String[0])).callerAddress(Objects.nonNull(this.callerAddress) ? this.callerAddress.getBech32() : null).value(Objects.nonNull(this.value) ? this.value.toString() : null).build();
    }

    @Generated
    ScQuery(@NonNull Address smartContractAddress, @NonNull FunctionName functionName, @NonNull FunctionArgs args, Address callerAddress, Balance value) {
        if (smartContractAddress == null) {
            throw new NullPointerException("smartContractAddress is marked non-null but is null");
        }
        if (functionName == null) {
            throw new NullPointerException("functionName is marked non-null but is null");
        }
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        this.smartContractAddress = smartContractAddress;
        this.functionName = functionName;
        this.args = args;
        this.callerAddress = callerAddress;
        this.value = value;
    }

    @Generated
    public static ScQueryBuilder builder() {
        return new ScQueryBuilder();
    }

    @NonNull
    @Generated
    public Address getSmartContractAddress() {
        return this.smartContractAddress;
    }

    @NonNull
    @Generated
    public FunctionName getFunctionName() {
        return this.functionName;
    }

    @NonNull
    @Generated
    public FunctionArgs getArgs() {
        return this.args;
    }

    @Generated
    public Address getCallerAddress() {
        return this.callerAddress;
    }

    @Generated
    public Balance getValue() {
        return this.value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScQuery)) {
            return false;
        }
        ScQuery other = (ScQuery)o;
        Address this$smartContractAddress = this.getSmartContractAddress();
        Address other$smartContractAddress = other.getSmartContractAddress();
        if (this$smartContractAddress == null ? other$smartContractAddress != null : !this$smartContractAddress.equals(other$smartContractAddress)) {
            return false;
        }
        FunctionName this$functionName = this.getFunctionName();
        FunctionName other$functionName = other.getFunctionName();
        if (this$functionName == null ? other$functionName != null : !((Object)this$functionName).equals(other$functionName)) {
            return false;
        }
        FunctionArgs this$args = this.getArgs();
        FunctionArgs other$args = other.getArgs();
        if (this$args == null ? other$args != null : !((Object)this$args).equals(other$args)) {
            return false;
        }
        Address this$callerAddress = this.getCallerAddress();
        Address other$callerAddress = other.getCallerAddress();
        if (this$callerAddress == null ? other$callerAddress != null : !this$callerAddress.equals(other$callerAddress)) {
            return false;
        }
        Balance this$value = this.getValue();
        Balance other$value = other.getValue();
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Address $smartContractAddress = this.getSmartContractAddress();
        result = result * 59 + ($smartContractAddress == null ? 43 : $smartContractAddress.hashCode());
        FunctionName $functionName = this.getFunctionName();
        result = result * 59 + ($functionName == null ? 43 : ((Object)$functionName).hashCode());
        FunctionArgs $args = this.getArgs();
        result = result * 59 + ($args == null ? 43 : ((Object)$args).hashCode());
        Address $callerAddress = this.getCallerAddress();
        result = result * 59 + ($callerAddress == null ? 43 : $callerAddress.hashCode());
        Balance $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ScQuery(smartContractAddress=" + this.getSmartContractAddress() + ", functionName=" + this.getFunctionName() + ", args=" + this.getArgs() + ", callerAddress=" + this.getCallerAddress() + ", value=" + this.getValue() + ")";
    }

    @Generated
    public static class ScQueryBuilder {
        @Generated
        private Address smartContractAddress;
        @Generated
        private FunctionName functionName;
        @Generated
        private FunctionArgs args;
        @Generated
        private Address callerAddress;
        @Generated
        private Balance value;

        @Generated
        ScQueryBuilder() {
        }

        @Generated
        public ScQueryBuilder smartContractAddress(@NonNull Address smartContractAddress) {
            if (smartContractAddress == null) {
                throw new NullPointerException("smartContractAddress is marked non-null but is null");
            }
            this.smartContractAddress = smartContractAddress;
            return this;
        }

        @Generated
        public ScQueryBuilder functionName(@NonNull FunctionName functionName) {
            if (functionName == null) {
                throw new NullPointerException("functionName is marked non-null but is null");
            }
            this.functionName = functionName;
            return this;
        }

        @Generated
        public ScQueryBuilder args(@NonNull FunctionArgs args) {
            if (args == null) {
                throw new NullPointerException("args is marked non-null but is null");
            }
            this.args = args;
            return this;
        }

        @Generated
        public ScQueryBuilder callerAddress(Address callerAddress) {
            this.callerAddress = callerAddress;
            return this;
        }

        @Generated
        public ScQueryBuilder value(Balance value) {
            this.value = value;
            return this;
        }

        @Generated
        public ScQuery build() {
            return new ScQuery(this.smartContractAddress, this.functionName, this.args, this.callerAddress, this.value);
        }

        @Generated
        public String toString() {
            return "ScQuery.ScQueryBuilder(smartContractAddress=" + this.smartContractAddress + ", functionName=" + this.functionName + ", args=" + this.args + ", callerAddress=" + this.callerAddress + ", value=" + this.value + ")";
        }
    }

    public static final class Sendable {
        @JsonProperty(value="scAddress")
        private final String smartContractAddress;
        @JsonProperty(value="funcName")
        private final String functionName;
        @JsonProperty(value="args")
        private final String[] args;
        @JsonProperty(value="caller")
        private final String callerAddress;
        @JsonProperty(value="value")
        private final String value;

        @Generated
        Sendable(String smartContractAddress, String functionName, String[] args, String callerAddress, String value) {
            this.smartContractAddress = smartContractAddress;
            this.functionName = functionName;
            this.args = args;
            this.callerAddress = callerAddress;
            this.value = value;
        }

        @Generated
        private static SendableBuilder builder() {
            return new SendableBuilder();
        }

        @Generated
        public String getSmartContractAddress() {
            return this.smartContractAddress;
        }

        @Generated
        public String getFunctionName() {
            return this.functionName;
        }

        @Generated
        public String[] getArgs() {
            return this.args;
        }

        @Generated
        public String getCallerAddress() {
            return this.callerAddress;
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Sendable)) {
                return false;
            }
            Sendable other = (Sendable)o;
            String this$smartContractAddress = this.getSmartContractAddress();
            String other$smartContractAddress = other.getSmartContractAddress();
            if (this$smartContractAddress == null ? other$smartContractAddress != null : !this$smartContractAddress.equals(other$smartContractAddress)) {
                return false;
            }
            String this$functionName = this.getFunctionName();
            String other$functionName = other.getFunctionName();
            if (this$functionName == null ? other$functionName != null : !this$functionName.equals(other$functionName)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getArgs(), other.getArgs())) {
                return false;
            }
            String this$callerAddress = this.getCallerAddress();
            String other$callerAddress = other.getCallerAddress();
            if (this$callerAddress == null ? other$callerAddress != null : !this$callerAddress.equals(other$callerAddress)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $smartContractAddress = this.getSmartContractAddress();
            result = result * 59 + ($smartContractAddress == null ? 43 : $smartContractAddress.hashCode());
            String $functionName = this.getFunctionName();
            result = result * 59 + ($functionName == null ? 43 : $functionName.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getArgs());
            String $callerAddress = this.getCallerAddress();
            result = result * 59 + ($callerAddress == null ? 43 : $callerAddress.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ScQuery.Sendable(smartContractAddress=" + this.getSmartContractAddress() + ", functionName=" + this.getFunctionName() + ", args=" + Arrays.deepToString(this.getArgs()) + ", callerAddress=" + this.getCallerAddress() + ", value=" + this.getValue() + ")";
        }

        @Generated
        private static class SendableBuilder {
            @Generated
            private String smartContractAddress;
            @Generated
            private String functionName;
            @Generated
            private String[] args;
            @Generated
            private String callerAddress;
            @Generated
            private String value;

            @Generated
            SendableBuilder() {
            }

            @JsonProperty(value="scAddress")
            @Generated
            private SendableBuilder smartContractAddress(String smartContractAddress) {
                this.smartContractAddress = smartContractAddress;
                return this;
            }

            @JsonProperty(value="funcName")
            @Generated
            private SendableBuilder functionName(String functionName) {
                this.functionName = functionName;
                return this;
            }

            @JsonProperty(value="args")
            @Generated
            private SendableBuilder args(String[] args) {
                this.args = args;
                return this;
            }

            @JsonProperty(value="caller")
            @Generated
            private SendableBuilder callerAddress(String callerAddress) {
                this.callerAddress = callerAddress;
                return this;
            }

            @JsonProperty(value="value")
            @Generated
            private SendableBuilder value(String value) {
                this.value = value;
                return this;
            }

            @Generated
            private Sendable build() {
                return new Sendable(this.smartContractAddress, this.functionName, this.args, this.callerAddress, this.value);
            }

            @Generated
            public String toString() {
                return "ScQuery.Sendable.SendableBuilder(smartContractAddress=" + this.smartContractAddress + ", functionName=" + this.functionName + ", args=" + Arrays.deepToString(this.args) + ", callerAddress=" + this.callerAddress + ", value=" + this.value + ")";
            }
        }
    }
}

