/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.domain.smartcontract;

import lombok.Generated;
import lombok.NonNull;
import software.crldev.elrondspringbootstarterreactive.domain.account.Address;
import software.crldev.elrondspringbootstarterreactive.domain.common.Balance;
import software.crldev.elrondspringbootstarterreactive.domain.smartcontract.FunctionArgs;
import software.crldev.elrondspringbootstarterreactive.domain.smartcontract.FunctionName;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.GasLimit;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.PayloadData;

public final class ScFunction {
    @NonNull
    private final Address smartContractAddress;
    @NonNull
    private final FunctionName functionName;
    @NonNull
    private final FunctionArgs args;
    private final Balance value;
    private final GasLimit gasLimit;

    public PayloadData getPayloadData() {
        return PayloadData.fromString(this.functionName + this.args.toString());
    }

    @Generated
    ScFunction(@NonNull Address smartContractAddress, @NonNull FunctionName functionName, @NonNull FunctionArgs args, Balance value, GasLimit gasLimit) {
        if (smartContractAddress == null) {
            throw new NullPointerException("smartContractAddress is marked non-null but is null");
        }
        if (functionName == null) {
            throw new NullPointerException("functionName is marked non-null but is null");
        }
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        this.smartContractAddress = smartContractAddress;
        this.functionName = functionName;
        this.args = args;
        this.value = value;
        this.gasLimit = gasLimit;
    }

    @Generated
    public static ScFunctionBuilder builder() {
        return new ScFunctionBuilder();
    }

    @NonNull
    @Generated
    public Address getSmartContractAddress() {
        return this.smartContractAddress;
    }

    @NonNull
    @Generated
    public FunctionName getFunctionName() {
        return this.functionName;
    }

    @NonNull
    @Generated
    public FunctionArgs getArgs() {
        return this.args;
    }

    @Generated
    public Balance getValue() {
        return this.value;
    }

    @Generated
    public GasLimit getGasLimit() {
        return this.gasLimit;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScFunction)) {
            return false;
        }
        ScFunction other = (ScFunction)o;
        Address this$smartContractAddress = this.getSmartContractAddress();
        Address other$smartContractAddress = other.getSmartContractAddress();
        if (this$smartContractAddress == null ? other$smartContractAddress != null : !this$smartContractAddress.equals(other$smartContractAddress)) {
            return false;
        }
        FunctionName this$functionName = this.getFunctionName();
        FunctionName other$functionName = other.getFunctionName();
        if (this$functionName == null ? other$functionName != null : !((Object)this$functionName).equals(other$functionName)) {
            return false;
        }
        FunctionArgs this$args = this.getArgs();
        FunctionArgs other$args = other.getArgs();
        if (this$args == null ? other$args != null : !((Object)this$args).equals(other$args)) {
            return false;
        }
        Balance this$value = this.getValue();
        Balance other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        GasLimit this$gasLimit = this.getGasLimit();
        GasLimit other$gasLimit = other.getGasLimit();
        return !(this$gasLimit == null ? other$gasLimit != null : !((Object)this$gasLimit).equals(other$gasLimit));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Address $smartContractAddress = this.getSmartContractAddress();
        result = result * 59 + ($smartContractAddress == null ? 43 : $smartContractAddress.hashCode());
        FunctionName $functionName = this.getFunctionName();
        result = result * 59 + ($functionName == null ? 43 : ((Object)$functionName).hashCode());
        FunctionArgs $args = this.getArgs();
        result = result * 59 + ($args == null ? 43 : ((Object)$args).hashCode());
        Balance $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        GasLimit $gasLimit = this.getGasLimit();
        result = result * 59 + ($gasLimit == null ? 43 : ((Object)$gasLimit).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ScFunction(smartContractAddress=" + this.getSmartContractAddress() + ", functionName=" + this.getFunctionName() + ", args=" + this.getArgs() + ", value=" + this.getValue() + ", gasLimit=" + this.getGasLimit() + ")";
    }

    @Generated
    public static class ScFunctionBuilder {
        @Generated
        private Address smartContractAddress;
        @Generated
        private FunctionName functionName;
        @Generated
        private FunctionArgs args;
        @Generated
        private Balance value;
        @Generated
        private GasLimit gasLimit;

        @Generated
        ScFunctionBuilder() {
        }

        @Generated
        public ScFunctionBuilder smartContractAddress(@NonNull Address smartContractAddress) {
            if (smartContractAddress == null) {
                throw new NullPointerException("smartContractAddress is marked non-null but is null");
            }
            this.smartContractAddress = smartContractAddress;
            return this;
        }

        @Generated
        public ScFunctionBuilder functionName(@NonNull FunctionName functionName) {
            if (functionName == null) {
                throw new NullPointerException("functionName is marked non-null but is null");
            }
            this.functionName = functionName;
            return this;
        }

        @Generated
        public ScFunctionBuilder args(@NonNull FunctionArgs args) {
            if (args == null) {
                throw new NullPointerException("args is marked non-null but is null");
            }
            this.args = args;
            return this;
        }

        @Generated
        public ScFunctionBuilder value(Balance value) {
            this.value = value;
            return this;
        }

        @Generated
        public ScFunctionBuilder gasLimit(GasLimit gasLimit) {
            this.gasLimit = gasLimit;
            return this;
        }

        @Generated
        public ScFunction build() {
            return new ScFunction(this.smartContractAddress, this.functionName, this.args, this.value, this.gasLimit);
        }

        @Generated
        public String toString() {
            return "ScFunction.ScFunctionBuilder(smartContractAddress=" + this.smartContractAddress + ", functionName=" + this.functionName + ", args=" + this.args + ", value=" + this.value + ", gasLimit=" + this.gasLimit + ")";
        }
    }
}

