/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.math.BigInteger;
import java.util.List;
import lombok.Generated;
import software.crldev.elrondspringbootstarterreactive.api.model.Receipt;
import software.crldev.elrondspringbootstarterreactive.api.model.SmartContractResult;
import software.crldev.elrondspringbootstarterreactive.domain.ApiModelToDomainConvertible;
import software.crldev.elrondspringbootstarterreactive.domain.account.Address;
import software.crldev.elrondspringbootstarterreactive.domain.common.Balance;
import software.crldev.elrondspringbootstarterreactive.domain.common.Nonce;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.GasLimit;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.GasPrice;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.Hash;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.PayloadData;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.Signature;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.Transaction;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.TransactionStatus;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=TransactionOnNetworkBuilder.class)
public final class TransactionOnNetwork
implements ApiModelToDomainConvertible<Transaction> {
    @JsonProperty(value="type")
    private final String type;
    @JsonProperty(value="nonce")
    private final Long nonce;
    @JsonProperty(value="round")
    private final Long round;
    @JsonProperty(value="epoch")
    private final Long epoch;
    @JsonProperty(value="value")
    private final BigInteger value;
    @JsonProperty(value="receiver")
    private final String receiver;
    @JsonProperty(value="sender")
    private final String sender;
    @JsonProperty(value="gasPrice")
    private final BigInteger gasPrice;
    @JsonProperty(value="gasLimit")
    private final BigInteger gasLimit;
    @JsonProperty(value="data")
    private final String data;
    @JsonProperty(value="signature")
    private final String signature;
    @JsonProperty(value="sourceShard")
    private final Long sourceShard;
    @JsonProperty(value="destinationShard")
    private final Long destinationShard;
    @JsonProperty(value="blockNonce")
    private final Integer blockNonce;
    @JsonProperty(value="blockHash")
    private final String blockHash;
    @JsonProperty(value="notarizedAtSourceInMetaNonce")
    private final Long notarizedAtSourceInMetaNonce;
    @JsonProperty(value="NotarizedAtSourceInMetaHash")
    private final String notarizedAtSourceInMetaHash;
    @JsonProperty(value="notarizedAtDestinationInMetaNonce")
    private final Long notarizedAtDestinationInMetaNonce;
    @JsonProperty(value="notarizedAtDestinationInMetaHash")
    private final String notarizedAtDestinationInMetaHash;
    @JsonProperty(value="miniblockType")
    private final String miniblockType;
    @JsonProperty(value="miniblockHash")
    private final String miniblockHash;
    @JsonProperty(value="timestamp")
    private final Long timestamp;
    @JsonProperty(value="status")
    private final String status;
    @JsonProperty(value="hyperblockNonce")
    private final Long hyperblockNonce;
    @JsonProperty(value="hyperblockHash")
    private final String hyperblockHash;
    @JsonProperty(value="receipt")
    private final Receipt receipt;
    @JsonProperty(value="smartContractResults")
    private final List<SmartContractResult> smartContractResults;
    @JsonProperty(value="logs")
    private final Logs logs;

    @Override
    public Transaction toDomainObject() {
        Transaction transaction = new Transaction();
        transaction.setReceiver(Address.fromBech32(this.getReceiver()));
        transaction.setSender(Address.fromBech32(this.getSender()));
        transaction.setValue(Balance.fromNumber(this.getValue()));
        transaction.setNonce(Nonce.fromLong(this.getNonce()));
        transaction.setGasPrice(GasPrice.fromNumber(this.getGasPrice()));
        transaction.setGasLimit(GasLimit.fromNumber(this.getGasLimit()));
        transaction.setHash(Hash.fromString(this.getBlockHash()));
        transaction.setPayloadData(PayloadData.fromEncoded(this.getData()));
        transaction.applySignature(Signature.fromHex(this.getSignature()));
        transaction.setStatus(TransactionStatus.fromString(this.getStatus()));
        return transaction;
    }

    @Generated
    TransactionOnNetwork(String type, Long nonce, Long round, Long epoch, BigInteger value, String receiver, String sender, BigInteger gasPrice, BigInteger gasLimit, String data, String signature, Long sourceShard, Long destinationShard, Integer blockNonce, String blockHash, Long notarizedAtSourceInMetaNonce, String notarizedAtSourceInMetaHash, Long notarizedAtDestinationInMetaNonce, String notarizedAtDestinationInMetaHash, String miniblockType, String miniblockHash, Long timestamp, String status, Long hyperblockNonce, String hyperblockHash, Receipt receipt, List<SmartContractResult> smartContractResults, Logs logs) {
        this.type = type;
        this.nonce = nonce;
        this.round = round;
        this.epoch = epoch;
        this.value = value;
        this.receiver = receiver;
        this.sender = sender;
        this.gasPrice = gasPrice;
        this.gasLimit = gasLimit;
        this.data = data;
        this.signature = signature;
        this.sourceShard = sourceShard;
        this.destinationShard = destinationShard;
        this.blockNonce = blockNonce;
        this.blockHash = blockHash;
        this.notarizedAtSourceInMetaNonce = notarizedAtSourceInMetaNonce;
        this.notarizedAtSourceInMetaHash = notarizedAtSourceInMetaHash;
        this.notarizedAtDestinationInMetaNonce = notarizedAtDestinationInMetaNonce;
        this.notarizedAtDestinationInMetaHash = notarizedAtDestinationInMetaHash;
        this.miniblockType = miniblockType;
        this.miniblockHash = miniblockHash;
        this.timestamp = timestamp;
        this.status = status;
        this.hyperblockNonce = hyperblockNonce;
        this.hyperblockHash = hyperblockHash;
        this.receipt = receipt;
        this.smartContractResults = smartContractResults;
        this.logs = logs;
    }

    @Generated
    public static TransactionOnNetworkBuilder builder() {
        return new TransactionOnNetworkBuilder();
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Long getNonce() {
        return this.nonce;
    }

    @Generated
    public Long getRound() {
        return this.round;
    }

    @Generated
    public Long getEpoch() {
        return this.epoch;
    }

    @Generated
    public BigInteger getValue() {
        return this.value;
    }

    @Generated
    public String getReceiver() {
        return this.receiver;
    }

    @Generated
    public String getSender() {
        return this.sender;
    }

    @Generated
    public BigInteger getGasPrice() {
        return this.gasPrice;
    }

    @Generated
    public BigInteger getGasLimit() {
        return this.gasLimit;
    }

    @Generated
    public String getData() {
        return this.data;
    }

    @Generated
    public String getSignature() {
        return this.signature;
    }

    @Generated
    public Long getSourceShard() {
        return this.sourceShard;
    }

    @Generated
    public Long getDestinationShard() {
        return this.destinationShard;
    }

    @Generated
    public Integer getBlockNonce() {
        return this.blockNonce;
    }

    @Generated
    public String getBlockHash() {
        return this.blockHash;
    }

    @Generated
    public Long getNotarizedAtSourceInMetaNonce() {
        return this.notarizedAtSourceInMetaNonce;
    }

    @Generated
    public String getNotarizedAtSourceInMetaHash() {
        return this.notarizedAtSourceInMetaHash;
    }

    @Generated
    public Long getNotarizedAtDestinationInMetaNonce() {
        return this.notarizedAtDestinationInMetaNonce;
    }

    @Generated
    public String getNotarizedAtDestinationInMetaHash() {
        return this.notarizedAtDestinationInMetaHash;
    }

    @Generated
    public String getMiniblockType() {
        return this.miniblockType;
    }

    @Generated
    public String getMiniblockHash() {
        return this.miniblockHash;
    }

    @Generated
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public Long getHyperblockNonce() {
        return this.hyperblockNonce;
    }

    @Generated
    public String getHyperblockHash() {
        return this.hyperblockHash;
    }

    @Generated
    public Receipt getReceipt() {
        return this.receipt;
    }

    @Generated
    public List<SmartContractResult> getSmartContractResults() {
        return this.smartContractResults;
    }

    @Generated
    public Logs getLogs() {
        return this.logs;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionOnNetwork)) {
            return false;
        }
        TransactionOnNetwork other = (TransactionOnNetwork)o;
        Long this$nonce = this.getNonce();
        Long other$nonce = other.getNonce();
        if (this$nonce == null ? other$nonce != null : !((Object)this$nonce).equals(other$nonce)) {
            return false;
        }
        Long this$round = this.getRound();
        Long other$round = other.getRound();
        if (this$round == null ? other$round != null : !((Object)this$round).equals(other$round)) {
            return false;
        }
        Long this$epoch = this.getEpoch();
        Long other$epoch = other.getEpoch();
        if (this$epoch == null ? other$epoch != null : !((Object)this$epoch).equals(other$epoch)) {
            return false;
        }
        Long this$sourceShard = this.getSourceShard();
        Long other$sourceShard = other.getSourceShard();
        if (this$sourceShard == null ? other$sourceShard != null : !((Object)this$sourceShard).equals(other$sourceShard)) {
            return false;
        }
        Long this$destinationShard = this.getDestinationShard();
        Long other$destinationShard = other.getDestinationShard();
        if (this$destinationShard == null ? other$destinationShard != null : !((Object)this$destinationShard).equals(other$destinationShard)) {
            return false;
        }
        Integer this$blockNonce = this.getBlockNonce();
        Integer other$blockNonce = other.getBlockNonce();
        if (this$blockNonce == null ? other$blockNonce != null : !((Object)this$blockNonce).equals(other$blockNonce)) {
            return false;
        }
        Long this$notarizedAtSourceInMetaNonce = this.getNotarizedAtSourceInMetaNonce();
        Long other$notarizedAtSourceInMetaNonce = other.getNotarizedAtSourceInMetaNonce();
        if (this$notarizedAtSourceInMetaNonce == null ? other$notarizedAtSourceInMetaNonce != null : !((Object)this$notarizedAtSourceInMetaNonce).equals(other$notarizedAtSourceInMetaNonce)) {
            return false;
        }
        Long this$notarizedAtDestinationInMetaNonce = this.getNotarizedAtDestinationInMetaNonce();
        Long other$notarizedAtDestinationInMetaNonce = other.getNotarizedAtDestinationInMetaNonce();
        if (this$notarizedAtDestinationInMetaNonce == null ? other$notarizedAtDestinationInMetaNonce != null : !((Object)this$notarizedAtDestinationInMetaNonce).equals(other$notarizedAtDestinationInMetaNonce)) {
            return false;
        }
        Long this$timestamp = this.getTimestamp();
        Long other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        Long this$hyperblockNonce = this.getHyperblockNonce();
        Long other$hyperblockNonce = other.getHyperblockNonce();
        if (this$hyperblockNonce == null ? other$hyperblockNonce != null : !((Object)this$hyperblockNonce).equals(other$hyperblockNonce)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        BigInteger this$value = this.getValue();
        BigInteger other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        String this$receiver = this.getReceiver();
        String other$receiver = other.getReceiver();
        if (this$receiver == null ? other$receiver != null : !this$receiver.equals(other$receiver)) {
            return false;
        }
        String this$sender = this.getSender();
        String other$sender = other.getSender();
        if (this$sender == null ? other$sender != null : !this$sender.equals(other$sender)) {
            return false;
        }
        BigInteger this$gasPrice = this.getGasPrice();
        BigInteger other$gasPrice = other.getGasPrice();
        if (this$gasPrice == null ? other$gasPrice != null : !((Object)this$gasPrice).equals(other$gasPrice)) {
            return false;
        }
        BigInteger this$gasLimit = this.getGasLimit();
        BigInteger other$gasLimit = other.getGasLimit();
        if (this$gasLimit == null ? other$gasLimit != null : !((Object)this$gasLimit).equals(other$gasLimit)) {
            return false;
        }
        String this$data = this.getData();
        String other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$signature = this.getSignature();
        String other$signature = other.getSignature();
        if (this$signature == null ? other$signature != null : !this$signature.equals(other$signature)) {
            return false;
        }
        String this$blockHash = this.getBlockHash();
        String other$blockHash = other.getBlockHash();
        if (this$blockHash == null ? other$blockHash != null : !this$blockHash.equals(other$blockHash)) {
            return false;
        }
        String this$notarizedAtSourceInMetaHash = this.getNotarizedAtSourceInMetaHash();
        String other$notarizedAtSourceInMetaHash = other.getNotarizedAtSourceInMetaHash();
        if (this$notarizedAtSourceInMetaHash == null ? other$notarizedAtSourceInMetaHash != null : !this$notarizedAtSourceInMetaHash.equals(other$notarizedAtSourceInMetaHash)) {
            return false;
        }
        String this$notarizedAtDestinationInMetaHash = this.getNotarizedAtDestinationInMetaHash();
        String other$notarizedAtDestinationInMetaHash = other.getNotarizedAtDestinationInMetaHash();
        if (this$notarizedAtDestinationInMetaHash == null ? other$notarizedAtDestinationInMetaHash != null : !this$notarizedAtDestinationInMetaHash.equals(other$notarizedAtDestinationInMetaHash)) {
            return false;
        }
        String this$miniblockType = this.getMiniblockType();
        String other$miniblockType = other.getMiniblockType();
        if (this$miniblockType == null ? other$miniblockType != null : !this$miniblockType.equals(other$miniblockType)) {
            return false;
        }
        String this$miniblockHash = this.getMiniblockHash();
        String other$miniblockHash = other.getMiniblockHash();
        if (this$miniblockHash == null ? other$miniblockHash != null : !this$miniblockHash.equals(other$miniblockHash)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$hyperblockHash = this.getHyperblockHash();
        String other$hyperblockHash = other.getHyperblockHash();
        if (this$hyperblockHash == null ? other$hyperblockHash != null : !this$hyperblockHash.equals(other$hyperblockHash)) {
            return false;
        }
        Receipt this$receipt = this.getReceipt();
        Receipt other$receipt = other.getReceipt();
        if (this$receipt == null ? other$receipt != null : !((Object)this$receipt).equals(other$receipt)) {
            return false;
        }
        List<SmartContractResult> this$smartContractResults = this.getSmartContractResults();
        List<SmartContractResult> other$smartContractResults = other.getSmartContractResults();
        if (this$smartContractResults == null ? other$smartContractResults != null : !((Object)this$smartContractResults).equals(other$smartContractResults)) {
            return false;
        }
        Logs this$logs = this.getLogs();
        Logs other$logs = other.getLogs();
        return !(this$logs == null ? other$logs != null : !this$logs.equals(other$logs));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $nonce = this.getNonce();
        result = result * 59 + ($nonce == null ? 43 : ((Object)$nonce).hashCode());
        Long $round = this.getRound();
        result = result * 59 + ($round == null ? 43 : ((Object)$round).hashCode());
        Long $epoch = this.getEpoch();
        result = result * 59 + ($epoch == null ? 43 : ((Object)$epoch).hashCode());
        Long $sourceShard = this.getSourceShard();
        result = result * 59 + ($sourceShard == null ? 43 : ((Object)$sourceShard).hashCode());
        Long $destinationShard = this.getDestinationShard();
        result = result * 59 + ($destinationShard == null ? 43 : ((Object)$destinationShard).hashCode());
        Integer $blockNonce = this.getBlockNonce();
        result = result * 59 + ($blockNonce == null ? 43 : ((Object)$blockNonce).hashCode());
        Long $notarizedAtSourceInMetaNonce = this.getNotarizedAtSourceInMetaNonce();
        result = result * 59 + ($notarizedAtSourceInMetaNonce == null ? 43 : ((Object)$notarizedAtSourceInMetaNonce).hashCode());
        Long $notarizedAtDestinationInMetaNonce = this.getNotarizedAtDestinationInMetaNonce();
        result = result * 59 + ($notarizedAtDestinationInMetaNonce == null ? 43 : ((Object)$notarizedAtDestinationInMetaNonce).hashCode());
        Long $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        Long $hyperblockNonce = this.getHyperblockNonce();
        result = result * 59 + ($hyperblockNonce == null ? 43 : ((Object)$hyperblockNonce).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        BigInteger $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        String $receiver = this.getReceiver();
        result = result * 59 + ($receiver == null ? 43 : $receiver.hashCode());
        String $sender = this.getSender();
        result = result * 59 + ($sender == null ? 43 : $sender.hashCode());
        BigInteger $gasPrice = this.getGasPrice();
        result = result * 59 + ($gasPrice == null ? 43 : ((Object)$gasPrice).hashCode());
        BigInteger $gasLimit = this.getGasLimit();
        result = result * 59 + ($gasLimit == null ? 43 : ((Object)$gasLimit).hashCode());
        String $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
        String $blockHash = this.getBlockHash();
        result = result * 59 + ($blockHash == null ? 43 : $blockHash.hashCode());
        String $notarizedAtSourceInMetaHash = this.getNotarizedAtSourceInMetaHash();
        result = result * 59 + ($notarizedAtSourceInMetaHash == null ? 43 : $notarizedAtSourceInMetaHash.hashCode());
        String $notarizedAtDestinationInMetaHash = this.getNotarizedAtDestinationInMetaHash();
        result = result * 59 + ($notarizedAtDestinationInMetaHash == null ? 43 : $notarizedAtDestinationInMetaHash.hashCode());
        String $miniblockType = this.getMiniblockType();
        result = result * 59 + ($miniblockType == null ? 43 : $miniblockType.hashCode());
        String $miniblockHash = this.getMiniblockHash();
        result = result * 59 + ($miniblockHash == null ? 43 : $miniblockHash.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $hyperblockHash = this.getHyperblockHash();
        result = result * 59 + ($hyperblockHash == null ? 43 : $hyperblockHash.hashCode());
        Receipt $receipt = this.getReceipt();
        result = result * 59 + ($receipt == null ? 43 : ((Object)$receipt).hashCode());
        List<SmartContractResult> $smartContractResults = this.getSmartContractResults();
        result = result * 59 + ($smartContractResults == null ? 43 : ((Object)$smartContractResults).hashCode());
        Logs $logs = this.getLogs();
        result = result * 59 + ($logs == null ? 43 : $logs.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TransactionOnNetwork(type=" + this.getType() + ", nonce=" + this.getNonce() + ", round=" + this.getRound() + ", epoch=" + this.getEpoch() + ", value=" + this.getValue() + ", receiver=" + this.getReceiver() + ", sender=" + this.getSender() + ", gasPrice=" + this.getGasPrice() + ", gasLimit=" + this.getGasLimit() + ", data=" + this.getData() + ", signature=" + this.getSignature() + ", sourceShard=" + this.getSourceShard() + ", destinationShard=" + this.getDestinationShard() + ", blockNonce=" + this.getBlockNonce() + ", blockHash=" + this.getBlockHash() + ", notarizedAtSourceInMetaNonce=" + this.getNotarizedAtSourceInMetaNonce() + ", notarizedAtSourceInMetaHash=" + this.getNotarizedAtSourceInMetaHash() + ", notarizedAtDestinationInMetaNonce=" + this.getNotarizedAtDestinationInMetaNonce() + ", notarizedAtDestinationInMetaHash=" + this.getNotarizedAtDestinationInMetaHash() + ", miniblockType=" + this.getMiniblockType() + ", miniblockHash=" + this.getMiniblockHash() + ", timestamp=" + this.getTimestamp() + ", status=" + this.getStatus() + ", hyperblockNonce=" + this.getHyperblockNonce() + ", hyperblockHash=" + this.getHyperblockHash() + ", receipt=" + this.getReceipt() + ", smartContractResults=" + this.getSmartContractResults() + ", logs=" + this.getLogs() + ")";
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class TransactionOnNetworkBuilder {
        @Generated
        private String type;
        @Generated
        private Long nonce;
        @Generated
        private Long round;
        @Generated
        private Long epoch;
        @Generated
        private BigInteger value;
        @Generated
        private String receiver;
        @Generated
        private String sender;
        @Generated
        private BigInteger gasPrice;
        @Generated
        private BigInteger gasLimit;
        @Generated
        private String data;
        @Generated
        private String signature;
        @Generated
        private Long sourceShard;
        @Generated
        private Long destinationShard;
        @Generated
        private Integer blockNonce;
        @Generated
        private String blockHash;
        @Generated
        private Long notarizedAtSourceInMetaNonce;
        @Generated
        private String notarizedAtSourceInMetaHash;
        @Generated
        private Long notarizedAtDestinationInMetaNonce;
        @Generated
        private String notarizedAtDestinationInMetaHash;
        @Generated
        private String miniblockType;
        @Generated
        private String miniblockHash;
        @Generated
        private Long timestamp;
        @Generated
        private String status;
        @Generated
        private Long hyperblockNonce;
        @Generated
        private String hyperblockHash;
        @Generated
        private Receipt receipt;
        @Generated
        private List<SmartContractResult> smartContractResults;
        @Generated
        private Logs logs;

        @Generated
        TransactionOnNetworkBuilder() {
        }

        @JsonProperty(value="type")
        @Generated
        public TransactionOnNetworkBuilder type(String type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="nonce")
        @Generated
        public TransactionOnNetworkBuilder nonce(Long nonce) {
            this.nonce = nonce;
            return this;
        }

        @JsonProperty(value="round")
        @Generated
        public TransactionOnNetworkBuilder round(Long round) {
            this.round = round;
            return this;
        }

        @JsonProperty(value="epoch")
        @Generated
        public TransactionOnNetworkBuilder epoch(Long epoch) {
            this.epoch = epoch;
            return this;
        }

        @JsonProperty(value="value")
        @Generated
        public TransactionOnNetworkBuilder value(BigInteger value) {
            this.value = value;
            return this;
        }

        @JsonProperty(value="receiver")
        @Generated
        public TransactionOnNetworkBuilder receiver(String receiver) {
            this.receiver = receiver;
            return this;
        }

        @JsonProperty(value="sender")
        @Generated
        public TransactionOnNetworkBuilder sender(String sender) {
            this.sender = sender;
            return this;
        }

        @JsonProperty(value="gasPrice")
        @Generated
        public TransactionOnNetworkBuilder gasPrice(BigInteger gasPrice) {
            this.gasPrice = gasPrice;
            return this;
        }

        @JsonProperty(value="gasLimit")
        @Generated
        public TransactionOnNetworkBuilder gasLimit(BigInteger gasLimit) {
            this.gasLimit = gasLimit;
            return this;
        }

        @JsonProperty(value="data")
        @Generated
        public TransactionOnNetworkBuilder data(String data) {
            this.data = data;
            return this;
        }

        @JsonProperty(value="signature")
        @Generated
        public TransactionOnNetworkBuilder signature(String signature) {
            this.signature = signature;
            return this;
        }

        @JsonProperty(value="sourceShard")
        @Generated
        public TransactionOnNetworkBuilder sourceShard(Long sourceShard) {
            this.sourceShard = sourceShard;
            return this;
        }

        @JsonProperty(value="destinationShard")
        @Generated
        public TransactionOnNetworkBuilder destinationShard(Long destinationShard) {
            this.destinationShard = destinationShard;
            return this;
        }

        @JsonProperty(value="blockNonce")
        @Generated
        public TransactionOnNetworkBuilder blockNonce(Integer blockNonce) {
            this.blockNonce = blockNonce;
            return this;
        }

        @JsonProperty(value="blockHash")
        @Generated
        public TransactionOnNetworkBuilder blockHash(String blockHash) {
            this.blockHash = blockHash;
            return this;
        }

        @JsonProperty(value="notarizedAtSourceInMetaNonce")
        @Generated
        public TransactionOnNetworkBuilder notarizedAtSourceInMetaNonce(Long notarizedAtSourceInMetaNonce) {
            this.notarizedAtSourceInMetaNonce = notarizedAtSourceInMetaNonce;
            return this;
        }

        @JsonProperty(value="NotarizedAtSourceInMetaHash")
        @Generated
        public TransactionOnNetworkBuilder notarizedAtSourceInMetaHash(String notarizedAtSourceInMetaHash) {
            this.notarizedAtSourceInMetaHash = notarizedAtSourceInMetaHash;
            return this;
        }

        @JsonProperty(value="notarizedAtDestinationInMetaNonce")
        @Generated
        public TransactionOnNetworkBuilder notarizedAtDestinationInMetaNonce(Long notarizedAtDestinationInMetaNonce) {
            this.notarizedAtDestinationInMetaNonce = notarizedAtDestinationInMetaNonce;
            return this;
        }

        @JsonProperty(value="notarizedAtDestinationInMetaHash")
        @Generated
        public TransactionOnNetworkBuilder notarizedAtDestinationInMetaHash(String notarizedAtDestinationInMetaHash) {
            this.notarizedAtDestinationInMetaHash = notarizedAtDestinationInMetaHash;
            return this;
        }

        @JsonProperty(value="miniblockType")
        @Generated
        public TransactionOnNetworkBuilder miniblockType(String miniblockType) {
            this.miniblockType = miniblockType;
            return this;
        }

        @JsonProperty(value="miniblockHash")
        @Generated
        public TransactionOnNetworkBuilder miniblockHash(String miniblockHash) {
            this.miniblockHash = miniblockHash;
            return this;
        }

        @JsonProperty(value="timestamp")
        @Generated
        public TransactionOnNetworkBuilder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @JsonProperty(value="status")
        @Generated
        public TransactionOnNetworkBuilder status(String status) {
            this.status = status;
            return this;
        }

        @JsonProperty(value="hyperblockNonce")
        @Generated
        public TransactionOnNetworkBuilder hyperblockNonce(Long hyperblockNonce) {
            this.hyperblockNonce = hyperblockNonce;
            return this;
        }

        @JsonProperty(value="hyperblockHash")
        @Generated
        public TransactionOnNetworkBuilder hyperblockHash(String hyperblockHash) {
            this.hyperblockHash = hyperblockHash;
            return this;
        }

        @JsonProperty(value="receipt")
        @Generated
        public TransactionOnNetworkBuilder receipt(Receipt receipt) {
            this.receipt = receipt;
            return this;
        }

        @JsonProperty(value="smartContractResults")
        @Generated
        public TransactionOnNetworkBuilder smartContractResults(List<SmartContractResult> smartContractResults) {
            this.smartContractResults = smartContractResults;
            return this;
        }

        @JsonProperty(value="logs")
        @Generated
        public TransactionOnNetworkBuilder logs(Logs logs) {
            this.logs = logs;
            return this;
        }

        @Generated
        public TransactionOnNetwork build() {
            return new TransactionOnNetwork(this.type, this.nonce, this.round, this.epoch, this.value, this.receiver, this.sender, this.gasPrice, this.gasLimit, this.data, this.signature, this.sourceShard, this.destinationShard, this.blockNonce, this.blockHash, this.notarizedAtSourceInMetaNonce, this.notarizedAtSourceInMetaHash, this.notarizedAtDestinationInMetaNonce, this.notarizedAtDestinationInMetaHash, this.miniblockType, this.miniblockHash, this.timestamp, this.status, this.hyperblockNonce, this.hyperblockHash, this.receipt, this.smartContractResults, this.logs);
        }

        @Generated
        public String toString() {
            return "TransactionOnNetwork.TransactionOnNetworkBuilder(type=" + this.type + ", nonce=" + this.nonce + ", round=" + this.round + ", epoch=" + this.epoch + ", value=" + this.value + ", receiver=" + this.receiver + ", sender=" + this.sender + ", gasPrice=" + this.gasPrice + ", gasLimit=" + this.gasLimit + ", data=" + this.data + ", signature=" + this.signature + ", sourceShard=" + this.sourceShard + ", destinationShard=" + this.destinationShard + ", blockNonce=" + this.blockNonce + ", blockHash=" + this.blockHash + ", notarizedAtSourceInMetaNonce=" + this.notarizedAtSourceInMetaNonce + ", notarizedAtSourceInMetaHash=" + this.notarizedAtSourceInMetaHash + ", notarizedAtDestinationInMetaNonce=" + this.notarizedAtDestinationInMetaNonce + ", notarizedAtDestinationInMetaHash=" + this.notarizedAtDestinationInMetaHash + ", miniblockType=" + this.miniblockType + ", miniblockHash=" + this.miniblockHash + ", timestamp=" + this.timestamp + ", status=" + this.status + ", hyperblockNonce=" + this.hyperblockNonce + ", hyperblockHash=" + this.hyperblockHash + ", receipt=" + this.receipt + ", smartContractResults=" + this.smartContractResults + ", logs=" + this.logs + ")";
        }
    }

    @JsonDeserialize(builder=EventBuilder.class)
    private static class Event {
        @JsonProperty(value="address")
        String address;
        @JsonProperty(value="identifier")
        String identifier;
        @JsonProperty(value="topics")
        List<String> topics;

        @Generated
        Event(String address, String identifier, List<String> topics) {
            this.address = address;
            this.identifier = identifier;
            this.topics = topics;
        }

        @Generated
        public static EventBuilder builder() {
            return new EventBuilder();
        }

        @Generated
        public static class EventBuilder {
            @Generated
            private String address;
            @Generated
            private String identifier;
            @Generated
            private List<String> topics;

            @Generated
            EventBuilder() {
            }

            @JsonProperty(value="address")
            @Generated
            public EventBuilder address(String address) {
                this.address = address;
                return this;
            }

            @JsonProperty(value="identifier")
            @Generated
            public EventBuilder identifier(String identifier) {
                this.identifier = identifier;
                return this;
            }

            @JsonProperty(value="topics")
            @Generated
            public EventBuilder topics(List<String> topics) {
                this.topics = topics;
                return this;
            }

            @Generated
            public Event build() {
                return new Event(this.address, this.identifier, this.topics);
            }

            @Generated
            public String toString() {
                return "TransactionOnNetwork.Event.EventBuilder(address=" + this.address + ", identifier=" + this.identifier + ", topics=" + this.topics + ")";
            }
        }
    }

    @JsonDeserialize(builder=LogsBuilder.class)
    private static class Logs {
        @JsonProperty(value="address")
        String address;
        @JsonProperty(value="events")
        List<Event> events;

        @Generated
        Logs(String address, List<Event> events) {
            this.address = address;
            this.events = events;
        }

        @Generated
        public static LogsBuilder builder() {
            return new LogsBuilder();
        }

        @Generated
        public static class LogsBuilder {
            @Generated
            private String address;
            @Generated
            private List<Event> events;

            @Generated
            LogsBuilder() {
            }

            @JsonProperty(value="address")
            @Generated
            public LogsBuilder address(String address) {
                this.address = address;
                return this;
            }

            @JsonProperty(value="events")
            @Generated
            public LogsBuilder events(List<Event> events) {
                this.events = events;
                return this;
            }

            @Generated
            public Logs build() {
                return new Logs(this.address, this.events);
            }

            @Generated
            public String toString() {
                return "TransactionOnNetwork.Logs.LogsBuilder(address=" + this.address + ", events=" + this.events + ")";
            }
        }
    }
}

