/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.math.BigInteger;
import java.util.List;
import lombok.Generated;
import software.crldev.elrondspringbootstarterreactive.api.model.SmartContractResult;
import software.crldev.elrondspringbootstarterreactive.domain.ApiModelToDomainConvertible;
import software.crldev.elrondspringbootstarterreactive.domain.account.Address;
import software.crldev.elrondspringbootstarterreactive.domain.common.Balance;
import software.crldev.elrondspringbootstarterreactive.domain.common.Nonce;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.GasLimit;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.GasPrice;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.Hash;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.PayloadData;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.Signature;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.Transaction;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.TransactionStatus;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=TransactionForAddressBuilder.class)
public final class TransactionForAddress
implements ApiModelToDomainConvertible<Transaction> {
    @JsonProperty(value="hash")
    private final String hash;
    @JsonProperty(value="fee")
    private final String fee;
    @JsonProperty(value="miniBlockHash")
    private final String miniBlockHash;
    @JsonProperty(value="nonce")
    private final Long nonce;
    @JsonProperty(value="round")
    private final Long round;
    @JsonProperty(value="value")
    private final BigInteger value;
    @JsonProperty(value="receiver")
    private final String receiver;
    @JsonProperty(value="sender")
    private final String sender;
    @JsonProperty(value="receiverShard")
    private final Long receiverShard;
    @JsonProperty(value="senderShard")
    private final Long senderShard;
    @JsonProperty(value="gasPrice")
    private final BigInteger gasPrice;
    @JsonProperty(value="gasLimit")
    private final BigInteger gasLimit;
    @JsonProperty(value="gasUsed")
    private final BigInteger gasUsed;
    @JsonProperty(value="data")
    private final String data;
    @JsonProperty(value="signature")
    private final String signature;
    @JsonProperty(value="timestamp")
    private final Long timestamp;
    @JsonProperty(value="status")
    private final String status;
    @JsonProperty(value="searchOrder")
    private final Integer searchOrder;
    @JsonProperty(value="scResults")
    private final List<SmartContractResult> scResults;

    @Override
    public Transaction toDomainObject() {
        Transaction transaction = new Transaction();
        transaction.setReceiver(Address.fromBech32(this.getReceiver()));
        transaction.setSender(Address.fromBech32(this.getSender()));
        transaction.setValue(Balance.fromNumber(this.getValue()));
        transaction.setNonce(Nonce.fromLong(this.getNonce()));
        transaction.setGasPrice(GasPrice.fromNumber(this.getGasPrice()));
        transaction.setGasLimit(GasLimit.fromNumber(this.getGasLimit()));
        transaction.setHash(Hash.fromString(this.getHash()));
        transaction.setPayloadData(PayloadData.fromEncoded(this.getData()));
        transaction.applySignature(Signature.fromHex(this.getSignature()));
        transaction.setStatus(TransactionStatus.fromString(this.getStatus()));
        return transaction;
    }

    @Generated
    TransactionForAddress(String hash, String fee, String miniBlockHash, Long nonce, Long round, BigInteger value, String receiver, String sender, Long receiverShard, Long senderShard, BigInteger gasPrice, BigInteger gasLimit, BigInteger gasUsed, String data, String signature, Long timestamp, String status, Integer searchOrder, List<SmartContractResult> scResults) {
        this.hash = hash;
        this.fee = fee;
        this.miniBlockHash = miniBlockHash;
        this.nonce = nonce;
        this.round = round;
        this.value = value;
        this.receiver = receiver;
        this.sender = sender;
        this.receiverShard = receiverShard;
        this.senderShard = senderShard;
        this.gasPrice = gasPrice;
        this.gasLimit = gasLimit;
        this.gasUsed = gasUsed;
        this.data = data;
        this.signature = signature;
        this.timestamp = timestamp;
        this.status = status;
        this.searchOrder = searchOrder;
        this.scResults = scResults;
    }

    @Generated
    public static TransactionForAddressBuilder builder() {
        return new TransactionForAddressBuilder();
    }

    @Generated
    public String getHash() {
        return this.hash;
    }

    @Generated
    public String getFee() {
        return this.fee;
    }

    @Generated
    public String getMiniBlockHash() {
        return this.miniBlockHash;
    }

    @Generated
    public Long getNonce() {
        return this.nonce;
    }

    @Generated
    public Long getRound() {
        return this.round;
    }

    @Generated
    public BigInteger getValue() {
        return this.value;
    }

    @Generated
    public String getReceiver() {
        return this.receiver;
    }

    @Generated
    public String getSender() {
        return this.sender;
    }

    @Generated
    public Long getReceiverShard() {
        return this.receiverShard;
    }

    @Generated
    public Long getSenderShard() {
        return this.senderShard;
    }

    @Generated
    public BigInteger getGasPrice() {
        return this.gasPrice;
    }

    @Generated
    public BigInteger getGasLimit() {
        return this.gasLimit;
    }

    @Generated
    public BigInteger getGasUsed() {
        return this.gasUsed;
    }

    @Generated
    public String getData() {
        return this.data;
    }

    @Generated
    public String getSignature() {
        return this.signature;
    }

    @Generated
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public Integer getSearchOrder() {
        return this.searchOrder;
    }

    @Generated
    public List<SmartContractResult> getScResults() {
        return this.scResults;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionForAddress)) {
            return false;
        }
        TransactionForAddress other = (TransactionForAddress)o;
        Long this$nonce = this.getNonce();
        Long other$nonce = other.getNonce();
        if (this$nonce == null ? other$nonce != null : !((Object)this$nonce).equals(other$nonce)) {
            return false;
        }
        Long this$round = this.getRound();
        Long other$round = other.getRound();
        if (this$round == null ? other$round != null : !((Object)this$round).equals(other$round)) {
            return false;
        }
        Long this$receiverShard = this.getReceiverShard();
        Long other$receiverShard = other.getReceiverShard();
        if (this$receiverShard == null ? other$receiverShard != null : !((Object)this$receiverShard).equals(other$receiverShard)) {
            return false;
        }
        Long this$senderShard = this.getSenderShard();
        Long other$senderShard = other.getSenderShard();
        if (this$senderShard == null ? other$senderShard != null : !((Object)this$senderShard).equals(other$senderShard)) {
            return false;
        }
        Long this$timestamp = this.getTimestamp();
        Long other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        Integer this$searchOrder = this.getSearchOrder();
        Integer other$searchOrder = other.getSearchOrder();
        if (this$searchOrder == null ? other$searchOrder != null : !((Object)this$searchOrder).equals(other$searchOrder)) {
            return false;
        }
        String this$hash = this.getHash();
        String other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
            return false;
        }
        String this$fee = this.getFee();
        String other$fee = other.getFee();
        if (this$fee == null ? other$fee != null : !this$fee.equals(other$fee)) {
            return false;
        }
        String this$miniBlockHash = this.getMiniBlockHash();
        String other$miniBlockHash = other.getMiniBlockHash();
        if (this$miniBlockHash == null ? other$miniBlockHash != null : !this$miniBlockHash.equals(other$miniBlockHash)) {
            return false;
        }
        BigInteger this$value = this.getValue();
        BigInteger other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        String this$receiver = this.getReceiver();
        String other$receiver = other.getReceiver();
        if (this$receiver == null ? other$receiver != null : !this$receiver.equals(other$receiver)) {
            return false;
        }
        String this$sender = this.getSender();
        String other$sender = other.getSender();
        if (this$sender == null ? other$sender != null : !this$sender.equals(other$sender)) {
            return false;
        }
        BigInteger this$gasPrice = this.getGasPrice();
        BigInteger other$gasPrice = other.getGasPrice();
        if (this$gasPrice == null ? other$gasPrice != null : !((Object)this$gasPrice).equals(other$gasPrice)) {
            return false;
        }
        BigInteger this$gasLimit = this.getGasLimit();
        BigInteger other$gasLimit = other.getGasLimit();
        if (this$gasLimit == null ? other$gasLimit != null : !((Object)this$gasLimit).equals(other$gasLimit)) {
            return false;
        }
        BigInteger this$gasUsed = this.getGasUsed();
        BigInteger other$gasUsed = other.getGasUsed();
        if (this$gasUsed == null ? other$gasUsed != null : !((Object)this$gasUsed).equals(other$gasUsed)) {
            return false;
        }
        String this$data = this.getData();
        String other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$signature = this.getSignature();
        String other$signature = other.getSignature();
        if (this$signature == null ? other$signature != null : !this$signature.equals(other$signature)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        List<SmartContractResult> this$scResults = this.getScResults();
        List<SmartContractResult> other$scResults = other.getScResults();
        return !(this$scResults == null ? other$scResults != null : !((Object)this$scResults).equals(other$scResults));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $nonce = this.getNonce();
        result = result * 59 + ($nonce == null ? 43 : ((Object)$nonce).hashCode());
        Long $round = this.getRound();
        result = result * 59 + ($round == null ? 43 : ((Object)$round).hashCode());
        Long $receiverShard = this.getReceiverShard();
        result = result * 59 + ($receiverShard == null ? 43 : ((Object)$receiverShard).hashCode());
        Long $senderShard = this.getSenderShard();
        result = result * 59 + ($senderShard == null ? 43 : ((Object)$senderShard).hashCode());
        Long $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        Integer $searchOrder = this.getSearchOrder();
        result = result * 59 + ($searchOrder == null ? 43 : ((Object)$searchOrder).hashCode());
        String $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        String $fee = this.getFee();
        result = result * 59 + ($fee == null ? 43 : $fee.hashCode());
        String $miniBlockHash = this.getMiniBlockHash();
        result = result * 59 + ($miniBlockHash == null ? 43 : $miniBlockHash.hashCode());
        BigInteger $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        String $receiver = this.getReceiver();
        result = result * 59 + ($receiver == null ? 43 : $receiver.hashCode());
        String $sender = this.getSender();
        result = result * 59 + ($sender == null ? 43 : $sender.hashCode());
        BigInteger $gasPrice = this.getGasPrice();
        result = result * 59 + ($gasPrice == null ? 43 : ((Object)$gasPrice).hashCode());
        BigInteger $gasLimit = this.getGasLimit();
        result = result * 59 + ($gasLimit == null ? 43 : ((Object)$gasLimit).hashCode());
        BigInteger $gasUsed = this.getGasUsed();
        result = result * 59 + ($gasUsed == null ? 43 : ((Object)$gasUsed).hashCode());
        String $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        List<SmartContractResult> $scResults = this.getScResults();
        result = result * 59 + ($scResults == null ? 43 : ((Object)$scResults).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TransactionForAddress(hash=" + this.getHash() + ", fee=" + this.getFee() + ", miniBlockHash=" + this.getMiniBlockHash() + ", nonce=" + this.getNonce() + ", round=" + this.getRound() + ", value=" + this.getValue() + ", receiver=" + this.getReceiver() + ", sender=" + this.getSender() + ", receiverShard=" + this.getReceiverShard() + ", senderShard=" + this.getSenderShard() + ", gasPrice=" + this.getGasPrice() + ", gasLimit=" + this.getGasLimit() + ", gasUsed=" + this.getGasUsed() + ", data=" + this.getData() + ", signature=" + this.getSignature() + ", timestamp=" + this.getTimestamp() + ", status=" + this.getStatus() + ", searchOrder=" + this.getSearchOrder() + ", scResults=" + this.getScResults() + ")";
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class TransactionForAddressBuilder {
        @Generated
        private String hash;
        @Generated
        private String fee;
        @Generated
        private String miniBlockHash;
        @Generated
        private Long nonce;
        @Generated
        private Long round;
        @Generated
        private BigInteger value;
        @Generated
        private String receiver;
        @Generated
        private String sender;
        @Generated
        private Long receiverShard;
        @Generated
        private Long senderShard;
        @Generated
        private BigInteger gasPrice;
        @Generated
        private BigInteger gasLimit;
        @Generated
        private BigInteger gasUsed;
        @Generated
        private String data;
        @Generated
        private String signature;
        @Generated
        private Long timestamp;
        @Generated
        private String status;
        @Generated
        private Integer searchOrder;
        @Generated
        private List<SmartContractResult> scResults;

        @Generated
        TransactionForAddressBuilder() {
        }

        @JsonProperty(value="hash")
        @Generated
        public TransactionForAddressBuilder hash(String hash) {
            this.hash = hash;
            return this;
        }

        @JsonProperty(value="fee")
        @Generated
        public TransactionForAddressBuilder fee(String fee) {
            this.fee = fee;
            return this;
        }

        @JsonProperty(value="miniBlockHash")
        @Generated
        public TransactionForAddressBuilder miniBlockHash(String miniBlockHash) {
            this.miniBlockHash = miniBlockHash;
            return this;
        }

        @JsonProperty(value="nonce")
        @Generated
        public TransactionForAddressBuilder nonce(Long nonce) {
            this.nonce = nonce;
            return this;
        }

        @JsonProperty(value="round")
        @Generated
        public TransactionForAddressBuilder round(Long round) {
            this.round = round;
            return this;
        }

        @JsonProperty(value="value")
        @Generated
        public TransactionForAddressBuilder value(BigInteger value) {
            this.value = value;
            return this;
        }

        @JsonProperty(value="receiver")
        @Generated
        public TransactionForAddressBuilder receiver(String receiver) {
            this.receiver = receiver;
            return this;
        }

        @JsonProperty(value="sender")
        @Generated
        public TransactionForAddressBuilder sender(String sender) {
            this.sender = sender;
            return this;
        }

        @JsonProperty(value="receiverShard")
        @Generated
        public TransactionForAddressBuilder receiverShard(Long receiverShard) {
            this.receiverShard = receiverShard;
            return this;
        }

        @JsonProperty(value="senderShard")
        @Generated
        public TransactionForAddressBuilder senderShard(Long senderShard) {
            this.senderShard = senderShard;
            return this;
        }

        @JsonProperty(value="gasPrice")
        @Generated
        public TransactionForAddressBuilder gasPrice(BigInteger gasPrice) {
            this.gasPrice = gasPrice;
            return this;
        }

        @JsonProperty(value="gasLimit")
        @Generated
        public TransactionForAddressBuilder gasLimit(BigInteger gasLimit) {
            this.gasLimit = gasLimit;
            return this;
        }

        @JsonProperty(value="gasUsed")
        @Generated
        public TransactionForAddressBuilder gasUsed(BigInteger gasUsed) {
            this.gasUsed = gasUsed;
            return this;
        }

        @JsonProperty(value="data")
        @Generated
        public TransactionForAddressBuilder data(String data) {
            this.data = data;
            return this;
        }

        @JsonProperty(value="signature")
        @Generated
        public TransactionForAddressBuilder signature(String signature) {
            this.signature = signature;
            return this;
        }

        @JsonProperty(value="timestamp")
        @Generated
        public TransactionForAddressBuilder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @JsonProperty(value="status")
        @Generated
        public TransactionForAddressBuilder status(String status) {
            this.status = status;
            return this;
        }

        @JsonProperty(value="searchOrder")
        @Generated
        public TransactionForAddressBuilder searchOrder(Integer searchOrder) {
            this.searchOrder = searchOrder;
            return this;
        }

        @JsonProperty(value="scResults")
        @Generated
        public TransactionForAddressBuilder scResults(List<SmartContractResult> scResults) {
            this.scResults = scResults;
            return this;
        }

        @Generated
        public TransactionForAddress build() {
            return new TransactionForAddress(this.hash, this.fee, this.miniBlockHash, this.nonce, this.round, this.value, this.receiver, this.sender, this.receiverShard, this.senderShard, this.gasPrice, this.gasLimit, this.gasUsed, this.data, this.signature, this.timestamp, this.status, this.searchOrder, this.scResults);
        }

        @Generated
        public String toString() {
            return "TransactionForAddress.TransactionForAddressBuilder(hash=" + this.hash + ", fee=" + this.fee + ", miniBlockHash=" + this.miniBlockHash + ", nonce=" + this.nonce + ", round=" + this.round + ", value=" + this.value + ", receiver=" + this.receiver + ", sender=" + this.sender + ", receiverShard=" + this.receiverShard + ", senderShard=" + this.senderShard + ", gasPrice=" + this.gasPrice + ", gasLimit=" + this.gasLimit + ", gasUsed=" + this.gasUsed + ", data=" + this.data + ", signature=" + this.signature + ", timestamp=" + this.timestamp + ", status=" + this.status + ", searchOrder=" + this.searchOrder + ", scResults=" + this.scResults + ")";
        }
    }
}

