/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bitcoinj.crypto.MnemonicCode;
import org.bitcoinj.crypto.MnemonicException;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import software.crldev.elrondspringbootstarterreactive.config.WalletConstants;
import software.crldev.elrondspringbootstarterreactive.error.exception.CannotDeriveKeysException;
import software.crldev.elrondspringbootstarterreactive.error.exception.CannotGenerateMnemonicException;

public class MnemonicsUtils {
    public static List<String> generateMnemonic() {
        try {
            byte[] entropy = MnemonicsUtils.generateEntropy();
            MnemonicCode mnemonicCode = new MnemonicCode();
            return mnemonicCode.toMnemonic(entropy);
        }
        catch (IOException | MnemonicException.MnemonicLengthException error) {
            throw new CannotGenerateMnemonicException();
        }
    }

    public static byte[] privateKeyFromMnemonic(List<String> mnemonics, long accountIndex) {
        try {
            String mnemonicsAsString = mnemonics.stream().map(String::trim).collect(Collectors.joining(" "));
            byte[] seed = MnemonicsUtils.mnemonicToBip39Seed(mnemonicsAsString);
            return MnemonicsUtils.bip39SeedToPrivateKey(seed, accountIndex);
        }
        catch (IOException error) {
            throw new CannotDeriveKeysException();
        }
    }

    private static byte[] mnemonicToBip39Seed(String mnemonic) {
        byte[] mnemonicBytes = mnemonic.getBytes();
        byte[] passphrase = "mnemonic".getBytes();
        PKCS5S2ParametersGenerator generator = new PKCS5S2ParametersGenerator((Digest)new SHA512Digest());
        generator.init(mnemonicBytes, passphrase, 2048);
        return ((KeyParameter)generator.generateDerivedParameters(512)).getKey();
    }

    private static byte[] generateEntropy() {
        SecureRandom random = new SecureRandom();
        byte[] entropy = new byte[32];
        random.nextBytes(entropy);
        return entropy;
    }

    private static byte[] bip39SeedToPrivateKey(byte[] seed, long accountIndex) throws IOException {
        KeyAndChainCode keyAndChainCode = MnemonicsUtils.bip39SeedToMasterKey(seed);
        byte[] key = keyAndChainCode.key;
        byte[] chainCode = keyAndChainCode.chainCode;
        long[] derivationPath = Arrays.copyOf(WalletConstants.ELROND_DERIVATION_PATH, WalletConstants.ELROND_DERIVATION_PATH.length);
        derivationPath[derivationPath.length - 1] = accountIndex;
        for (long segment : derivationPath) {
            keyAndChainCode = MnemonicsUtils.ckdPriv(key, chainCode, segment + Integer.MIN_VALUE);
            key = keyAndChainCode.key;
            chainCode = keyAndChainCode.chainCode;
        }
        return key;
    }

    private static KeyAndChainCode bip39SeedToMasterKey(byte[] seed) {
        byte[] result = MnemonicsUtils.hmacSHA512("ed25519 seed".getBytes(), seed);
        byte[] masterKey = Arrays.copyOfRange(result, 0, 32);
        byte[] chainCode = Arrays.copyOfRange(result, 32, 64);
        return new KeyAndChainCode(masterKey, chainCode);
    }

    private static KeyAndChainCode ckdPriv(byte[] key, byte[] chainCode, long index) throws IOException {
        ByteBuffer indexBuffer = ByteBuffer.allocate(4);
        indexBuffer.order(ByteOrder.BIG_ENDIAN);
        indexBuffer.putInt((int)(index & 0xFFFFFFFFL));
        byte[] indexBytes = indexBuffer.array();
        ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
        dataStream.write(new byte[]{0});
        dataStream.write(key);
        dataStream.write(indexBytes);
        byte[] data = dataStream.toByteArray();
        byte[] result = MnemonicsUtils.hmacSHA512(chainCode, data);
        return new KeyAndChainCode(Arrays.copyOfRange(result, 0, 32), Arrays.copyOfRange(result, 32, 64));
    }

    private static byte[] hmacSHA512(byte[] key, byte[] message) {
        byte[] result = new byte[64];
        HMac hmac = new HMac((Digest)new SHA512Digest());
        hmac.init((CipherParameters)new KeyParameter(key));
        hmac.update(message, 0, message.length);
        hmac.doFinal(result, 0);
        return result;
    }

    private static class KeyAndChainCode {
        public final byte[] key;
        public final byte[] chainCode;

        private KeyAndChainCode(byte[] key, byte[] chainCode) {
            this.key = key;
            this.chainCode = chainCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyAndChainCode that = (KeyAndChainCode)o;
            if (!Arrays.equals(this.key, that.key)) {
                return false;
            }
            return Arrays.equals(this.chainCode, that.chainCode);
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.key);
            result = 31 * result + Arrays.hashCode(this.chainCode);
            return result;
        }
    }
}

