/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.sender;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import reactor.core.publisher.Mono;
import software.crldev.elrondspringbootstarterreactive.api.model.AddressNonce;
import software.crldev.elrondspringbootstarterreactive.api.model.SimulationResults;
import software.crldev.elrondspringbootstarterreactive.api.model.TransactionCostEstimation;
import software.crldev.elrondspringbootstarterreactive.api.model.TransactionHash;
import software.crldev.elrondspringbootstarterreactive.api.model.TransactionsSentResult;
import software.crldev.elrondspringbootstarterreactive.domain.account.Address;
import software.crldev.elrondspringbootstarterreactive.domain.common.Balance;
import software.crldev.elrondspringbootstarterreactive.domain.common.Nonce;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.PayloadData;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.Transaction;
import software.crldev.elrondspringbootstarterreactive.domain.wallet.Wallet;
import software.crldev.elrondspringbootstarterreactive.error.exception.MissingTransactionRequestException;
import software.crldev.elrondspringbootstarterreactive.interactor.account.ErdAccountInteractor;
import software.crldev.elrondspringbootstarterreactive.interactor.transaction.ErdTransactionInteractor;
import software.crldev.elrondspringbootstarterreactive.sender.ErdSimpleTransactionSender;
import software.crldev.elrondspringbootstarterreactive.sender.TransactionRequest;

public class ErdSimpleTransactionSenderImpl
implements ErdSimpleTransactionSender {
    private final ErdAccountInteractor accountInteractor;
    private final ErdTransactionInteractor transactionInteractor;

    @Override
    public Mono<TransactionHash> send(Wallet wallet, TransactionRequest request) {
        return this.assignNonce(wallet).map(nonce -> this.buildSendableFromRequest(wallet, request, (Long)nonce, false)).flatMap(this.transactionInteractor::sendTransaction);
    }

    @Override
    public Mono<TransactionsSentResult> sendBatch(Wallet wallet, List<TransactionRequest> request) {
        request.stream().findFirst().orElseThrow(MissingTransactionRequestException::new);
        return this.assignNonce(wallet).map(n -> {
            ArrayList<Transaction.Sendable> listOfSendables = new ArrayList<Transaction.Sendable>();
            long i = 0L;
            for (long nonce = n.longValue(); i < (long)request.size() && nonce <= nonce + (long)request.size(); ++i, ++nonce) {
                listOfSendables.add(this.buildSendableFromRequest(wallet, (TransactionRequest)request.get((int)i), nonce, false));
            }
            return listOfSendables;
        }).flatMap(this.transactionInteractor::sendBatchOfTransactions);
    }

    @Override
    public Mono<SimulationResults> simulate(Wallet wallet, TransactionRequest request) {
        return this.assignNonce(wallet).map(nonce -> this.buildSendableFromRequest(wallet, request, (Long)nonce, false)).flatMap(this.transactionInteractor::simulateTransaction);
    }

    @Override
    public Mono<TransactionCostEstimation> estimate(Wallet wallet, TransactionRequest request) {
        return this.assignNonce(wallet).map(nonce -> this.buildSendableFromRequest(wallet, request, (Long)nonce, true)).flatMap(this.transactionInteractor::estimateTransactionCost);
    }

    private Transaction.Sendable buildSendableFromRequest(Wallet wallet, TransactionRequest request, Long nonceValue, boolean isEstimationRequest) {
        Address senderAddress = Address.fromHex(wallet.getPublicKeyHex());
        Address receiverAddress = request.getReceiverAddress();
        Nonce nonce = Nonce.fromLong(nonceValue);
        Balance value = request.getValue();
        PayloadData data = request.getData();
        Transaction transaction = new Transaction();
        transaction.setValue(value);
        transaction.setNonce(nonce);
        transaction.setReceiver(receiverAddress);
        transaction.setSender(senderAddress);
        transaction.setPayloadData(data);
        if (isEstimationRequest) {
            return transaction.toSendableForEstimation();
        }
        wallet.sign(transaction);
        return transaction.toSendable();
    }

    private Mono<Long> assignNonce(Wallet wallet) {
        return this.accountInteractor.getNonce(Address.fromHex(wallet.getPublicKeyHex())).map(AddressNonce::getNonce);
    }

    @Generated
    public ErdSimpleTransactionSenderImpl(ErdAccountInteractor accountInteractor, ErdTransactionInteractor transactionInteractor) {
        this.accountInteractor = accountInteractor;
        this.transactionInteractor = transactionInteractor;
    }
}

