/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.interactor.transaction;

import java.util.List;
import lombok.Generated;
import reactor.core.publisher.Mono;
import software.crldev.elrondspringbootstarterreactive.api.ApiResourceURI;
import software.crldev.elrondspringbootstarterreactive.api.model.SimulationResults;
import software.crldev.elrondspringbootstarterreactive.api.model.TransactionCostEstimation;
import software.crldev.elrondspringbootstarterreactive.api.model.TransactionHash;
import software.crldev.elrondspringbootstarterreactive.api.model.TransactionOnNetwork;
import software.crldev.elrondspringbootstarterreactive.api.model.TransactionStatus;
import software.crldev.elrondspringbootstarterreactive.api.model.TransactionsSentResult;
import software.crldev.elrondspringbootstarterreactive.client.ErdProxyClient;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.Transaction;
import software.crldev.elrondspringbootstarterreactive.error.exception.InvalidSentTransactionsException;
import software.crldev.elrondspringbootstarterreactive.error.exception.ProxyRequestException;
import software.crldev.elrondspringbootstarterreactive.interactor.WrappedResponses;
import software.crldev.elrondspringbootstarterreactive.interactor.transaction.ErdTransactionInteractor;

public class ErdTransactionInteractorImpl
implements ErdTransactionInteractor {
    private final ErdProxyClient client;

    @Override
    public Mono<TransactionHash> sendTransaction(Transaction.Sendable payload) {
        return this.client.post(ApiResourceURI.SEND_TRANSACTION.getURI(), payload, TransactionHash.class);
    }

    @Override
    public Mono<TransactionsSentResult> sendBatchOfTransactions(List<Transaction.Sendable> payloads) {
        return this.client.post(ApiResourceURI.SEND_MULTIPLE_TRANSACTIONS.getURI(), payloads.toArray(), TransactionsSentResult.class).map(this::processSendTransactions);
    }

    @Override
    public Mono<SimulationResults> simulateTransaction(Transaction.Sendable payload) {
        return this.client.post(ApiResourceURI.SIMULATE_TRANSACTION.getURI(), payload, WrappedResponses.SimulateTransactionResponse.class).map(WrappedResponses.SimulateTransactionResponse::getResult);
    }

    @Override
    public Mono<TransactionCostEstimation> estimateTransactionCost(Transaction.Sendable payload) {
        return this.client.post(ApiResourceURI.ESTIMATE_TRANSACTION_COST.getURI(), payload, TransactionCostEstimation.class).map(this::processCostEstimation);
    }

    @Override
    public Mono<TransactionOnNetwork> queryTransactionInfo(String transactionHash, boolean withResults) {
        return this.client.get(String.format(ApiResourceURI.TRANSACTION_ON_NETWORK.getURI(), transactionHash, withResults), WrappedResponses.QueryTransactionResponse.class).map(WrappedResponses.QueryTransactionResponse::getTransaction);
    }

    @Override
    public Mono<TransactionStatus> queryTransactionStatus(String transactionHash) {
        return this.client.get(String.format(ApiResourceURI.TRANSACTION_STATUS.getURI(), transactionHash), TransactionStatus.class);
    }

    private TransactionCostEstimation processCostEstimation(TransactionCostEstimation estimation) {
        if (estimation.getTransactionGasUnits().equals("0")) {
            throw new ProxyRequestException(estimation.getReturnMessage());
        }
        return estimation;
    }

    private TransactionsSentResult processSendTransactions(TransactionsSentResult result) {
        if (result.getNumberOfSentTransactions() == 0) {
            throw new InvalidSentTransactionsException();
        }
        return result;
    }

    @Generated
    public ErdTransactionInteractorImpl(ErdProxyClient client) {
        this.client = client;
    }
}

