/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.interactor.account;

import java.util.List;
import java.util.Map;
import lombok.Generated;
import reactor.core.publisher.Mono;
import software.crldev.elrondspringbootstarterreactive.api.ApiResourceURI;
import software.crldev.elrondspringbootstarterreactive.api.model.AccountOnNetwork;
import software.crldev.elrondspringbootstarterreactive.api.model.AddressBalance;
import software.crldev.elrondspringbootstarterreactive.api.model.AddressNonce;
import software.crldev.elrondspringbootstarterreactive.api.model.AddressStorageValue;
import software.crldev.elrondspringbootstarterreactive.api.model.TransactionForAddress;
import software.crldev.elrondspringbootstarterreactive.client.ErdProxyClient;
import software.crldev.elrondspringbootstarterreactive.domain.account.Address;
import software.crldev.elrondspringbootstarterreactive.interactor.WrappedResponses;
import software.crldev.elrondspringbootstarterreactive.interactor.account.ErdAccountInteractor;

public class ErdAccountInteractorImpl
implements ErdAccountInteractor {
    private final ErdProxyClient client;

    @Override
    public Mono<AccountOnNetwork> getAccountInfo(Address address) {
        return this.client.get(String.format(ApiResourceURI.ACCOUNT_ON_NETWORK.getURI(), address.getBech32()), WrappedResponses.GetAccountWrapper.class).map(WrappedResponses.GetAccountWrapper::getAccount);
    }

    @Override
    public Mono<AddressBalance> getBalance(Address address) {
        return this.client.get(String.format(ApiResourceURI.ACCOUNT_BALANCE.getURI(), address.getBech32()), AddressBalance.class);
    }

    @Override
    public Mono<AddressNonce> getNonce(Address address) {
        return this.client.get(String.format(ApiResourceURI.ACCOUNT_NONCE.getURI(), address.getBech32()), AddressNonce.class);
    }

    @Override
    public Mono<List<TransactionForAddress>> getTransactions(Address address) {
        return this.client.get(String.format(ApiResourceURI.ADDRESS_TRANSACTIONS.getURI(), address.getBech32()), WrappedResponses.GetAccountTransactionsWrapper.class).map(WrappedResponses.GetAccountTransactionsWrapper::getList);
    }

    @Override
    public Mono<AddressStorageValue> getStorageValue(Address address, String key) {
        return this.client.get(String.format(ApiResourceURI.ACCOUNT_STORAGE_VALUE.getURI(), address.getBech32(), key), AddressStorageValue.class);
    }

    @Override
    public Mono<Map<String, String>> getStorage(Address address) {
        return this.client.get(String.format(ApiResourceURI.ACCOUNT_STORAGE.getURI(), address.getBech32()), WrappedResponses.GetAllAccountStorageWrapper.class).map(WrappedResponses.GetAllAccountStorageWrapper::getPairs);
    }

    @Generated
    public ErdAccountInteractorImpl(ErdProxyClient client) {
        this.client = client;
    }
}

