/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.domain.transaction;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.math.BigInteger;
import lombok.Generated;
import software.crldev.elrondspringbootstarterreactive.config.ErdNetworkConfigSupplier;
import software.crldev.elrondspringbootstarterreactive.config.JsonMapper;
import software.crldev.elrondspringbootstarterreactive.domain.account.Address;
import software.crldev.elrondspringbootstarterreactive.domain.common.Balance;
import software.crldev.elrondspringbootstarterreactive.domain.common.Nonce;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.ChainID;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.GasLimit;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.GasPrice;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.Hash;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.PayloadData;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.Signable;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.Signature;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.TransactionStatus;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.TransactionVersion;
import software.crldev.elrondspringbootstarterreactive.util.GasUtils;

public class Transaction
implements Signable {
    private Nonce nonce = Nonce.fromLong(0L);
    private ChainID chainID = ChainID.fromString(ErdNetworkConfigSupplier.config.getChainId());
    private Balance value = Balance.zero();
    private Address sender = Address.zero();
    private Address receiver = Address.zero();
    private GasPrice gasPrice = GasPrice.fromNumber(ErdNetworkConfigSupplier.config.getMinGasPrice());
    private GasLimit gasLimit = GasLimit.fromNumber(ErdNetworkConfigSupplier.config.getMinGasLimit());
    private PayloadData payloadData = PayloadData.empty();
    private TransactionVersion version = TransactionVersion.withDefaultVersion();
    private Signature signature = Signature.empty();
    private Hash hash = Hash.empty();
    private TransactionStatus status = TransactionStatus.UNKNOWN;

    @Override
    public byte[] serializeForSigning() throws JsonProcessingException {
        return JsonMapper.serializeToJsonBuffer(this.toSendable());
    }

    @Override
    public void applySignature(Signature signature) {
        this.setSignature(signature);
    }

    public Sendable toSendable() {
        return this.generateSender(false);
    }

    public Sendable toSendableForEstimation() {
        return this.generateSender(true);
    }

    public void setPayloadData(PayloadData payloadData) {
        this.payloadData = payloadData;
        this.gasLimit = GasLimit.fromNumber(GasUtils.computeGasCost(payloadData));
    }

    private Sendable generateSender(boolean isEstimation) {
        Sendable.SendableBuilder sendableBuilder = Sendable.builder().chainId(this.chainID.getValue()).nonce(this.nonce.getValue()).value(this.value.toString()).receiver(this.receiver.getBech32()).sender(this.sender.getBech32()).data(this.payloadData.isEmpty() ? null : this.payloadData.encoded()).signature(this.signature.isEmpty() ? null : this.signature.getHex()).version(this.version.getValue());
        if (!isEstimation) {
            sendableBuilder.gasLimit(this.gasLimit.getValue());
            sendableBuilder.gasPrice(this.gasPrice.getValue());
        }
        return sendableBuilder.build();
    }

    @Generated
    public Transaction() {
    }

    @Generated
    public Nonce getNonce() {
        return this.nonce;
    }

    @Generated
    public ChainID getChainID() {
        return this.chainID;
    }

    @Generated
    public Balance getValue() {
        return this.value;
    }

    @Generated
    public Address getSender() {
        return this.sender;
    }

    @Generated
    public Address getReceiver() {
        return this.receiver;
    }

    @Generated
    public GasPrice getGasPrice() {
        return this.gasPrice;
    }

    @Generated
    public GasLimit getGasLimit() {
        return this.gasLimit;
    }

    @Generated
    public PayloadData getPayloadData() {
        return this.payloadData;
    }

    @Generated
    public TransactionVersion getVersion() {
        return this.version;
    }

    @Generated
    public Signature getSignature() {
        return this.signature;
    }

    @Generated
    public Hash getHash() {
        return this.hash;
    }

    @Generated
    public TransactionStatus getStatus() {
        return this.status;
    }

    @Generated
    public void setNonce(Nonce nonce) {
        this.nonce = nonce;
    }

    @Generated
    public void setChainID(ChainID chainID) {
        this.chainID = chainID;
    }

    @Generated
    public void setValue(Balance value) {
        this.value = value;
    }

    @Generated
    public void setSender(Address sender) {
        this.sender = sender;
    }

    @Generated
    public void setReceiver(Address receiver) {
        this.receiver = receiver;
    }

    @Generated
    public void setGasPrice(GasPrice gasPrice) {
        this.gasPrice = gasPrice;
    }

    @Generated
    public void setGasLimit(GasLimit gasLimit) {
        this.gasLimit = gasLimit;
    }

    @Generated
    public void setVersion(TransactionVersion version) {
        this.version = version;
    }

    @Generated
    public void setSignature(Signature signature) {
        this.signature = signature;
    }

    @Generated
    public void setHash(Hash hash) {
        this.hash = hash;
    }

    @Generated
    public void setStatus(TransactionStatus status) {
        this.status = status;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Transaction)) {
            return false;
        }
        Transaction other = (Transaction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Nonce this$nonce = this.getNonce();
        Nonce other$nonce = other.getNonce();
        if (this$nonce == null ? other$nonce != null : !((Object)this$nonce).equals(other$nonce)) {
            return false;
        }
        ChainID this$chainID = this.getChainID();
        ChainID other$chainID = other.getChainID();
        if (this$chainID == null ? other$chainID != null : !((Object)((Object)this$chainID)).equals((Object)other$chainID)) {
            return false;
        }
        Balance this$value = this.getValue();
        Balance other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        Address this$sender = this.getSender();
        Address other$sender = other.getSender();
        if (this$sender == null ? other$sender != null : !this$sender.equals(other$sender)) {
            return false;
        }
        Address this$receiver = this.getReceiver();
        Address other$receiver = other.getReceiver();
        if (this$receiver == null ? other$receiver != null : !this$receiver.equals(other$receiver)) {
            return false;
        }
        GasPrice this$gasPrice = this.getGasPrice();
        GasPrice other$gasPrice = other.getGasPrice();
        if (this$gasPrice == null ? other$gasPrice != null : !((Object)this$gasPrice).equals(other$gasPrice)) {
            return false;
        }
        GasLimit this$gasLimit = this.getGasLimit();
        GasLimit other$gasLimit = other.getGasLimit();
        if (this$gasLimit == null ? other$gasLimit != null : !((Object)this$gasLimit).equals(other$gasLimit)) {
            return false;
        }
        PayloadData this$payloadData = this.getPayloadData();
        PayloadData other$payloadData = other.getPayloadData();
        if (this$payloadData == null ? other$payloadData != null : !((Object)this$payloadData).equals(other$payloadData)) {
            return false;
        }
        TransactionVersion this$version = this.getVersion();
        TransactionVersion other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        Signature this$signature = this.getSignature();
        Signature other$signature = other.getSignature();
        if (this$signature == null ? other$signature != null : !((Object)this$signature).equals(other$signature)) {
            return false;
        }
        Hash this$hash = this.getHash();
        Hash other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !((Object)this$hash).equals(other$hash)) {
            return false;
        }
        TransactionStatus this$status = this.getStatus();
        TransactionStatus other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Transaction;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Nonce $nonce = this.getNonce();
        result = result * 59 + ($nonce == null ? 43 : ((Object)$nonce).hashCode());
        ChainID $chainID = this.getChainID();
        result = result * 59 + ($chainID == null ? 43 : ((Object)((Object)$chainID)).hashCode());
        Balance $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        Address $sender = this.getSender();
        result = result * 59 + ($sender == null ? 43 : $sender.hashCode());
        Address $receiver = this.getReceiver();
        result = result * 59 + ($receiver == null ? 43 : $receiver.hashCode());
        GasPrice $gasPrice = this.getGasPrice();
        result = result * 59 + ($gasPrice == null ? 43 : ((Object)$gasPrice).hashCode());
        GasLimit $gasLimit = this.getGasLimit();
        result = result * 59 + ($gasLimit == null ? 43 : ((Object)$gasLimit).hashCode());
        PayloadData $payloadData = this.getPayloadData();
        result = result * 59 + ($payloadData == null ? 43 : ((Object)$payloadData).hashCode());
        TransactionVersion $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        Signature $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : ((Object)$signature).hashCode());
        Hash $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : ((Object)$hash).hashCode());
        TransactionStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Transaction(nonce=" + this.getNonce() + ", chainID=" + this.getChainID() + ", value=" + this.getValue() + ", sender=" + this.getSender() + ", receiver=" + this.getReceiver() + ", gasPrice=" + this.getGasPrice() + ", gasLimit=" + this.getGasLimit() + ", payloadData=" + this.getPayloadData() + ", version=" + this.getVersion() + ", signature=" + this.getSignature() + ", hash=" + this.getHash() + ", status=" + this.getStatus() + ")";
    }

    public static final class Sendable {
        @JsonProperty(value="nonce")
        private final Long nonce;
        @JsonProperty(value="value")
        private final String value;
        @JsonProperty(value="receiver")
        private final String receiver;
        @JsonProperty(value="sender")
        private final String sender;
        @JsonProperty(value="gasPrice")
        private final BigInteger gasPrice;
        @JsonProperty(value="gasLimit")
        private final BigInteger gasLimit;
        @JsonProperty(value="data")
        private final String data;
        @JsonProperty(value="chainID")
        private final String chainId;
        @JsonProperty(value="signature")
        private final String signature;
        @JsonProperty(value="version")
        private final Integer version;

        @Generated
        Sendable(Long nonce, String value, String receiver, String sender, BigInteger gasPrice, BigInteger gasLimit, String data, String chainId, String signature, Integer version) {
            this.nonce = nonce;
            this.value = value;
            this.receiver = receiver;
            this.sender = sender;
            this.gasPrice = gasPrice;
            this.gasLimit = gasLimit;
            this.data = data;
            this.chainId = chainId;
            this.signature = signature;
            this.version = version;
        }

        @Generated
        private static SendableBuilder builder() {
            return new SendableBuilder();
        }

        @Generated
        public Long getNonce() {
            return this.nonce;
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public String getReceiver() {
            return this.receiver;
        }

        @Generated
        public String getSender() {
            return this.sender;
        }

        @Generated
        public BigInteger getGasPrice() {
            return this.gasPrice;
        }

        @Generated
        public BigInteger getGasLimit() {
            return this.gasLimit;
        }

        @Generated
        public String getData() {
            return this.data;
        }

        @Generated
        public String getChainId() {
            return this.chainId;
        }

        @Generated
        public String getSignature() {
            return this.signature;
        }

        @Generated
        public Integer getVersion() {
            return this.version;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Sendable)) {
                return false;
            }
            Sendable other = (Sendable)o;
            Long this$nonce = this.getNonce();
            Long other$nonce = other.getNonce();
            if (this$nonce == null ? other$nonce != null : !((Object)this$nonce).equals(other$nonce)) {
                return false;
            }
            Integer this$version = this.getVersion();
            Integer other$version = other.getVersion();
            if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            String this$receiver = this.getReceiver();
            String other$receiver = other.getReceiver();
            if (this$receiver == null ? other$receiver != null : !this$receiver.equals(other$receiver)) {
                return false;
            }
            String this$sender = this.getSender();
            String other$sender = other.getSender();
            if (this$sender == null ? other$sender != null : !this$sender.equals(other$sender)) {
                return false;
            }
            BigInteger this$gasPrice = this.getGasPrice();
            BigInteger other$gasPrice = other.getGasPrice();
            if (this$gasPrice == null ? other$gasPrice != null : !((Object)this$gasPrice).equals(other$gasPrice)) {
                return false;
            }
            BigInteger this$gasLimit = this.getGasLimit();
            BigInteger other$gasLimit = other.getGasLimit();
            if (this$gasLimit == null ? other$gasLimit != null : !((Object)this$gasLimit).equals(other$gasLimit)) {
                return false;
            }
            String this$data = this.getData();
            String other$data = other.getData();
            if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
                return false;
            }
            String this$chainId = this.getChainId();
            String other$chainId = other.getChainId();
            if (this$chainId == null ? other$chainId != null : !this$chainId.equals(other$chainId)) {
                return false;
            }
            String this$signature = this.getSignature();
            String other$signature = other.getSignature();
            return !(this$signature == null ? other$signature != null : !this$signature.equals(other$signature));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $nonce = this.getNonce();
            result = result * 59 + ($nonce == null ? 43 : ((Object)$nonce).hashCode());
            Integer $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            String $receiver = this.getReceiver();
            result = result * 59 + ($receiver == null ? 43 : $receiver.hashCode());
            String $sender = this.getSender();
            result = result * 59 + ($sender == null ? 43 : $sender.hashCode());
            BigInteger $gasPrice = this.getGasPrice();
            result = result * 59 + ($gasPrice == null ? 43 : ((Object)$gasPrice).hashCode());
            BigInteger $gasLimit = this.getGasLimit();
            result = result * 59 + ($gasLimit == null ? 43 : ((Object)$gasLimit).hashCode());
            String $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            String $chainId = this.getChainId();
            result = result * 59 + ($chainId == null ? 43 : $chainId.hashCode());
            String $signature = this.getSignature();
            result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Transaction.Sendable(nonce=" + this.getNonce() + ", value=" + this.getValue() + ", receiver=" + this.getReceiver() + ", sender=" + this.getSender() + ", gasPrice=" + this.getGasPrice() + ", gasLimit=" + this.getGasLimit() + ", data=" + this.getData() + ", chainId=" + this.getChainId() + ", signature=" + this.getSignature() + ", version=" + this.getVersion() + ")";
        }

        @Generated
        private static class SendableBuilder {
            @Generated
            private Long nonce;
            @Generated
            private String value;
            @Generated
            private String receiver;
            @Generated
            private String sender;
            @Generated
            private BigInteger gasPrice;
            @Generated
            private BigInteger gasLimit;
            @Generated
            private String data;
            @Generated
            private String chainId;
            @Generated
            private String signature;
            @Generated
            private Integer version;

            @Generated
            SendableBuilder() {
            }

            @JsonProperty(value="nonce")
            @Generated
            private SendableBuilder nonce(Long nonce) {
                this.nonce = nonce;
                return this;
            }

            @JsonProperty(value="value")
            @Generated
            private SendableBuilder value(String value) {
                this.value = value;
                return this;
            }

            @JsonProperty(value="receiver")
            @Generated
            private SendableBuilder receiver(String receiver) {
                this.receiver = receiver;
                return this;
            }

            @JsonProperty(value="sender")
            @Generated
            private SendableBuilder sender(String sender) {
                this.sender = sender;
                return this;
            }

            @JsonProperty(value="gasPrice")
            @Generated
            private SendableBuilder gasPrice(BigInteger gasPrice) {
                this.gasPrice = gasPrice;
                return this;
            }

            @JsonProperty(value="gasLimit")
            @Generated
            private SendableBuilder gasLimit(BigInteger gasLimit) {
                this.gasLimit = gasLimit;
                return this;
            }

            @JsonProperty(value="data")
            @Generated
            private SendableBuilder data(String data) {
                this.data = data;
                return this;
            }

            @JsonProperty(value="chainID")
            @Generated
            private SendableBuilder chainId(String chainId) {
                this.chainId = chainId;
                return this;
            }

            @JsonProperty(value="signature")
            @Generated
            private SendableBuilder signature(String signature) {
                this.signature = signature;
                return this;
            }

            @JsonProperty(value="version")
            @Generated
            private SendableBuilder version(Integer version) {
                this.version = version;
                return this;
            }

            @Generated
            private Sendable build() {
                return new Sendable(this.nonce, this.value, this.receiver, this.sender, this.gasPrice, this.gasLimit, this.data, this.chainId, this.signature, this.version);
            }

            @Generated
            public String toString() {
                return "Transaction.Sendable.SendableBuilder(nonce=" + this.nonce + ", value=" + this.value + ", receiver=" + this.receiver + ", sender=" + this.sender + ", gasPrice=" + this.gasPrice + ", gasLimit=" + this.gasLimit + ", data=" + this.data + ", chainId=" + this.chainId + ", signature=" + this.signature + ", version=" + this.version + ")";
            }
        }
    }
}

