/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.domain.transaction;

import java.util.Arrays;
import lombok.Generated;
import org.bouncycastle.util.encoders.Hex;
import software.crldev.elrondspringbootstarterreactive.config.TransactionConstants;
import software.crldev.elrondspringbootstarterreactive.error.exception.CannotCreateSignatureException;
import software.crldev.elrondspringbootstarterreactive.error.exception.SignatureEmptyException;
import software.crldev.elrondspringbootstarterreactive.util.HexValidator;

public final class Signature {
    private final String hex;

    private Signature(String hex) {
        this.hex = hex;
    }

    public static Signature fromHex(String hexValue) {
        if (!HexValidator.isHexValid(hexValue, TransactionConstants.SIGNATURE_LENGTH_HEX)) {
            throw new CannotCreateSignatureException(hexValue);
        }
        return new Signature(hexValue);
    }

    public static Signature fromBuffer(byte[] buffer) {
        if (buffer.length != TransactionConstants.SIGNATURE_LENGTH) {
            throw new CannotCreateSignatureException(Arrays.toString(buffer));
        }
        return new Signature(Hex.toHexString((byte[])buffer));
    }

    public static Signature empty() {
        return new Signature("");
    }

    public String getHex() {
        if (this.isEmpty()) {
            throw new SignatureEmptyException();
        }
        return this.hex;
    }

    public boolean isEmpty() {
        return this.hex.isEmpty();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Signature)) {
            return false;
        }
        Signature other = (Signature)o;
        String this$hex = this.getHex();
        String other$hex = other.getHex();
        return !(this$hex == null ? other$hex != null : !this$hex.equals(other$hex));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $hex = this.getHex();
        result = result * 59 + ($hex == null ? 43 : $hex.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Signature(hex=" + this.getHex() + ")";
    }
}

