/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.domain.transaction;

import java.math.BigInteger;
import lombok.Generated;
import software.crldev.elrondspringbootstarterreactive.config.CurrencyConstants;
import software.crldev.elrondspringbootstarterreactive.error.exception.NegativeGasException;

public final class GasLimit {
    private final BigInteger value;

    private GasLimit(BigInteger value) {
        if (value.signum() == -1) {
            throw new NegativeGasException(value);
        }
        this.value = value;
    }

    public static GasLimit fromNumber(BigInteger value) {
        return new GasLimit(value);
    }

    public static GasLimit fromString(String value) {
        return GasLimit.fromNumber(new BigInteger(value));
    }

    public String toString() {
        return this.value.toString(CurrencyConstants.BASE10);
    }

    @Generated
    public BigInteger getValue() {
        return this.value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GasLimit)) {
            return false;
        }
        GasLimit other = (GasLimit)o;
        BigInteger this$value = this.getValue();
        BigInteger other$value = other.getValue();
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigInteger $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }
}

