/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.domain.wallet;

import java.io.File;
import java.util.List;
import software.crldev.elrondspringbootstarterreactive.domain.wallet.Wallet;
import software.crldev.elrondspringbootstarterreactive.error.exception.CannotCreateWalletException;
import software.crldev.elrondspringbootstarterreactive.util.MnemonicsUtils;
import software.crldev.elrondspringbootstarterreactive.util.PemUtils;

public class WalletCreator {
    public static Wallet fromPemFile(File pem) {
        try {
            String privateKeyHex = PemUtils.extractKeyHex(pem);
            return Wallet.fromPrivateKeyHex(privateKeyHex);
        }
        catch (Exception e) {
            throw new CannotCreateWalletException(e);
        }
    }

    public static Wallet fromMnemonic(List<String> mnemonics, long accountIndex) {
        byte[] privateKey = MnemonicsUtils.privateKeyFromMnemonic(mnemonics, accountIndex);
        return Wallet.fromPrivateKeyBuffer(privateKey);
    }
}

