/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.sender;

import lombok.Generated;
import lombok.NonNull;
import software.crldev.elrondspringbootstarterreactive.domain.account.Address;
import software.crldev.elrondspringbootstarterreactive.domain.common.Balance;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.PayloadData;
import software.crldev.elrondspringbootstarterreactive.domain.wallet.Wallet;

public final class TransactionRequest {
    @NonNull
    private final Wallet wallet;
    @NonNull
    private final Address receiverAddress;
    @NonNull
    private final Balance value;
    @NonNull
    private final PayloadData data;

    @Generated
    TransactionRequest(@NonNull Wallet wallet, @NonNull Address receiverAddress, @NonNull Balance value, @NonNull PayloadData data) {
        if (wallet == null) {
            throw new NullPointerException("wallet is marked non-null but is null");
        }
        if (receiverAddress == null) {
            throw new NullPointerException("receiverAddress is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        this.wallet = wallet;
        this.receiverAddress = receiverAddress;
        this.value = value;
        this.data = data;
    }

    @Generated
    public static TransactionRequestBuilder builder() {
        return new TransactionRequestBuilder();
    }

    @NonNull
    @Generated
    public Wallet getWallet() {
        return this.wallet;
    }

    @NonNull
    @Generated
    public Address getReceiverAddress() {
        return this.receiverAddress;
    }

    @NonNull
    @Generated
    public Balance getValue() {
        return this.value;
    }

    @NonNull
    @Generated
    public PayloadData getData() {
        return this.data;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionRequest)) {
            return false;
        }
        TransactionRequest other = (TransactionRequest)o;
        Wallet this$wallet = this.getWallet();
        Wallet other$wallet = other.getWallet();
        if (this$wallet == null ? other$wallet != null : !((Object)this$wallet).equals(other$wallet)) {
            return false;
        }
        Address this$receiverAddress = this.getReceiverAddress();
        Address other$receiverAddress = other.getReceiverAddress();
        if (this$receiverAddress == null ? other$receiverAddress != null : !this$receiverAddress.equals(other$receiverAddress)) {
            return false;
        }
        Balance this$value = this.getValue();
        Balance other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        PayloadData this$data = this.getData();
        PayloadData other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Wallet $wallet = this.getWallet();
        result = result * 59 + ($wallet == null ? 43 : ((Object)$wallet).hashCode());
        Address $receiverAddress = this.getReceiverAddress();
        result = result * 59 + ($receiverAddress == null ? 43 : $receiverAddress.hashCode());
        Balance $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        PayloadData $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TransactionRequest(wallet=" + this.getWallet() + ", receiverAddress=" + this.getReceiverAddress() + ", value=" + this.getValue() + ", data=" + this.getData() + ")";
    }

    @Generated
    public static class TransactionRequestBuilder {
        @Generated
        private Wallet wallet;
        @Generated
        private Address receiverAddress;
        @Generated
        private Balance value;
        @Generated
        private PayloadData data;

        @Generated
        TransactionRequestBuilder() {
        }

        @Generated
        public TransactionRequestBuilder wallet(@NonNull Wallet wallet) {
            if (wallet == null) {
                throw new NullPointerException("wallet is marked non-null but is null");
            }
            this.wallet = wallet;
            return this;
        }

        @Generated
        public TransactionRequestBuilder receiverAddress(@NonNull Address receiverAddress) {
            if (receiverAddress == null) {
                throw new NullPointerException("receiverAddress is marked non-null but is null");
            }
            this.receiverAddress = receiverAddress;
            return this;
        }

        @Generated
        public TransactionRequestBuilder value(@NonNull Balance value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.value = value;
            return this;
        }

        @Generated
        public TransactionRequestBuilder data(@NonNull PayloadData data) {
            if (data == null) {
                throw new NullPointerException("data is marked non-null but is null");
            }
            this.data = data;
            return this;
        }

        @Generated
        public TransactionRequest build() {
            return new TransactionRequest(this.wallet, this.receiverAddress, this.value, this.data);
        }

        @Generated
        public String toString() {
            return "TransactionRequest.TransactionRequestBuilder(wallet=" + this.wallet + ", receiverAddress=" + this.receiverAddress + ", value=" + this.value + ", data=" + this.data + ")";
        }
    }
}

