/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.sender;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import reactor.core.publisher.Mono;
import software.crldev.elrondspringbootstarterreactive.api.model.AddressNonce;
import software.crldev.elrondspringbootstarterreactive.api.model.SimulationResults;
import software.crldev.elrondspringbootstarterreactive.api.model.TransactionCostEstimation;
import software.crldev.elrondspringbootstarterreactive.api.model.TransactionHash;
import software.crldev.elrondspringbootstarterreactive.api.model.TransactionsSentResult;
import software.crldev.elrondspringbootstarterreactive.domain.account.Address;
import software.crldev.elrondspringbootstarterreactive.domain.common.Balance;
import software.crldev.elrondspringbootstarterreactive.domain.common.Nonce;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.PayloadData;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.Transaction;
import software.crldev.elrondspringbootstarterreactive.domain.wallet.Wallet;
import software.crldev.elrondspringbootstarterreactive.error.exception.MissingTransactionRequestException;
import software.crldev.elrondspringbootstarterreactive.interactor.account.ErdAccountInteractor;
import software.crldev.elrondspringbootstarterreactive.interactor.transaction.ErdTransactionInteractor;
import software.crldev.elrondspringbootstarterreactive.interactor.transaction.SendableTransaction;
import software.crldev.elrondspringbootstarterreactive.sender.ErdSimpleTransactionSender;
import software.crldev.elrondspringbootstarterreactive.sender.TransactionRequest;

public class ErdSimpleTransactionSenderImpl
implements ErdSimpleTransactionSender {
    private final ErdAccountInteractor accountInteractor;
    private final ErdTransactionInteractor transactionInteractor;

    @Override
    public Mono<TransactionHash> send(TransactionRequest request) {
        return this.assignNonce(request).map(nonce -> this.buildSendableFromRequest(request, (Long)nonce, false)).flatMap(this.transactionInteractor::sendTransaction);
    }

    @Override
    public Mono<TransactionsSentResult> sendBatchOfTransactions(List<TransactionRequest> request) {
        return this.assignNonce((TransactionRequest)request.stream().findFirst().orElseThrow(MissingTransactionRequestException::new)).map(n -> {
            ArrayList<SendableTransaction> listOfSendables = new ArrayList<SendableTransaction>();
            long i = 0L;
            for (long nonce = n.longValue(); i < (long)request.size() && nonce <= nonce + (long)request.size(); ++i, ++nonce) {
                listOfSendables.add(this.buildSendableFromRequest((TransactionRequest)request.get((int)i), nonce, false));
            }
            return listOfSendables;
        }).flatMap(this.transactionInteractor::sendBatchOfTransactions);
    }

    @Override
    public Mono<SimulationResults> simulate(TransactionRequest request) {
        return this.assignNonce(request).map(nonce -> this.buildSendableFromRequest(request, (Long)nonce, false)).flatMap(this.transactionInteractor::simulateTransaction);
    }

    @Override
    public Mono<TransactionCostEstimation> estimate(TransactionRequest request) {
        return this.assignNonce(request).map(nonce -> this.buildSendableFromRequest(request, (Long)nonce, true)).flatMap(this.transactionInteractor::estimateTransactionCost);
    }

    private SendableTransaction buildSendableFromRequest(TransactionRequest request, Long nonceValue, boolean isEstimationRequest) {
        Wallet wallet = request.getWallet();
        Address senderAddress = Address.fromHex(wallet.getPublicKeyHex());
        Address receiverAddress = request.getReceiverAddress();
        Nonce nonce = Nonce.fromLong(nonceValue);
        Balance value = request.getValue();
        PayloadData data = request.getData();
        Transaction transaction = new Transaction();
        transaction.setValue(value);
        transaction.setNonce(nonce);
        transaction.setReceiver(receiverAddress);
        transaction.setSender(senderAddress);
        transaction.setPayloadData(data);
        if (isEstimationRequest) {
            return transaction.toSendableForEstimation();
        }
        wallet.sign(transaction);
        return transaction.toSendable();
    }

    private Mono<Long> assignNonce(TransactionRequest request) {
        return this.accountInteractor.getNonce(Address.fromHex(request.getWallet().getPublicKeyHex())).map(AddressNonce::getNonce);
    }

    @Generated
    public ErdSimpleTransactionSenderImpl(ErdAccountInteractor accountInteractor, ErdTransactionInteractor transactionInteractor) {
        this.accountInteractor = accountInteractor;
        this.transactionInteractor = transactionInteractor;
    }
}

