/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.domain.transaction;

import com.fasterxml.jackson.core.JsonProcessingException;
import lombok.Generated;
import software.crldev.elrondspringbootstarterreactive.config.ErdNetworkConfigSupplier;
import software.crldev.elrondspringbootstarterreactive.config.JsonMapper;
import software.crldev.elrondspringbootstarterreactive.domain.account.Address;
import software.crldev.elrondspringbootstarterreactive.domain.common.Balance;
import software.crldev.elrondspringbootstarterreactive.domain.common.Nonce;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.ChainID;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.GasLimit;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.GasPrice;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.Hash;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.PayloadData;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.Signable;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.Signature;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.TransactionStatus;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.TransactionVersion;
import software.crldev.elrondspringbootstarterreactive.interactor.transaction.SendableTransaction;
import software.crldev.elrondspringbootstarterreactive.util.GasUtils;

public class Transaction
implements Signable {
    private Nonce nonce = Nonce.fromLong(0L);
    private ChainID chainID = ChainID.fromString(ErdNetworkConfigSupplier.config.getChainId());
    private Balance value = Balance.zero();
    private Address sender = Address.zero();
    private Address receiver = Address.zero();
    private GasPrice gasPrice = GasPrice.fromNumber(ErdNetworkConfigSupplier.config.getMinGasPrice());
    private GasLimit gasLimit = GasLimit.fromNumber(ErdNetworkConfigSupplier.config.getMinGasLimit());
    private PayloadData payloadData = PayloadData.empty();
    private TransactionVersion version = TransactionVersion.withDefaultVersion();
    private Signature signature = Signature.empty();
    private Hash hash = Hash.empty();
    private TransactionStatus status = TransactionStatus.UNKNOWN;

    @Override
    public byte[] serializeForSigning() throws JsonProcessingException {
        return JsonMapper.serializeToJsonBuffer(this.toSendable());
    }

    @Override
    public void applySignature(Signature signature) {
        this.setSignature(signature);
    }

    public SendableTransaction toSendable() {
        return this.generateSender(false);
    }

    public SendableTransaction toSendableForEstimation() {
        return this.generateSender(true);
    }

    public void setPayloadData(PayloadData payloadData) {
        this.payloadData = payloadData;
        this.gasLimit = GasLimit.fromNumber(GasUtils.computeGasCost(payloadData));
    }

    private SendableTransaction generateSender(boolean isEstimation) {
        SendableTransaction.SendableTransactionBuilder sendableBuilder = SendableTransaction.builder().chainId(this.chainID.getValue()).nonce(this.nonce.getValue()).value(this.value.toString()).receiver(this.receiver.getBech32()).sender(this.sender.getBech32()).data(this.payloadData.isEmpty() ? null : this.payloadData.encoded()).signature(this.signature.isEmpty() ? null : this.signature.getHex()).version(this.version.getValue());
        if (!isEstimation) {
            sendableBuilder.gasLimit(this.gasLimit.getValue());
            sendableBuilder.gasPrice(this.gasPrice.getValue());
        }
        return sendableBuilder.build();
    }

    @Generated
    public Transaction() {
    }

    @Generated
    public Nonce getNonce() {
        return this.nonce;
    }

    @Generated
    public ChainID getChainID() {
        return this.chainID;
    }

    @Generated
    public Balance getValue() {
        return this.value;
    }

    @Generated
    public Address getSender() {
        return this.sender;
    }

    @Generated
    public Address getReceiver() {
        return this.receiver;
    }

    @Generated
    public GasPrice getGasPrice() {
        return this.gasPrice;
    }

    @Generated
    public GasLimit getGasLimit() {
        return this.gasLimit;
    }

    @Generated
    public PayloadData getPayloadData() {
        return this.payloadData;
    }

    @Generated
    public TransactionVersion getVersion() {
        return this.version;
    }

    @Generated
    public Signature getSignature() {
        return this.signature;
    }

    @Generated
    public Hash getHash() {
        return this.hash;
    }

    @Generated
    public TransactionStatus getStatus() {
        return this.status;
    }

    @Generated
    public void setNonce(Nonce nonce) {
        this.nonce = nonce;
    }

    @Generated
    public void setChainID(ChainID chainID) {
        this.chainID = chainID;
    }

    @Generated
    public void setValue(Balance value) {
        this.value = value;
    }

    @Generated
    public void setSender(Address sender) {
        this.sender = sender;
    }

    @Generated
    public void setReceiver(Address receiver) {
        this.receiver = receiver;
    }

    @Generated
    public void setGasPrice(GasPrice gasPrice) {
        this.gasPrice = gasPrice;
    }

    @Generated
    public void setGasLimit(GasLimit gasLimit) {
        this.gasLimit = gasLimit;
    }

    @Generated
    public void setVersion(TransactionVersion version) {
        this.version = version;
    }

    @Generated
    public void setSignature(Signature signature) {
        this.signature = signature;
    }

    @Generated
    public void setHash(Hash hash) {
        this.hash = hash;
    }

    @Generated
    public void setStatus(TransactionStatus status) {
        this.status = status;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Transaction)) {
            return false;
        }
        Transaction other = (Transaction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Nonce this$nonce = this.getNonce();
        Nonce other$nonce = other.getNonce();
        if (this$nonce == null ? other$nonce != null : !((Object)this$nonce).equals(other$nonce)) {
            return false;
        }
        ChainID this$chainID = this.getChainID();
        ChainID other$chainID = other.getChainID();
        if (this$chainID == null ? other$chainID != null : !((Object)((Object)this$chainID)).equals((Object)other$chainID)) {
            return false;
        }
        Balance this$value = this.getValue();
        Balance other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        Address this$sender = this.getSender();
        Address other$sender = other.getSender();
        if (this$sender == null ? other$sender != null : !this$sender.equals(other$sender)) {
            return false;
        }
        Address this$receiver = this.getReceiver();
        Address other$receiver = other.getReceiver();
        if (this$receiver == null ? other$receiver != null : !this$receiver.equals(other$receiver)) {
            return false;
        }
        GasPrice this$gasPrice = this.getGasPrice();
        GasPrice other$gasPrice = other.getGasPrice();
        if (this$gasPrice == null ? other$gasPrice != null : !((Object)this$gasPrice).equals(other$gasPrice)) {
            return false;
        }
        GasLimit this$gasLimit = this.getGasLimit();
        GasLimit other$gasLimit = other.getGasLimit();
        if (this$gasLimit == null ? other$gasLimit != null : !((Object)this$gasLimit).equals(other$gasLimit)) {
            return false;
        }
        PayloadData this$payloadData = this.getPayloadData();
        PayloadData other$payloadData = other.getPayloadData();
        if (this$payloadData == null ? other$payloadData != null : !((Object)this$payloadData).equals(other$payloadData)) {
            return false;
        }
        TransactionVersion this$version = this.getVersion();
        TransactionVersion other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        Signature this$signature = this.getSignature();
        Signature other$signature = other.getSignature();
        if (this$signature == null ? other$signature != null : !((Object)this$signature).equals(other$signature)) {
            return false;
        }
        Hash this$hash = this.getHash();
        Hash other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !((Object)this$hash).equals(other$hash)) {
            return false;
        }
        TransactionStatus this$status = this.getStatus();
        TransactionStatus other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Transaction;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Nonce $nonce = this.getNonce();
        result = result * 59 + ($nonce == null ? 43 : ((Object)$nonce).hashCode());
        ChainID $chainID = this.getChainID();
        result = result * 59 + ($chainID == null ? 43 : ((Object)((Object)$chainID)).hashCode());
        Balance $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        Address $sender = this.getSender();
        result = result * 59 + ($sender == null ? 43 : $sender.hashCode());
        Address $receiver = this.getReceiver();
        result = result * 59 + ($receiver == null ? 43 : $receiver.hashCode());
        GasPrice $gasPrice = this.getGasPrice();
        result = result * 59 + ($gasPrice == null ? 43 : ((Object)$gasPrice).hashCode());
        GasLimit $gasLimit = this.getGasLimit();
        result = result * 59 + ($gasLimit == null ? 43 : ((Object)$gasLimit).hashCode());
        PayloadData $payloadData = this.getPayloadData();
        result = result * 59 + ($payloadData == null ? 43 : ((Object)$payloadData).hashCode());
        TransactionVersion $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        Signature $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : ((Object)$signature).hashCode());
        Hash $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : ((Object)$hash).hashCode());
        TransactionStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Transaction(nonce=" + this.getNonce() + ", chainID=" + this.getChainID() + ", value=" + this.getValue() + ", sender=" + this.getSender() + ", receiver=" + this.getReceiver() + ", gasPrice=" + this.getGasPrice() + ", gasLimit=" + this.getGasLimit() + ", payloadData=" + this.getPayloadData() + ", version=" + this.getVersion() + ", signature=" + this.getSignature() + ", hash=" + this.getHash() + ", status=" + this.getStatus() + ")";
    }
}

