/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.config;

import java.math.BigInteger;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.crldev.elrondspringbootstarterreactive.api.model.NetworkConfig;
import software.crldev.elrondspringbootstarterreactive.interactor.network.ErdNetworkInteractor;

public class ErdNetworkConfigSupplier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ErdNetworkConfigSupplier.class);
    private final ErdNetworkInteractor networkInteractor;
    public static NetworkConfig config;
    public static final Integer DEFAULT_VERSION;

    public ErdNetworkConfigSupplier(ErdNetworkInteractor networkInteractor) {
        this.networkInteractor = networkInteractor;
    }

    @PostConstruct
    public void sync() {
        this.networkInteractor.getNetworkConfig().doOnSuccess(r -> {
            config = r;
            log.info("Elrond network configuration synced. Chain ID: {}", (Object)r.getChainId());
        }).doOnError(e -> log.info("Could not sync Elrond network configuration at startup. Using defaults for chain ID {}.", (Object)config.getChainId())).subscribe();
    }

    static {
        DEFAULT_VERSION = 1;
        config = NetworkConfig.builder().chainId("D").gasPerDataByte(1500L).minGasLimit(BigInteger.valueOf(70000L)).minGasPrice(BigInteger.valueOf(1000000000L)).minTransactionVersion(DEFAULT_VERSION).build();
    }
}

