/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.client;

import java.util.Objects;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;
import software.crldev.elrondspringbootstarterreactive.api.ApiResponse;
import software.crldev.elrondspringbootstarterreactive.client.ErdProxyClient;
import software.crldev.elrondspringbootstarterreactive.config.ErdClientConfig;
import software.crldev.elrondspringbootstarterreactive.config.JsonMapper;
import software.crldev.elrondspringbootstarterreactive.error.exception.EmptyPayloadException;
import software.crldev.elrondspringbootstarterreactive.error.exception.ProxyRequestException;

public class ErdProxyClientImpl
implements ErdProxyClient {
    private final WebClient erdClient;

    public ErdProxyClientImpl(ErdClientConfig config) {
        this.erdClient = config.getErdClientBuilder().build();
    }

    @Override
    public <T> Mono<T> get(String uri, Class<T> responseType) {
        return this.processRequest(uri, null, responseType, HttpMethod.GET);
    }

    @Override
    public <T, P> Mono<T> post(String uri, P payload, Class<T> responseType) {
        return this.processRequest(uri, payload, responseType, HttpMethod.POST);
    }

    private <T, P> Mono<T> processRequest(String uri, P payload, Class<T> responseType, HttpMethod method) {
        WebClient.RequestBodySpec requestBuilder = (WebClient.RequestBodySpec)this.erdClient.method(method).uri(uri, new Object[0]);
        if (method == HttpMethod.POST) {
            if (Objects.nonNull(payload)) {
                requestBuilder.contentType(MediaType.APPLICATION_JSON).bodyValue(payload);
            } else {
                throw new EmptyPayloadException();
            }
        }
        return requestBuilder.exchangeToMono(r -> r.bodyToMono(String.class)).map(r -> JsonMapper.deserializeApiResponse(r, responseType)).doOnSuccess(this::onSuccess).doOnError(this::onError).map(ApiResponse::getData);
    }

    private <T> void onSuccess(ApiResponse<T> response) {
        response.throwIfError();
    }

    private void onError(Throwable t) {
        String errorMessage = t.getMessage();
        throw new ProxyRequestException(errorMessage);
    }
}

