/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.postgresql.ca;

import java.util.Properties;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.aws.rds.jdbc.postgresql.shading.org.postgresql.util.HostSpec;

public class HostInfo {
    public static final int NO_PORT = -1;
    private static final String HOST_PORT_SEPARATOR = ":";
    private final String endpoint;
    private final @Nullable String instanceIdentifier;
    private final boolean isWriter;
    private final int port;

    public HostInfo(String endpoint, @Nullable String instanceIdentifier, int port, boolean isWriter) {
        this.endpoint = endpoint;
        this.instanceIdentifier = instanceIdentifier;
        this.port = port;
        this.isWriter = isWriter;
    }

    private String getUrlFromEndpoint(String endpoint, int port, @Nullable String dbname) {
        if (dbname == null) {
            dbname = "";
        }
        return String.format("%s//%s:%d/%s", "jdbc:postgresql:aws:", endpoint, port, dbname);
    }

    public @Nullable String getUrl(@Nullable String dbname) {
        return this.getUrlFromEndpoint(this.endpoint, this.port, dbname);
    }

    public @Nullable String getUrl() {
        return this.getUrl("");
    }

    public @Nullable String getUrl(@Nullable Properties props) {
        String dbname = props == null ? "" : props.getProperty("PGDBNAME", "");
        return this.getUrl(dbname);
    }

    public String getHost() {
        return this.endpoint;
    }

    public int getPort() {
        return this.port;
    }

    public @Nullable String getInstanceIdentifier() {
        return this.instanceIdentifier;
    }

    public boolean isWriter() {
        return this.isWriter;
    }

    public String getHostPortPair() {
        return this.getHost() + HOST_PORT_SEPARATOR + this.getPort();
    }

    public boolean equalsHostPortPair(@Nullable HostInfo other) {
        if (other == null) {
            return false;
        }
        return this.getHostPortPair().equals(other.getHostPortPair());
    }

    public HostSpec toHostSpec() {
        return new HostSpec(this.getHost(), this.getPort());
    }

    public String toString() {
        return super.toString() + String.format(" :: {host: \"%s\", port: %d, isWriter: %b}", this.getHost(), this.getPort(), this.isWriter());
    }
}

