/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.postgresql.ca;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.aws.rds.jdbc.postgresql.ca.ConnectionProvider;
import software.aws.rds.jdbc.postgresql.ca.HostInfo;
import software.aws.rds.jdbc.postgresql.ca.ReaderFailoverHandler;
import software.aws.rds.jdbc.postgresql.ca.ReaderFailoverResult;
import software.aws.rds.jdbc.postgresql.ca.TopologyService;
import software.aws.rds.jdbc.postgresql.ca.WriterFailoverHandler;
import software.aws.rds.jdbc.postgresql.ca.WriterFailoverResult;
import software.aws.rds.jdbc.postgresql.shading.org.postgresql.core.BaseConnection;

public class ClusterAwareWriterFailoverHandler
implements WriterFailoverHandler {
    static final int WRITER_CONNECTION_INDEX = 0;
    private static final transient Logger LOGGER = Logger.getLogger(ClusterAwareWriterFailoverHandler.class.getName());
    protected int maxFailoverTimeoutMs = 60000;
    protected int readTopologyIntervalMs = 5000;
    protected int reconnectWriterIntervalMs = 5000;
    protected TopologyService topologyService;
    protected ConnectionProvider connectionProvider;
    protected ReaderFailoverHandler readerFailoverHandler;
    protected Properties connectionProps;

    public ClusterAwareWriterFailoverHandler(TopologyService topologyService, ConnectionProvider connectionProvider, Properties connectionProps, ReaderFailoverHandler readerFailoverHandler) {
        this.topologyService = topologyService;
        this.connectionProvider = connectionProvider;
        this.connectionProps = connectionProps;
        this.readerFailoverHandler = readerFailoverHandler;
    }

    public ClusterAwareWriterFailoverHandler(TopologyService topologyService, ConnectionProvider connectionProvider, Properties connectionProps, ReaderFailoverHandler readerFailoverHandler, int failoverTimeoutMs, int readTopologyIntervalMs, int reconnectWriterIntervalMs) {
        this(topologyService, connectionProvider, connectionProps, readerFailoverHandler);
        this.maxFailoverTimeoutMs = failoverTimeoutMs;
        this.readTopologyIntervalMs = readTopologyIntervalMs;
        this.reconnectWriterIntervalMs = reconnectWriterIntervalMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WriterFailoverResult failover(List<HostInfo> currentTopology) throws SQLException {
        if (currentTopology.isEmpty()) {
            LOGGER.log(Level.FINE, "[ClusterAwareWriterFailoverHandler] failover was called with an invalid (empty) topology");
            return new WriterFailoverResult(false, false, new ArrayList<HostInfo>(), null);
        }
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        ExecutorCompletionService<WriterFailoverResult> completionService = new ExecutorCompletionService<WriterFailoverResult>(executorService);
        this.submitTasks(currentTopology, executorService, completionService);
        try {
            for (int numTasks = 2; numTasks > 0; --numTasks) {
                WriterFailoverResult result = this.getNextResult(executorService, completionService);
                if (!result.isConnected()) continue;
                WriterFailoverResult writerFailoverResult = result;
                return writerFailoverResult;
            }
            LOGGER.log(Level.FINE, "[ClusterAwareWriterFailoverHandler] Failed to connect to the writer instance.");
            WriterFailoverResult writerFailoverResult = new WriterFailoverResult(false, false, new ArrayList<HostInfo>(), null);
            return writerFailoverResult;
        }
        finally {
            if (!executorService.isTerminated()) {
                executorService.shutdownNow();
            }
        }
    }

    private void submitTasks(List<HostInfo> currentTopology, ExecutorService executorService, CompletionService<WriterFailoverResult> completionService) {
        HostInfo writerHost = currentTopology.get(0);
        this.topologyService.addToDownHostList(writerHost);
        completionService.submit(new ReconnectToWriterHandler(writerHost));
        completionService.submit(new WaitForNewWriterHandler(currentTopology, writerHost));
        executorService.shutdown();
    }

    private WriterFailoverResult getNextResult(ExecutorService executorService, CompletionService<WriterFailoverResult> completionService) throws SQLException {
        try {
            Future<WriterFailoverResult> firstCompleted = completionService.poll(this.maxFailoverTimeoutMs, TimeUnit.MILLISECONDS);
            if (firstCompleted == null) {
                return new WriterFailoverResult(false, false, new ArrayList<HostInfo>(), null);
            }
            WriterFailoverResult result = firstCompleted.get();
            if (result.isConnected()) {
                executorService.shutdownNow();
                this.logTaskSuccess(result);
                return result;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw this.createInterruptedException(e);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return new WriterFailoverResult(false, false, new ArrayList<HostInfo>(), null);
    }

    private void logTaskSuccess(WriterFailoverResult result) {
        @Nullable List<HostInfo> topology = result.getTopology();
        if (topology == null || topology.isEmpty()) {
            String taskId = result.isNewHost() ? "TaskB" : "TaskA";
            LOGGER.log(Level.SEVERE, "[ClusterAwareWriterFailoverHandler] " + taskId + " successfully established a connection but doesn't contain a valid topology");
            return;
        }
        HostInfo newWriterHost = topology.get(0);
        String newWriterHostPair = newWriterHost == null ? "<null>" : newWriterHost.getHostPortPair();
        String message = result.isNewHost() ? "[ClusterAwareWriterFailoverHandler] Successfully connected to the new writer instance: ''{0}''" : "[ClusterAwareWriterFailoverHandler] Successfully re-connected to the current writer instance: ''{0}''";
        LOGGER.log(Level.FINE, message, newWriterHostPair);
    }

    private SQLException createInterruptedException(InterruptedException e) {
        return new SQLException("Thread was interrupted.", "70100", e);
    }

    private class WaitForNewWriterHandler
    implements Callable<WriterFailoverResult> {
        private @Nullable BaseConnection currentConnection = null;
        private final @Nullable HostInfo originalWriterHost;
        private List<HostInfo> currentTopology;
        private @Nullable HostInfo currentReaderHost;
        private @Nullable BaseConnection currentReaderConnection;

        WaitForNewWriterHandler(@Nullable List<HostInfo> currentTopology, HostInfo originalWriterHost) {
            this.currentTopology = currentTopology;
            this.originalWriterHost = originalWriterHost;
        }

        @Override
        public WriterFailoverResult call() {
            LOGGER.log(Level.FINE, "[ClusterAwareWriterFailoverHandler] [TaskB] Attempting to connect to a new writer instance");
            try {
                boolean success = false;
                while (!success) {
                    this.connectToReader();
                    success = this.refreshTopologyAndConnectToNewWriter();
                    if (success) continue;
                    this.closeReaderConnection();
                }
                WriterFailoverResult writerFailoverResult = new WriterFailoverResult(true, true, this.currentTopology, this.currentConnection);
                return writerFailoverResult;
            }
            catch (InterruptedException exception) {
                Thread.currentThread().interrupt();
                WriterFailoverResult writerFailoverResult = new WriterFailoverResult(false, false, new ArrayList<HostInfo>(), null);
                return writerFailoverResult;
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "[ClusterAwareWriterFailoverHandler] [TaskB] encountered an exception: {0}", ex);
                throw ex;
            }
            finally {
                this.performFinalCleanup();
            }
        }

        private void connectToReader() throws InterruptedException {
            while (true) {
                try {
                    ReaderFailoverResult connResult = ClusterAwareWriterFailoverHandler.this.readerFailoverHandler.getReaderConnection(this.currentTopology);
                    if (connResult.isConnected() && connResult.getConnection() != null && connResult.getHost() != null) {
                        this.currentReaderConnection = connResult.getConnection();
                        this.currentReaderHost = connResult.getHost();
                        String hostPortPair = "<null>";
                        if (this.currentReaderHost != null) {
                            hostPortPair = this.currentReaderHost.getHostPortPair();
                        }
                        LOGGER.log(Level.FINE, "[ClusterAwareWriterFailoverHandler] [TaskB] Connected to reader {0}", hostPortPair);
                        break;
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                LOGGER.log(Level.FINER, "[ClusterAwareWriterFailoverHandler] [TaskB] Failed to connect to any reader.");
                TimeUnit.MILLISECONDS.sleep(1L);
            }
        }

        private boolean refreshTopologyAndConnectToNewWriter() throws InterruptedException {
            while (this.currentReaderConnection != null) {
                List<HostInfo> topology = ClusterAwareWriterFailoverHandler.this.topologyService.getTopology(this.currentReaderConnection, true);
                if (!topology.isEmpty()) {
                    this.currentTopology = topology;
                    this.logTopology();
                    HostInfo writerCandidate = this.currentTopology.get(0);
                    if (!this.isSame(writerCandidate, this.originalWriterHost) && this.connectToWriter(writerCandidate)) {
                        return true;
                    }
                }
                TimeUnit.MILLISECONDS.sleep(ClusterAwareWriterFailoverHandler.this.readTopologyIntervalMs);
            }
            return false;
        }

        private boolean connectToWriter(HostInfo writerCandidate) {
            try {
                LOGGER.log(Level.FINER, "[ClusterAwareWriterFailoverHandler] [TaskB] Trying to connect to a new writer {0}", writerCandidate.getHostPortPair());
                this.currentConnection = this.isSame(writerCandidate, this.currentReaderHost) ? this.currentReaderConnection : ClusterAwareWriterFailoverHandler.this.connectionProvider.connect(writerCandidate.toHostSpec(), ClusterAwareWriterFailoverHandler.this.connectionProps, writerCandidate.getUrl(ClusterAwareWriterFailoverHandler.this.connectionProps));
                ClusterAwareWriterFailoverHandler.this.topologyService.removeFromDownHostList(writerCandidate);
                return true;
            }
            catch (SQLException exception) {
                ClusterAwareWriterFailoverHandler.this.topologyService.addToDownHostList(writerCandidate);
                return false;
            }
        }

        private boolean isSame(HostInfo writerCandidate, @Nullable HostInfo originalWriter) {
            if (writerCandidate == null || originalWriter == null) {
                return false;
            }
            String writerCandidateName = writerCandidate.getInstanceIdentifier();
            return writerCandidateName != null && writerCandidateName.equals(originalWriter.getInstanceIdentifier());
        }

        private void closeReaderConnection() {
            try {
                if (this.currentReaderConnection != null && !this.currentReaderConnection.isClosed()) {
                    this.currentReaderConnection.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.currentReaderConnection = null;
            this.currentReaderHost = null;
        }

        private void logTopology() {
            StringBuilder msg = new StringBuilder();
            for (int i = 0; i < this.currentTopology.size(); ++i) {
                HostInfo hostInfo = this.currentTopology.get(i);
                msg.append("\n   [").append(i).append("]: ").append(hostInfo == null ? "<null>" : hostInfo.getHost());
            }
            LOGGER.log(Level.FINER, "[ClusterAwareWriterFailoverHandler] [TaskB] Topology obtained: {0}", msg.toString());
        }

        private void performFinalCleanup() {
            if (this.currentReaderConnection != null && this.currentConnection != this.currentReaderConnection) {
                try {
                    this.currentReaderConnection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            LOGGER.log(Level.FINE, "[ClusterAwareWriterFailoverHandler] [TaskB] Finished");
        }
    }

    private class ReconnectToWriterHandler
    implements Callable<WriterFailoverResult> {
        private final HostInfo originalWriterHost;

        ReconnectToWriterHandler(HostInfo originalWriterHost) {
            this.originalWriterHost = originalWriterHost;
        }

        /*
         * Exception decompiling
         */
        @Override
        public WriterFailoverResult call() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[UNCONDITIONALDOLOOP]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private boolean isCurrentHostWriter(List<HostInfo> latestTopology) {
            String currentWriterName = this.originalWriterHost.getInstanceIdentifier();
            HostInfo latestWriter = latestTopology.get(0);
            if (currentWriterName == null || latestWriter == null) {
                return false;
            }
            String latestWriterName = latestWriter.getInstanceIdentifier();
            return latestWriterName != null && latestWriterName.equals(currentWriterName);
        }
    }
}

