/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.postgresql.ca;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.initialization.qual.UnderInitialization;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
import software.aws.rds.jdbc.postgresql.ca.AuroraTopologyService;
import software.aws.rds.jdbc.postgresql.ca.BasicConnectionProvider;
import software.aws.rds.jdbc.postgresql.ca.ClusterAwareReaderFailoverHandler;
import software.aws.rds.jdbc.postgresql.ca.ClusterAwareWriterFailoverHandler;
import software.aws.rds.jdbc.postgresql.ca.ConnectionProvider;
import software.aws.rds.jdbc.postgresql.ca.HostInfo;
import software.aws.rds.jdbc.postgresql.ca.RdsDnsAnalyzer;
import software.aws.rds.jdbc.postgresql.ca.ReaderFailoverHandler;
import software.aws.rds.jdbc.postgresql.ca.ReaderFailoverResult;
import software.aws.rds.jdbc.postgresql.ca.TopologyService;
import software.aws.rds.jdbc.postgresql.ca.WriterFailoverHandler;
import software.aws.rds.jdbc.postgresql.ca.WriterFailoverResult;
import software.aws.rds.jdbc.postgresql.ca.metrics.ClusterAwareMetrics;
import software.aws.rds.jdbc.postgresql.shading.org.postgresql.PGProperty;
import software.aws.rds.jdbc.postgresql.shading.org.postgresql.core.BaseConnection;
import software.aws.rds.jdbc.postgresql.shading.org.postgresql.core.TransactionState;
import software.aws.rds.jdbc.postgresql.shading.org.postgresql.util.HostSpec;
import software.aws.rds.jdbc.postgresql.shading.org.postgresql.util.IpAddressUtils;
import software.aws.rds.jdbc.postgresql.shading.org.postgresql.util.PSQLException;
import software.aws.rds.jdbc.postgresql.shading.org.postgresql.util.PSQLState;
import software.aws.rds.jdbc.postgresql.shading.org.postgresql.util.Util;

public class ClusterAwareConnectionProxy
implements InvocationHandler {
    static final String METHOD_ABORT = "abort";
    static final String METHOD_CLOSE = "close";
    static final String METHOD_COMMIT = "commit";
    static final String METHOD_EQUALS = "equals";
    static final String METHOD_GET_AUTO_COMMIT = "getAutoCommit";
    static final String METHOD_GET_CATALOG = "getCatalog";
    static final String METHOD_GET_SCHEMA = "getSchema";
    static final String METHOD_GET_TRANSACTION_ISOLATION = "getTransactionIsolation";
    static final String METHOD_HASH_CODE = "hashCode";
    static final String METHOD_IS_CLOSED = "isClosed";
    static final String METHOD_ROLLBACK = "rollback";
    static final String METHOD_SET_AUTO_COMMIT = "setAutoCommit";
    static final String METHOD_SET_READ_ONLY = "setReadOnly";
    protected static final int DEFAULT_SOCKET_TIMEOUT = 10;
    protected static final int DEFAULT_CONNECT_TIMEOUT = 30;
    protected static final int WRITER_CONNECTION_INDEX = 0;
    private static final transient Logger LOGGER = Logger.getLogger(ClusterAwareConnectionProxy.class.getName());
    protected final String originalUrl;
    protected boolean explicitlyReadOnly = false;
    protected boolean inTransaction = false;
    protected boolean isClusterTopologyAvailable = false;
    protected boolean isRdsProxy = false;
    protected boolean isRds = false;
    protected TopologyService topologyService;
    protected List<HostInfo> hosts = new ArrayList<HostInfo>();
    protected Properties initialConnectionProps;
    protected WriterFailoverHandler writerFailoverHandler;
    protected ReaderFailoverHandler readerFailoverHandler;
    protected RdsDnsAnalyzer rdsDnsAnalyzer;
    protected ConnectionProvider connectionProvider;
    protected @Nullable BaseConnection currentConnection;
    protected @Nullable HostInfo currentHost;
    protected boolean isClosed = false;
    protected boolean closedExplicitly = false;
    protected @Nullable String closedReason = null;
    protected ClusterAwareMetrics metrics = new ClusterAwareMetrics();
    private long invokeStartTimeMs;
    private long failoverStartTimeMs;
    protected boolean enableFailoverSetting = true;
    protected int clusterTopologyRefreshRateMsSetting;
    protected @Nullable String clusterIdSetting;
    protected @Nullable String clusterInstanceHostPatternSetting;
    protected boolean gatherPerfMetricsSetting;
    protected int failoverTimeoutMsSetting;
    protected int failoverClusterTopologyRefreshRateMsSetting;
    protected int failoverWriterReconnectIntervalMsSetting;
    protected int failoverReaderConnectTimeoutMsSetting;
    protected int failoverConnectTimeout;
    protected int failoverSocketTimeout;
    protected @Nullable Throwable lastHandledException = null;

    public ClusterAwareConnectionProxy(HostSpec hostSpec, Properties props, String url) throws SQLException {
        this.originalUrl = url;
        this.initSettings(props);
        this.initProxyFields(props);
        this.initProxy(hostSpec, props, url);
    }

    ClusterAwareConnectionProxy(HostSpec hostSpec, Properties props, String url, ConnectionProvider connectionProvider, TopologyService service, WriterFailoverHandler writerFailoverHandler, ReaderFailoverHandler readerFailoverHandler, RdsDnsAnalyzer rdsDnsAnalyzer) throws SQLException {
        this.originalUrl = url;
        this.initSettings(props);
        this.initProxyFields(props, connectionProvider, service, writerFailoverHandler, readerFailoverHandler, rdsDnsAnalyzer);
        this.initProxy(hostSpec, props, url);
    }

    private synchronized void initSettings(@UnderInitialization ClusterAwareConnectionProxy this, Properties props) throws PSQLException {
        this.clusterIdSetting = PGProperty.CLUSTER_ID.get(props);
        this.clusterInstanceHostPatternSetting = PGProperty.CLUSTER_INSTANCE_HOST_PATTERN.get(props);
        this.clusterTopologyRefreshRateMsSetting = PGProperty.CLUSTER_TOPOLOGY_REFRESH_RATE_MS.getInt(props);
        this.failoverClusterTopologyRefreshRateMsSetting = PGProperty.FAILOVER_CLUSTER_TOPOLOGY_REFRESH_RATE_MS.getInt(props);
        this.failoverReaderConnectTimeoutMsSetting = PGProperty.FAILOVER_READER_CONNECT_TIMEOUT_MS.getInt(props);
        this.failoverTimeoutMsSetting = PGProperty.FAILOVER_TIMEOUT_MS.getInt(props);
        this.failoverWriterReconnectIntervalMsSetting = PGProperty.FAILOVER_WRITER_RECONNECT_INTERVAL_MS.getInt(props);
        this.failoverConnectTimeout = props.getProperty(PGProperty.CONNECT_TIMEOUT.getName(), null) != null ? PGProperty.CONNECT_TIMEOUT.getInt(props) : 30;
        this.failoverSocketTimeout = props.getProperty(PGProperty.SOCKET_TIMEOUT.getName(), null) != null ? PGProperty.SOCKET_TIMEOUT.getInt(props) : 10;
        this.enableFailoverSetting = PGProperty.ENABLE_CLUSTER_AWARE_FAILOVER.getBoolean(props);
        this.gatherPerfMetricsSetting = PGProperty.GATHER_PERF_METRICS.getBoolean(props);
    }

    @EnsuresNonNull(value={"this.topologyService", "this.connectionProvider", "this.writerFailoverHandler", "this.readerFailoverHandler", "this.initialConnectionProps", "this.rdsDnsAnalyzer"})
    @RequiresNonNull(value={"this.metrics"})
    private synchronized void initProxyFields(@UnderInitialization ClusterAwareConnectionProxy this, Properties props) {
        this.initialConnectionProps = (Properties)props.clone();
        PGProperty.CONNECT_TIMEOUT.set(this.initialConnectionProps, this.failoverConnectTimeout);
        PGProperty.SOCKET_TIMEOUT.set(this.initialConnectionProps, this.failoverSocketTimeout);
        AuroraTopologyService topologyService = new AuroraTopologyService();
        topologyService.setPerformanceMetrics(this.metrics, this.gatherPerfMetricsSetting);
        topologyService.setRefreshRate(this.clusterTopologyRefreshRateMsSetting);
        this.topologyService = topologyService;
        this.connectionProvider = new BasicConnectionProvider();
        this.readerFailoverHandler = new ClusterAwareReaderFailoverHandler(this.topologyService, this.connectionProvider, this.initialConnectionProps, this.failoverTimeoutMsSetting, this.failoverReaderConnectTimeoutMsSetting);
        this.writerFailoverHandler = new ClusterAwareWriterFailoverHandler(this.topologyService, this.connectionProvider, this.initialConnectionProps, this.readerFailoverHandler, this.failoverTimeoutMsSetting, this.failoverClusterTopologyRefreshRateMsSetting, this.failoverWriterReconnectIntervalMsSetting);
        this.rdsDnsAnalyzer = new RdsDnsAnalyzer();
    }

    @EnsuresNonNull(value={"this.topologyService", "this.connectionProvider", "this.writerFailoverHandler", "this.readerFailoverHandler", "this.initialConnectionProps", "this.rdsDnsAnalyzer"})
    private synchronized void initProxyFields(@UnderInitialization ClusterAwareConnectionProxy this, Properties props, ConnectionProvider connectionProvider, TopologyService service, WriterFailoverHandler writerFailoverHandler, ReaderFailoverHandler readerFailoverHandler, RdsDnsAnalyzer rdsDnsAnalyzer) {
        this.initialConnectionProps = (Properties)props.clone();
        PGProperty.CONNECT_TIMEOUT.set(this.initialConnectionProps, this.failoverConnectTimeout);
        PGProperty.SOCKET_TIMEOUT.set(this.initialConnectionProps, this.failoverSocketTimeout);
        this.topologyService = service;
        this.topologyService.setRefreshRate(this.clusterTopologyRefreshRateMsSetting);
        this.writerFailoverHandler = writerFailoverHandler;
        this.readerFailoverHandler = readerFailoverHandler;
        this.rdsDnsAnalyzer = rdsDnsAnalyzer;
        this.connectionProvider = connectionProvider;
    }

    @RequiresNonNull(value={"this.topologyService", "this.connectionProvider", "this.writerFailoverHandler", "this.readerFailoverHandler", "this.rdsDnsAnalyzer", "this.initialConnectionProps", "this.metrics", "this.hosts"})
    private synchronized void initProxy(@UnderInitialization ClusterAwareConnectionProxy this, HostSpec hostSpec, Properties props, String url) throws SQLException {
        if (!this.enableFailoverSetting) {
            this.currentConnection = this.connectionProvider.connect(hostSpec, props, url);
            return;
        }
        LOGGER.log(Level.FINE, "[ClusterAwareConnectionProxy] Cluster-aware failover is enabled.");
        LOGGER.log(Level.FINER, "[ClusterAwareConnectionProxy] 'clusterId' configuration setting: {0}", this.clusterIdSetting);
        LOGGER.log(Level.FINER, "[ClusterAwareConnectionProxy] 'clusterInstanceHostPatternSetting' configuration setting: {0}", this.clusterInstanceHostPatternSetting);
        if (!Util.isNullOrEmpty(this.clusterInstanceHostPatternSetting)) {
            this.initFromHostPatternSetting(hostSpec, props, url);
        } else if (IpAddressUtils.isIPv4(hostSpec.getHost()) || IpAddressUtils.isIPv6(hostSpec.getHost())) {
            this.initExpectingNoTopology(hostSpec, props, url);
        } else {
            this.identifyRdsType(hostSpec.getHost());
            if (!this.isRds) {
                this.initExpectingNoTopology(hostSpec, props, url);
            } else {
                this.initFromConnectionString(hostSpec, props, url);
            }
        }
    }

    @RequiresNonNull(value={"this.topologyService", "this.connectionProvider", "this.writerFailoverHandler", "this.readerFailoverHandler", "this.rdsDnsAnalyzer", "this.initialConnectionProps", "this.metrics", "this.hosts"})
    private void initFromHostPatternSetting(@UnderInitialization ClusterAwareConnectionProxy this, HostSpec connectionStringHostSpec, Properties props, String url) throws SQLException {
        HostSpec patternSettingHostSpec = this.getHostSpecFromHostPatternSetting();
        String instanceHostPattern = patternSettingHostSpec.getHost();
        int instanceHostPort = patternSettingHostSpec.getPort() != -1 ? patternSettingHostSpec.getPort() : connectionStringHostSpec.getPort();
        this.setClusterId(instanceHostPattern, instanceHostPort);
        this.topologyService.setClusterInstanceTemplate(this.createClusterInstanceTemplate(instanceHostPattern, instanceHostPort));
        this.createConnectionAndInitializeTopology(connectionStringHostSpec, props, url);
    }

    @RequiresNonNull(value={"this.rdsDnsAnalyzer"})
    private HostSpec getHostSpecFromHostPatternSetting(@UnderInitialization ClusterAwareConnectionProxy this) throws SQLException {
        HostSpec hostSpec = Util.parseUrl(this.clusterInstanceHostPatternSetting);
        if (hostSpec == null) {
            throw new SQLException("Invalid value in 'clusterInstanceHostPattern' configuration setting - the value could not be parsed");
        }
        this.validateHostPatternSetting(hostSpec);
        return hostSpec;
    }

    @RequiresNonNull(value={"this.rdsDnsAnalyzer"})
    private void validateHostPatternSetting(@UnderInitialization ClusterAwareConnectionProxy this, HostSpec hostSpec) throws SQLException {
        String hostPattern = hostSpec.getHost();
        if (!this.isDnsPatternValid(hostPattern)) {
            String invalidDnsPatternError = "Invalid value set for the 'clusterInstanceHostPattern' configuration setting - the host pattern must contain a '?' character as a placeholder for the DB instance identifiers of the instances in the cluster";
            LOGGER.log(Level.SEVERE, invalidDnsPatternError);
            throw new SQLException(invalidDnsPatternError);
        }
        this.identifyRdsType(hostPattern);
        if (this.isRdsProxy) {
            String rdsProxyInstancePatternError = "An RDS Proxy url can't be used as the 'clusterInstanceHostPattern' configuration setting.";
            LOGGER.log(Level.SEVERE, rdsProxyInstancePatternError);
            throw new SQLException(rdsProxyInstancePatternError);
        }
        if (this.rdsDnsAnalyzer.isRdsCustomClusterDns(hostPattern)) {
            String rdsCustomClusterInstancePatternError = "An RDS Custom Cluster endpoint can't be used as the 'clusterInstanceHostPattern' configuration setting";
            LOGGER.log(Level.SEVERE, rdsCustomClusterInstancePatternError);
            throw new SQLException(rdsCustomClusterInstancePatternError);
        }
    }

    private boolean isDnsPatternValid(@UnderInitialization ClusterAwareConnectionProxy this, String pattern) {
        return pattern.contains("?");
    }

    @RequiresNonNull(value={"this.rdsDnsAnalyzer"})
    private void identifyRdsType(@UnderInitialization ClusterAwareConnectionProxy this, String host) {
        this.isRds = this.rdsDnsAnalyzer.isRdsDns(host);
        LOGGER.log(Level.FINER, "[ClusterAwareConnectionProxy] isRds={0}", this.isRds);
        this.isRdsProxy = this.rdsDnsAnalyzer.isRdsProxyDns(host);
        LOGGER.log(Level.FINER, "[ClusterAwareConnectionProxy] isRdsProxy={0}", this.isRdsProxy);
    }

    @RequiresNonNull(value={"this.topologyService", "this.connectionProvider", "this.writerFailoverHandler", "this.readerFailoverHandler", "this.rdsDnsAnalyzer", "this.initialConnectionProps", "this.metrics", "this.hosts"})
    private void initExpectingNoTopology(@UnderInitialization ClusterAwareConnectionProxy this, HostSpec hostSpec, Properties props, String url) throws SQLException {
        this.setClusterId(hostSpec.getHost(), hostSpec.getPort());
        this.topologyService.setClusterInstanceTemplate(this.createClusterInstanceTemplate(hostSpec.getHost(), hostSpec.getPort()));
        this.createConnectionAndInitializeTopology(hostSpec, props, url);
        if (this.isClusterTopologyAvailable) {
            String instanceHostPatternRequiredError = "The 'clusterInstanceHostPattern' configuration property is required when an IP address or custom domain is used to connect to a cluster that provides topology information. If you would instead like to connect without failover functionality, set the 'enableClusterAwareFailover' configuration property to false.";
            LOGGER.log(Level.SEVERE, instanceHostPatternRequiredError);
            throw new SQLException(instanceHostPatternRequiredError);
        }
    }

    @RequiresNonNull(value={"this.topologyService", "this.connectionProvider", "this.writerFailoverHandler", "this.readerFailoverHandler", "this.rdsDnsAnalyzer", "this.initialConnectionProps", "this.metrics", "this.hosts"})
    private void initFromConnectionString(@UnderInitialization ClusterAwareConnectionProxy this, HostSpec hostSpec, Properties props, String url) throws SQLException {
        String rdsInstanceHostPattern = this.rdsDnsAnalyzer.getRdsInstanceHostPattern(hostSpec.getHost());
        if (rdsInstanceHostPattern == null) {
            String unexpectedConnectionStringPattern = "The provided connection string does not appear to match an expected Aurora DNS pattern. Please set the 'clusterInstanceHostPattern' configuration property to specify the host pattern for the cluster you are trying to connect to.";
            LOGGER.log(Level.SEVERE, unexpectedConnectionStringPattern);
            throw new SQLException(unexpectedConnectionStringPattern);
        }
        this.setClusterId(hostSpec.getHost(), hostSpec.getPort());
        this.topologyService.setClusterInstanceTemplate(this.createClusterInstanceTemplate(rdsInstanceHostPattern, hostSpec.getPort()));
        this.createConnectionAndInitializeTopology(hostSpec, props, url);
    }

    @RequiresNonNull(value={"this.topologyService", "this.rdsDnsAnalyzer"})
    private void setClusterId(@UnderInitialization ClusterAwareConnectionProxy this, String host, int port) {
        String clusterRdsHostUrl;
        if (!Util.isNullOrEmpty(this.clusterIdSetting)) {
            this.topologyService.setClusterId(this.clusterIdSetting);
        } else if (this.isRdsProxy) {
            this.topologyService.setClusterId(host + ":" + port);
        } else if (this.isRds && !Util.isNullOrEmpty(clusterRdsHostUrl = this.rdsDnsAnalyzer.getRdsClusterHostUrl(host))) {
            this.topologyService.setClusterId(clusterRdsHostUrl + ":" + port);
        }
    }

    private HostInfo createClusterInstanceTemplate(@UnderInitialization ClusterAwareConnectionProxy this, String host, int port) {
        return new HostInfo(host, null, port, false);
    }

    @RequiresNonNull(value={"this.topologyService", "this.connectionProvider", "this.writerFailoverHandler", "this.readerFailoverHandler", "this.rdsDnsAnalyzer", "this.initialConnectionProps", "this.metrics", "this.hosts"})
    private synchronized void createConnectionAndInitializeTopology(@UnderInitialization ClusterAwareConnectionProxy this, HostSpec hostSpec, Properties props, String url) throws SQLException {
        boolean connectedUsingCachedTopology = this.createInitialConnection(hostSpec, props, url);
        this.initTopology(hostSpec, connectedUsingCachedTopology);
        this.finalizeConnection(connectedUsingCachedTopology);
    }

    @RequiresNonNull(value={"this.topologyService", "this.connectionProvider", "this.rdsDnsAnalyzer", "this.initialConnectionProps"})
    private boolean createInitialConnection(@UnderInitialization ClusterAwareConnectionProxy this, HostSpec hostSpec, Properties props, String url) throws SQLException {
        String host = hostSpec.getHost();
        boolean connectedUsingCachedTopology = false;
        if (this.rdsDnsAnalyzer.isRdsClusterDns(host)) {
            this.explicitlyReadOnly = this.rdsDnsAnalyzer.isReaderClusterDns(host);
            LOGGER.log(Level.FINER, "[ClusterAwareConnectionProxy] explicitlyReadOnly={0}", this.explicitlyReadOnly);
            try {
                this.attemptConnectionUsingCachedTopology();
                if (this.currentConnection != null && this.currentHost != null) {
                    connectedUsingCachedTopology = true;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (!this.isConnected()) {
            this.currentConnection = this.connectionProvider.connect(hostSpec, props, url);
        }
        return connectedUsingCachedTopology;
    }

    synchronized boolean isConnected(@UnknownInitialization ClusterAwareConnectionProxy this) {
        try {
            return this.currentConnection != null && !this.currentConnection.isClosed();
        }
        catch (SQLException e) {
            return false;
        }
    }

    @RequiresNonNull(value={"this.initialConnectionProps", "this.topologyService", "this.connectionProvider"})
    private void attemptConnectionUsingCachedTopology(@UnderInitialization ClusterAwareConnectionProxy this) throws SQLException {
        @Nullable List<HostInfo> cachedHosts = this.topologyService.getCachedTopology();
        if (cachedHosts != null && !cachedHosts.isEmpty()) {
            this.hosts = cachedHosts;
            HostInfo candidateHost = this.getCandidateHostForInitialConnection();
            if (candidateHost != null) {
                this.connectToHost(candidateHost);
            }
        }
    }

    @RequiresNonNull(value={"this.hosts", "this.topologyService"})
    private @Nullable HostInfo getCandidateHostForInitialConnection(@UnderInitialization ClusterAwareConnectionProxy this) {
        HostInfo candidateReader;
        if (this.explicitlyReadOnly && (candidateReader = this.getCandidateReaderForInitialConnection()) != null) {
            return candidateReader;
        }
        return this.hosts.get(0);
    }

    @RequiresNonNull(value={"this.topologyService", "this.hosts"})
    private @Nullable HostInfo getCandidateReaderForInitialConnection(@UnderInitialization ClusterAwareConnectionProxy this) {
        HostInfo lastUsedReader = this.topologyService.getLastUsedReaderHost();
        if (this.topologyContainsHost(lastUsedReader)) {
            return lastUsedReader;
        }
        return this.clusterContainsReader() ? this.getRandomReaderHost() : null;
    }

    @RequiresNonNull(value={"this.hosts"})
    private boolean topologyContainsHost(@UnderInitialization ClusterAwareConnectionProxy this, @Nullable HostInfo host) {
        if (host == null) {
            return false;
        }
        for (HostInfo potentialMatch : this.hosts) {
            if (potentialMatch == null || !potentialMatch.equalsHostPortPair(host)) continue;
            return true;
        }
        return false;
    }

    @RequiresNonNull(value={"this.hosts"})
    private boolean clusterContainsReader(@UnknownInitialization ClusterAwareConnectionProxy this) {
        return this.hosts.size() > 1;
    }

    @RequiresNonNull(value={"this.hosts"})
    private HostInfo getRandomReaderHost(@UnknownInitialization ClusterAwareConnectionProxy this) {
        int max = this.hosts.size() - 1;
        int min = 1;
        int readerIndex = (int)(Math.random() * (double)(max - min + 1)) + min;
        return this.hosts.get(readerIndex);
    }

    @RequiresNonNull(value={"this.topologyService", "this.rdsDnsAnalyzer", "this.hosts"})
    private synchronized void initTopology(@UnderInitialization ClusterAwareConnectionProxy this, HostSpec hostSpec, boolean connectedUsingCachedTopology) {
        if (this.currentConnection != null) {
            List<HostInfo> topology = this.topologyService.getTopology(this.currentConnection, false);
            this.hosts = topology.isEmpty() ? this.hosts : topology;
        }
        this.isClusterTopologyAvailable = !this.hosts.isEmpty();
        LOGGER.log(Level.FINER, "[ClusterAwareConnectionProxy] isClusterTopologyAvailable={0}", this.isClusterTopologyAvailable);
        if (connectedUsingCachedTopology || this.currentConnection != null && this.currentHost == null) {
            this.updateInitialHost(this.currentHost == null ? hostSpec : this.currentHost.toHostSpec(), connectedUsingCachedTopology);
        }
    }

    @RequiresNonNull(value={"this.hosts", "this.rdsDnsAnalyzer"})
    private void updateInitialHost(@UnderInitialization ClusterAwareConnectionProxy this, HostSpec hostSpec, boolean connectedUsingCachedTopology) {
        String connUrlHost = hostSpec.getHost();
        if (!connectedUsingCachedTopology && this.rdsDnsAnalyzer.isWriterClusterDns(connUrlHost) && !this.hosts.isEmpty()) {
            this.currentHost = this.hosts.get(0);
        } else {
            for (HostInfo host : this.hosts) {
                if (!hostSpec.toString().equals(host.getHostPortPair())) continue;
                this.currentHost = host;
                return;
            }
            this.currentHost = null;
        }
    }

    @RequiresNonNull(value={"this.topologyService", "this.connectionProvider", "this.writerFailoverHandler", "this.readerFailoverHandler", "this.initialConnectionProps", "this.metrics", "this.hosts"})
    private void finalizeConnection(@UnderInitialization ClusterAwareConnectionProxy this, boolean connectedUsingCachedTopology) throws SQLException {
        if (this.isFailoverEnabled()) {
            this.logTopology();
            if (this.gatherPerfMetricsSetting) {
                this.failoverStartTimeMs = System.currentTimeMillis();
            }
            this.validateInitialConnection(connectedUsingCachedTopology);
            if (this.currentHost != null && this.explicitlyReadOnly) {
                this.topologyService.setLastUsedReaderHost(this.currentHost);
            }
        }
    }

    public synchronized boolean isFailoverEnabled(@UnknownInitialization ClusterAwareConnectionProxy this) {
        return this.enableFailoverSetting && !this.isRdsProxy && this.isClusterTopologyAvailable;
    }

    @RequiresNonNull(value={"this.initialConnectionProps", "this.topologyService", "this.metrics", "this.readerFailoverHandler", "this.writerFailoverHandler", "this.connectionProvider", "this.hosts"})
    private synchronized void validateInitialConnection(@UnderInitialization ClusterAwareConnectionProxy this, boolean connectedUsingCachedTopology) throws SQLException {
        if (!this.isConnected()) {
            this.switchConnection(true);
            return;
        }
        if (!this.invalidCachedWriterConnection(connectedUsingCachedTopology)) {
            return;
        }
        try {
            this.connectToHost(this.hosts.get(0));
        }
        catch (SQLException e) {
            this.failover();
        }
    }

    private boolean invalidCachedWriterConnection(@UnderInitialization ClusterAwareConnectionProxy this, boolean connectedUsingCachedTopology) {
        if (this.explicitlyReadOnly || !connectedUsingCachedTopology) {
            return false;
        }
        return this.currentHost == null || !this.currentHost.isWriter();
    }

    @RequiresNonNull(value={"this.initialConnectionProps", "this.topologyService", "this.metrics", "this.readerFailoverHandler", "this.writerFailoverHandler", "this.connectionProvider", "this.hosts"})
    protected synchronized void switchConnection(@UnknownInitialization ClusterAwareConnectionProxy this, boolean inInitialization) throws SQLException {
        if (this.isClosed && this.closedExplicitly) {
            LOGGER.log(Level.FINE, "[ClusterAwareConnectionProxy] Connection was closed by the user");
            return;
        }
        if (this.isConnected() || !inInitialization || this.hosts.isEmpty()) {
            this.failover();
            return;
        }
        if (this.shouldAttemptReaderConnection()) {
            this.failoverReader();
            return;
        }
        try {
            this.connectToHost(this.hosts.get(0));
            if (this.explicitlyReadOnly) {
                this.topologyService.setLastUsedReaderHost(this.currentHost);
            }
        }
        catch (SQLException e) {
            this.failover();
        }
    }

    @RequiresNonNull(value={"this.hosts"})
    private boolean shouldAttemptReaderConnection(@UnknownInitialization ClusterAwareConnectionProxy this) {
        return this.explicitlyReadOnly && this.clusterContainsReader();
    }

    @RequiresNonNull(value={"this.initialConnectionProps", "this.connectionProvider"})
    private synchronized void connectToHost(@UnknownInitialization ClusterAwareConnectionProxy this, HostInfo host) throws SQLException {
        try {
            BaseConnection connection = this.createConnectionForHost(host, this.initialConnectionProps);
            LOGGER.log(Level.FINE, "[ClusterAwareConnectionProxy] Connected to: {0}", host);
            this.invalidateCurrentConnection();
            boolean readOnly = this.explicitlyReadOnly ? true : (this.currentConnection != null ? this.currentConnection.isReadOnly() : false);
            this.syncSessionState(this.currentConnection, connection, readOnly);
            this.currentConnection = connection;
            this.currentHost = host;
            this.inTransaction = false;
        }
        catch (SQLException e) {
            if (this.currentConnection != null && host != null) {
                this.logConnectionFailure(host, e);
            }
            throw e;
        }
    }

    @RequiresNonNull(value={"this.connectionProvider"})
    protected synchronized @Nullable BaseConnection createConnectionForHost(@UnknownInitialization ClusterAwareConnectionProxy this, HostInfo hostInfo, Properties props) throws SQLException {
        String currentDbName;
        String dbname = props.getProperty("PGDBNAME", "");
        if (Util.isNullOrEmpty(dbname) && this.currentConnection != null && !Util.isNullOrEmpty(currentDbName = this.currentConnection.getCatalog())) {
            dbname = currentDbName;
        }
        return this.connectionProvider.connect(hostInfo.toHostSpec(), props, hostInfo.getUrl(dbname));
    }

    private synchronized void invalidateCurrentConnection(@UnknownInitialization ClusterAwareConnectionProxy this) {
        if (this.currentConnection == null) {
            return;
        }
        boolean bl = this.inTransaction = this.currentConnection.getQueryExecutor().getTransactionState() != TransactionState.IDLE;
        if (this.inTransaction) {
            try {
                if (this.currentConnection != null) {
                    this.currentConnection.rollback();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.invalidateConnection(this.currentConnection);
    }

    protected synchronized void invalidateConnection(@UnknownInitialization ClusterAwareConnectionProxy this, @Nullable BaseConnection conn) {
        try {
            if (conn != null && !conn.isClosed()) {
                conn.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void syncSessionState(@UnknownInitialization ClusterAwareConnectionProxy this, @Nullable BaseConnection source, @Nullable BaseConnection target, boolean readOnly) throws SQLException {
        if (target != null) {
            target.setReadOnly(readOnly);
        }
        if (source == null || target == null) {
            return;
        }
        target.setAutoCommit(source.getAutoCommit());
        target.setTransactionIsolation(source.getTransactionIsolation());
    }

    @RequiresNonNull(value={"this.topologyService", "this.initialConnectionProps", "this.readerFailoverHandler", "this.writerFailoverHandler", "this.metrics", "this.connectionProvider", "this.hosts"})
    protected synchronized void failover(@UnknownInitialization ClusterAwareConnectionProxy this) throws SQLException {
        if (this.currentConnection != null) {
            boolean bl = this.inTransaction = this.currentConnection.getQueryExecutor().getTransactionState() != TransactionState.IDLE;
        }
        if (this.shouldPerformWriterFailover()) {
            this.failoverWriter();
        } else {
            this.failoverReader();
        }
        if (this.inTransaction) {
            this.inTransaction = false;
            String transactionResolutionUnknownError = "Transaction resolution unknown. Please re-configure session state if required and try restarting the transaction.";
            LOGGER.log(Level.SEVERE, transactionResolutionUnknownError);
            throw new SQLException(transactionResolutionUnknownError, PSQLState.CONNECTION_FAILURE_DURING_TRANSACTION.getState());
        }
        String connectionChangedError = "The active SQL connection has changed due to a connection failure. Please re-configure session state if required.";
        LOGGER.log(Level.SEVERE, connectionChangedError);
        throw new SQLException(connectionChangedError, PSQLState.COMMUNICATION_LINK_CHANGED.getState());
    }

    private boolean shouldPerformWriterFailover(@UnknownInitialization ClusterAwareConnectionProxy this) {
        return !this.explicitlyReadOnly;
    }

    @RequiresNonNull(value={"this.topologyService", "this.initialConnectionProps", "this.writerFailoverHandler", "this.metrics", "this.hosts"})
    protected void failoverWriter(@UnknownInitialization ClusterAwareConnectionProxy this) throws SQLException {
        LOGGER.log(Level.FINE, "[ClusterAwareConnectionProxy] Starting writer failover procedure.");
        WriterFailoverResult failoverResult = this.writerFailoverHandler.failover(this.hosts);
        if (this.gatherPerfMetricsSetting) {
            long currentTimeMs = System.currentTimeMillis();
            this.metrics.registerWriterFailoverProcedureTime(currentTimeMs - this.failoverStartTimeMs);
            this.failoverStartTimeMs = 0L;
        }
        if (!failoverResult.isConnected()) {
            this.processFailoverFailureAndThrowException("Unable to establish SQL connection to the writer instance");
            return;
        }
        if (this.gatherPerfMetricsSetting) {
            this.metrics.registerFailoverConnects(true);
        }
        if (!failoverResult.getTopology().isEmpty()) {
            this.hosts = failoverResult.getTopology();
        }
        this.currentHost = this.hosts.get(0);
        this.currentConnection = failoverResult.getNewConnection();
        LOGGER.log(Level.FINE, "[ClusterAwareConnectionProxy] Connected to: {0}", this.currentHost);
    }

    @RequiresNonNull(value={"this.metrics"})
    private void processFailoverFailureAndThrowException(@UnknownInitialization ClusterAwareConnectionProxy this, String message) throws SQLException {
        if (this.gatherPerfMetricsSetting) {
            this.metrics.registerFailoverConnects(false);
        }
        LOGGER.log(Level.SEVERE, message);
        throw new SQLException(message, PSQLState.CONNECTION_UNABLE_TO_CONNECT.getState());
    }

    @RequiresNonNull(value={"this.topologyService", "this.initialConnectionProps", "this.readerFailoverHandler", "this.metrics", "this.writerFailoverHandler", "this.connectionProvider", "this.hosts"})
    protected void failoverReader(@UnknownInitialization ClusterAwareConnectionProxy this) throws SQLException {
        LOGGER.log(Level.FINE, "[ClusterAwareConnectionProxy] Starting reader failover procedure.");
        ReaderFailoverResult result = this.readerFailoverHandler.failover(this.hosts, this.currentHost);
        if (this.gatherPerfMetricsSetting) {
            long currentTimeMs = System.currentTimeMillis();
            this.metrics.registerReaderFailoverProcedureTime(currentTimeMs - this.failoverStartTimeMs);
            this.failoverStartTimeMs = 0L;
        }
        if (!result.isConnected()) {
            this.processFailoverFailureAndThrowException("Unable to establish a read-only connection");
            return;
        }
        if (this.gatherPerfMetricsSetting) {
            this.metrics.registerFailoverConnects(true);
        }
        this.currentHost = result.getHost();
        this.currentConnection = result.getConnection();
        this.updateTopologyAndConnectIfNeeded(true);
        this.topologyService.setLastUsedReaderHost(this.currentHost);
        LOGGER.log(Level.FINE, "[ClusterAwareConnectionProxy] Connected to: {0}", this.currentHost);
    }

    @RequiresNonNull(value={"this.initialConnectionProps", "this.topologyService", "this.metrics", "this.readerFailoverHandler", "this.writerFailoverHandler", "this.connectionProvider", "this.hosts"})
    protected void updateTopologyAndConnectIfNeeded(@UnknownInitialization ClusterAwareConnectionProxy this, boolean forceUpdate) throws SQLException {
        if (!this.isFailoverEnabled()) {
            return;
        }
        if (!this.isConnected()) {
            this.switchConnection(false);
            return;
        }
        List<HostInfo> latestTopology = null;
        if (this.currentConnection != null) {
            latestTopology = this.topologyService.getTopology(this.currentConnection, forceUpdate);
        }
        if (latestTopology == null || latestTopology.isEmpty()) {
            return;
        }
        this.hosts = latestTopology;
        if (this.currentHost == null) {
            return;
        }
        this.updateCurrentHost(latestTopology);
    }

    @RequiresNonNull(value={"this.connectionProvider", "this.topologyService", "this.readerFailoverHandler", "this.writerFailoverHandler", "this.initialConnectionProps", "this.hosts", "this.metrics"})
    private void updateCurrentHost(@UnknownInitialization ClusterAwareConnectionProxy this, List<HostInfo> latestTopology) throws SQLException {
        HostInfo latestHost = null;
        for (HostInfo host : latestTopology) {
            if (host == null || !host.equalsHostPortPair(this.currentHost)) continue;
            latestHost = host;
            break;
        }
        if (latestHost == null) {
            this.currentHost = null;
            this.switchConnection(false);
        } else {
            this.currentHost = latestHost;
        }
    }

    public boolean isRds() {
        return this.isRds;
    }

    public synchronized boolean isRdsProxy() {
        return this.isRdsProxy;
    }

    @Override
    public synchronized @Nullable Object invoke(Object proxy, Method method, @Nullable Object[] args) throws Throwable {
        this.invokeStartTimeMs = this.gatherPerfMetricsSetting ? System.currentTimeMillis() : 0L;
        String methodName = method.getName();
        if (!this.isForwardingRequired(methodName, args)) {
            return this.executeMethodWithoutForwarding(methodName, args);
        }
        try {
            this.updateTopologyAndConnectIfNeeded(false);
            if (this.isClosed && !this.allowedOnClosedConnection(method)) {
                throw this.getInvalidInvocationOnClosedConnectionException();
            }
            Object result = null;
            try {
                result = method.invoke((Object)this.currentConnection, args);
                result = this.wrapWithProxyIfNeeded(method.getReturnType(), result);
            }
            catch (InvocationTargetException e) {
                this.processInvocationException(e);
            }
            catch (IllegalStateException e) {
                this.processIllegalStateException(e);
            }
            this.performSpecialMethodHandlingIfRequired(methodName, args);
            return result;
        }
        catch (InvocationTargetException e) {
            throw e.getCause() != null ? e.getCause() : e;
        }
        catch (Exception e) {
            throw this.wrapExceptionIfRequired(method, e);
        }
    }

    private boolean isForwardingRequired(String methodName, @Nullable Object[] args) {
        return !(METHOD_EQUALS.equals(methodName) && args != null && args.length > 0 && args[0] != null || METHOD_HASH_CODE.equals(methodName) || METHOD_CLOSE.equals(methodName) || METHOD_ABORT.equals(methodName) && args != null && args.length == 1 && args[0] != null || METHOD_IS_CLOSED.equals(methodName));
    }

    protected boolean allowedOnClosedConnection(Method method) {
        String methodName = method.getName();
        return methodName.equals(METHOD_GET_AUTO_COMMIT) || methodName.equals(METHOD_GET_CATALOG) || methodName.equals(METHOD_GET_SCHEMA) || methodName.equals(METHOD_GET_TRANSACTION_ISOLATION);
    }

    private @Nullable Object executeMethodWithoutForwarding(String methodName, @Nullable Object[] args) throws Throwable {
        if (METHOD_EQUALS.equals(methodName) && args != null && args.length > 0 && args[0] != null) {
            return args[0].equals(this);
        }
        if (METHOD_HASH_CODE.equals(methodName)) {
            return this.hashCode();
        }
        if (METHOD_CLOSE.equals(methodName)) {
            this.doClose();
            if (this.gatherPerfMetricsSetting) {
                this.metrics.reportMetrics(LOGGER);
            }
            this.isClosed = true;
            this.closedReason = "Connection explicitly closed.";
            this.closedExplicitly = true;
            return null;
        }
        if (METHOD_ABORT.equals(methodName) && args != null && args.length == 1 && args[0] != null) {
            this.doAbort((Executor)args[0]);
            if (this.gatherPerfMetricsSetting) {
                this.metrics.reportMetrics(LOGGER);
            }
            this.isClosed = true;
            this.closedReason = "Connection explicitly closed.";
            this.closedExplicitly = true;
            return null;
        }
        if (METHOD_IS_CLOSED.equals(methodName)) {
            return this.isClosed;
        }
        return null;
    }

    protected synchronized void doClose() throws SQLException {
        if (this.currentConnection != null) {
            this.currentConnection.close();
        }
    }

    protected synchronized void doAbort(Executor executor) throws SQLException {
        if (this.currentConnection != null) {
            this.currentConnection.abort(executor);
        }
    }

    private SQLException getInvalidInvocationOnClosedConnectionException() {
        String reason = "No operations allowed after connection closed.";
        if (!Util.isNullOrEmpty(this.closedReason)) {
            reason = reason + "  " + this.closedReason;
        }
        return new SQLException(reason, PSQLState.CONNECTION_DOES_NOT_EXIST.getState());
    }

    protected synchronized void processInvocationException(InvocationTargetException e) throws Throwable, InvocationTargetException {
        this.processException(e.getTargetException(), e);
    }

    protected void processIllegalStateException(IllegalStateException e) throws Throwable {
        this.processException(e.getCause(), e);
    }

    @RequiresNonNull(value={"this.metrics"})
    private synchronized void processException(@Nullable Throwable originalException, Exception wrapperException) throws Throwable {
        if (originalException != null) {
            LOGGER.log(Level.WARNING, "[ClusterAwareConnectionProxy] Detected an exception while executing a command: {0}", originalException.getMessage());
            LOGGER.log(Level.FINER, Util.stackTraceToString(originalException, this.getClass()));
            if (this.lastHandledException != originalException && this.isConnectionSwitchRequired(originalException)) {
                if (this.gatherPerfMetricsSetting) {
                    long currentTimeMs = System.currentTimeMillis();
                    this.metrics.registerFailureDetectionTime(currentTimeMs - this.invokeStartTimeMs);
                    this.invokeStartTimeMs = 0L;
                    this.failoverStartTimeMs = currentTimeMs;
                }
                this.invalidateCurrentConnection();
                this.switchConnection(false);
                this.lastHandledException = originalException;
            }
            throw originalException;
        }
        throw wrapperException;
    }

    protected boolean isConnectionSwitchRequired(Throwable t) {
        if (!this.isFailoverEnabled()) {
            LOGGER.log(Level.FINE, "[ClusterAwareConnectionProxy] Cluster-aware failover is disabled");
            return false;
        }
        String sqlState = null;
        if (t instanceof SQLException) {
            sqlState = ((SQLException)t).getSQLState();
        }
        if (sqlState != null) {
            return PSQLState.isConnectionError(sqlState) || PSQLState.COMMUNICATION_ERROR.getState().equals(sqlState);
        }
        return false;
    }

    private void performSpecialMethodHandlingIfRequired(String methodName, @Nullable Object[] args) throws SQLException {
        if (METHOD_SET_AUTO_COMMIT.equals(methodName) && args[0] != null) {
            boolean autoCommit = (Boolean)args[0];
            boolean bl = this.inTransaction = !autoCommit;
        }
        if (METHOD_COMMIT.equals(methodName) || METHOD_ROLLBACK.equals(methodName)) {
            this.inTransaction = false;
        }
        if (METHOD_SET_READ_ONLY.equals(methodName) && args != null && args.length > 0 && args[0] != null) {
            boolean originalReadOnlyValue = this.explicitlyReadOnly;
            this.explicitlyReadOnly = (Boolean)args[0];
            LOGGER.log(Level.FINER, "[ClusterAwareConnectionProxy] explicitlyReadOnly={0}", this.explicitlyReadOnly);
            this.connectToWriterIfRequired(originalReadOnlyValue, this.explicitlyReadOnly);
        }
    }

    private void connectToWriterIfRequired(boolean originalReadOnlyValue, boolean newReadOnlyValue) throws SQLException {
        if (!this.shouldReconnectToWriter(originalReadOnlyValue, newReadOnlyValue) || this.hosts.isEmpty()) {
            return;
        }
        try {
            this.connectToHost(this.hosts.get(0));
        }
        catch (SQLException e) {
            if (this.gatherPerfMetricsSetting) {
                this.failoverStartTimeMs = System.currentTimeMillis();
            }
            this.failover();
        }
    }

    private boolean shouldReconnectToWriter(boolean originalReadOnlyValue, boolean newReadOnlyValue) {
        return originalReadOnlyValue && !newReadOnlyValue && (this.currentHost == null || !this.currentHost.isWriter());
    }

    Throwable wrapExceptionIfRequired(Method method, Throwable e) {
        Class<?>[] declaredException;
        for (Class<?> declEx : declaredException = method.getExceptionTypes()) {
            if (!declEx.isAssignableFrom(e.getClass())) continue;
            return e;
        }
        return new IllegalStateException(e.getMessage(), e);
    }

    public boolean isClusterTopologyAvailable() {
        return this.isClusterTopologyAvailable;
    }

    public @Nullable Connection getConnection() {
        return this.currentConnection;
    }

    private void logConnectionFailure(@UnknownInitialization ClusterAwareConnectionProxy this, HostInfo host, SQLException e) {
        String instanceType = host.isWriter() ? "writer" : "reader";
        String msg = "Connection to " + instanceType + " host '" + host.getHostPortPair() + "' failed";
        LOGGER.log(Level.WARNING, msg + ": " + e.getMessage());
        LOGGER.log(Level.FINER, Util.stackTraceToString(e, this.getClass()));
    }

    @RequiresNonNull(value={"this.hosts"})
    private void logTopology(@UnderInitialization ClusterAwareConnectionProxy this) {
        StringBuilder msg = new StringBuilder();
        for (int i = 0; i < this.hosts.size(); ++i) {
            HostInfo hostInfo = this.hosts.get(i);
            msg.append("\n   [").append(i).append("]: ").append(hostInfo == null ? "<null>" : hostInfo.getHost());
        }
        LOGGER.log(Level.FINE, "[ClusterAwareConnectionProxy] Topology obtained: {0}", msg.toString());
    }

    protected @Nullable Object wrapWithProxyIfNeeded(Class<?> returnType, @Nullable Object toProxy) {
        if (toProxy == null || !Util.isJdbcInterface(returnType)) {
            return toProxy;
        }
        Class<?> toProxyClass = toProxy.getClass();
        return java.lang.reflect.Proxy.newProxyInstance(toProxyClass.getClassLoader(), Util.getImplementedInterfaces(toProxyClass), (InvocationHandler)new Proxy(toProxy));
    }

    class Proxy
    implements InvocationHandler {
        Object invocationTarget;

        Proxy(Object invocationTarget) {
            this.invocationTarget = invocationTarget;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public @Nullable Object invoke(Object proxy, Method method, @Nullable Object[] args) throws Throwable {
            if (ClusterAwareConnectionProxy.METHOD_EQUALS.equals(method.getName()) && args != null && args[0] != null) {
                return args[0].equals(this);
            }
            ClusterAwareConnectionProxy clusterAwareConnectionProxy = ClusterAwareConnectionProxy.this;
            synchronized (clusterAwareConnectionProxy) {
                Object result = null;
                try {
                    result = method.invoke(this.invocationTarget, args);
                    result = ClusterAwareConnectionProxy.this.wrapWithProxyIfNeeded(method.getReturnType(), result);
                }
                catch (InvocationTargetException e) {
                    ClusterAwareConnectionProxy.this.processInvocationException(e);
                }
                catch (IllegalStateException e) {
                    ClusterAwareConnectionProxy.this.processIllegalStateException(e);
                }
                return result;
            }
        }
    }
}

