/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.mysql.shading.com.mysql.cj.util;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ExpiringCache<K, V>
implements Map<K, V> {
    private int expireTimeMs;
    private final LinkedHashMap<K, Hit<V>> linkedHashMap = new LinkedHashMap<K, Hit<V>>(1, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, Hit<V>> eldest) {
            if (eldest.getValue().isExpire(ExpiringCache.this.expireTimeMs)) {
                Iterator i = this.values().iterator();
                i.next();
                do {
                    i.remove();
                } while (i.hasNext() && ((Hit)i.next()).isExpire(ExpiringCache.this.expireTimeMs));
            }
            return false;
        }
    };

    public ExpiringCache(int expireTimeMs) {
        this.expireTimeMs = expireTimeMs;
    }

    public void setExpireTime(int expireTimeMs) {
        this.expireTimeMs = expireTimeMs;
    }

    public int getExpireTime() {
        return this.expireTimeMs;
    }

    @Override
    public synchronized int size() {
        return (int)this.linkedHashMap.values().stream().filter(x -> !x.isExpire(this.expireTimeMs)).count();
    }

    @Override
    public synchronized boolean isEmpty() {
        return !this.linkedHashMap.values().stream().anyMatch(x -> !x.isExpire(this.expireTimeMs));
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        V payload = this.get(key);
        return payload != null;
    }

    @Override
    public synchronized boolean containsValue(Object value) {
        return this.linkedHashMap.values().stream().anyMatch(x -> !x.isExpire(this.expireTimeMs) && ((Hit)x).payload == value);
    }

    @Override
    public synchronized V get(Object key) {
        Hit<V> hit = this.linkedHashMap.get(key);
        if (hit == null) {
            return null;
        }
        if (hit.isExpire(this.expireTimeMs)) {
            this.linkedHashMap.remove(key);
            return null;
        }
        return (V)((Hit)hit).payload;
    }

    @Override
    public synchronized V put(K key, V value) {
        Hit<V> prevValue = this.linkedHashMap.put(key, new Hit<V>(value));
        return (V)(prevValue == null ? null : ((Hit)prevValue).payload);
    }

    @Override
    public synchronized V remove(Object key) {
        Hit prevValue = (Hit)this.linkedHashMap.remove(key);
        return (V)(prevValue == null ? null : prevValue.payload);
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.linkedHashMap.put(entry.getKey(), new Hit<V>(entry.getValue()));
        }
    }

    @Override
    public synchronized void clear() {
        this.linkedHashMap.clear();
    }

    @Override
    public synchronized Set<K> keySet() {
        return this.linkedHashMap.entrySet().stream().filter(x -> !((Hit)x.getValue()).isExpire(this.expireTimeMs)).map(x -> x.getKey()).collect(Collectors.toSet());
    }

    @Override
    public synchronized Collection<V> values() {
        return this.linkedHashMap.values().stream().filter(x -> !x.isExpire(this.expireTimeMs)).map(x -> ((Hit)x).payload).collect(Collectors.toList());
    }

    @Override
    public synchronized Set<Map.Entry<K, V>> entrySet() {
        return this.linkedHashMap.entrySet().stream().filter(x -> !((Hit)x.getValue()).isExpire(this.expireTimeMs)).map(x -> new AbstractMap.SimpleEntry(x.getKey(), ((Hit)x.getValue()).payload)).collect(Collectors.toSet());
    }

    private class Hit<V> {
        private final long time = System.currentTimeMillis();
        private final V payload;

        Hit(V payload) {
            this.payload = payload;
        }

        boolean isExpire(int expireTimeMs) {
            return System.currentTimeMillis() - this.time >= (long)expireTimeMs;
        }
    }
}

