/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.failover;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.Messages;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.ConnectionUrl;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.HostInfo;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.PropertyKey;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.PropertySet;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.exceptions.WrongArgumentException;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.JdbcConnection;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.failover.ClusterAwareMetricsContainer;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.failover.IClusterAwareMetricsContainer;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.failover.ITopologyService;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.log.Log;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.log.NullLogger;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.util.CacheMap;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.util.Util;

public class AuroraTopologyService
implements ITopologyService {
    static final int DEFAULT_REFRESH_RATE_IN_MILLISECONDS = 30000;
    static final int DEFAULT_CACHE_EXPIRE_MS = 300000;
    private long refreshRateNanos;
    static final String RETRIEVE_TOPOLOGY_SQL = "SELECT SERVER_ID, SESSION_ID, LAST_UPDATE_TIMESTAMP, REPLICA_LAG_IN_MILLISECONDS FROM information_schema.replica_host_status WHERE time_to_sec(timediff(now(), LAST_UPDATE_TIMESTAMP)) <= 300 ORDER BY LAST_UPDATE_TIMESTAMP DESC";
    static final String GET_INSTANCE_NAME_SQL = "SELECT @@aurora_server_id";
    static final String GET_INSTANCE_NAME_COL = "@@aurora_server_id";
    static final String WRITER_SESSION_ID = "MASTER_SESSION_ID";
    static final String FIELD_SERVER_ID = "SERVER_ID";
    static final String FIELD_SESSION_ID = "SESSION_ID";
    static final String FIELD_LAST_UPDATED = "LAST_UPDATE_TIMESTAMP";
    static final String FIELD_REPLICA_LAG = "REPLICA_LAG_IN_MILLISECONDS";
    public static final CacheMap<String, List<HostInfo>> topologyCache = new CacheMap();
    public static final CacheMap<String, Set<String>> downHostCache = new CacheMap();
    public static final CacheMap<String, HostInfo> lastUsedReaderCache = new CacheMap();
    protected String clusterId;
    protected HostInfo clusterInstanceTemplate;
    protected IClusterAwareMetricsContainer metricsContainer;
    protected static final Log NULL_LOGGER = new NullLogger("MySQL");
    protected transient Log log = NULL_LOGGER;

    public AuroraTopologyService(Log log) {
        this(30000, log, ClusterAwareMetricsContainer::new);
    }

    public AuroraTopologyService(int refreshRateInMilliseconds, Log log, Supplier<IClusterAwareMetricsContainer> metricsContainerSupplier) {
        this.refreshRateNanos = TimeUnit.MILLISECONDS.toNanos(refreshRateInMilliseconds);
        this.clusterId = UUID.randomUUID().toString();
        this.clusterInstanceTemplate = new HostInfo(null, "?", -1, null, null);
        this.metricsContainer = metricsContainerSupplier.get();
        if (log != null) {
            this.log = log;
        }
    }

    @Override
    public void setClusterId(String clusterId) {
        this.log.logTrace(Messages.getString("AuroraTopologyService.1", new Object[]{clusterId}));
        this.clusterId = clusterId;
        this.metricsContainer.setClusterId(clusterId);
    }

    @Override
    public String getClusterId() {
        return this.clusterId;
    }

    @Override
    public void setClusterInstanceTemplate(HostInfo clusterInstanceTemplate) {
        this.log.logTrace(Messages.getString("AuroraTopologyService.2", new Object[]{clusterInstanceTemplate.getHost(), clusterInstanceTemplate.getPort(), clusterInstanceTemplate.getDatabase()}));
        this.clusterInstanceTemplate = clusterInstanceTemplate;
    }

    @Override
    public List<HostInfo> getTopology(JdbcConnection conn, boolean forceUpdate) throws SQLException {
        ClusterTopologyInfo latestTopologyInfo;
        ArrayList hosts = topologyCache.get(this.clusterId);
        if ((hosts == null || forceUpdate) && (latestTopologyInfo = this.queryForTopology(conn)) != null) {
            ((Set)downHostCache.get(this.clusterId, ConcurrentHashMap.newKeySet(), this.refreshRateNanos)).clear();
            if (!Util.isNullOrEmpty(latestTopologyInfo.getHosts())) {
                topologyCache.put(this.clusterId, latestTopologyInfo.getHosts(), this.refreshRateNanos);
                return latestTopologyInfo.getHosts();
            }
        }
        return forceUpdate ? new ArrayList() : hosts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClusterTopologyInfo queryForTopology(JdbcConnection conn) throws SQLException {
        long startTimeMs = System.currentTimeMillis();
        ClusterTopologyInfo topologyInfo = null;
        try (Statement stmt = conn.createStatement();
             ResultSet resultSet = stmt.executeQuery(RETRIEVE_TOPOLOGY_SQL);){
            topologyInfo = this.processQueryResults(resultSet);
        }
        catch (SQLSyntaxErrorException currentTimeMs) {
        }
        finally {
            if (this.gatherPerfMetrics(conn.getPropertySet())) {
                long currentTimeMs = System.currentTimeMillis();
                this.metricsContainer.registerTopologyQueryExecutionTime(currentTimeMs - startTimeMs);
            }
        }
        return topologyInfo != null ? topologyInfo : new ClusterTopologyInfo(new ArrayList<HostInfo>());
    }

    private boolean gatherPerfMetrics(PropertySet props) {
        return props != null && props.getProperty(PropertyKey.gatherPerfMetrics.getKeyName()) != null && props.getBooleanProperty(PropertyKey.gatherPerfMetrics.getKeyName()).getValue() != false;
    }

    private ClusterTopologyInfo processQueryResults(ResultSet resultSet) throws SQLException {
        ArrayList<HostInfo> hosts = new ArrayList<HostInfo>();
        ArrayList<HostInfo> writers = new ArrayList<HostInfo>();
        while (resultSet.next()) {
            HostInfo currentHost = this.createHost(resultSet);
            if (!WRITER_SESSION_ID.equalsIgnoreCase(resultSet.getString(FIELD_SESSION_ID))) {
                hosts.add(currentHost);
                continue;
            }
            writers.add(currentHost);
        }
        int writersCount = writers.size();
        if (writersCount == 0) {
            this.log.logError(Messages.getString("AuroraTopologyService.3"));
            hosts.clear();
        } else if (writersCount == 1) {
            hosts.add(0, (HostInfo)writers.get(0));
        } else {
            List sortedWriters = writers.stream().sorted(Comparator.comparing(HostInfo::getLastUpdatedTime).reversed()).collect(Collectors.toList());
            hosts.add(0, (HostInfo)sortedWriters.get(0));
        }
        return new ClusterTopologyInfo(hosts);
    }

    private HostInfo createHost(ResultSet resultSet) throws SQLException {
        String hostEndpoint = this.getHostEndpoint(resultSet.getString(FIELD_SERVER_ID));
        ConnectionUrl hostUrl = ConnectionUrl.getConnectionUrlInstance(this.getUrlFromEndpoint(hostEndpoint, this.clusterInstanceTemplate.getPort(), this.clusterInstanceTemplate.getDatabase()), new Properties());
        return new HostInfo(hostUrl, hostEndpoint, this.clusterInstanceTemplate.getPort(), this.clusterInstanceTemplate.getUser(), this.clusterInstanceTemplate.getPassword(), this.getPropertiesFromTopology(resultSet));
    }

    private String getHostEndpoint(String nodeName) {
        String host = this.clusterInstanceTemplate.getHost();
        return host.replace("?", nodeName);
    }

    private String getUrlFromEndpoint(String endpoint, int port, String dbname) {
        return String.format("%s//%s:%d/%s", ConnectionUrl.Type.SINGLE_CONNECTION_AWS.getScheme(), endpoint, port, dbname);
    }

    private Map<String, String> getPropertiesFromTopology(ResultSet resultSet) throws SQLException {
        HashMap<String, String> properties = new HashMap<String, String>(this.clusterInstanceTemplate.getHostProperties());
        properties.put("TOPOLOGY_SERVICE_SERVER_ID", resultSet.getString(FIELD_SERVER_ID));
        properties.put("TOPOLOGY_SERVICE_SESSION_ID", resultSet.getString(FIELD_SESSION_ID));
        try {
            properties.put("TOPOLOGY_SERVICE_LAST_UPDATE_TIMESTAMP", this.convertTimestampToString(resultSet.getTimestamp(FIELD_LAST_UPDATED)));
        }
        catch (WrongArgumentException ex) {
            properties.put("TOPOLOGY_SERVICE_LAST_UPDATE_TIMESTAMP", this.convertTimestampToString(Timestamp.from(Instant.now())));
        }
        properties.put("TOPOLOGY_SERVICE_REPLICA_LAG_IN_MILLISECONDS", Double.valueOf(resultSet.getDouble(FIELD_REPLICA_LAG)).toString());
        return properties;
    }

    private String convertTimestampToString(Timestamp timestamp) {
        DateTimeFormatter formatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
        return timestamp == null ? null : formatter.format(timestamp.toLocalDateTime());
    }

    @Override
    public List<HostInfo> getCachedTopology() {
        return topologyCache.get(this.clusterId);
    }

    @Override
    public HostInfo getLastUsedReaderHost() {
        return lastUsedReaderCache.get(this.clusterId);
    }

    @Override
    public void setLastUsedReaderHost(HostInfo reader) {
        if (reader == null) {
            return;
        }
        lastUsedReaderCache.put(this.clusterId, reader, this.refreshRateNanos);
    }

    /*
     * Exception decompiling
     */
    @Override
    public HostInfo getHostByName(JdbcConnection conn) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private HostInfo instanceNameToHost(String name, List<HostInfo> hosts) {
        if (name == null || hosts == null) {
            return null;
        }
        for (HostInfo host : hosts) {
            if (host == null || !name.equalsIgnoreCase(host.getHostProperties().get("TOPOLOGY_SERVICE_SERVER_ID"))) continue;
            return host;
        }
        return null;
    }

    @Override
    public Set<String> getDownHosts() {
        return downHostCache.get(this.clusterId, ConcurrentHashMap.newKeySet(), this.refreshRateNanos);
    }

    @Override
    public void addToDownHostList(HostInfo downHost) {
        if (downHost == null) {
            return;
        }
        ((Set)downHostCache.get(this.clusterId, ConcurrentHashMap.newKeySet(), this.refreshRateNanos)).add(downHost.getHostPortPair());
    }

    @Override
    public void removeFromDownHostList(HostInfo host) {
        if (host == null) {
            return;
        }
        ((Set)downHostCache.get(this.clusterId, ConcurrentHashMap.newKeySet(), this.refreshRateNanos)).remove(host.getHostPortPair());
    }

    @Override
    public void setRefreshRate(int refreshRateMillis) {
        this.refreshRateNanos = TimeUnit.MILLISECONDS.toNanos(refreshRateMillis);
    }

    @Override
    public void clearAll() {
        topologyCache.clear();
        downHostCache.clear();
        lastUsedReaderCache.clear();
    }

    @Override
    public void clear() {
        topologyCache.remove(this.clusterId);
        downHostCache.remove(this.clusterId);
        lastUsedReaderCache.remove(this.clusterId);
    }

    private static class ClusterTopologyInfo {
        private List<HostInfo> hosts;

        ClusterTopologyInfo(List<HostInfo> hosts) {
            this.hosts = hosts;
        }

        List<HostInfo> getHosts() {
            return this.hosts;
        }
    }
}

