/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.failover;

import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.log.BaseMetricsHolder;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.log.Log;

public class ClusterAwareTimeMetricsHolder
extends BaseMetricsHolder {
    protected String metricName;

    public ClusterAwareTimeMetricsHolder(String metricName) {
        this.metricName = metricName;
    }

    @Override
    public void reportMetrics(Log log) {
        StringBuilder logMessage = new StringBuilder(256);
        logMessage.append("** Performance Metrics Report for '").append(this.metricName).append("' **\n");
        if (this.numberOfQueriesIssued > 0L) {
            logMessage.append("\nLongest reported time: ").append(this.longestQueryTimeMs).append(" ms");
            logMessage.append("\nShortest reported time: ").append(this.shortestQueryTimeMs).append(" ms");
            double avgTime = this.totalQueryTimeMs / (double)this.numberOfQueriesIssued;
            logMessage.append("\nAverage query execution time: ").append(avgTime).append(" ms");
        }
        logMessage.append("\nNumber of reports: ").append(this.numberOfQueriesIssued);
        if (this.numberOfQueriesIssued > 0L && this.perfMetricsHistBreakpoints != null) {
            int i;
            logMessage.append("\n\n\tTiming Histogram:\n");
            int maxNumPoints = 20;
            int highestCount = Integer.MIN_VALUE;
            for (i = 0; i < 20; ++i) {
                if (this.perfMetricsHistCounts[i] <= highestCount) continue;
                highestCount = this.perfMetricsHistCounts[i];
            }
            if (highestCount == 0) {
                highestCount = 1;
            }
            for (i = 0; i < 19; ++i) {
                if (i == 0) {
                    logMessage.append("\n\tless than ").append(this.perfMetricsHistBreakpoints[i + 1]).append(" ms: \t").append(this.perfMetricsHistCounts[i]);
                } else {
                    logMessage.append("\n\tbetween ").append(this.perfMetricsHistBreakpoints[i]).append(" and ").append(this.perfMetricsHistBreakpoints[i + 1]).append(" ms: \t").append(this.perfMetricsHistCounts[i]);
                }
                logMessage.append("\t");
                int numPointsToGraph = (int)((double)maxNumPoints * ((double)this.perfMetricsHistCounts[i] / (double)highestCount));
                for (int j = 0; j < numPointsToGraph; ++j) {
                    logMessage.append("*");
                }
                if (this.longestQueryTimeMs < (long)this.perfMetricsHistCounts[i + 1]) break;
            }
            if (this.perfMetricsHistBreakpoints[18] < this.longestQueryTimeMs) {
                logMessage.append("\n\tbetween ");
                logMessage.append(this.perfMetricsHistBreakpoints[18]);
                logMessage.append(" and ");
                logMessage.append(this.perfMetricsHistBreakpoints[19]);
                logMessage.append(" ms: \t");
                logMessage.append(this.perfMetricsHistCounts[19]);
            }
        }
        log.logInfo(logMessage);
    }
}

