/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.failover;

import java.io.EOFException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLException;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.Messages;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.NativeSession;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.ConnectionUrl;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.ConnectionUrlParser;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.HostInfo;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.PropertyKey;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.PropertySet;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.RuntimeProperty;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.exceptions.CJCommunicationsException;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.exceptions.CJException;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ConnectionImpl;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.JdbcConnection;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.exceptions.CommunicationsException;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.exceptions.SQLError;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.exceptions.SQLExceptionsMapping;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.ConnectionUtils;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.BasicConnectionProvider;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.IConnectionPlugin;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.IConnectionProvider;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.ICurrentConnectionProvider;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.failover.AuroraTopologyService;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.failover.ClusterAwareMetricsContainer;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.failover.ClusterAwareReaderFailoverHandler;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.failover.ClusterAwareWriterFailoverHandler;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.failover.IClusterAwareMetricsContainer;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.failover.IReaderFailoverHandler;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.failover.ITopologyService;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.failover.IWriterFailoverHandler;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.failover.ReaderFailoverResult;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.failover.WriterFailoverResult;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.log.Log;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.util.IpAddressUtils;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.util.StringUtils;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.util.Util;

public class FailoverConnectionPlugin
implements IConnectionPlugin {
    public static final int NO_CONNECTION_INDEX = -1;
    public static final int WRITER_CONNECTION_INDEX = 0;
    static final String METHOD_SET_READ_ONLY = "setReadOnly";
    static final String METHOD_SET_AUTO_COMMIT = "setAutoCommit";
    static final String METHOD_COMMIT = "commit";
    static final String METHOD_ROLLBACK = "rollback";
    private static final String METHOD_GET_AUTO_COMMIT = "getAutoCommit";
    private static final String METHOD_GET_CATALOG = "getCatalog";
    private static final String METHOD_GET_SCHEMA = "getSchema";
    private static final String METHOD_GET_DATABASE = "getDatabase";
    static final String METHOD_ABORT = "abort";
    static final String METHOD_CLOSE = "close";
    static final String METHOD_IS_CLOSED = "isClosed";
    private static final String METHOD_GET_TRANSACTION_ISOLATION = "getTransactionIsolation";
    private static final String METHOD_GET_SESSION_MAX_ROWS = "getSessionMaxRows";
    protected final IConnectionProvider connectionProvider;
    protected final IClusterAwareMetricsContainer metricsContainer;
    private final ICurrentConnectionProvider currentConnectionProvider;
    private final PropertySet propertySet;
    private final IConnectionPlugin nextPlugin;
    private final Log logger;
    private final Pattern auroraDnsPattern = Pattern.compile("(.+)\\.(proxy-|cluster-|cluster-ro-|cluster-custom-)?([a-zA-Z0-9]+\\.[a-zA-Z0-9\\-]+\\.rds\\.amazonaws\\.com)", 2);
    private final Pattern auroraCustomClusterPattern = Pattern.compile("(.+)\\.(cluster-custom-[a-zA-Z0-9]+\\.[a-zA-Z0-9\\-]+\\.rds\\.amazonaws\\.com)", 2);
    private final Pattern auroraProxyDnsPattern = Pattern.compile("(.+)\\.(proxy-[a-zA-Z0-9]+\\.[a-zA-Z0-9\\-]+\\.rds\\.amazonaws\\.com)", 2);
    protected IWriterFailoverHandler writerFailoverHandler = null;
    protected IReaderFailoverHandler readerFailoverHandler = null;
    protected int currentHostIndex = -1;
    protected Map<String, String> initialConnectionProps;
    protected Boolean explicitlyReadOnly = null;
    protected boolean inTransaction = false;
    protected boolean explicitlyAutoCommit = true;
    protected boolean isClusterTopologyAvailable = false;
    protected boolean isMultiWriterCluster = false;
    protected boolean isRdsProxy = false;
    protected boolean isRds = false;
    protected ITopologyService topologyService;
    protected List<HostInfo> hosts = new ArrayList<HostInfo>();
    protected boolean enableFailoverSetting = true;
    protected boolean enableFailoverStrictReaderSetting;
    protected int clusterTopologyRefreshRateMsSetting;
    protected int failoverTimeoutMsSetting;
    protected int failoverClusterTopologyRefreshRateMsSetting;
    protected int failoverWriterReconnectIntervalMsSetting;
    protected int failoverReaderConnectTimeoutMsSetting;
    protected String clusterIdSetting;
    protected String clusterInstanceHostPatternSetting;
    protected int failoverConnectTimeoutMs;
    protected int failoverSocketTimeoutMs;
    protected boolean isClosed = false;
    protected boolean closedExplicitly = false;
    protected String closedReason = null;
    protected Throwable lastExceptionDealtWith = null;
    protected boolean autoReconnect;
    private long invokeStartTimeMs;
    private long failoverStartTimeMs;

    public FailoverConnectionPlugin(ICurrentConnectionProvider currentConnectionProvider, PropertySet propertySet, IConnectionPlugin nextPlugin, Log logger) throws SQLException {
        this(currentConnectionProvider, propertySet, nextPlugin, logger, new BasicConnectionProvider(), () -> new AuroraTopologyService(logger), () -> new ClusterAwareMetricsContainer(currentConnectionProvider, propertySet));
    }

    FailoverConnectionPlugin(ICurrentConnectionProvider currentConnectionProvider, PropertySet propertySet, IConnectionPlugin nextPlugin, Log logger, IConnectionProvider connectionProvider, Supplier<ITopologyService> topologyServiceSupplier, Supplier<IClusterAwareMetricsContainer> metricsContainerSupplier) throws SQLException {
        this.currentConnectionProvider = currentConnectionProvider;
        this.propertySet = propertySet;
        this.nextPlugin = nextPlugin;
        this.logger = logger;
        this.connectionProvider = connectionProvider;
        this.metricsContainer = metricsContainerSupplier.get();
        this.initialConnectionProps = new HashMap<String, String>();
        this.initialConnectionProps = this.getInitialConnectionProps(this.propertySet);
        this.initSettings();
        if (!this.enableFailoverSetting) {
            return;
        }
        this.topologyService = topologyServiceSupplier.get();
        this.topologyService.setRefreshRate(this.clusterTopologyRefreshRateMsSetting);
        this.readerFailoverHandler = new ClusterAwareReaderFailoverHandler(this.topologyService, this.connectionProvider, this.initialConnectionProps, this.failoverTimeoutMsSetting, this.failoverReaderConnectTimeoutMsSetting, this.enableFailoverStrictReaderSetting, this.logger);
        this.writerFailoverHandler = new ClusterAwareWriterFailoverHandler(this.topologyService, this.connectionProvider, this.readerFailoverHandler, this.initialConnectionProps, this.failoverTimeoutMsSetting, this.failoverClusterTopologyRefreshRateMsSetting, this.failoverWriterReconnectIntervalMsSetting, this.logger);
        this.initProxy();
    }

    @Override
    public void openInitialConnection(ConnectionUrl connectionUrl) throws SQLException {
        this.createConnection(connectionUrl);
        if (this.enableFailoverSetting) {
            this.initProxy();
        }
    }

    @Override
    public Object execute(Class<?> methodInvokeOn, String methodName, Callable<?> executeSqlFunc, Object[] args) throws Exception {
        if (!this.enableFailoverSetting || this.canDirectExecute(methodName)) {
            return this.nextPlugin.execute(methodInvokeOn, methodName, executeSqlFunc, args);
        }
        if (this.isClosed && !this.allowedOnClosedConnection(methodName)) {
            this.invalidInvocationOnClosedConnection();
        }
        this.invokeStartTimeMs = System.currentTimeMillis();
        Object result = null;
        try {
            this.updateTopologyAndConnectIfNeeded(false);
            result = this.nextPlugin.execute(methodInvokeOn, methodName, executeSqlFunc, args);
        }
        catch (IllegalStateException e) {
            this.dealWithIllegalStateException(e);
        }
        catch (Exception e) {
            this.dealWithOriginalException(e, null);
        }
        this.performSpecialMethodHandlingIfRequired(args, methodName);
        return result;
    }

    @Override
    public void transactionBegun() {
        this.inTransaction = true;
        this.nextPlugin.transactionBegun();
    }

    @Override
    public void transactionCompleted() {
        this.inTransaction = false;
        this.nextPlugin.transactionCompleted();
    }

    @Override
    public void releaseResources() {
        this.nextPlugin.releaseResources();
    }

    public boolean isFailoverEnabled() {
        return this.enableFailoverSetting && !this.isRdsProxy && this.isClusterTopologyAvailable && !this.isMultiWriterCluster && (this.hosts == null || this.hosts.size() > 1);
    }

    public boolean isRds() {
        return this.isRds;
    }

    public boolean isRdsProxy() {
        return this.isRdsProxy;
    }

    void initSettings() {
        this.enableFailoverSetting = this.propertySet.getBooleanProperty(PropertyKey.enableClusterAwareFailover).getValue();
        this.clusterTopologyRefreshRateMsSetting = this.propertySet.getIntegerProperty(PropertyKey.clusterTopologyRefreshRateMs).getValue();
        this.failoverTimeoutMsSetting = this.propertySet.getIntegerProperty(PropertyKey.failoverTimeoutMs).getValue();
        this.failoverClusterTopologyRefreshRateMsSetting = this.propertySet.getIntegerProperty(PropertyKey.failoverClusterTopologyRefreshRateMs).getValue();
        this.failoverWriterReconnectIntervalMsSetting = this.propertySet.getIntegerProperty(PropertyKey.failoverWriterReconnectIntervalMs).getValue();
        this.failoverReaderConnectTimeoutMsSetting = this.propertySet.getIntegerProperty(PropertyKey.failoverReaderConnectTimeoutMs).getValue();
        this.clusterIdSetting = this.propertySet.getStringProperty(PropertyKey.clusterId).getValue();
        this.clusterInstanceHostPatternSetting = this.propertySet.getStringProperty(PropertyKey.clusterInstanceHostPattern).getValue();
        this.failoverConnectTimeoutMs = this.propertySet.getIntegerProperty(PropertyKey.connectTimeout).getValue();
        this.failoverSocketTimeoutMs = this.propertySet.getIntegerProperty(PropertyKey.socketTimeout).getValue();
        this.autoReconnect = this.propertySet.getBooleanProperty(PropertyKey.autoReconnect.getKeyName()).getValue() != false || this.propertySet.getBooleanProperty(PropertyKey.autoReconnectForPools.getKeyName()).getValue() != false;
        this.enableFailoverStrictReaderSetting = this.propertySet.getBooleanProperty(PropertyKey.enableFailoverStrictReader.getKeyName()).getValue();
    }

    boolean isConnected() {
        return this.currentHostIndex != -1;
    }

    private void validateConnection() throws SQLException {
        this.currentHostIndex = this.getHostIndex(this.topologyService.getHostByName(this.currentConnectionProvider.getCurrentConnection()));
        if (!this.isConnected()) {
            this.pickNewConnection();
            return;
        }
        if (this.validWriterConnection()) {
            this.metricsContainer.registerInvalidInitialConnection(false);
            return;
        }
        this.metricsContainer.registerInvalidInitialConnection(true);
        try {
            this.connectTo(0);
        }
        catch (SQLException e) {
            this.failoverStartTimeMs = System.currentTimeMillis();
            this.failover(0);
        }
    }

    private boolean validWriterConnection() {
        return this.explicitlyReadOnly == null || this.explicitlyReadOnly != false || this.isWriterHostIndex(this.currentHostIndex);
    }

    private void attemptConnectionUsingCachedTopology() throws SQLException {
        List<HostInfo> cachedHosts = this.topologyService.getCachedTopology();
        if (Util.isNullOrEmpty(cachedHosts)) {
            this.metricsContainer.registerUseCachedTopology(false);
            return;
        }
        this.hosts = cachedHosts;
        this.metricsContainer.registerUseCachedTopology(true);
        int candidateIndex = this.getCandidateIndexForInitialConnection();
        if (candidateIndex != -1) {
            this.connectTo(candidateIndex);
        }
    }

    private int getCandidateIndexForInitialConnection() {
        int candidateReaderIndex;
        if (Util.isNullOrEmpty(this.hosts)) {
            return -1;
        }
        if (this.isExplicitlyReadOnly() && (candidateReaderIndex = this.getCandidateReaderForInitialConnection()) != -1) {
            return candidateReaderIndex;
        }
        return 0;
    }

    private int getCandidateReaderForInitialConnection() {
        int lastUsedReaderIndex = this.getHostIndex(this.topologyService.getLastUsedReaderHost());
        if (lastUsedReaderIndex != -1) {
            this.metricsContainer.registerUseLastConnectedReader(true);
            return lastUsedReaderIndex;
        }
        this.metricsContainer.registerUseLastConnectedReader(false);
        if (this.clusterContainsReader()) {
            return this.getRandomReaderIndex();
        }
        return -1;
    }

    private int getRandomReaderIndex() {
        int max = this.hosts.size() - 1;
        int min = 1;
        return (int)(Math.random() * (double)(max - min + 1)) + min;
    }

    protected void initializeTopology() throws SQLException {
        if (this.currentConnectionProvider.getCurrentConnection() == null) {
            return;
        }
        this.fetchTopology();
        if (this.isFailoverEnabled()) {
            this.validateConnection();
            if (this.currentHostIndex != -1 && this.currentHostIndex != 0 && !Util.isNullOrEmpty(this.hosts)) {
                HostInfo currentHost = this.hosts.get(this.currentHostIndex);
                this.topologyService.setLastUsedReaderHost(currentHost);
            }
            JdbcConnection currentConnection = this.currentConnectionProvider.getCurrentConnection();
            currentConnection.getPropertySet().getIntegerProperty(PropertyKey.socketTimeout).setValue(this.failoverSocketTimeoutMs);
            ((NativeSession)currentConnection.getSession()).setSocketTimeout(this.failoverSocketTimeoutMs);
        }
    }

    protected ConnectionImpl createConnectionForHost(HostInfo baseHostInfo) throws SQLException {
        HostInfo hostInfoWithInitialProps = ConnectionUtils.copyWithAdditionalProps(baseHostInfo, this.currentConnectionProvider.getCurrentHostInfo());
        return this.connectionProvider.connect(hostInfoWithInitialProps);
    }

    protected void dealWithIllegalStateException(IllegalStateException e) throws Exception {
        this.dealWithOriginalException(e.getCause(), e);
    }

    protected synchronized void failover(int failedHostIdx) throws SQLException {
        if (this.shouldPerformWriterFailover()) {
            this.failoverWriter();
        } else {
            this.failoverReader(failedHostIdx);
        }
        if (this.inTransaction) {
            this.inTransaction = false;
            this.logger.logError(Messages.getString("ClusterAwareConnectionProxy.1"));
            throw new SQLException(Messages.getString("ClusterAwareConnectionProxy.1"), "08007");
        }
        this.logger.logError(Messages.getString("ClusterAwareConnectionProxy.3"));
        throw new SQLException(Messages.getString("ClusterAwareConnectionProxy.3"), "08S02");
    }

    protected void failoverReader(int failedHostIdx) throws SQLException {
        SQLException exception;
        this.logger.logDebug(Messages.getString("ClusterAwareConnectionProxy.17"));
        HostInfo failedHost = null;
        if (failedHostIdx != -1 && !Util.isNullOrEmpty(this.hosts)) {
            failedHost = this.hosts.get(failedHostIdx);
        }
        ReaderFailoverResult result = this.readerFailoverHandler.failover(this.hosts, failedHost);
        long currentTimeMs = System.currentTimeMillis();
        this.metricsContainer.registerReaderFailoverProcedureTime(currentTimeMs - this.failoverStartTimeMs);
        this.failoverStartTimeMs = 0L;
        if (result != null && (exception = result.getException()) != null) {
            throw exception;
        }
        if (result == null || !result.isConnected()) {
            this.processFailoverFailure(Messages.getString("ClusterAwareConnectionProxy.4"));
            return;
        }
        this.metricsContainer.registerFailoverConnects(true);
        this.updateCurrentConnection(result.getConnection(), result.getConnectionIndex());
        this.updateTopologyAndConnectIfNeeded(true);
        if (this.currentHostIndex != -1 && this.currentHostIndex != 0 && !Util.isNullOrEmpty(this.hosts)) {
            HostInfo currentHost = this.hosts.get(this.currentHostIndex);
            this.topologyService.setLastUsedReaderHost(currentHost);
            this.logger.logDebug(Messages.getString("ClusterAwareConnectionProxy.15", new Object[]{currentHost}));
        }
    }

    protected void failoverWriter() throws SQLException {
        SQLException exception;
        this.logger.logDebug(Messages.getString("ClusterAwareConnectionProxy.16"));
        WriterFailoverResult failoverResult = this.writerFailoverHandler.failover(this.hosts);
        long currentTimeMs = System.currentTimeMillis();
        this.metricsContainer.registerWriterFailoverProcedureTime(currentTimeMs - this.failoverStartTimeMs);
        this.failoverStartTimeMs = 0L;
        if (failoverResult != null && (exception = failoverResult.getException()) != null) {
            throw exception;
        }
        if (failoverResult == null || !failoverResult.isConnected()) {
            this.processFailoverFailure(Messages.getString("ClusterAwareConnectionProxy.2"));
            return;
        }
        if (!Util.isNullOrEmpty(failoverResult.getTopology())) {
            this.hosts = failoverResult.getTopology();
        }
        this.metricsContainer.registerFailoverConnects(true);
        this.updateCurrentConnection(failoverResult.getNewConnection(), 0);
        this.logger.logDebug(Messages.getString("ClusterAwareConnectionProxy.15", new Object[]{this.hosts.get(this.currentHostIndex)}));
    }

    protected void invalidateCurrentConnection() {
        JdbcConnection conn = this.currentConnectionProvider.getCurrentConnection();
        if (this.inTransaction) {
            try {
                conn.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        try {
            if (conn != null && !conn.isClosed()) {
                conn.realClose(true, !conn.getAutoCommit(), true, null);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected synchronized void pickNewConnection() throws SQLException {
        if (this.isClosed && this.closedExplicitly) {
            this.logger.logDebug(Messages.getString("ClusterAwareConnectionProxy.1"));
            return;
        }
        if (this.isConnected() || Util.isNullOrEmpty(this.hosts)) {
            this.failover(this.currentHostIndex);
            return;
        }
        if (this.shouldAttemptReaderConnection()) {
            this.failoverReader(-1);
            return;
        }
        try {
            this.connectTo(0);
            if (this.currentHostIndex != -1 && this.currentHostIndex != 0) {
                this.topologyService.setLastUsedReaderHost(this.hosts.get(this.currentHostIndex));
            }
        }
        catch (SQLException e) {
            this.failover(0);
        }
    }

    protected boolean shouldExceptionTriggerConnectionSwitch(Throwable t) {
        if (!this.isFailoverEnabled()) {
            this.logger.logDebug(Messages.getString("ClusterAwareConnectionProxy.13"));
            return false;
        }
        if (t instanceof CommunicationsException || t instanceof CJCommunicationsException) {
            return true;
        }
        if (t instanceof SQLException) {
            return ConnectionUtils.isNetworkException((SQLException)t);
        }
        if (t instanceof CJException) {
            if (t.getCause() instanceof EOFException) {
                return true;
            }
            if (t.getCause() instanceof SSLException) {
                return true;
            }
            return ConnectionUtils.isNetworkException(((CJException)t).getSQLState());
        }
        return false;
    }

    protected void syncSessionState(JdbcConnection source, JdbcConnection target, boolean readOnly) throws SQLException {
        if (target != null) {
            target.setReadOnly(readOnly);
        }
        if (source == null || target == null) {
            return;
        }
        RuntimeProperty<Boolean> sourceUseLocalSessionState = source.getPropertySet().getBooleanProperty(PropertyKey.useLocalSessionState);
        boolean prevUseLocalSessionState = sourceUseLocalSessionState.getValue();
        sourceUseLocalSessionState.setValue(true);
        target.setAutoCommit(source.getAutoCommit());
        String db = source.getDatabase();
        if (db != null && !db.isEmpty()) {
            target.setDatabase(db);
        }
        target.setTransactionIsolation(source.getTransactionIsolation());
        target.setSessionMaxRows(source.getSessionMaxRows());
        sourceUseLocalSessionState.setValue(prevUseLocalSessionState);
    }

    protected void updateTopologyAndConnectIfNeeded(boolean forceUpdate) throws SQLException {
        JdbcConnection connection = this.currentConnectionProvider.getCurrentConnection();
        if (!this.isFailoverEnabled() || connection == null || connection.isClosed() || connection.isInPreparedTx()) {
            return;
        }
        List<HostInfo> latestTopology = this.topologyService.getTopology(connection, forceUpdate);
        this.updateHostIndex(latestTopology);
        this.hosts = latestTopology;
    }

    boolean isCurrentConnectionReadOnly() {
        return this.isConnected() && !this.isWriterHostIndex(this.currentHostIndex);
    }

    protected boolean isCurrentConnectionWriter() {
        return this.isWriterHostIndex(this.currentHostIndex);
    }

    private boolean allowedOnClosedConnection(String methodName) {
        return methodName.equals(METHOD_GET_AUTO_COMMIT) || methodName.equals(METHOD_GET_CATALOG) || methodName.equals(METHOD_GET_SCHEMA) || methodName.equals(METHOD_GET_DATABASE) || methodName.equals(METHOD_GET_TRANSACTION_ISOLATION) || methodName.equals(METHOD_GET_SESSION_MAX_ROWS);
    }

    private boolean clusterContainsReader() {
        return this.hosts.size() > 1;
    }

    private void connectTo(int hostIndex) throws SQLException {
        try {
            this.switchCurrentConnectionTo(hostIndex, this.createConnectionForHostIndex(hostIndex));
            this.logger.logDebug(Messages.getString("ClusterAwareConnectionProxy.15", new Object[]{this.hosts.get(hostIndex)}));
        }
        catch (SQLException e) {
            if (this.currentConnectionProvider.getCurrentConnection() != null) {
                HostInfo host = this.hosts.get(hostIndex);
                StringBuilder msg = new StringBuilder("Connection to ").append(this.isWriterHostIndex(hostIndex) ? "writer" : "reader").append(" host '").append(host == null ? "<null>" : host.getHostPortPair()).append("' failed");
                try {
                    this.logger.logWarn(msg.toString(), e);
                }
                catch (CJException ex) {
                    throw SQLExceptionsMapping.translateException(e, this.currentConnectionProvider.getCurrentConnection().getExceptionInterceptor());
                }
            }
            throw e;
        }
    }

    private void connectToWriterIfRequired(Boolean readOnly) throws SQLException {
        if (this.shouldReconnectToWriter(readOnly) && !Util.isNullOrEmpty(this.hosts)) {
            try {
                this.connectTo(0);
            }
            catch (SQLException e) {
                this.failover(0);
            }
        }
    }

    private HostInfo createClusterInstanceTemplate(HostInfo hostInfo, String host, int port) {
        HashMap<String, String> properties = new HashMap<String, String>(this.initialConnectionProps);
        properties.put(PropertyKey.connectTimeout.getKeyName(), String.valueOf(this.failoverConnectTimeoutMs));
        properties.put(PropertyKey.socketTimeout.getKeyName(), String.valueOf(this.failoverSocketTimeoutMs));
        if (!Objects.equals(hostInfo.getDatabase(), "")) {
            properties.put(PropertyKey.DBNAME.getKeyName(), hostInfo.getDatabase());
        }
        Properties connectionProperties = new Properties();
        connectionProperties.putAll(this.initialConnectionProps);
        ConnectionUrl connectionUrl = ConnectionUrl.getConnectionUrlInstance(hostInfo.getDatabaseUrl(), connectionProperties);
        return new HostInfo(connectionUrl, host, port, hostInfo.getUser(), hostInfo.getPassword(), properties);
    }

    private ConnectionImpl createConnectionForHostIndex(int hostIndex) throws SQLException {
        return this.createConnectionForHost(this.hosts.get(hostIndex));
    }

    private void dealWithOriginalException(Throwable originalException, Exception wrapperException) throws Exception {
        if (originalException != null) {
            this.logger.logTrace(Messages.getString("ClusterAwareConnectionProxy.12"), originalException);
            if (this.lastExceptionDealtWith != originalException && this.shouldExceptionTriggerConnectionSwitch(originalException)) {
                long currentTimeMs = System.currentTimeMillis();
                this.metricsContainer.registerFailureDetectionTime(currentTimeMs - this.invokeStartTimeMs);
                this.invokeStartTimeMs = 0L;
                this.failoverStartTimeMs = currentTimeMs;
                this.invalidateCurrentConnection();
                this.pickNewConnection();
                this.lastExceptionDealtWith = originalException;
            }
            if (originalException instanceof Error) {
                throw (Error)originalException;
            }
            throw (Exception)originalException;
        }
        throw wrapperException;
    }

    private String getClusterKeyword(Matcher matcher) {
        if (matcher.find() && matcher.group(2) != null && matcher.group(1) != null && !matcher.group(1).isEmpty()) {
            return matcher.group(2);
        }
        return null;
    }

    private int getHostIndex(HostInfo host) {
        if (host == null || Util.isNullOrEmpty(this.hosts)) {
            return -1;
        }
        for (int i = 0; i < this.hosts.size(); ++i) {
            HostInfo potentialMatch = this.hosts.get(i);
            if (potentialMatch == null || !potentialMatch.equalHostPortPair(host)) continue;
            return i;
        }
        return -1;
    }

    private ConnectionUrlParser.Pair<String, Integer> getHostPortPairFromHostPatternSetting() throws SQLException {
        ConnectionUrlParser.Pair<String, Integer> pair = ConnectionUrlParser.parseHostPortPair(this.clusterInstanceHostPatternSetting);
        if (pair == null) {
            throw new SQLException(Messages.getString("ClusterAwareConnectionProxy.5"));
        }
        this.validateHostPatternSetting((String)pair.left);
        return pair;
    }

    private String getRdsClusterHostUrl(String host) {
        Matcher matcher = this.auroraDnsPattern.matcher(host);
        String clusterKeyword = this.getClusterKeyword(matcher);
        if ("cluster-".equalsIgnoreCase(clusterKeyword) || "cluster-ro-".equalsIgnoreCase(clusterKeyword)) {
            return matcher.group(1) + ".cluster-" + matcher.group(3);
        }
        return null;
    }

    private String getRdsInstanceHostPattern(String host) {
        Matcher matcher = this.auroraDnsPattern.matcher(host);
        if (matcher.find()) {
            return "?." + matcher.group(3);
        }
        return null;
    }

    private void identifyRdsType(String host) {
        this.isRds = this.isRdsDns(host);
        this.logger.logTrace(Messages.getString("ClusterAwareConnectionProxy.10", new Object[]{"isRds", this.isRds}));
        this.isRdsProxy = this.isRdsProxyDns(host);
        this.logger.logTrace(Messages.getString("ClusterAwareConnectionProxy.10", new Object[]{"isRdsProxy", this.isRdsProxy}));
    }

    private void initExpectingNoTopology(HostInfo hostInfo) throws SQLException {
        this.setClusterId(hostInfo.getHost(), hostInfo.getPort());
        this.topologyService.setClusterInstanceTemplate(this.createClusterInstanceTemplate(hostInfo, hostInfo.getHost(), hostInfo.getPort()));
        this.initializeTopology();
        if (this.isClusterTopologyAvailable) {
            this.logger.logError(Messages.getString("ClusterAwareConnectionProxy.6"));
            throw new SQLException(Messages.getString("ClusterAwareConnectionProxy.6"));
        }
    }

    private void initFromConnectionString(HostInfo hostInfo) throws SQLException {
        String rdsInstanceHostPattern = this.getRdsInstanceHostPattern(hostInfo.getHost());
        if (rdsInstanceHostPattern == null) {
            this.logger.logError(Messages.getString("ClusterAwareConnectionProxy.20"));
            throw new SQLException(Messages.getString("ClusterAwareConnectionProxy.20"));
        }
        this.setClusterId(hostInfo.getHost(), hostInfo.getPort());
        this.topologyService.setClusterInstanceTemplate(this.createClusterInstanceTemplate(hostInfo, rdsInstanceHostPattern, hostInfo.getPort()));
        this.initializeTopology();
    }

    private void initFromHostPatternSetting(HostInfo hostInfo) throws SQLException {
        ConnectionUrlParser.Pair<String, Integer> pair = this.getHostPortPairFromHostPatternSetting();
        String instanceHostPattern = (String)pair.left;
        int instanceHostPort = (Integer)pair.right != -1 ? ((Integer)pair.right).intValue() : hostInfo.getPort();
        this.setClusterId(instanceHostPattern, instanceHostPort);
        this.topologyService.setClusterInstanceTemplate(this.createClusterInstanceTemplate(hostInfo, instanceHostPattern, instanceHostPort));
        this.initializeTopology();
    }

    private void initProxy() throws SQLException {
        HostInfo hostInfo = this.currentConnectionProvider.getCurrentHostInfo();
        String hostname = hostInfo.getHost();
        if (!StringUtils.isNullOrEmpty(this.clusterInstanceHostPatternSetting)) {
            this.initFromHostPatternSetting(hostInfo);
        } else if (IpAddressUtils.isIPv4(hostname) || IpAddressUtils.isIPv6(hostname)) {
            this.initExpectingNoTopology(hostInfo);
        } else {
            this.identifyRdsType(hostname);
            if (!this.isRds) {
                this.initExpectingNoTopology(hostInfo);
            } else {
                this.initFromConnectionString(hostInfo);
            }
        }
        if (this.isRdsClusterDns(hostname)) {
            this.explicitlyReadOnly = this.isReaderClusterDns(hostname);
            this.logger.logTrace(Messages.getString("ClusterAwareConnectionProxy.10", new Object[]{"explicitlyReadOnly", this.explicitlyReadOnly}));
        }
    }

    private void fetchTopology() throws SQLException {
        JdbcConnection currentConnection = this.currentConnectionProvider.getCurrentConnection();
        List<HostInfo> topology = this.topologyService.getTopology(currentConnection, false);
        if (!Util.isNullOrEmpty(topology)) {
            this.hosts = topology;
        }
        this.isClusterTopologyAvailable = !Util.isNullOrEmpty(this.hosts);
        this.logger.logTrace(Messages.getString("ClusterAwareConnectionProxy.10", new Object[]{"isClusterTopologyAvailable", this.isClusterTopologyAvailable}));
        this.isMultiWriterCluster = this.topologyService.isMultiWriterCluster();
        this.currentHostIndex = this.getHostIndex(this.topologyService.getHostByName(this.currentConnectionProvider.getCurrentConnection()));
        if (this.isFailoverEnabled()) {
            this.logTopology();
        }
    }

    private void createConnection(ConnectionUrl connectionUrl) throws SQLException {
        String host;
        if (this.enableFailoverSetting && this.currentConnectionProvider.getCurrentConnection() == null && this.isRdsClusterDns(host = connectionUrl.getMainHost().getHost())) {
            this.explicitlyReadOnly = this.isReaderClusterDns(host);
            this.logger.logTrace(Messages.getString("ClusterAwareConnectionProxy.10", new Object[]{"explicitlyReadOnly", this.explicitlyReadOnly}));
            try {
                this.attemptConnectionUsingCachedTopology();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.currentConnectionProvider.getCurrentConnection() == null) {
            this.nextPlugin.openInitialConnection(connectionUrl);
        }
        if (this.currentConnectionProvider.getCurrentConnection() == null) {
            HostInfo mainHost = connectionUrl.getMainHost();
            ConnectionImpl connection = this.connectionProvider.connect(mainHost);
            this.currentConnectionProvider.setCurrentConnection(connection, mainHost);
        }
    }

    private void invalidInvocationOnClosedConnection() throws SQLException {
        if (this.autoReconnect && !this.closedExplicitly) {
            this.currentHostIndex = -1;
            this.isClosed = false;
            this.closedReason = null;
            this.pickNewConnection();
            this.logger.logError(Messages.getString("ClusterAwareConnectionProxy.19"));
            throw new SQLException(Messages.getString("ClusterAwareConnectionProxy.19"), "08S02");
        }
        String reason = "No operations allowed after connection closed.";
        if (this.closedReason != null) {
            reason = reason + " " + this.closedReason;
        }
        throw SQLError.createSQLException(reason, "08003", null);
    }

    private boolean isDnsPatternValid(String pattern) {
        return pattern.contains("?");
    }

    private boolean isExplicitlyReadOnly() {
        return this.explicitlyReadOnly != null && this.explicitlyReadOnly != false;
    }

    private boolean isRdsClusterDns(String host) {
        Matcher matcher = this.auroraDnsPattern.matcher(host);
        String clusterKeyword = this.getClusterKeyword(matcher);
        return "cluster-".equalsIgnoreCase(clusterKeyword) || "cluster-ro-".equalsIgnoreCase(clusterKeyword);
    }

    private boolean isRdsCustomClusterDns(String host) {
        Matcher matcher = this.auroraCustomClusterPattern.matcher(host);
        return matcher.find();
    }

    private boolean isRdsDns(String host) {
        Matcher matcher = this.auroraDnsPattern.matcher(host);
        return matcher.find();
    }

    private boolean isRdsProxyDns(String host) {
        Matcher matcher = this.auroraProxyDnsPattern.matcher(host);
        return matcher.find();
    }

    private boolean isReaderClusterDns(String host) {
        Matcher matcher = this.auroraDnsPattern.matcher(host);
        return "cluster-ro-".equalsIgnoreCase(this.getClusterKeyword(matcher));
    }

    private boolean isWriterHostIndex(int hostIndex) {
        return hostIndex == 0;
    }

    private void logTopology() {
        StringBuilder msg = new StringBuilder();
        for (int i = 0; i < this.hosts.size(); ++i) {
            HostInfo hostInfo = this.hosts.get(i);
            msg.append("\n   [").append(i).append("]: ").append(hostInfo == null ? "<null>" : hostInfo.getHost());
        }
        this.logger.logTrace(Messages.getString("ClusterAwareConnectionProxy.11", new Object[]{msg.toString()}));
    }

    private void performSpecialMethodHandlingIfRequired(Object[] args, String methodName) throws SQLException {
        if (METHOD_SET_AUTO_COMMIT.equals(methodName)) {
            this.explicitlyAutoCommit = (Boolean)args[0];
            boolean bl = this.inTransaction = !this.explicitlyAutoCommit;
        }
        if (METHOD_COMMIT.equals(methodName) || METHOD_ROLLBACK.equals(methodName)) {
            this.inTransaction = false;
        }
        if (METHOD_SET_READ_ONLY.equals(methodName)) {
            this.explicitlyReadOnly = (Boolean)args[0];
            this.logger.logTrace(Messages.getString("ClusterAwareConnectionProxy.10", new Object[]{"explicitlyReadOnly", this.explicitlyReadOnly}));
            this.connectToWriterIfRequired(this.explicitlyReadOnly);
        }
    }

    private void processFailoverFailure(String message) throws SQLException {
        this.metricsContainer.registerFailoverConnects(false);
        this.logger.logError(message);
        throw new SQLException(message, "08001");
    }

    private void setClusterId(String host, int port) {
        String clusterRdsHostUrl;
        if (!StringUtils.isNullOrEmpty(this.clusterIdSetting)) {
            this.topologyService.setClusterId(this.clusterIdSetting);
        } else if (this.isRdsProxy) {
            this.topologyService.setClusterId(host + ":" + port);
        } else if (this.isRds && !StringUtils.isNullOrEmpty(clusterRdsHostUrl = this.getRdsClusterHostUrl(host))) {
            this.topologyService.setClusterId(clusterRdsHostUrl + ":" + port);
        }
        this.metricsContainer.setClusterId(this.topologyService.getClusterId());
    }

    private boolean shouldAttemptReaderConnection() {
        return this.isExplicitlyReadOnly() && this.clusterContainsReader();
    }

    private boolean shouldPerformWriterFailover() {
        return this.explicitlyReadOnly == null || this.explicitlyReadOnly == false;
    }

    private boolean shouldReconnectToWriter(Boolean readOnly) {
        return readOnly != null && readOnly == false && !this.isWriterHostIndex(this.currentHostIndex);
    }

    private void switchCurrentConnectionTo(int hostIndex, JdbcConnection connection) throws SQLException {
        this.invalidateCurrentConnection();
        JdbcConnection currentConnection = this.currentConnectionProvider.getCurrentConnection();
        boolean readOnly = this.isWriterHostIndex(hostIndex) ? this.isExplicitlyReadOnly() : (this.explicitlyReadOnly != null ? this.explicitlyReadOnly : (currentConnection != null ? currentConnection.isReadOnly() : false));
        this.syncSessionState(currentConnection, connection, readOnly);
        this.updateCurrentConnection(connection, hostIndex);
        this.inTransaction = false;
    }

    private void updateCurrentConnection(JdbcConnection connection, int hostIndex) {
        this.currentHostIndex = hostIndex;
        this.updateCurrentConnection(connection, this.hosts.get(this.currentHostIndex));
    }

    private void updateCurrentConnection(JdbcConnection connection, HostInfo hostInfo) {
        this.currentConnectionProvider.setCurrentConnection(connection, hostInfo);
    }

    private void updateHostIndex(List<HostInfo> latestTopology) throws SQLException {
        HostInfo currentHost = this.hosts.get(this.currentHostIndex);
        int latestHostIndex = -1;
        for (int i = 0; i < latestTopology.size(); ++i) {
            HostInfo host = latestTopology.get(i);
            if (host == null || currentHost == null || !host.equalHostPortPair(currentHost)) continue;
            latestHostIndex = i;
            break;
        }
        if (latestHostIndex == -1) {
            this.currentHostIndex = -1;
            this.pickNewConnection();
        } else {
            this.currentHostIndex = latestHostIndex;
        }
    }

    private void validateHostPatternSetting(String hostPattern) throws SQLException {
        if (!this.isDnsPatternValid(hostPattern)) {
            this.logger.logError(Messages.getString("ClusterAwareConnectionProxy.21"));
            throw new SQLException(Messages.getString("ClusterAwareConnectionProxy.21"));
        }
        this.identifyRdsType(hostPattern);
        if (this.isRdsProxy) {
            this.logger.logError(Messages.getString("ClusterAwareConnectionProxy.7"));
            throw new SQLException(Messages.getString("ClusterAwareConnectionProxy.7"));
        }
        if (this.isRdsCustomClusterDns(hostPattern)) {
            this.logger.logError(Messages.getString("ClusterAwareConnectionProxy.18"));
            throw new SQLException(Messages.getString("ClusterAwareConnectionProxy.18"));
        }
    }

    private Map<String, String> getInitialConnectionProps(PropertySet propertySet) {
        HashMap<String, String> initialConnectionProperties = new HashMap<String, String>();
        Properties originalProperties = propertySet.exposeAsProperties();
        originalProperties.stringPropertyNames().stream().filter(x -> this.propertySet.getProperty((String)x).isExplicitlySet()).forEach(x -> initialConnectionProperties.put((String)x, originalProperties.getProperty((String)x)));
        return initialConnectionProperties;
    }

    private boolean canDirectExecute(String methodName) {
        return METHOD_CLOSE.equals(methodName) || METHOD_IS_CLOSED.equals(methodName) || METHOD_ABORT.equals(methodName);
    }
}

