/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.ConnectionUrl;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.HostInfo;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.PropertyKey;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.PropertySet;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.exceptions.CJCommunicationsException;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.JdbcConnection;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.DefaultMonitorService;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.IConnectionPlugin;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.ICurrentConnectionProvider;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.IMonitorService;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.MonitorConnectionContext;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.NullArgumentMessage;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.log.Log;

public class NodeMonitoringConnectionPlugin
implements IConnectionPlugin {
    private static final String RETRIEVE_HOST_PORT_SQL = "SELECT CONCAT(@@hostname, ':', @@port)";
    private static final List<String> METHODS_STARTING_WITH = Arrays.asList("get", "abort");
    private static final List<String> METHODS_EQUAL_TO = Arrays.asList("close", "next");
    protected IConnectionPlugin nextPlugin;
    protected Log logger;
    protected PropertySet propertySet;
    private IMonitorService monitorService;
    private final Supplier<IMonitorService> monitorServiceSupplier;
    private final Set<String> nodeKeys = new HashSet<String>();
    private final ICurrentConnectionProvider currentConnectionProvider;
    private JdbcConnection connection;

    public NodeMonitoringConnectionPlugin(ICurrentConnectionProvider currentConnectionProvider, PropertySet propertySet, IConnectionPlugin nextPlugin, Log logger) {
        this(currentConnectionProvider, propertySet, nextPlugin, logger, () -> new DefaultMonitorService(logger));
    }

    NodeMonitoringConnectionPlugin(ICurrentConnectionProvider currentConnectionProvider, PropertySet propertySet, IConnectionPlugin nextPlugin, Log logger, Supplier<IMonitorService> monitorServiceSupplier) {
        this.assertArgumentIsNotNull(currentConnectionProvider, "currentConnectionProvider");
        this.assertArgumentIsNotNull(propertySet, "propertySet");
        this.assertArgumentIsNotNull(nextPlugin, "nextPlugin");
        this.assertArgumentIsNotNull(logger, "logger");
        this.currentConnectionProvider = currentConnectionProvider;
        this.connection = currentConnectionProvider.getCurrentConnection();
        this.propertySet = propertySet;
        this.logger = logger;
        this.nextPlugin = nextPlugin;
        this.monitorServiceSupplier = monitorServiceSupplier;
        if (this.connection != null) {
            this.generateNodeKeys(this.connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(Class<?> methodInvokeOn, String methodName, Callable<?> executeSqlFunc, Object[] args) throws Exception {
        Object result;
        block15: {
            MonitorConnectionContext monitorConnectionContext;
            boolean isEnabled = this.propertySet.getBooleanProperty(PropertyKey.failureDetectionEnabled).getValue();
            if (!isEnabled || !this.doesNeedMonitoring(methodInvokeOn, methodName)) {
                return this.nextPlugin.execute(methodInvokeOn, methodName, executeSqlFunc, args);
            }
            int failureDetectionTimeMillis = this.propertySet.getIntegerProperty(PropertyKey.failureDetectionTime).getValue();
            int failureDetectionIntervalMillis = this.propertySet.getIntegerProperty(PropertyKey.failureDetectionInterval).getValue();
            int failureDetectionCount = this.propertySet.getIntegerProperty(PropertyKey.failureDetectionCount).getValue();
            this.initMonitorService();
            MonitorConnectionContext monitorContext = null;
            try {
                if (this.logger.isTraceEnabled()) {
                    this.logger.logTrace(String.format("[NodeMonitoringConnectionPlugin.execute]: method=%s.%s, monitoring is activated", methodInvokeOn.getName(), methodName));
                }
                this.checkIfChanged(this.currentConnectionProvider.getCurrentConnection());
                monitorContext = this.monitorService.startMonitoring(this.connection, this.nodeKeys, this.currentConnectionProvider.getCurrentHostInfo(), this.propertySet, failureDetectionTimeMillis, failureDetectionIntervalMillis, failureDetectionCount);
                result = this.nextPlugin.execute(methodInvokeOn, methodName, executeSqlFunc, args);
                if (monitorContext == null) break block15;
                this.monitorService.stopMonitoring(monitorContext);
                monitorConnectionContext = monitorContext;
            }
            catch (Throwable throwable) {
                if (monitorContext != null) {
                    this.monitorService.stopMonitoring(monitorContext);
                    MonitorConnectionContext monitorConnectionContext2 = monitorContext;
                    synchronized (monitorConnectionContext2) {
                        if (monitorContext.isNodeUnhealthy() && !this.connection.isClosed()) {
                            this.abortConnection();
                            throw new CJCommunicationsException("Node is unavailable.");
                        }
                    }
                }
                if (this.logger.isTraceEnabled()) {
                    this.logger.logTrace(String.format("[NodeMonitoringConnectionPlugin.execute]: method=%s.%s, monitoring is deactivated", methodInvokeOn.getName(), methodName));
                }
                throw throwable;
            }
            synchronized (monitorConnectionContext) {
                if (monitorContext.isNodeUnhealthy() && !this.connection.isClosed()) {
                    this.abortConnection();
                    throw new CJCommunicationsException("Node is unavailable.");
                }
            }
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.logTrace(String.format("[NodeMonitoringConnectionPlugin.execute]: method=%s.%s, monitoring is deactivated", methodInvokeOn.getName(), methodName));
        }
        return result;
    }

    void abortConnection() {
        try {
            this.connection.abortInternal();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected boolean doesNeedMonitoring(Class<?> methodInvokeOn, String methodName) {
        for (String method : METHODS_STARTING_WITH) {
            if (!methodName.startsWith(method)) continue;
            return false;
        }
        for (String method : METHODS_EQUAL_TO) {
            if (!method.equals(methodName)) continue;
            return false;
        }
        return true;
    }

    private void initMonitorService() {
        if (this.monitorService == null) {
            this.monitorService = this.monitorServiceSupplier.get();
        }
    }

    @Override
    public void transactionBegun() {
        this.nextPlugin.transactionBegun();
    }

    @Override
    public void transactionCompleted() {
        this.nextPlugin.transactionCompleted();
    }

    @Override
    public void openInitialConnection(ConnectionUrl connectionUrl) throws SQLException {
        this.nextPlugin.openInitialConnection(connectionUrl);
    }

    @Override
    public void releaseResources() {
        if (this.monitorService != null) {
            this.monitorService.releaseResources();
        }
        this.monitorService = null;
        this.nextPlugin.releaseResources();
    }

    private void assertArgumentIsNotNull(Object param, String paramName) {
        if (param == null) {
            throw new IllegalArgumentException(NullArgumentMessage.getMessage(paramName));
        }
    }

    private void checkIfChanged(JdbcConnection newConnection) {
        boolean isSameConnection;
        boolean bl = isSameConnection = this.connection != null && this.connection.equals(newConnection);
        if (!isSameConnection) {
            if (!this.nodeKeys.isEmpty()) {
                this.monitorService.stopMonitoringForAllConnections(this.nodeKeys);
            }
            this.connection = newConnection;
            this.generateNodeKeys(this.connection);
        }
    }

    private void generateNodeKeys(Connection connection) {
        this.nodeKeys.clear();
        HostInfo hostInfo = this.currentConnectionProvider.getCurrentHostInfo();
        this.nodeKeys.add(String.format("%s:%d", hostInfo.getHost(), hostInfo.getPort()));
        try (Statement stmt = connection.createStatement();
             ResultSet rs = stmt.executeQuery(RETRIEVE_HOST_PORT_SQL);){
            while (rs.next()) {
                this.nodeKeys.add(rs.getString(1));
            }
        }
        catch (SQLException sqlException) {
            this.logger.logTrace("[NodeMonitoringConnectionPlugin.initNodes]: Could not retrieve Host:Port from querying");
        }
    }
}

