/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.util.StringUtils;

public class RdsUtils {
    private static final Pattern AURORA_DNS_PATTERN = Pattern.compile("(?<instance>.+)\\.(?<dns>proxy-|cluster-|cluster-ro-|cluster-custom-)?(?<domain>[a-zA-Z0-9]+\\.(?<region>[a-zA-Z0-9\\-]+)\\.rds\\.amazonaws\\.com(\\.cn)?)", 2);
    private static final Pattern AURORA_CLUSTER_PATTERN = Pattern.compile("(?<instance>.+)\\.(?<dns>cluster-|cluster-ro-)+(?<domain>[a-zA-Z0-9]+\\.(?<region>[a-zA-Z0-9\\-]+)\\.rds\\.amazonaws\\.com(\\.cn)?)", 2);
    private static final Pattern AURORA_CUSTOM_CLUSTER_PATTERN = Pattern.compile("(?<instance>.+)\\.(?<dns>cluster-custom-)+(?<domain>[a-zA-Z0-9]+\\.(?<region>[a-zA-Z0-9\\-]+)\\.rds\\.amazonaws\\.com(\\.cn)?)", 2);
    private static final Pattern AURORA_PROXY_DNS_PATTERN = Pattern.compile("(?<instance>.+)\\.(?<dns>proxy-)+(?<domain>[a-zA-Z0-9]+\\.(?<region>[a-zA-Z0-9\\-]+)\\.rds\\.amazonaws\\.com(\\.cn)?)", 2);
    private static final Pattern AURORA_CHINA_DNS_PATTERN = Pattern.compile("(?<instance>.+)\\.(?<dns>proxy-|cluster-|cluster-ro-|cluster-custom-)?(?<domain>[a-zA-Z0-9]+\\.(?<region>rds\\.[a-zA-Z0-9\\-]+|[a-zA-Z0-9\\-]+\\.rds)\\.amazonaws\\.com\\.cn)", 2);
    private static final Pattern AURORA_CHINA_CLUSTER_PATTERN = Pattern.compile("(?<instance>.+)\\.(?<dns>cluster-|cluster-ro-)+(?<domain>[a-zA-Z0-9]+\\.(?<region>rds\\.[a-zA-Z0-9\\-]+|[a-zA-Z0-9\\-]+\\.rds)\\.amazonaws\\.com\\.cn)", 2);
    private static final Pattern AURORA_CHINA_CUSTOM_CLUSTER_PATTERN = Pattern.compile("(?<instance>.+)\\.(?<dns>cluster-custom-)+(?<domain>[a-zA-Z0-9]+\\.(?<region>rds\\.[a-zA-Z0-9\\-]+|[a-zA-Z0-9\\-]+\\.rds)\\.amazonaws\\.com\\.cn)", 2);
    private static final Pattern AURORA_CHINA_PROXY_DNS_PATTERN = Pattern.compile("(?<instance>.+)\\.(?<dns>proxy-)+(?<domain>[a-zA-Z0-9]+\\.(?<region>rds\\.[a-zA-Z0-9\\-]+|[a-zA-Z0-9\\-]+\\.rds)\\.amazonaws\\.com\\.cn)", 2);
    private static final String DNS_GROUP = "dns";
    private static final String DOMAIN_GROUP = "domain";

    public static String getRdsInstanceHostPattern(String host) {
        if (StringUtils.isNullOrEmpty(host)) {
            return "?";
        }
        Matcher matcher = AURORA_DNS_PATTERN.matcher(host);
        if (matcher.find()) {
            return "?." + matcher.group(DOMAIN_GROUP);
        }
        Matcher chinaMatcher = AURORA_CHINA_DNS_PATTERN.matcher(host);
        if (chinaMatcher.find()) {
            return "?." + chinaMatcher.group(DOMAIN_GROUP);
        }
        return "?";
    }

    public static String getRdsClusterHostUrl(String host) {
        if (StringUtils.isNullOrEmpty(host)) {
            return null;
        }
        Matcher matcher = AURORA_CLUSTER_PATTERN.matcher(host);
        if (matcher.find()) {
            return host.replaceAll(AURORA_CLUSTER_PATTERN.pattern(), "${instance}.cluster-${domain}");
        }
        Matcher chinaMatcher = AURORA_CHINA_CLUSTER_PATTERN.matcher(host);
        if (chinaMatcher.find()) {
            return host.replaceAll(AURORA_CHINA_CLUSTER_PATTERN.pattern(), "${instance}.cluster-${domain}");
        }
        return null;
    }

    public static boolean isReaderClusterDns(String host) {
        if (StringUtils.isNullOrEmpty(host)) {
            return false;
        }
        Matcher matcher = AURORA_CLUSTER_PATTERN.matcher(host);
        if (matcher.find()) {
            return "cluster-ro-".equalsIgnoreCase(matcher.group(DNS_GROUP));
        }
        Matcher chinaMatcher = AURORA_CHINA_CLUSTER_PATTERN.matcher(host);
        if (chinaMatcher.find()) {
            return "cluster-ro-".equalsIgnoreCase(chinaMatcher.group(DNS_GROUP));
        }
        return false;
    }

    public static boolean isRdsClusterDns(String host) {
        return !StringUtils.isNullOrEmpty(host) && (AURORA_CLUSTER_PATTERN.matcher(host).find() || AURORA_CHINA_CLUSTER_PATTERN.matcher(host).find());
    }

    public static boolean isRdsCustomClusterDns(String host) {
        return !StringUtils.isNullOrEmpty(host) && (AURORA_CUSTOM_CLUSTER_PATTERN.matcher(host).find() || AURORA_CHINA_CUSTOM_CLUSTER_PATTERN.matcher(host).find());
    }

    public static boolean isRdsDns(String host) {
        return !StringUtils.isNullOrEmpty(host) && (AURORA_DNS_PATTERN.matcher(host).find() || AURORA_CHINA_DNS_PATTERN.matcher(host).find());
    }

    public static boolean isRdsProxyDns(String host) {
        if (StringUtils.isNullOrEmpty(host)) {
            return false;
        }
        return AURORA_PROXY_DNS_PATTERN.matcher(host).find() || AURORA_CHINA_PROXY_DNS_PATTERN.matcher(host).find();
    }

    public static boolean isDnsPatternValid(String pattern) {
        return pattern.contains("?");
    }
}

