/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.failover;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.PropertyKey;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.PropertySet;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.JdbcConnection;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.ICurrentConnectionProvider;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.failover.ClusterAwareMetrics;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.failover.ClusterAwareTimeMetricsHolder;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.failover.IClusterAwareMetricsContainer;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.log.Log;

public class ClusterAwareMetricsContainer
implements IClusterAwareMetricsContainer {
    private static final Map<String, ClusterAwareMetrics> clusterMetrics = new ConcurrentHashMap<String, ClusterAwareMetrics>();
    private static final Map<String, ClusterAwareTimeMetricsHolder> topologyMetrics = new ConcurrentHashMap<String, ClusterAwareTimeMetricsHolder>();
    private static final Map<String, ClusterAwareMetrics> instanceMetrics = new ConcurrentHashMap<String, ClusterAwareMetrics>();
    private ICurrentConnectionProvider currentConnectionProvider = null;
    private PropertySet propertySet = null;
    private String clusterId = "[Unknown Id]";

    public ClusterAwareMetricsContainer() {
    }

    public ClusterAwareMetricsContainer(ICurrentConnectionProvider currentConnectionProvider, PropertySet propertySet) {
        this.currentConnectionProvider = currentConnectionProvider;
        this.propertySet = propertySet;
    }

    @Override
    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    @Override
    public void registerFailureDetectionTime(long timeMs) {
        this.register(metrics -> metrics.registerFailureDetectionTime(timeMs));
    }

    @Override
    public void registerWriterFailoverProcedureTime(long timeMs) {
        this.register(metrics -> metrics.registerWriterFailoverProcedureTime(timeMs));
    }

    @Override
    public void registerReaderFailoverProcedureTime(long timeMs) {
        this.register(metrics -> metrics.registerReaderFailoverProcedureTime(timeMs));
    }

    @Override
    public void registerFailoverConnects(boolean isHit) {
        this.register(metrics -> metrics.registerFailoverConnects(isHit));
    }

    @Override
    public void registerInvalidInitialConnection(boolean isHit) {
        this.register(metrics -> metrics.registerInvalidInitialConnection(isHit));
    }

    @Override
    public void registerUseLastConnectedReader(boolean isHit) {
        this.register(metrics -> metrics.registerUseLastConnectedReader(isHit));
    }

    @Override
    public void registerUseCachedTopology(boolean isHit) {
        this.register(metrics -> metrics.registerUseCachedTopology(isHit));
    }

    @Override
    public void registerTopologyQueryExecutionTime(long timeMs) {
        if (!this.isEnabled()) {
            return;
        }
        topologyMetrics.computeIfAbsent(this.clusterId, k -> new ClusterAwareTimeMetricsHolder("Topology Query")).registerQueryExecutionTime(timeMs);
    }

    protected void register(Consumer<ClusterAwareMetrics> lambda) {
        if (!this.isEnabled()) {
            return;
        }
        lambda.accept(this.getClusterMetrics(this.clusterId));
        if (this.isInstanceMetricsEnabled()) {
            lambda.accept(this.getInstanceMetrics(this.getCurrentConnUrl()));
        }
    }

    private boolean isEnabled() {
        if (this.propertySet != null) {
            return this.propertySet.getBooleanProperty(PropertyKey.gatherPerfMetrics.getKeyName()).getValue();
        }
        return false;
    }

    private boolean isInstanceMetricsEnabled() {
        if (this.propertySet != null) {
            return this.propertySet.getBooleanProperty(PropertyKey.gatherAdditionalMetricsOnInstance.getKeyName()).getValue();
        }
        return false;
    }

    private ClusterAwareMetrics getClusterMetrics(String key) {
        return clusterMetrics.computeIfAbsent(key, k -> new ClusterAwareMetrics());
    }

    private ClusterAwareMetrics getInstanceMetrics(String key) {
        return instanceMetrics.computeIfAbsent(key, k -> new ClusterAwareMetrics());
    }

    private String getCurrentConnUrl() {
        String currUrl = "[Unknown Url]";
        if (this.currentConnectionProvider == null) {
            return currUrl;
        }
        JdbcConnection currConn = this.currentConnectionProvider.getCurrentConnection();
        if (currConn != null) {
            currUrl = currConn.getHostPortPair();
        }
        return currUrl;
    }

    public static void reportMetrics(String connUrl, Log log) {
        ClusterAwareMetricsContainer.reportMetrics(connUrl, log, false);
    }

    public static void reportMetrics(String connUrl, Log log, boolean forInstances) {
        ClusterAwareMetrics metrics;
        ClusterAwareMetrics clusterAwareMetrics = metrics = forInstances ? instanceMetrics.get(connUrl) : clusterMetrics.get(connUrl);
        if (metrics != null) {
            StringBuilder logMessage = new StringBuilder(256);
            logMessage.append("** Performance Metrics Report for '").append(connUrl).append("' **\n");
            log.logInfo(logMessage);
            ClusterAwareTimeMetricsHolder topMetric = topologyMetrics.get(connUrl);
            if (topMetric != null) {
                topMetric.reportMetrics(log);
            }
            metrics.reportMetrics(log);
        } else {
            StringBuilder logMessage = new StringBuilder();
            logMessage.append("** No metrics collected for '").append(connUrl).append("' **\n");
            log.logInfo(logMessage);
        }
    }

    public static void resetMetrics() {
        clusterMetrics.clear();
        topologyMetrics.clear();
        instanceMetrics.clear();
    }
}

