/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.mysql.shading.com.mysql.cj.protocol.a;

import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.PropertyKey;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.protocol.ColumnDefinition;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.protocol.ProtocolEntityFactory;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.protocol.Resultset;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.protocol.ResultsetRow;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.protocol.a.AbstractRowFactory;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.protocol.a.MysqlTextValueDecoder;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.protocol.a.NativeConstants;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.protocol.a.NativePacketPayload;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.protocol.a.NativeProtocol;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.protocol.a.result.ByteArrayRow;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.protocol.a.result.TextBufferRow;

public class TextRowFactory
extends AbstractRowFactory
implements ProtocolEntityFactory<ResultsetRow, NativePacketPayload> {
    public TextRowFactory(NativeProtocol protocol, ColumnDefinition colDefinition, Resultset.Concurrency resultSetConcurrency, boolean canReuseRowPacketForBufferRow) {
        this.columnDefinition = colDefinition;
        this.resultSetConcurrency = resultSetConcurrency;
        this.canReuseRowPacketForBufferRow = canReuseRowPacketForBufferRow;
        this.useBufferRowSizeThreshold = protocol.getPropertySet().getMemorySizeProperty(PropertyKey.largeRowSizeThreshold);
        this.exceptionInterceptor = protocol.getExceptionInterceptor();
        this.valueDecoder = new MysqlTextValueDecoder();
    }

    @Override
    public ResultsetRow createFromMessage(NativePacketPayload rowPacket) {
        boolean useBufferRow;
        boolean bl = useBufferRow = this.canReuseRowPacketForBufferRow || this.columnDefinition.hasLargeFields() || rowPacket.getPayloadLength() >= (Integer)this.useBufferRowSizeThreshold.getValue();
        if (this.resultSetConcurrency == Resultset.Concurrency.UPDATABLE || !useBufferRow) {
            byte[][] rowBytes = new byte[this.columnDefinition.getFields().length][];
            for (int i = 0; i < this.columnDefinition.getFields().length; ++i) {
                rowBytes[i] = rowPacket.readBytes(NativeConstants.StringSelfDataType.STRING_LENENC);
            }
            return new ByteArrayRow(rowBytes, this.exceptionInterceptor);
        }
        return new TextBufferRow(rowPacket, this.columnDefinition, this.exceptionInterceptor, this.valueDecoder);
    }

    @Override
    public boolean canReuseRowPacketForBufferRow() {
        return this.canReuseRowPacketForBufferRow;
    }
}

