/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.efm2;

import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.HostInfo;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.PropertyKey;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.PropertySet;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.IConnectionProvider;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.efm2.IMonitor;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.efm2.MonitorConnectionContext;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.log.Log;

public class Monitor
implements IMonitor {
    protected static final String MONITORING_PROPERTY_PREFIX = "monitoring-";
    protected static final long THREAD_SLEEP_NANO = TimeUnit.MILLISECONDS.toNanos(1000L);
    protected static final Executor ABORT_EXECUTOR = Executors.newSingleThreadExecutor();
    private final Queue<WeakReference<MonitorConnectionContext>> activeContexts = new ConcurrentLinkedQueue<WeakReference<MonitorConnectionContext>>();
    private final HashMap<Long, Queue<WeakReference<MonitorConnectionContext>>> newContexts = new HashMap();
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private Connection monitoringConn = null;
    private final ExecutorService threadPool = Executors.newFixedThreadPool(2, runnableTarget -> {
        Thread monitoringThread = new Thread(runnableTarget);
        monitoringThread.setDaemon(true);
        return monitoringThread;
    });
    private final long failureDetectionTimeNano;
    private final long failureDetectionIntervalNano;
    private final int failureDetectionCount;
    private long invalidNodeStartTimeNano;
    private long failureCount;
    private boolean nodeUnhealthy = false;
    private final IConnectionProvider connectionProvider;
    private final Log logger;
    private final PropertySet propertySet;
    private final HostInfo hostInfo;
    private final String defaultTimeoutMillis;

    public Monitor(IConnectionProvider connectionProvider, HostInfo hostInfo, PropertySet propertySet, int failureDetectionTimeMillis, int failureDetectionIntervalMillis, int failureDetectionCount, Log logger) {
        this.connectionProvider = connectionProvider;
        this.hostInfo = hostInfo;
        this.propertySet = propertySet;
        this.logger = logger;
        this.failureDetectionTimeNano = TimeUnit.MILLISECONDS.toNanos(failureDetectionTimeMillis);
        this.failureDetectionIntervalNano = TimeUnit.MILLISECONDS.toNanos(failureDetectionIntervalMillis);
        this.failureDetectionCount = failureDetectionCount;
        this.defaultTimeoutMillis = String.valueOf(failureDetectionIntervalMillis);
        this.threadPool.submit(this::newContextRun);
        this.threadPool.submit(this);
        this.threadPool.shutdown();
    }

    @Override
    public boolean canDispose() {
        return this.activeContexts.isEmpty() && this.newContexts.isEmpty();
    }

    @Override
    public void close() throws Exception {
        this.stopped.set(true);
        if (!this.threadPool.awaitTermination(30L, TimeUnit.SECONDS)) {
            this.threadPool.shutdownNow();
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.logTrace(String.format("[efm2.Monitor.close]: Stopped monitoring thread for node '%s'.", this.hostInfo.getHostPortPair()));
        }
    }

    @Override
    public void startMonitoring(MonitorConnectionContext context) {
        if (this.stopped.get()) {
            this.logger.logWarn(String.format("[efm2.Monitor.startMonitoring]: Monitoring was already stopped for node %s.", this.hostInfo.getHostPortPair()));
        }
        long currentTimeNano = this.getCurrentTimeNano();
        long startMonitoringTimeNano = this.truncateNanoToSeconds(currentTimeNano + this.failureDetectionTimeNano);
        Queue queue = this.newContexts.computeIfAbsent(startMonitoringTimeNano, key -> new ConcurrentLinkedQueue());
        queue.add(new WeakReference<MonitorConnectionContext>(context));
    }

    private long truncateNanoToSeconds(long timeNano) {
        return TimeUnit.SECONDS.toNanos(TimeUnit.NANOSECONDS.toSeconds(timeNano));
    }

    public void clearContexts() {
        this.newContexts.clear();
        this.activeContexts.clear();
    }

    long getCurrentTimeNano() {
        return System.nanoTime();
    }

    public void newContextRun() {
        block4: {
            try {
                while (!this.stopped.get()) {
                    long currentTimeNano = this.getCurrentTimeNano();
                    ArrayList<Long> processedKeys = new ArrayList<Long>();
                    this.newContexts.entrySet().stream().filter(entry -> (Long)entry.getKey() < currentTimeNano).forEach(entry -> {
                        WeakReference contextWeakRef;
                        Queue queue = (Queue)entry.getValue();
                        processedKeys.add((Long)entry.getKey());
                        while ((contextWeakRef = (WeakReference)queue.poll()) != null) {
                            MonitorConnectionContext context = (MonitorConnectionContext)contextWeakRef.get();
                            if (context == null || !context.isActive()) continue;
                            this.activeContexts.add(contextWeakRef);
                        }
                    });
                    processedKeys.forEach(this.newContexts::remove);
                    TimeUnit.SECONDS.sleep(1L);
                }
            }
            catch (InterruptedException currentTimeNano) {
            }
            catch (Exception ex) {
                if (!this.logger.isTraceEnabled()) break block4;
                this.logger.logTrace(String.format("[efm2.Monitor.newContextRun]: Stopping monitoring after unhandled exception was thrown in monitoring thread for node %s.", this.hostInfo.getHostPortPair()), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!this.stopped.get()) {
                WeakReference<MonitorConnectionContext> monitorContextWeakRef;
                if (this.activeContexts.isEmpty()) {
                    TimeUnit.NANOSECONDS.sleep(THREAD_SLEEP_NANO);
                    continue;
                }
                long statusCheckStartTimeNano = this.getCurrentTimeNano();
                boolean isValid = this.checkConnectionStatus();
                long statusCheckEndTimeNano = this.getCurrentTimeNano();
                this.updateNodeHealthStatus(isValid, statusCheckStartTimeNano, statusCheckEndTimeNano);
                ArrayList<WeakReference<MonitorConnectionContext>> tmpActiveContexts = new ArrayList<WeakReference<MonitorConnectionContext>>();
                while ((monitorContextWeakRef = this.activeContexts.poll()) != null && !this.stopped.get()) {
                    MonitorConnectionContext monitorContext = (MonitorConnectionContext)monitorContextWeakRef.get();
                    if (monitorContext == null) continue;
                    if (this.nodeUnhealthy) {
                        monitorContext.setNodeUnhealthy(true);
                        Connection connectionToAbort = monitorContext.getConnection();
                        monitorContext.setInactive();
                        if (connectionToAbort == null) continue;
                        this.abortConnection(connectionToAbort);
                        continue;
                    }
                    if (!monitorContext.isActive()) continue;
                    tmpActiveContexts.add(monitorContextWeakRef);
                }
                this.activeContexts.addAll(tmpActiveContexts);
                long delayNano = this.failureDetectionIntervalNano - (statusCheckEndTimeNano - statusCheckStartTimeNano);
                if (delayNano < THREAD_SLEEP_NANO) {
                    delayNano = THREAD_SLEEP_NANO;
                }
                TimeUnit.NANOSECONDS.sleep(delayNano);
            }
        }
        catch (InterruptedException statusCheckStartTimeNano) {
        }
        catch (Exception ex) {
            if (this.logger.isTraceEnabled()) {
                this.logger.logTrace(String.format("[efm2.Monitor.run]: Stopping monitoring after unhandled exception was thrown in monitoring thread for node %s.", this.hostInfo.getHostPortPair()), ex);
            }
        }
        finally {
            this.stopped.set(true);
            if (this.monitoringConn != null) {
                try {
                    this.monitoringConn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    boolean checkConnectionStatus() {
        try {
            if (this.monitoringConn == null || this.monitoringConn.isClosed()) {
                HashMap<String, String> monitoringConnProperties = new HashMap<String, String>();
                monitoringConnProperties.put(PropertyKey.connectTimeout.getKeyName(), this.defaultTimeoutMillis);
                monitoringConnProperties.put(PropertyKey.socketTimeout.getKeyName(), this.defaultTimeoutMillis);
                Properties originalProperties = this.propertySet.exposeAsProperties();
                if (originalProperties != null) {
                    originalProperties.stringPropertyNames().stream().filter(p -> p.startsWith(MONITORING_PROPERTY_PREFIX)).forEach(p -> monitoringConnProperties.put(p.substring(MONITORING_PROPERTY_PREFIX.length()), originalProperties.getProperty((String)p)));
                }
                if (this.logger.isTraceEnabled()) {
                    this.logger.logTrace("[efm2.Monitor.checkConnectionStatus]: Opening a monitoring connection to " + this.hostInfo.getHostPortPair());
                }
                this.monitoringConn = this.connectionProvider.connect(this.copy(this.hostInfo, monitoringConnProperties));
                if (this.logger.isTraceEnabled()) {
                    this.logger.logTrace("[efm2.Monitor.checkConnectionStatus]: Opened monitoring connection: " + this.monitoringConn);
                }
                return true;
            }
            boolean isValid = this.monitoringConn.isValid((int)TimeUnit.NANOSECONDS.toSeconds(this.failureDetectionIntervalNano));
            return isValid;
        }
        catch (SQLException sqlEx) {
            return false;
        }
    }

    private void updateNodeHealthStatus(boolean connectionValid, long statusCheckStartNano, long statusCheckEndNano) {
        if (!connectionValid) {
            long maxInvalidNodeDurationNano;
            long invalidNodeDurationNano;
            ++this.failureCount;
            if (this.invalidNodeStartTimeNano == 0L) {
                this.invalidNodeStartTimeNano = statusCheckStartNano;
            }
            if ((invalidNodeDurationNano = statusCheckEndNano - this.invalidNodeStartTimeNano) >= (maxInvalidNodeDurationNano = this.failureDetectionIntervalNano * (long)Math.max(0, this.failureDetectionCount))) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.logTrace(String.format("[efm2.Monitor.updateNodeHealthStatus]: Host %s is *dead*.", this.hostInfo.getHostPortPair()));
                }
                this.nodeUnhealthy = true;
                return;
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.logTrace(String.format("[efm2.Monitor.updateNodeHealthStatus]: Host %s is not *responding* %d.", this.hostInfo.getHostPortPair(), this.failureCount));
            }
            return;
        }
        if (this.failureCount > 0L && this.logger.isTraceEnabled()) {
            this.logger.logTrace(String.format("[efm2.Monitor.updateNodeHealthStatus]: Host %s is *alive*.", this.hostInfo.getHostPortPair()));
        }
        this.failureCount = 0L;
        this.invalidNodeStartTimeNano = 0L;
        this.nodeUnhealthy = false;
    }

    private void abortConnection(@NonNull Connection connectionToAbort) {
        block2: {
            try {
                connectionToAbort.abort(ABORT_EXECUTOR);
                connectionToAbort.close();
            }
            catch (SQLException sqlEx) {
                if (!this.logger.isTraceEnabled()) break block2;
                this.logger.logTrace(String.format("[efm2.Monitor.abortConnection]: Exception during aborting connection: %s", sqlEx.getMessage()));
            }
        }
    }

    private HostInfo copy(HostInfo src, Map<String, String> props) {
        return new HostInfo(null, src.getHost(), src.getPort(), src.getUser(), src.getPassword(), props);
    }
}

