/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.mysql.shading.com.mysql.cj;

import java.io.IOException;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.CoreSession;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.QueryResult;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.HostInfo;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.PropertySet;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.exceptions.CJCommunicationsException;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.protocol.ColumnDefinition;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.protocol.Message;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.protocol.ResultBuilder;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.protocol.x.StatementExecuteOkBuilder;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.protocol.x.XProtocol;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.protocol.x.XProtocolError;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.protocol.x.XProtocolRowInputStream;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.result.Row;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.xdevapi.PreparableStatement;

public class MysqlxSession
extends CoreSession {
    public MysqlxSession(HostInfo hostInfo, PropertySet propSet) {
        super(hostInfo, propSet);
        this.protocol = new XProtocol(hostInfo, propSet);
        this.messageBuilder = this.protocol.getMessageBuilder();
        this.protocol.connect(hostInfo.getUser(), hostInfo.getPassword(), hostInfo.getDatabase());
    }

    public MysqlxSession(XProtocol prot) {
        super(null, prot.getPropertySet());
        this.protocol = prot;
        this.messageBuilder = this.protocol.getMessageBuilder();
    }

    @Override
    public String getProcessHost() {
        return this.protocol.getSocketConnection().getHost();
    }

    public int getPort() {
        return this.protocol.getSocketConnection().getPort();
    }

    public XProtocol getProtocol() {
        return (XProtocol)this.protocol;
    }

    @Override
    public void quit() {
        try {
            this.protocol.close();
        }
        catch (IOException ex) {
            throw new CJCommunicationsException(ex);
        }
        super.quit();
    }

    @Override
    public boolean isClosed() {
        return !((XProtocol)this.protocol).isOpen();
    }

    public boolean supportsPreparedStatements() {
        return ((XProtocol)this.protocol).supportsPreparedStatements();
    }

    public boolean readyForPreparingStatements() {
        return ((XProtocol)this.protocol).readyForPreparingStatements();
    }

    public int getNewPreparedStatementId(PreparableStatement<?> preparableStatement) {
        return ((XProtocol)this.protocol).getNewPreparedStatementId(preparableStatement);
    }

    public void freePreparedStatementId(int preparedStatementId) {
        ((XProtocol)this.protocol).freePreparedStatementId(preparedStatementId);
    }

    public boolean failedPreparingStatement(int preparedStatementId, XProtocolError e) {
        return ((XProtocol)this.protocol).failedPreparingStatement(preparedStatementId, e);
    }

    @Override
    public <M extends Message, R, RES> RES query(M message, Predicate<Row> rowFilter, Function<Row, R> rowMapper, Collector<R, ?, RES> collector) {
        this.protocol.send(message, 0);
        ColumnDefinition metadata = this.protocol.readMetadata();
        XProtocolRowInputStream ris = new XProtocolRowInputStream(metadata, (XProtocol)this.protocol, null);
        Stream<Row> stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(ris, 0), false);
        if (rowFilter != null) {
            stream = stream.filter(rowFilter);
        }
        RES result = stream.map(rowMapper).collect(collector);
        this.protocol.readQueryResult(new StatementExecuteOkBuilder());
        return result;
    }

    @Override
    public <M extends Message, R extends QueryResult> R query(M message, ResultBuilder<R> resultBuilder) {
        return ((XProtocol)this.protocol).query(message, resultBuilder);
    }

    @Override
    public <M extends Message, R extends QueryResult> CompletableFuture<R> queryAsync(M message, ResultBuilder<R> resultBuilder) {
        return ((XProtocol)this.protocol).queryAsync(message, resultBuilder);
    }
}

