/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.failover;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.Messages;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.ConnectionUrl;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.HostInfo;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.PropertyKey;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.PropertySet;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.JdbcConnection;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.failover.ClusterAwareMetricsContainer;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.failover.IClusterAwareMetricsContainer;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.failover.ITopologyService;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.log.Log;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.log.NullLogger;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.util.ExpiringCache;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.util.Util;

public class AuroraTopologyService
implements ITopologyService {
    static final int DEFAULT_REFRESH_RATE_IN_MILLISECONDS = 30000;
    static final int DEFAULT_CACHE_EXPIRE_MS = 300000;
    private int refreshRateInMilliseconds;
    static final String RETRIEVE_TOPOLOGY_SQL = "SELECT SERVER_ID, SESSION_ID, LAST_UPDATE_TIMESTAMP, REPLICA_LAG_IN_MILLISECONDS FROM information_schema.replica_host_status WHERE time_to_sec(timediff(now(), LAST_UPDATE_TIMESTAMP)) <= 300 ORDER BY LAST_UPDATE_TIMESTAMP DESC";
    static final String GET_INSTANCE_NAME_SQL = "SELECT @@aurora_server_id";
    static final String GET_INSTANCE_NAME_COL = "@@aurora_server_id";
    static final String WRITER_SESSION_ID = "MASTER_SESSION_ID";
    static final String FIELD_SERVER_ID = "SERVER_ID";
    static final String FIELD_SESSION_ID = "SESSION_ID";
    static final String FIELD_LAST_UPDATED = "LAST_UPDATE_TIMESTAMP";
    static final String FIELD_REPLICA_LAG = "REPLICA_LAG_IN_MILLISECONDS";
    public static final ExpiringCache<String, ClusterTopologyInfo> topologyCache = new ExpiringCache(300000);
    private static final Object cacheLock = new Object();
    protected String clusterId;
    protected HostInfo clusterInstanceTemplate;
    protected IClusterAwareMetricsContainer metricsContainer;
    protected static final Log NULL_LOGGER = new NullLogger("MySQL");
    protected transient Log log = NULL_LOGGER;

    public AuroraTopologyService(Log log) {
        this(30000, log, ClusterAwareMetricsContainer::new);
    }

    public AuroraTopologyService(int refreshRateInMilliseconds, Log log, Supplier<IClusterAwareMetricsContainer> metricsContainerSupplier) {
        this.refreshRateInMilliseconds = refreshRateInMilliseconds;
        this.clusterId = UUID.randomUUID().toString();
        this.clusterInstanceTemplate = new HostInfo(null, "?", -1, null, null);
        this.metricsContainer = metricsContainerSupplier.get();
        if (log != null) {
            this.log = log;
        }
    }

    public static void setExpireTime(int expireTimeMs) {
        topologyCache.setExpireTime(expireTimeMs);
    }

    @Override
    public void setClusterId(String clusterId) {
        this.log.logTrace(Messages.getString("AuroraTopologyService.1", new Object[]{clusterId}));
        this.clusterId = clusterId;
        this.metricsContainer.setClusterId(clusterId);
    }

    @Override
    public String getClusterId() {
        return this.clusterId;
    }

    @Override
    public void setClusterInstanceTemplate(HostInfo clusterInstanceTemplate) {
        this.log.logTrace(Messages.getString("AuroraTopologyService.2", new Object[]{clusterInstanceTemplate.getHost(), clusterInstanceTemplate.getPort(), clusterInstanceTemplate.getDatabase()}));
        this.clusterInstanceTemplate = clusterInstanceTemplate;
    }

    @Override
    public List<HostInfo> getTopology(JdbcConnection conn, boolean forceUpdate) throws SQLException {
        ClusterTopologyInfo clusterTopologyInfo = topologyCache.get(this.clusterId);
        if (clusterTopologyInfo == null || Util.isNullOrEmpty(clusterTopologyInfo.hosts) || forceUpdate || this.refreshNeeded(clusterTopologyInfo)) {
            ClusterTopologyInfo latestTopologyInfo = this.queryForTopology(conn);
            if (!Util.isNullOrEmpty(latestTopologyInfo.hosts)) {
                clusterTopologyInfo = this.updateCache(clusterTopologyInfo, latestTopologyInfo);
            } else if (clusterTopologyInfo == null || clusterTopologyInfo.hosts == null || forceUpdate) {
                return new ArrayList<HostInfo>();
            }
        }
        return clusterTopologyInfo.hosts;
    }

    private boolean refreshNeeded(ClusterTopologyInfo info) {
        Instant lastUpdateTime = info.lastUpdated;
        return lastUpdateTime == null || Duration.between(lastUpdateTime, Instant.now()).toMillis() > (long)this.refreshRateInMilliseconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClusterTopologyInfo queryForTopology(JdbcConnection conn) throws SQLException {
        long startTimeMs = System.currentTimeMillis();
        ClusterTopologyInfo topologyInfo = null;
        try (Statement stmt = conn.createStatement();
             ResultSet resultSet = stmt.executeQuery(RETRIEVE_TOPOLOGY_SQL);){
            topologyInfo = this.processQueryResults(resultSet);
        }
        catch (SQLSyntaxErrorException currentTimeMs) {
        }
        finally {
            if (this.gatherPerfMetrics(conn.getPropertySet())) {
                long currentTimeMs = System.currentTimeMillis();
                this.metricsContainer.registerTopologyQueryExecutionTime(currentTimeMs - startTimeMs);
            }
        }
        return topologyInfo != null ? topologyInfo : new ClusterTopologyInfo(new ArrayList<HostInfo>(), new HashSet<String>(), null, Instant.now(), false);
    }

    private boolean gatherPerfMetrics(PropertySet props) {
        return props != null && props.getProperty(PropertyKey.gatherPerfMetrics.getKeyName()) != null && props.getBooleanProperty(PropertyKey.gatherPerfMetrics.getKeyName()).getValue() != false;
    }

    private ClusterTopologyInfo processQueryResults(ResultSet resultSet) throws SQLException {
        int writerCount = 0;
        ArrayList<HostInfo> hosts = new ArrayList<HostInfo>();
        while (resultSet.next()) {
            if (!WRITER_SESSION_ID.equalsIgnoreCase(resultSet.getString(FIELD_SESSION_ID))) {
                hosts.add(this.createHost(resultSet));
                continue;
            }
            if (writerCount == 0) {
                hosts.add(0, this.createHost(resultSet));
            } else {
                hosts.add(this.createHost(resultSet));
            }
            ++writerCount;
        }
        if (writerCount == 0) {
            this.log.logError(Messages.getString("AuroraTopologyService.3"));
            hosts.clear();
        }
        return new ClusterTopologyInfo(hosts, new HashSet<String>(), null, Instant.now(), writerCount > 1);
    }

    private HostInfo createHost(ResultSet resultSet) throws SQLException {
        String hostEndpoint = this.getHostEndpoint(resultSet.getString(FIELD_SERVER_ID));
        ConnectionUrl hostUrl = ConnectionUrl.getConnectionUrlInstance(this.getUrlFromEndpoint(hostEndpoint, this.clusterInstanceTemplate.getPort(), this.clusterInstanceTemplate.getDatabase()), new Properties());
        return new HostInfo(hostUrl, hostEndpoint, this.clusterInstanceTemplate.getPort(), this.clusterInstanceTemplate.getUser(), this.clusterInstanceTemplate.getPassword(), this.clusterInstanceTemplate.isPasswordless(), this.getPropertiesFromTopology(resultSet));
    }

    private String getHostEndpoint(String nodeName) {
        String host = this.clusterInstanceTemplate.getHost();
        return host.replace("?", nodeName);
    }

    private String getUrlFromEndpoint(String endpoint, int port, String dbname) {
        return String.format("%s//%s:%d/%s", ConnectionUrl.Type.SINGLE_CONNECTION_AWS.getScheme(), endpoint, port, dbname);
    }

    private Map<String, String> getPropertiesFromTopology(ResultSet resultSet) throws SQLException {
        HashMap<String, String> properties = new HashMap<String, String>(this.clusterInstanceTemplate.getHostProperties());
        properties.put("TOPOLOGY_SERVICE_SERVER_ID", resultSet.getString(FIELD_SERVER_ID));
        properties.put("TOPOLOGY_SERVICE_SESSION_ID", resultSet.getString(FIELD_SESSION_ID));
        properties.put("TOPOLOGY_SERVICE_LAST_UPDATE_TIMESTAMP", this.convertTimestampToString(resultSet.getTimestamp(FIELD_LAST_UPDATED)));
        properties.put("TOPOLOGY_SERVICE_REPLICA_LAG_IN_MILLISECONDS", Double.valueOf(resultSet.getDouble(FIELD_REPLICA_LAG)).toString());
        return properties;
    }

    private String convertTimestampToString(Timestamp timestamp) {
        return timestamp == null ? null : timestamp.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClusterTopologyInfo updateCache(ClusterTopologyInfo clusterTopologyInfo, ClusterTopologyInfo latestTopologyInfo) {
        if (clusterTopologyInfo == null) {
            clusterTopologyInfo = latestTopologyInfo;
        } else {
            clusterTopologyInfo.hosts = latestTopologyInfo.hosts;
            clusterTopologyInfo.downHosts = latestTopologyInfo.downHosts;
            clusterTopologyInfo.isMultiWriterCluster = latestTopologyInfo.isMultiWriterCluster;
        }
        clusterTopologyInfo.lastUpdated = Instant.now();
        Object object = cacheLock;
        synchronized (object) {
            topologyCache.put(this.clusterId, clusterTopologyInfo);
        }
        return clusterTopologyInfo;
    }

    @Override
    public List<HostInfo> getCachedTopology() {
        ClusterTopologyInfo info = topologyCache.get(this.clusterId);
        return info == null || this.refreshNeeded(info) ? null : info.hosts;
    }

    @Override
    public HostInfo getLastUsedReaderHost() {
        ClusterTopologyInfo info = topologyCache.get(this.clusterId);
        return info == null || this.refreshNeeded(info) ? null : info.lastUsedReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLastUsedReaderHost(HostInfo reader) {
        if (reader != null) {
            Object object = cacheLock;
            synchronized (object) {
                ClusterTopologyInfo info = topologyCache.get(this.clusterId);
                if (info != null) {
                    info.lastUsedReader = reader;
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public HostInfo getHostByName(JdbcConnection conn) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private HostInfo instanceNameToHost(String name, List<HostInfo> hosts) {
        if (name == null || hosts == null) {
            return null;
        }
        for (HostInfo host : hosts) {
            if (host == null || !name.equalsIgnoreCase(host.getHostProperties().get("TOPOLOGY_SERVICE_SERVER_ID"))) continue;
            return host;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getDownHosts() {
        Object object = cacheLock;
        synchronized (object) {
            ClusterTopologyInfo clusterTopologyInfo = topologyCache.get(this.clusterId);
            return clusterTopologyInfo != null && clusterTopologyInfo.downHosts != null ? clusterTopologyInfo.downHosts : new HashSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addToDownHostList(HostInfo downHost) {
        if (downHost == null) {
            return;
        }
        Object object = cacheLock;
        synchronized (object) {
            ClusterTopologyInfo clusterTopologyInfo = topologyCache.get(this.clusterId);
            if (clusterTopologyInfo == null) {
                clusterTopologyInfo = new ClusterTopologyInfo(new ArrayList<HostInfo>(), new HashSet<String>(), null, Instant.now(), false);
                topologyCache.put(this.clusterId, clusterTopologyInfo);
            } else if (clusterTopologyInfo.downHosts == null) {
                clusterTopologyInfo.downHosts = new HashSet<String>();
            }
            clusterTopologyInfo.downHosts.add(downHost.getHostPortPair());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFromDownHostList(HostInfo host) {
        if (host == null) {
            return;
        }
        Object object = cacheLock;
        synchronized (object) {
            ClusterTopologyInfo clusterTopologyInfo = topologyCache.get(this.clusterId);
            if (clusterTopologyInfo != null && clusterTopologyInfo.downHosts != null) {
                clusterTopologyInfo.downHosts.remove(host.getHostPortPair());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isMultiWriterCluster() {
        Object object = cacheLock;
        synchronized (object) {
            ClusterTopologyInfo clusterTopologyInfo = topologyCache.get(this.clusterId);
            return clusterTopologyInfo != null && clusterTopologyInfo.downHosts != null && clusterTopologyInfo.isMultiWriterCluster;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRefreshRate(int refreshRate) {
        this.refreshRateInMilliseconds = refreshRate;
        if (topologyCache.getExpireTime() < this.refreshRateInMilliseconds) {
            Object object = cacheLock;
            synchronized (object) {
                if (topologyCache.getExpireTime() < this.refreshRateInMilliseconds) {
                    topologyCache.setExpireTime(this.refreshRateInMilliseconds);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAll() {
        Object object = cacheLock;
        synchronized (object) {
            topologyCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = cacheLock;
        synchronized (object) {
            topologyCache.remove(this.clusterId);
        }
    }

    private static class ClusterTopologyInfo {
        public Instant lastUpdated;
        public Set<String> downHosts;
        public List<HostInfo> hosts;
        public HostInfo lastUsedReader;
        public boolean isMultiWriterCluster;

        ClusterTopologyInfo(List<HostInfo> hosts, Set<String> downHosts, HostInfo lastUsedReader, Instant lastUpdated, boolean isMultiWriterCluster) {
            this.hosts = hosts;
            this.downHosts = downHosts;
            this.lastUsedReader = lastUsedReader;
            this.lastUpdated = lastUpdated;
            this.isMultiWriterCluster = isMultiWriterCluster;
        }
    }
}

