/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins;

import java.util.Set;
import java.util.concurrent.Executors;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.Messages;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.HostInfo;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.PropertyKey;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.PropertySet;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.JdbcConnection;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.BasicConnectionProvider;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.IExecutorServiceInitializer;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.IMonitor;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.IMonitorInitializer;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.IMonitorService;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.Monitor;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.MonitorConnectionContext;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.MonitorThreadContainer;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.NullArgumentMessage;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.log.Log;

public class DefaultMonitorService
implements IMonitorService {
    MonitorThreadContainer threadContainer;
    private final Log logger;
    final IMonitorInitializer monitorInitializer;

    public DefaultMonitorService(Log logger) {
        this((hostInfo, propertySet, monitorService) -> new Monitor(new BasicConnectionProvider(), hostInfo, propertySet, propertySet.getIntegerProperty(PropertyKey.monitorDisposalTime).getValue().intValue(), monitorService, logger), () -> Executors.newCachedThreadPool(r -> {
            Thread monitoringThread = new Thread(r);
            monitoringThread.setDaemon(true);
            return monitoringThread;
        }), logger);
    }

    DefaultMonitorService(IMonitorInitializer monitorInitializer, IExecutorServiceInitializer executorServiceInitializer, Log logger) {
        this.monitorInitializer = monitorInitializer;
        this.logger = logger;
        this.threadContainer = MonitorThreadContainer.getInstance(executorServiceInitializer);
    }

    @Override
    public MonitorConnectionContext startMonitoring(JdbcConnection connectionToAbort, Set<String> nodeKeys, HostInfo hostInfo, PropertySet propertySet, int failureDetectionTimeMillis, int failureDetectionIntervalMillis, int failureDetectionCount) {
        if (nodeKeys.isEmpty()) {
            String warning = Messages.getString("DefaultMonitorService.EmptyNodeKeys");
            this.logger.logWarn(warning);
            throw new IllegalArgumentException(warning);
        }
        IMonitor monitor = this.getMonitor(nodeKeys, hostInfo, propertySet);
        MonitorConnectionContext context = new MonitorConnectionContext(connectionToAbort, nodeKeys, this.logger, failureDetectionTimeMillis, failureDetectionIntervalMillis, failureDetectionCount);
        monitor.startMonitoring(context);
        this.threadContainer.addTask(monitor);
        return context;
    }

    @Override
    public void stopMonitoring(MonitorConnectionContext context) {
        if (context == null) {
            this.logger.logWarn(NullArgumentMessage.getMessage("context"));
            return;
        }
        context.invalidate();
        String node = this.threadContainer.getNode(context.getNodeKeys());
        if (node == null) {
            this.logger.logWarn(Messages.getString("DefaultMonitorService.InvalidContext"));
            return;
        }
        IMonitor monitor = this.threadContainer.getMonitor(node);
        if (monitor != null) {
            monitor.stopMonitoring(context);
        }
    }

    @Override
    public void stopMonitoringForAllConnections(Set<String> nodeKeys) {
        String node = this.threadContainer.getNode(nodeKeys);
        if (node == null) {
            this.logger.logDebug(Messages.getString("DefaultMonitorService.InvalidNodeKey"));
            return;
        }
        IMonitor monitor = this.threadContainer.getMonitor(node);
        if (monitor != null) {
            monitor.clearContexts();
            this.threadContainer.resetResource(monitor);
        }
    }

    @Override
    public void releaseResources() {
        this.threadContainer = null;
        MonitorThreadContainer.releaseInstance();
    }

    @Override
    public synchronized void notifyUnused(IMonitor monitor) {
        if (monitor == null) {
            this.logger.logWarn(NullArgumentMessage.getMessage("monitor"));
            return;
        }
        this.threadContainer.releaseResource(monitor);
    }

    protected IMonitor getMonitor(Set<String> nodeKeys, HostInfo hostInfo, PropertySet propertySet) {
        return this.threadContainer.getOrCreateMonitor(nodeKeys, () -> this.monitorInitializer.createMonitor(hostInfo, propertySet, this));
    }
}

