/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins;

import java.sql.SQLException;
import java.util.concurrent.Callable;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.ConnectionUrl;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.PropertyKey;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.PropertySet;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.JdbcConnection;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.DefaultConnectionPluginFactory;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.IConnectionPlugin;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.IConnectionPluginFactory;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.ICurrentConnectionProvider;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.ITransactionContextHandler;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.NodeMonitoringConnectionPluginFactory;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.NullArgumentMessage;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.failover.FailoverConnectionPluginFactory;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.log.Log;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.util.StringUtils;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.util.Util;

public class ConnectionPluginManager
implements ITransactionContextHandler {
    protected static final String DEFAULT_PLUGIN_FACTORIES = String.format("%s,%s", FailoverConnectionPluginFactory.class.getName(), NodeMonitoringConnectionPluginFactory.class.getName());
    protected Log logger;
    protected PropertySet propertySet = null;
    protected IConnectionPlugin headPlugin = null;
    ICurrentConnectionProvider currentConnectionProvider;

    public ConnectionPluginManager(Log logger) {
        if (logger == null) {
            throw new IllegalArgumentException(NullArgumentMessage.getMessage("logger"));
        }
        this.logger = logger;
    }

    public void init(ICurrentConnectionProvider currentConnectionProvider, PropertySet propertySet) throws SQLException {
        this.currentConnectionProvider = currentConnectionProvider;
        this.propertySet = propertySet;
        String factoryClazzNames = propertySet.getStringProperty(PropertyKey.connectionPluginFactories).getValue();
        if (StringUtils.isNullOrEmpty(factoryClazzNames)) {
            factoryClazzNames = DEFAULT_PLUGIN_FACTORIES;
        }
        this.headPlugin = new DefaultConnectionPluginFactory().getInstance(this.currentConnectionProvider, this.propertySet, null, this.logger);
        if (!StringUtils.isNullOrEmpty(factoryClazzNames)) {
            IConnectionPluginFactory[] factories = Util.loadClasses(factoryClazzNames, "MysqlIo.BadConnectionPluginFactory", null).toArray(new IConnectionPluginFactory[0]);
            for (int i = factories.length - 1; i >= 0; --i) {
                this.headPlugin = factories[i].getInstance(this.currentConnectionProvider, this.propertySet, this.headPlugin, this.logger);
            }
        }
    }

    public Object execute(Class<?> methodInvokeOn, String methodName, Callable<?> executeSqlFunc, Object[] args) throws Exception {
        return this.headPlugin.execute(methodInvokeOn, methodName, executeSqlFunc, args);
    }

    public void releaseResources() {
        this.logger.logTrace("[ConnectionPluginManager.releaseResources]");
        this.headPlugin.releaseResources();
    }

    public void openInitialConnection(ConnectionUrl connectionUrl) throws SQLException {
        this.headPlugin.openInitialConnection(connectionUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transactionBegun() {
        JdbcConnection jdbcConnection = this.currentConnectionProvider.getCurrentConnection();
        synchronized (jdbcConnection) {
            this.headPlugin.transactionBegun();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transactionCompleted() {
        JdbcConnection jdbcConnection = this.currentConnectionProvider.getCurrentConnection();
        synchronized (jdbcConnection) {
            this.headPlugin.transactionCompleted();
        }
    }
}

