/*
 * Decompiled with CFR 0.152.
 */
package customplugins;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.ConnectionUrl;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.IConnectionPlugin;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.log.Log;

public class ExecutionTimeConnectionPlugin
implements IConnectionPlugin {
    final long initializeTime;
    final IConnectionPlugin nextPlugin;
    private final Log logger;
    private final Map<String, Long> methodExecutionTimes = new HashMap<String, Long>();

    public ExecutionTimeConnectionPlugin(IConnectionPlugin nextPlugin, Log logger) {
        this.nextPlugin = nextPlugin;
        this.logger = logger;
        this.initializeTime = System.currentTimeMillis();
    }

    @Override
    public Object execute(Class<?> methodInvokeOn, String methodName, Callable<?> executeJdbcMethod, Object[] args) throws Exception {
        long startTime = System.nanoTime();
        Object executeResult = this.nextPlugin.execute(methodInvokeOn, methodName, executeJdbcMethod, args);
        long elapsedTime = System.nanoTime() - startTime;
        this.methodExecutionTimes.merge(methodName, elapsedTime / 1000000L, Long::sum);
        return executeResult;
    }

    @Override
    public void transactionBegun() {
        this.nextPlugin.transactionBegun();
    }

    @Override
    public void transactionCompleted() {
        this.nextPlugin.transactionCompleted();
    }

    @Override
    public void openInitialConnection(ConnectionUrl connectionUrl) throws SQLException {
        this.nextPlugin.openInitialConnection(connectionUrl);
    }

    @Override
    public void releaseResources() {
        long connectionUptime = System.nanoTime() - this.initializeTime;
        String leftAlignFormat = "| %-19s | %-10s |\n";
        StringBuilder logMessage = new StringBuilder();
        logMessage.append("** ExecutionTimeConnectionPlugin Summary **\n");
        logMessage.append(String.format("Connection Uptime: %ds\n", connectionUptime / 1000000L));
        logMessage.append("** Method Execution Time **\n").append("+---------------------+------------+\n").append("| Method Executed     | Total Time |\n").append("+---------------------+------------+\n");
        this.methodExecutionTimes.forEach((key, val) -> logMessage.append(String.format("| %-19s | %-10s |\n", key, val + "ms")));
        logMessage.append("+---------------------+------------+\n");
        this.logger.logInfo(logMessage);
        this.methodExecutionTimes.clear();
        this.nextPlugin.releaseResources();
    }
}

