/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.mysql.shading.com.mysql.cj.protocol;

import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.CharsetMapping;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.Messages;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.ServerVersion;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.PropertySet;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.exceptions.ExceptionFactory;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.exceptions.ExceptionInterceptor;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.protocol.Message;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.protocol.Protocol;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.protocol.ServerSession;

public interface AuthenticationProvider<M extends Message> {
    public void init(Protocol<M> var1, PropertySet var2, ExceptionInterceptor var3);

    public void connect(ServerSession var1, String var2, String var3, String var4);

    public void changeUser(ServerSession var1, String var2, String var3, String var4);

    public String getEncodingForHandshake();

    public static byte getCharsetForHandshake(String enc, ServerVersion sv) {
        int charsetIndex = 0;
        if (enc != null) {
            charsetIndex = CharsetMapping.getCollationIndexForJavaEncoding(enc, sv);
        }
        if (charsetIndex == 0) {
            charsetIndex = 33;
        }
        if (charsetIndex > 255) {
            throw ExceptionFactory.createException(Messages.getString("MysqlIO.113", new Object[]{enc}));
        }
        return (byte)charsetIndex;
    }
}

