/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.ca;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.Messages;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.HostInfo;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.JdbcConnection;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.ca.ClusterAwareUtils;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.ca.ConnectionProvider;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.ca.ReaderFailoverHandler;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.ca.ReaderFailoverResult;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.ca.TopologyService;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.ca.WriterFailoverHandler;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.ca.WriterFailoverResult;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.log.Log;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.log.NullLogger;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.util.Util;

public class ClusterAwareWriterFailoverHandler
implements WriterFailoverHandler {
    static final int WRITER_CONNECTION_INDEX = 0;
    protected static final Log NULL_LOGGER = new NullLogger("MySQL");
    protected transient Log log = NULL_LOGGER;
    protected int maxFailoverTimeoutMs = 60000;
    protected int readTopologyIntervalMs = 5000;
    protected int reconnectWriterIntervalMs = 5000;
    protected Map<String, String> initialConnectionProps;
    protected TopologyService topologyService;
    protected ConnectionProvider connectionProvider;
    protected ReaderFailoverHandler readerFailoverHandler;

    public ClusterAwareWriterFailoverHandler(TopologyService topologyService, ConnectionProvider connectionProvider, ReaderFailoverHandler readerFailoverHandler, Map<String, String> initialConnectionProps, Log log) {
        this.topologyService = topologyService;
        this.connectionProvider = connectionProvider;
        this.readerFailoverHandler = readerFailoverHandler;
        this.initialConnectionProps = initialConnectionProps;
        if (log != null) {
            this.log = log;
        }
    }

    public ClusterAwareWriterFailoverHandler(TopologyService topologyService, ConnectionProvider connectionProvider, ReaderFailoverHandler readerFailoverHandler, Map<String, String> initialConnectionProps, int failoverTimeoutMs, int readTopologyIntervalMs, int reconnectWriterIntervalMs, Log log) {
        this(topologyService, connectionProvider, readerFailoverHandler, initialConnectionProps, log);
        this.maxFailoverTimeoutMs = failoverTimeoutMs;
        this.readTopologyIntervalMs = readTopologyIntervalMs;
        this.reconnectWriterIntervalMs = reconnectWriterIntervalMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WriterFailoverResult failover(List<HostInfo> currentTopology) throws SQLException {
        if (Util.isNullOrEmpty(currentTopology)) {
            this.log.logError(Messages.getString("ClusterAwareWriterFailoverHandler.7"));
            return new WriterFailoverResult(false, false, null, null, "None");
        }
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        ExecutorCompletionService<WriterFailoverResult> completionService = new ExecutorCompletionService<WriterFailoverResult>(executorService);
        this.submitTasks(currentTopology, executorService, completionService);
        try {
            WriterFailoverResult result = this.getNextResult(executorService, completionService);
            if (result.isConnected()) {
                WriterFailoverResult writerFailoverResult = result;
                return writerFailoverResult;
            }
            result = this.getNextResult(executorService, completionService);
            if (result.isConnected()) {
                WriterFailoverResult writerFailoverResult = result;
                return writerFailoverResult;
            }
            this.log.logDebug(Messages.getString("ClusterAwareWriterFailoverHandler.3"));
            WriterFailoverResult writerFailoverResult = new WriterFailoverResult(false, false, null, null, "None");
            return writerFailoverResult;
        }
        finally {
            if (!executorService.isTerminated()) {
                executorService.shutdownNow();
            }
        }
    }

    private void submitTasks(List<HostInfo> currentTopology, ExecutorService executorService, CompletionService<WriterFailoverResult> completionService) {
        HostInfo writerHost = currentTopology.get(0);
        HostInfo writerHostWithInitialProps = ClusterAwareUtils.copyWithAdditionalProps(writerHost, this.initialConnectionProps);
        this.topologyService.addToDownHostList(writerHost);
        completionService.submit(new ReconnectToWriterHandler(writerHostWithInitialProps));
        completionService.submit(new WaitForNewWriterHandler(currentTopology, writerHostWithInitialProps));
        executorService.shutdown();
    }

    private WriterFailoverResult getNextResult(ExecutorService executorService, CompletionService<WriterFailoverResult> completionService) throws SQLException {
        try {
            Future<WriterFailoverResult> firstCompleted = completionService.poll(this.maxFailoverTimeoutMs, TimeUnit.MILLISECONDS);
            if (firstCompleted == null) {
                return new WriterFailoverResult(false, false, new ArrayList<HostInfo>(), null, "None");
            }
            WriterFailoverResult result = firstCompleted.get();
            if (result.isConnected()) {
                executorService.shutdownNow();
                this.logTaskSuccess(result);
                return result;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw this.createInterruptedException(e);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return new WriterFailoverResult(false, false, new ArrayList<HostInfo>(), null, "None");
    }

    private void logTaskSuccess(WriterFailoverResult result) {
        List<HostInfo> topology = result.getTopology();
        if (Util.isNullOrEmpty(topology)) {
            String taskName = result.getTaskName() == null ? "None" : result.getTaskName();
            this.log.logError(Messages.getString("ClusterAwareWriterFailoverHandler.5", new Object[]{taskName}));
            return;
        }
        String newWriterHost = topology.get(0).getHostPortPair();
        if (result.isNewHost()) {
            this.log.logDebug(Messages.getString("ClusterAwareWriterFailoverHandler.4", new Object[]{newWriterHost}));
        } else {
            this.log.logDebug(Messages.getString("ClusterAwareWriterFailoverHandler.2", new Object[]{newWriterHost}));
        }
    }

    private SQLException createInterruptedException(InterruptedException e) {
        return new SQLException(Messages.getString("ClusterAwareWriterFailoverHandler.1"), "70100", e);
    }

    private class ReconnectToWriterHandler
    implements Callable<WriterFailoverResult> {
        private final HostInfo originalWriterHost;

        public ReconnectToWriterHandler(HostInfo originalWriterHost) {
            this.originalWriterHost = originalWriterHost;
        }

        /*
         * Exception decompiling
         */
        @Override
        public WriterFailoverResult call() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[UNCONDITIONALDOLOOP]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private boolean isCurrentHostWriter(List<HostInfo> latestTopology) {
            String currentInstanceName = this.originalWriterHost.getHostProperties().get("TOPOLOGY_SERVICE_SERVER_ID");
            HostInfo latestWriter = latestTopology.get(0);
            if (currentInstanceName == null) {
                return false;
            }
            String latestWriterInstanceName = latestWriter.getHostProperties().get("TOPOLOGY_SERVICE_SERVER_ID");
            return currentInstanceName.equals(latestWriterInstanceName);
        }
    }

    private class WaitForNewWriterHandler
    implements Callable<WriterFailoverResult> {
        private JdbcConnection currentConnection = null;
        private final HostInfo originalWriterHost;
        private List<HostInfo> currentTopology;
        private HostInfo currentReaderHost;
        private JdbcConnection currentReaderConnection;

        public WaitForNewWriterHandler(List<HostInfo> currentTopology, HostInfo currentHost) {
            this.currentTopology = currentTopology;
            this.originalWriterHost = currentHost;
        }

        @Override
        public WriterFailoverResult call() {
            ClusterAwareWriterFailoverHandler.this.log.logTrace(Messages.getString("ClusterAwareWriterFailoverHandler.9"));
            try {
                boolean success = false;
                while (!success) {
                    this.connectoToReader();
                    success = this.refreshTopologyAndConnectToNewWriter();
                    if (success) continue;
                    this.closeReaderConnection();
                }
                WriterFailoverResult writerFailoverResult = new WriterFailoverResult(true, true, this.currentTopology, this.currentConnection, "TaskB");
                return writerFailoverResult;
            }
            catch (InterruptedException exception) {
                Thread.currentThread().interrupt();
                WriterFailoverResult writerFailoverResult = new WriterFailoverResult(false, false, null, null, "TaskB");
                return writerFailoverResult;
            }
            catch (Exception ex) {
                ClusterAwareWriterFailoverHandler.this.log.logError(Messages.getString("ClusterAwareWriterFailoverHandler.15", new Object[]{ex.getMessage()}));
                throw ex;
            }
            finally {
                this.performFinalCleanup();
            }
        }

        private void connectoToReader() throws InterruptedException {
            while (true) {
                try {
                    ReaderFailoverResult connResult = ClusterAwareWriterFailoverHandler.this.readerFailoverHandler.getReaderConnection(this.currentTopology);
                    if (this.isValidReaderConnection(connResult)) {
                        this.currentReaderConnection = connResult.getConnection();
                        this.currentReaderHost = this.currentTopology.get(connResult.getConnectionIndex());
                        ClusterAwareWriterFailoverHandler.this.log.logDebug(Messages.getString("ClusterAwareWriterFailoverHandler.11", new Object[]{connResult.getConnectionIndex(), this.currentReaderHost.getHostPortPair()}));
                        break;
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ClusterAwareWriterFailoverHandler.this.log.logDebug(Messages.getString("ClusterAwareWriterFailoverHandler.12"));
                TimeUnit.MILLISECONDS.sleep(1L);
            }
        }

        private boolean isValidReaderConnection(ReaderFailoverResult result) {
            if (!result.isConnected() || result.getConnection() == null) {
                return false;
            }
            int connIndex = result.getConnectionIndex();
            return connIndex != -1 && connIndex < this.currentTopology.size() && this.currentTopology.get(connIndex) != null;
        }

        private boolean refreshTopologyAndConnectToNewWriter() throws InterruptedException {
            while (true) {
                List<HostInfo> topology;
                if (!(topology = ClusterAwareWriterFailoverHandler.this.topologyService.getTopology(this.currentReaderConnection, true)).isEmpty()) {
                    this.currentTopology = topology;
                    HostInfo writerCandidate = this.currentTopology.get(0);
                    this.logTopology();
                    if (!this.isSame(writerCandidate, this.originalWriterHost) && this.connectToWriter(writerCandidate)) {
                        return true;
                    }
                }
                TimeUnit.MILLISECONDS.sleep(ClusterAwareWriterFailoverHandler.this.readTopologyIntervalMs);
            }
        }

        private boolean isSame(HostInfo writerCandidate, HostInfo originalWriter) {
            if (writerCandidate == null) {
                return false;
            }
            return writerCandidate.getHostProperties().get("TOPOLOGY_SERVICE_SERVER_ID").equals(originalWriter.getHostProperties().get("TOPOLOGY_SERVICE_SERVER_ID"));
        }

        private boolean connectToWriter(HostInfo writerCandidate) {
            try {
                ClusterAwareWriterFailoverHandler.this.log.logDebug(Messages.getString("ClusterAwareWriterFailoverHandler.14", new Object[]{writerCandidate.getHostPortPair()}));
                if (this.isSame(writerCandidate, this.currentReaderHost)) {
                    this.currentConnection = this.currentReaderConnection;
                } else {
                    HostInfo writerCandidateWithProps = ClusterAwareUtils.copyWithAdditionalProps(writerCandidate, ClusterAwareWriterFailoverHandler.this.initialConnectionProps);
                    this.currentConnection = ClusterAwareWriterFailoverHandler.this.connectionProvider.connect(writerCandidateWithProps);
                }
                ClusterAwareWriterFailoverHandler.this.topologyService.removeFromDownHostList(writerCandidate);
                return true;
            }
            catch (SQLException exception) {
                ClusterAwareWriterFailoverHandler.this.topologyService.addToDownHostList(writerCandidate);
                return false;
            }
        }

        private void closeReaderConnection() {
            try {
                if (this.currentReaderConnection != null && !this.currentReaderConnection.isClosed()) {
                    this.currentReaderConnection.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.currentReaderConnection = null;
            this.currentReaderHost = null;
        }

        private void performFinalCleanup() {
            if (this.currentReaderConnection != null && this.currentConnection != this.currentReaderConnection) {
                try {
                    this.currentReaderConnection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            ClusterAwareWriterFailoverHandler.this.log.logTrace(Messages.getString("ClusterAwareWriterFailoverHandler.10"));
        }

        private void logTopology() {
            StringBuilder msg = new StringBuilder();
            for (int i = 0; i < this.currentTopology.size(); ++i) {
                HostInfo hostInfo = this.currentTopology.get(i);
                msg.append("\n   [").append(i).append("]: ").append(hostInfo == null ? "<null>" : hostInfo.getHost());
            }
            ClusterAwareWriterFailoverHandler.this.log.logTrace(Messages.getString("ClusterAwareWriterFailoverHandler.13", new Object[]{msg.toString()}));
        }
    }
}

