/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.ha.ca;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import software.aws.rds.jdbc.shading.com.mysql.cj.Messages;
import software.aws.rds.jdbc.shading.com.mysql.cj.conf.HostInfo;
import software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.ConnectionImpl;
import software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.ha.ca.ConnectionAttemptResult;
import software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.ha.ca.ConnectionProvider;
import software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.ha.ca.ReaderFailoverHandler;
import software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.ha.ca.TopologyService;
import software.aws.rds.jdbc.shading.com.mysql.cj.log.Log;
import software.aws.rds.jdbc.shading.com.mysql.cj.log.NullLogger;

public class ClusterAwareReaderFailoverHandler
implements ReaderFailoverHandler {
    protected static final int DEFAULT_FAILOVER_TIMEOUT = 30000;
    protected static final Log NULL_LOGGER = new NullLogger("MySQL");
    protected transient Log log = NULL_LOGGER;
    protected int timeoutMs;
    protected final ConnectionProvider connProvider;
    protected final TopologyService topologyService;

    public ClusterAwareReaderFailoverHandler(TopologyService topologyService, ConnectionProvider connProvider, Log log) {
        this(topologyService, connProvider, 30000, log);
    }

    public ClusterAwareReaderFailoverHandler(TopologyService topologyService, ConnectionProvider connProvider, int timeoutMs, Log log) {
        this.topologyService = topologyService;
        this.connProvider = connProvider;
        this.timeoutMs = timeoutMs;
        if (log != null) {
            this.log = log;
        }
    }

    protected void setTimeoutMs(int timeoutMs) {
        this.timeoutMs = timeoutMs;
    }

    @Override
    public ConnectionAttemptResult failover(List<HostInfo> hosts, HostInfo currentHost) throws SQLException {
        this.topologyService.addToDownHostList(currentHost);
        if (hosts == null || hosts.isEmpty()) {
            return new ConnectionAttemptResult(null, -1, false);
        }
        Set<String> downHosts = this.topologyService.getDownHosts();
        List<HostTuple> hostGroup = this.getHostTuplesByPriority(hosts, downHosts);
        return this.getConnectionFromHostGroup(hostGroup);
    }

    List<HostTuple> getHostTuplesByPriority(List<HostInfo> hosts, Set<String> downHosts) {
        ArrayList<HostTuple> hostGroup = new ArrayList<HostTuple>();
        this.addActiveReaders(hostGroup, hosts, downHosts);
        HostInfo writerHost = hosts.get(0);
        if (writerHost != null) {
            hostGroup.add(new HostTuple(writerHost, 0));
        }
        this.addDownHosts(hostGroup, hosts, downHosts);
        return hostGroup;
    }

    private void addActiveReaders(List<HostTuple> list, List<HostInfo> hosts, Set<String> downHosts) {
        ArrayList<HostTuple> activeReaders = new ArrayList<HostTuple>();
        for (int i = 1; i < hosts.size(); ++i) {
            HostInfo host = hosts.get(i);
            if (downHosts.contains(host.getHostPortPair())) continue;
            activeReaders.add(new HostTuple(host, i));
        }
        Collections.shuffle(activeReaders);
        list.addAll(activeReaders);
    }

    private void addDownHosts(List<HostTuple> list, List<HostInfo> hosts, Set<String> downHosts) {
        ArrayList<HostTuple> downHostList = new ArrayList<HostTuple>();
        for (int i = 0; i < hosts.size(); ++i) {
            HostInfo host = hosts.get(i);
            if (host == null || !downHosts.contains(host.getHostPortPair())) continue;
            downHostList.add(new HostTuple(host, i));
        }
        Collections.shuffle(downHostList);
        list.addAll(downHostList);
    }

    @Override
    public ConnectionAttemptResult getReaderConnection(List<HostInfo> hostList) throws SQLException {
        Set<String> downHosts = this.topologyService.getDownHosts();
        List<HostTuple> tuples = this.getReaderTuplesByPriority(hostList, downHosts);
        return this.getConnectionFromHostGroup(tuples);
    }

    List<HostTuple> getReaderTuplesByPriority(List<HostInfo> hostList, Set<String> downHosts) {
        ArrayList<HostTuple> tuples = new ArrayList<HostTuple>();
        this.addActiveReaders(tuples, hostList, downHosts);
        this.addDownReaders(tuples, hostList, downHosts);
        return tuples;
    }

    private void addDownReaders(List<HostTuple> list, List<HostInfo> hosts, Set<String> downHosts) {
        ArrayList<HostTuple> downReaders = new ArrayList<HostTuple>();
        for (int i = 1; i < hosts.size(); ++i) {
            HostInfo host = hosts.get(i);
            if (!downHosts.contains(host.getHostPortPair())) continue;
            downReaders.add(new HostTuple(host, i));
        }
        Collections.shuffle(downReaders);
        list.addAll(downReaders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionAttemptResult getConnectionFromHostGroup(List<HostTuple> hostGroup) throws SQLException {
        ExecutorService executor = Executors.newFixedThreadPool(2);
        ExecutorCompletionService<ConnectionAttemptResult> completionService = new ExecutorCompletionService<ConnectionAttemptResult>(executor);
        try {
            for (int i = 0; i < hostGroup.size(); i += 2) {
                ConnectionAttemptResult result;
                Object attempt2;
                boolean secondAttemptPresent = i + 1 < hostGroup.size();
                Future<ConnectionAttemptResult> attempt1 = completionService.submit(new ConnectionAttemptTask(this.connProvider, hostGroup.get(i), this.topologyService, this.log));
                if (secondAttemptPresent) {
                    attempt2 = completionService.submit(new ConnectionAttemptTask(this.connProvider, hostGroup.get(i + 1), this.topologyService, this.log));
                    result = this.getResultFromAttemptPair(attempt1, (Future<ConnectionAttemptResult>)attempt2, (CompletionService<ConnectionAttemptResult>)completionService);
                } else {
                    result = this.getNextResult(completionService);
                }
                if (result.isSuccess()) {
                    this.log.logDebug(Messages.getString("ClusterAwareReaderFailoverHandler.2", new Object[]{result.getConnectionIndex()}));
                    attempt2 = result;
                    return attempt2;
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(1L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new SQLException(Messages.getString("ClusterAwareReaderFailoverHandler.1"), "70100", e);
                }
            }
            ConnectionAttemptResult connectionAttemptResult = new ConnectionAttemptResult(null, -1, false);
            return connectionAttemptResult;
        }
        finally {
            executor.shutdownNow();
        }
    }

    private ConnectionAttemptResult getResultFromAttemptPair(Future<ConnectionAttemptResult> attempt1, Future<ConnectionAttemptResult> attempt2, CompletionService<ConnectionAttemptResult> service) throws SQLException {
        try {
            ConnectionAttemptResult result;
            Future<ConnectionAttemptResult> firstCompleted = service.poll(this.timeoutMs, TimeUnit.MILLISECONDS);
            if (firstCompleted != null && (result = firstCompleted.get()).isSuccess()) {
                if (firstCompleted.equals(attempt1)) {
                    attempt2.cancel(true);
                } else {
                    attempt1.cancel(true);
                }
                return result;
            }
        }
        catch (ExecutionException e) {
            return this.getNextResult(service);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SQLException(Messages.getString("ClusterAwareReaderFailoverHandler.1"), "70100", e);
        }
        return this.getNextResult(service);
    }

    private ConnectionAttemptResult getNextResult(CompletionService<ConnectionAttemptResult> service) throws SQLException {
        try {
            Future<ConnectionAttemptResult> result = service.poll(this.timeoutMs, TimeUnit.MILLISECONDS);
            if (result == null) {
                return new ConnectionAttemptResult(null, -1, false);
            }
            return result.get();
        }
        catch (ExecutionException e) {
            return new ConnectionAttemptResult(null, -1, false);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SQLException(Messages.getString("ClusterAwareReaderFailoverHandler.1"), "70100", e);
        }
    }

    protected static class HostTuple {
        private final HostInfo host;
        private final int index;

        HostTuple(HostInfo host, int index) {
            this.host = host;
            this.index = index;
        }

        public HostInfo getHost() {
            return this.host;
        }

        public int getIndex() {
            return this.index;
        }
    }

    private static class ConnectionAttemptTask
    implements Callable<ConnectionAttemptResult> {
        private final ConnectionProvider connProvider;
        private final HostTuple newHostTuple;
        private final TopologyService topologyService;
        private final transient Log log;

        private ConnectionAttemptTask(ConnectionProvider connProvider, HostTuple newHostTuple, TopologyService topologyService, Log log) {
            this.connProvider = connProvider;
            this.newHostTuple = newHostTuple;
            this.topologyService = topologyService;
            this.log = log;
        }

        @Override
        public ConnectionAttemptResult call() {
            HostInfo newHost = this.newHostTuple.getHost();
            this.log.logDebug(Messages.getString("ClusterAwareReaderFailoverHandler.3", new Object[]{this.newHostTuple.getIndex(), newHost.getHostPortPair()}));
            try {
                ConnectionImpl conn = this.connProvider.connect(newHost);
                this.topologyService.removeFromDownHostList(newHost);
                this.log.logDebug(Messages.getString("ClusterAwareReaderFailoverHandler.4", new Object[]{this.newHostTuple.getIndex(), newHost.getHostPortPair()}));
                return new ConnectionAttemptResult(conn, this.newHostTuple.getIndex(), true);
            }
            catch (SQLException e) {
                this.topologyService.addToDownHostList(newHost);
                this.log.logDebug(Messages.getString("ClusterAwareReaderFailoverHandler.5", new Object[]{this.newHostTuple.getIndex(), newHost.getHostPortPair()}));
                return new ConnectionAttemptResult(null, -1, false);
            }
        }
    }
}

