/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.ha.ca;

import software.aws.rds.jdbc.shading.com.mysql.cj.log.Log;

public class ClusterAwareHitMissMetricsHolder {
    protected String metricName;
    protected int numberOfReports;
    protected int numberOfHits;
    private Object lockObject = new Object();

    public ClusterAwareHitMissMetricsHolder(String metricName) {
        this.metricName = metricName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(boolean isHit) {
        Object object = this.lockObject;
        synchronized (object) {
            ++this.numberOfReports;
            if (isHit) {
                ++this.numberOfHits;
            }
        }
    }

    public void reportMetrics(Log log) {
        StringBuilder logMessage = new StringBuilder(256);
        logMessage.append("** Performance Metrics Report for '");
        logMessage.append(this.metricName);
        logMessage.append("' **\n");
        logMessage.append("\nNumber of reports: " + this.numberOfReports);
        if (this.numberOfReports > 0) {
            logMessage.append("\nNumber of hits: " + this.numberOfHits);
            logMessage.append("\nRatio : " + (double)this.numberOfHits * 100.0 / (double)this.numberOfReports + " %");
        }
        log.logInfo(logMessage);
    }
}

