/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.shading.com.mysql.cj.jdbc;

import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import software.aws.rds.jdbc.shading.com.mysql.cj.conf.DefaultPropertySet;
import software.aws.rds.jdbc.shading.com.mysql.cj.conf.PropertyDefinition;
import software.aws.rds.jdbc.shading.com.mysql.cj.conf.PropertyDefinitions;
import software.aws.rds.jdbc.shading.com.mysql.cj.conf.PropertyKey;
import software.aws.rds.jdbc.shading.com.mysql.cj.conf.RuntimeProperty;
import software.aws.rds.jdbc.shading.com.mysql.cj.jdbc.JdbcPropertySet;
import software.aws.rds.jdbc.shading.com.mysql.cj.util.StringUtils;

public class JdbcPropertySetImpl
extends DefaultPropertySet
implements JdbcPropertySet {
    private static final long serialVersionUID = -8223499903182568260L;

    @Override
    public void postInitialization() {
        String testEncoding;
        if (this.getIntegerProperty(PropertyKey.maxRows).getValue() == 0) {
            super.getProperty(PropertyKey.maxRows).setValue(-1, null);
        }
        if ((testEncoding = this.getStringProperty(PropertyKey.characterEncoding).getValue()) != null) {
            String testString = "abc";
            StringUtils.getBytes(testString, testEncoding);
        }
        if (this.getBooleanProperty(PropertyKey.useCursorFetch).getValue().booleanValue()) {
            super.getProperty(PropertyKey.useServerPrepStmts).setValue(true);
        }
    }

    @Override
    public DriverPropertyInfo[] exposeAsDriverPropertyInfo(Properties info, int slotsToReserve) throws SQLException {
        this.initializeProperties(info);
        int numProperties = PropertyDefinitions.PROPERTY_KEY_TO_PROPERTY_DEFINITION.size();
        int listSize = numProperties + slotsToReserve;
        DriverPropertyInfo[] driverProperties = new DriverPropertyInfo[listSize];
        int i = slotsToReserve;
        for (PropertyKey propKey : PropertyDefinitions.PROPERTY_KEY_TO_PROPERTY_DEFINITION.keySet()) {
            driverProperties[i++] = this.getAsDriverPropertyInfo(this.getProperty(propKey));
        }
        return driverProperties;
    }

    private DriverPropertyInfo getAsDriverPropertyInfo(RuntimeProperty<?> pr) {
        PropertyDefinition<?> pdef = pr.getPropertyDefinition();
        DriverPropertyInfo dpi = new DriverPropertyInfo(pdef.getName(), null);
        dpi.choices = pdef.getAllowableValues();
        dpi.value = pr.getStringValue() != null ? pr.getStringValue() : null;
        dpi.required = false;
        dpi.description = pdef.getDescription();
        return dpi;
    }
}

