/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.session;

import android.app.Application;
import android.content.Context;
import com.amazonaws.services.chime.sdk.meetings.analytics.DefaultEventAnalyticsController;
import com.amazonaws.services.chime.sdk.meetings.analytics.DefaultMeetingStatsCollector;
import com.amazonaws.services.chime.sdk.meetings.analytics.EventAnalyticsController;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.AudioVideoFacade;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.DefaultAudioVideoController;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.DefaultAudioVideoFacade;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.audio.activespeakerdetector.DefaultActiveSpeakerDetector;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.contentshare.DefaultContentShareController;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.DefaultVideoTileController;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.DefaultVideoTileFactory;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.gl.DefaultEglCoreFactory;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.gl.EglCoreFactory;
import com.amazonaws.services.chime.sdk.meetings.device.DefaultDeviceController;
import com.amazonaws.services.chime.sdk.meetings.ingestion.AppStateHandler;
import com.amazonaws.services.chime.sdk.meetings.ingestion.DefaultAppStateMonitor;
import com.amazonaws.services.chime.sdk.meetings.ingestion.DefaultMeetingEventReporterFactory;
import com.amazonaws.services.chime.sdk.meetings.ingestion.EventClientConfiguration;
import com.amazonaws.services.chime.sdk.meetings.ingestion.EventReporter;
import com.amazonaws.services.chime.sdk.meetings.ingestion.EventReporterFactory;
import com.amazonaws.services.chime.sdk.meetings.ingestion.IngestionConfiguration;
import com.amazonaws.services.chime.sdk.meetings.ingestion.MeetingEventClientConfiguration;
import com.amazonaws.services.chime.sdk.meetings.internal.audio.AudioClientFactory;
import com.amazonaws.services.chime.sdk.meetings.internal.audio.DefaultAudioClientController;
import com.amazonaws.services.chime.sdk.meetings.internal.audio.DefaultAudioClientObserver;
import com.amazonaws.services.chime.sdk.meetings.internal.contentshare.DefaultContentShareVideoClientController;
import com.amazonaws.services.chime.sdk.meetings.internal.contentshare.DefaultContentShareVideoClientObserver;
import com.amazonaws.services.chime.sdk.meetings.internal.metric.DefaultClientMetricsCollector;
import com.amazonaws.services.chime.sdk.meetings.internal.video.DefaultVideoClientController;
import com.amazonaws.services.chime.sdk.meetings.internal.video.DefaultVideoClientFactory;
import com.amazonaws.services.chime.sdk.meetings.internal.video.DefaultVideoClientObserver;
import com.amazonaws.services.chime.sdk.meetings.internal.video.DefaultVideoClientStateController;
import com.amazonaws.services.chime.sdk.meetings.internal.video.TURNRequestParams;
import com.amazonaws.services.chime.sdk.meetings.realtime.DefaultRealtimeController;
import com.amazonaws.services.chime.sdk.meetings.session.MeetingSession;
import com.amazonaws.services.chime.sdk.meetings.session.MeetingSessionConfiguration;
import com.amazonaws.services.chime.sdk.meetings.utils.logger.Logger;
import com.xodee.client.audio.audioclient.AudioClient;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B3\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/session/DefaultMeetingSession;", "Lcom/amazonaws/services/chime/sdk/meetings/session/MeetingSession;", "configuration", "Lcom/amazonaws/services/chime/sdk/meetings/session/MeetingSessionConfiguration;", "logger", "Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;", "context", "Landroid/content/Context;", "eglCoreFactory", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/gl/EglCoreFactory;", "eventReporterFactory", "Lcom/amazonaws/services/chime/sdk/meetings/ingestion/EventReporterFactory;", "(Lcom/amazonaws/services/chime/sdk/meetings/session/MeetingSessionConfiguration;Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;Landroid/content/Context;Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/gl/EglCoreFactory;Lcom/amazonaws/services/chime/sdk/meetings/ingestion/EventReporterFactory;)V", "audioVideo", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/AudioVideoFacade;", "getAudioVideo", "()Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/AudioVideoFacade;", "getConfiguration", "()Lcom/amazonaws/services/chime/sdk/meetings/session/MeetingSessionConfiguration;", "eventAnalyticsController", "Lcom/amazonaws/services/chime/sdk/meetings/analytics/EventAnalyticsController;", "getEventAnalyticsController", "()Lcom/amazonaws/services/chime/sdk/meetings/analytics/EventAnalyticsController;", "getLogger", "()Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;", "amazon-chime-sdk_release"})
public final class DefaultMeetingSession
implements MeetingSession {
    @NotNull
    private final MeetingSessionConfiguration configuration;
    @NotNull
    private final Logger logger;
    @NotNull
    private final AudioVideoFacade audioVideo;
    @NotNull
    private final EventAnalyticsController eventAnalyticsController;

    @JvmOverloads
    public DefaultMeetingSession(@NotNull MeetingSessionConfiguration configuration, @NotNull Logger logger, @NotNull Context context, @NotNull EglCoreFactory eglCoreFactory, @NotNull EventReporterFactory eventReporterFactory) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)eglCoreFactory, (String)"eglCoreFactory");
        Intrinsics.checkNotNullParameter((Object)eventReporterFactory, (String)"eventReporterFactory");
        this.configuration = configuration;
        this.logger = logger;
        DefaultMeetingStatsCollector meetingStatsCollector = new DefaultMeetingStatsCollector(this.getLogger());
        EventReporter eventReporter = eventReporterFactory.createEventReporter();
        Context context2 = context.getApplicationContext();
        DefaultAppStateMonitor appStateMonitor = new DefaultAppStateMonitor(this.getLogger(), context2 instanceof Application ? (Application)context2 : null, 0L, 4, null);
        this.eventAnalyticsController = new DefaultEventAnalyticsController(this.getLogger(), this.getConfiguration(), meetingStatsCollector, appStateMonitor, eventReporter);
        appStateMonitor.bindHandler((AppStateHandler)((Object)this.getEventAnalyticsController()));
        DefaultClientMetricsCollector metricsCollector = new DefaultClientMetricsCollector();
        DefaultAudioClientObserver audioClientObserver = new DefaultAudioClientObserver(this.getLogger(), metricsCollector, this.getConfiguration(), meetingStatsCollector, this.getEventAnalyticsController(), appStateMonitor, null, 64, null);
        AudioClient audioClient = AudioClientFactory.Companion.getAudioClient(context, audioClientObserver);
        audioClientObserver.setAudioClient(audioClient);
        DefaultAudioClientController audioClientController = new DefaultAudioClientController(context, this.getLogger(), audioClientObserver, audioClient, meetingStatsCollector, this.getEventAnalyticsController());
        TURNRequestParams turnRequestParams = new TURNRequestParams(this.getConfiguration().getMeetingId(), this.getConfiguration().getUrls().getSignalingURL(), this.getConfiguration().getUrls().getTurnControlURL(), this.getConfiguration().getCredentials().getJoinToken());
        DefaultVideoClientStateController videoClientStateController = new DefaultVideoClientStateController(this.getLogger());
        DefaultVideoClientObserver videoClientObserver = new DefaultVideoClientObserver(context, this.getLogger(), turnRequestParams, metricsCollector, videoClientStateController, this.getConfiguration().getUrls().getUrlRewriter(), this.getEventAnalyticsController());
        DefaultVideoClientFactory videoClientFactory = new DefaultVideoClientFactory();
        DefaultVideoClientController videoClientController = new DefaultVideoClientController(context, this.getLogger(), videoClientStateController, videoClientObserver, this.getConfiguration(), videoClientFactory, eglCoreFactory, this.getEventAnalyticsController());
        DefaultVideoTileFactory videoTileFactory = new DefaultVideoTileFactory(this.getLogger());
        DefaultVideoTileController videoTileController = new DefaultVideoTileController(this.getLogger(), videoClientController, videoTileFactory, eglCoreFactory, meetingStatsCollector);
        videoClientObserver.subscribeToVideoTileChange(videoTileController);
        DefaultDeviceController deviceController = new DefaultDeviceController(context, audioClientController, videoClientController, this.getEventAnalyticsController(), this.getLogger(), null, 0, 96, null);
        DefaultRealtimeController realtimeController = new DefaultRealtimeController(audioClientController, audioClientObserver, videoClientController, videoClientObserver);
        DefaultActiveSpeakerDetector activeSpeakerDetector = new DefaultActiveSpeakerDetector(audioClientObserver);
        DefaultAudioVideoController audioVideoController = new DefaultAudioVideoController(audioClientController, audioClientObserver, metricsCollector, this.getConfiguration(), videoClientController, videoClientObserver, this.getLogger());
        MeetingSessionConfiguration contentShareConfiguration = this.getConfiguration().createContentShareMeetingSessionConfiguration();
        TURNRequestParams contentShareTurnRequestParams = new TURNRequestParams(contentShareConfiguration.getMeetingId(), contentShareConfiguration.getUrls().getSignalingURL(), contentShareConfiguration.getUrls().getTurnControlURL(), contentShareConfiguration.getCredentials().getJoinToken());
        DefaultContentShareVideoClientObserver contentShareObserver = new DefaultContentShareVideoClientObserver(context, this.getLogger(), contentShareTurnRequestParams, metricsCollector, contentShareConfiguration.getUrls().getUrlRewriter(), this.getEventAnalyticsController());
        DefaultContentShareVideoClientController contentShareVideoClientController = new DefaultContentShareVideoClientController(context, this.getLogger(), contentShareObserver, contentShareConfiguration, videoClientFactory, eglCoreFactory, this.getEventAnalyticsController());
        DefaultContentShareController contentShareController = new DefaultContentShareController(this.getLogger(), contentShareVideoClientController);
        this.audioVideo = new DefaultAudioVideoFacade(context, audioVideoController, realtimeController, deviceController, videoTileController, activeSpeakerDetector, contentShareController, this.getEventAnalyticsController(), appStateMonitor);
    }

    public /* synthetic */ DefaultMeetingSession(MeetingSessionConfiguration meetingSessionConfiguration, Logger logger, Context context, EglCoreFactory eglCoreFactory, EventReporterFactory eventReporterFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            eglCoreFactory = new DefaultEglCoreFactory(null, 1, null);
        }
        if ((n & 0x10) != 0) {
            CharSequence charSequence;
            EventClientConfiguration eventClientConfiguration = new MeetingEventClientConfiguration(meetingSessionConfiguration.getCredentials().getJoinToken(), meetingSessionConfiguration.getMeetingId(), meetingSessionConfiguration.getCredentials().getAttendeeId());
            String string = meetingSessionConfiguration.getUrls().getIngestionURL();
            if (string == null) {
                string = "";
            }
            eventReporterFactory = new DefaultMeetingEventReporterFactory(context, new IngestionConfiguration(eventClientConfiguration, string, (charSequence = (CharSequence)meetingSessionConfiguration.getUrls().getIngestionURL()) == null || charSequence.length() == 0, 0, 0L, 0, 56, null), logger);
        }
        this(meetingSessionConfiguration, logger, context, eglCoreFactory, eventReporterFactory);
    }

    @Override
    @NotNull
    public MeetingSessionConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    @NotNull
    public AudioVideoFacade getAudioVideo() {
        return this.audioVideo;
    }

    @Override
    @NotNull
    public EventAnalyticsController getEventAnalyticsController() {
        return this.eventAnalyticsController;
    }

    @JvmOverloads
    public DefaultMeetingSession(@NotNull MeetingSessionConfiguration configuration, @NotNull Logger logger, @NotNull Context context, @NotNull EglCoreFactory eglCoreFactory) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)eglCoreFactory, (String)"eglCoreFactory");
        this(configuration, logger, context, eglCoreFactory, null, 16, null);
    }

    @JvmOverloads
    public DefaultMeetingSession(@NotNull MeetingSessionConfiguration configuration, @NotNull Logger logger, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(configuration, logger, context, null, null, 24, null);
    }
}

