/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.internal.video;

import android.graphics.Matrix;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoContentHint;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoFrame;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoSink;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoSource;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.buffer.VideoFrameBuffer;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.buffer.VideoFrameI420Buffer;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.buffer.VideoFrameTextureBuffer;
import com.amazonaws.services.chime.sdk.meetings.internal.utils.ConcurrentSet;
import com.xodee.client.video.ContentHint;
import com.xodee.client.video.VideoFrameRGBABuffer;
import com.xodee.client.video.VideoFrameTextureBuffer;
import java.nio.ByteBuffer;
import java.security.InvalidParameterException;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002:\u0003\u0017\u0018\u0019B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoSourceAdapter;", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoSink;", "Lcom/xodee/client/video/VideoSource;", "()V", "sinks", "", "Lcom/xodee/client/video/VideoSink;", "value", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoSource;", "source", "getSource", "()Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoSource;", "setSource", "(Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoSource;)V", "addSink", "", "sink", "getContentHint", "Lcom/xodee/client/video/ContentHint;", "onVideoFrameReceived", "frame", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoFrame;", "removeSink", "VideoFrameI420BufferAdapter", "VideoFrameRGBABufferAdapter", "VideoFrameTextureBufferAdapter", "amazon-chime-sdk_release"})
@SourceDebugExtension(value={"SMAP\nVideoSourceAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VideoSourceAdapter.kt\ncom/amazonaws/services/chime/sdk/meetings/internal/video/VideoSourceAdapter\n+ 2 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,112:1\n32#2,2:113\n*S KotlinDebug\n*F\n+ 1 VideoSourceAdapter.kt\ncom/amazonaws/services/chime/sdk/meetings/internal/video/VideoSourceAdapter\n*L\n109#1:113,2\n*E\n"})
public final class VideoSourceAdapter
implements VideoSink,
com.xodee.client.video.VideoSource {
    @Nullable
    private VideoSource source;
    @NotNull
    private Set<com.xodee.client.video.VideoSink> sinks = ConcurrentSet.Companion.createConcurrentSet();

    @Nullable
    public final VideoSource getSource() {
        return this.source;
    }

    public final void setSource(@Nullable VideoSource value) {
        block1: {
            VideoSource videoSource = this.source;
            if (videoSource != null) {
                videoSource.removeVideoSink(this);
            }
            VideoSource videoSource2 = this.source = value;
            if (videoSource2 == null) break block1;
            videoSource2.addVideoSink(this);
        }
    }

    public void addSink(@NotNull com.xodee.client.video.VideoSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        this.sinks.add(sink);
    }

    public void removeSink(@NotNull com.xodee.client.video.VideoSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        this.sinks.remove(sink);
    }

    @NotNull
    public ContentHint getContentHint() {
        VideoSource videoSource = this.source;
        VideoContentHint videoContentHint = videoSource != null ? videoSource.getContentHint() : null;
        return switch (videoContentHint == null ? -1 : WhenMappings.$EnumSwitchMapping$0[videoContentHint.ordinal()]) {
            case 1 -> ContentHint.NONE;
            case 2 -> ContentHint.MOTION;
            case 3 -> ContentHint.DETAIL;
            case 4 -> ContentHint.TEXT;
            default -> ContentHint.NONE;
        };
    }

    @Override
    public void onVideoFrameReceived(@NotNull VideoFrame frame) {
        com.xodee.client.video.VideoFrameBuffer videoFrameBuffer;
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        VideoFrameBuffer videoFrameBuffer2 = frame.getBuffer();
        if (videoFrameBuffer2 instanceof VideoFrameTextureBuffer) {
            videoFrameBuffer = (com.xodee.client.video.VideoFrameBuffer)new VideoFrameTextureBufferAdapter((VideoFrameTextureBuffer)frame.getBuffer());
        } else if (videoFrameBuffer2 instanceof VideoFrameI420Buffer) {
            videoFrameBuffer = (com.xodee.client.video.VideoFrameBuffer)new VideoFrameI420BufferAdapter((VideoFrameI420Buffer)frame.getBuffer());
        } else if (videoFrameBuffer2 instanceof com.amazonaws.services.chime.sdk.meetings.audiovideo.video.buffer.VideoFrameRGBABuffer) {
            videoFrameBuffer = (com.xodee.client.video.VideoFrameBuffer)new VideoFrameRGBABufferAdapter((com.amazonaws.services.chime.sdk.meetings.audiovideo.video.buffer.VideoFrameRGBABuffer)frame.getBuffer());
        } else {
            throw new InvalidParameterException("Media SDK only supports texture, I420, and RGBA video frame buffers");
        }
        com.xodee.client.video.VideoFrameBuffer buffer = videoFrameBuffer;
        com.xodee.client.video.VideoFrame videoClientFrame = new com.xodee.client.video.VideoFrame(frame.getWidth(), frame.getHeight(), frame.getTimestampNs(), frame.getRotation().getDegrees(), buffer);
        Iterator<com.xodee.client.video.VideoSink> $this$forEach$iv = this.sinks.iterator();
        boolean $i$f$forEach = false;
        Iterator<com.xodee.client.video.VideoSink> iterator = $this$forEach$iv;
        while (iterator.hasNext()) {
            com.xodee.client.video.VideoSink element$iv;
            com.xodee.client.video.VideoSink it = element$iv = iterator.next();
            boolean bl = false;
            it.onFrameCaptured(videoClientFrame);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\n\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0016J\n\u0010\b\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\nH\u0016J\b\u0010\u000e\u001a\u00020\nH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoSourceAdapter$VideoFrameI420BufferAdapter;", "Lcom/xodee/client/video/VideoFrameI420Buffer;", "i420Buffer", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/buffer/VideoFrameI420Buffer;", "(Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/buffer/VideoFrameI420Buffer;)V", "getDataU", "Ljava/nio/ByteBuffer;", "getDataV", "getDataY", "getHeight", "", "getStrideU", "getStrideV", "getStrideY", "getWidth", "release", "", "retain", "amazon-chime-sdk_release"})
    public static final class VideoFrameI420BufferAdapter
    implements com.xodee.client.video.VideoFrameI420Buffer {
        @NotNull
        private final VideoFrameI420Buffer i420Buffer;

        public VideoFrameI420BufferAdapter(@NotNull VideoFrameI420Buffer i420Buffer) {
            Intrinsics.checkNotNullParameter((Object)i420Buffer, (String)"i420Buffer");
            this.i420Buffer = i420Buffer;
        }

        public int getWidth() {
            return this.i420Buffer.getWidth();
        }

        public int getHeight() {
            return this.i420Buffer.getHeight();
        }

        @Nullable
        public ByteBuffer getDataY() {
            return this.i420Buffer.getDataY();
        }

        @Nullable
        public ByteBuffer getDataU() {
            return this.i420Buffer.getDataU();
        }

        @Nullable
        public ByteBuffer getDataV() {
            return this.i420Buffer.getDataV();
        }

        public int getStrideY() {
            return this.i420Buffer.getStrideY();
        }

        public int getStrideU() {
            return this.i420Buffer.getStrideU();
        }

        public int getStrideV() {
            return this.i420Buffer.getStrideV();
        }

        public void retain() {
            this.i420Buffer.retain();
        }

        public void release() {
            this.i420Buffer.release();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\bH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoSourceAdapter$VideoFrameRGBABufferAdapter;", "Lcom/xodee/client/video/VideoFrameRGBABuffer;", "rgbaBuffer", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/buffer/VideoFrameRGBABuffer;", "(Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/buffer/VideoFrameRGBABuffer;)V", "getData", "Ljava/nio/ByteBuffer;", "getHeight", "", "getStride", "getWidth", "release", "", "retain", "amazon-chime-sdk_release"})
    public static final class VideoFrameRGBABufferAdapter
    implements VideoFrameRGBABuffer {
        @NotNull
        private final com.amazonaws.services.chime.sdk.meetings.audiovideo.video.buffer.VideoFrameRGBABuffer rgbaBuffer;

        public VideoFrameRGBABufferAdapter(@NotNull com.amazonaws.services.chime.sdk.meetings.audiovideo.video.buffer.VideoFrameRGBABuffer rgbaBuffer) {
            Intrinsics.checkNotNullParameter((Object)rgbaBuffer, (String)"rgbaBuffer");
            this.rgbaBuffer = rgbaBuffer;
        }

        public int getWidth() {
            return this.rgbaBuffer.getWidth();
        }

        public int getHeight() {
            return this.rgbaBuffer.getHeight();
        }

        @Nullable
        public ByteBuffer getData() {
            return this.rgbaBuffer.getData();
        }

        public int getStride() {
            return this.rgbaBuffer.getStride();
        }

        public void retain() {
            this.rgbaBuffer.retain();
        }

        public void release() {
            this.rgbaBuffer.release();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0006H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoSourceAdapter$VideoFrameTextureBufferAdapter;", "Lcom/xodee/client/video/VideoFrameTextureBuffer;", "textureBuffer", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/buffer/VideoFrameTextureBuffer;", "(Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/buffer/VideoFrameTextureBuffer;)V", "getHeight", "", "getTextureId", "getTransformMatrix", "Landroid/graphics/Matrix;", "getType", "Lcom/xodee/client/video/VideoFrameTextureBuffer$Type;", "getWidth", "release", "", "retain", "amazon-chime-sdk_release"})
    public static final class VideoFrameTextureBufferAdapter
    implements com.xodee.client.video.VideoFrameTextureBuffer {
        @NotNull
        private final VideoFrameTextureBuffer textureBuffer;

        public VideoFrameTextureBufferAdapter(@NotNull VideoFrameTextureBuffer textureBuffer) {
            Intrinsics.checkNotNullParameter((Object)textureBuffer, (String)"textureBuffer");
            this.textureBuffer = textureBuffer;
        }

        public int getWidth() {
            return this.textureBuffer.getWidth();
        }

        public int getHeight() {
            return this.textureBuffer.getHeight();
        }

        @NotNull
        public VideoFrameTextureBuffer.Type getType() {
            return switch (WhenMappings.$EnumSwitchMapping$0[this.textureBuffer.getType().ordinal()]) {
                case 1 -> VideoFrameTextureBuffer.Type.OES;
                case 2 -> VideoFrameTextureBuffer.Type.RGB;
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        @Nullable
        public Matrix getTransformMatrix() {
            return this.textureBuffer.getTransformMatrix();
        }

        public int getTextureId() {
            return this.textureBuffer.getTextureId();
        }

        public void release() {
            this.textureBuffer.release();
        }

        public void retain() {
            this.textureBuffer.retain();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[VideoFrameTextureBuffer.Type.values().length];
                try {
                    nArray[VideoFrameTextureBuffer.Type.TEXTURE_OES.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[VideoFrameTextureBuffer.Type.TEXTURE_2D.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VideoContentHint.values().length];
            try {
                nArray[VideoContentHint.None.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VideoContentHint.Motion.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VideoContentHint.Detail.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VideoContentHint.Text.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

