/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.internal.video;

import android.content.Context;
import com.amazonaws.services.chime.sdk.meetings.analytics.EventAnalyticsController;
import com.amazonaws.services.chime.sdk.meetings.analytics.EventAttributeName;
import com.amazonaws.services.chime.sdk.meetings.analytics.EventName;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.AudioVideoObserver;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.PrimaryMeetingPromotionObserver;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.RemoteVideoSource;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoPauseState;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoRotation;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoTileController;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.buffer.VideoFrameBuffer;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.buffer.VideoFrameI420Buffer;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.buffer.VideoFrameTextureBuffer;
import com.amazonaws.services.chime.sdk.meetings.internal.metric.ClientMetricsCollector;
import com.amazonaws.services.chime.sdk.meetings.internal.utils.ConcurrentSet;
import com.amazonaws.services.chime.sdk.meetings.internal.utils.DNSServerUtils;
import com.amazonaws.services.chime.sdk.meetings.internal.utils.ObserverUtils;
import com.amazonaws.services.chime.sdk.meetings.internal.utils.TURNRequestUtils;
import com.amazonaws.services.chime.sdk.meetings.internal.video.DefaultVideoClientObserver;
import com.amazonaws.services.chime.sdk.meetings.internal.video.TURNCredentials;
import com.amazonaws.services.chime.sdk.meetings.internal.video.TURNRequestParams;
import com.amazonaws.services.chime.sdk.meetings.internal.video.VideoClientObserver;
import com.amazonaws.services.chime.sdk.meetings.internal.video.VideoClientState;
import com.amazonaws.services.chime.sdk.meetings.internal.video.VideoClientStateController;
import com.amazonaws.services.chime.sdk.meetings.realtime.datamessage.DataMessage;
import com.amazonaws.services.chime.sdk.meetings.realtime.datamessage.DataMessageObserver;
import com.amazonaws.services.chime.sdk.meetings.session.MeetingSessionStatus;
import com.amazonaws.services.chime.sdk.meetings.session.MeetingSessionStatusCode;
import com.amazonaws.services.chime.sdk.meetings.utils.SignalingDroppedError;
import com.amazonaws.services.chime.sdk.meetings.utils.logger.Logger;
import com.xodee.client.video.RemoteVideoSourceInternal;
import com.xodee.client.video.VideoClient;
import com.xodee.client.video.VideoClientEvent;
import com.xodee.client.video.VideoClientEventType;
import com.xodee.client.video.VideoClientSignalingDroppedError;
import com.xodee.client.video.VideoFrame;
import com.xodee.client.video.VideoFrameTextureBuffer;
import java.nio.ByteBuffer;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ce\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\r\u0018\u00002\u00020\u0001B\\\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012%\u0010\f\u001a!\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u000e0\rj\u0002`\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\u001a\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020.H\u0016J\u001a\u0010/\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,2\u0006\u00100\u001a\u000201H\u0016J\"\u00102\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,2\u0006\u00103\u001a\u0002012\u0006\u00100\u001a\u000201H\u0016J\u001c\u00104\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,2\b\u00105\u001a\u0004\u0018\u000106H\u0016J>\u00107\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,2\b\u00108\u001a\u0004\u0018\u0001092\b\u0010:\u001a\u0004\u0018\u00010\u000e2\u0006\u0010;\u001a\u0002012\u0006\u0010<\u001a\u0002012\u0006\u0010=\u001a\u000201H\u0016J\u0012\u0010>\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,H\u0016J+\u0010?\u001a\u00020*2!\u0010@\u001a\u001d\u0012\u0013\u0012\u00110&\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(A\u0012\u0004\u0012\u00020*0\rH\u0002J\u0013\u0010B\u001a\b\u0012\u0004\u0012\u00020\u000e0CH\u0016\u00a2\u0006\u0002\u0010DJ\u0012\u0010E\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,H\u0016J+\u0010F\u001a\u00020*2!\u0010@\u001a\u001d\u0012\u0013\u0012\u00110(\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(A\u0012\u0004\u0012\u00020*0\rH\u0016J\b\u0010G\u001a\u00020*H\u0016J\u001d\u0010H\u001a\u00020*2\u000e\u0010I\u001a\n\u0012\u0004\u0012\u00020J\u0018\u00010CH\u0016\u00a2\u0006\u0002\u0010KJ\u001a\u0010L\u001a\u00020*2\u0006\u0010M\u001a\u0002012\b\u0010N\u001a\u0004\u0018\u00010\u000eH\u0016J\u001c\u0010O\u001a\u00020*2\b\u0010P\u001a\u0004\u0018\u00010Q2\b\u0010R\u001a\u0004\u0018\u00010SH\u0016J\u0010\u0010T\u001a\u00020*2\u0006\u00103\u001a\u000201H\u0016J\u0010\u0010U\u001a\u00020*2\u0006\u00103\u001a\u000201H\u0016J\u001d\u0010V\u001a\u00020*2\u000e\u0010W\u001a\n\u0012\u0004\u0012\u00020X\u0018\u00010CH\u0016\u00a2\u0006\u0002\u0010YJ\u001d\u0010Z\u001a\u00020*2\u000e\u0010W\u001a\n\u0012\u0004\u0012\u00020X\u0018\u00010CH\u0016\u00a2\u0006\u0002\u0010YJ\u001c\u0010[\u001a\b\u0012\u0004\u0012\u00020\u000e0\\2\f\u0010]\u001a\b\u0012\u0004\u0012\u00020\u000e0\\H\u0016J\"\u0010^\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010_\u001a\u0002012\u0006\u0010`\u001a\u00020.H\u0016J\u0012\u0010a\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,H\u0016J\u0018\u0010b\u001a\u00020*2\u0006\u0010c\u001a\u00020\u000e2\u0006\u0010A\u001a\u00020\u001cH\u0016J\u0010\u0010d\u001a\u00020*2\u0006\u0010A\u001a\u00020&H\u0016J\u0010\u0010e\u001a\u00020*2\u0006\u0010A\u001a\u00020(H\u0016J\u0010\u0010f\u001a\u00020*2\u0006\u0010c\u001a\u00020\u000eH\u0016J\u0010\u0010g\u001a\u00020*2\u0006\u0010A\u001a\u00020&H\u0016J\u0010\u0010h\u001a\u00020*2\u0006\u0010A\u001a\u00020(H\u0016R\u000e\u0010\u0016\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u00180\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\f\u001a!\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u000e0\rj\u0002`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006i"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/video/DefaultVideoClientObserver;", "Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoClientObserver;", "context", "Landroid/content/Context;", "logger", "Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;", "turnRequestParams", "Lcom/amazonaws/services/chime/sdk/meetings/internal/video/TURNRequestParams;", "clientMetricsCollector", "Lcom/amazonaws/services/chime/sdk/meetings/internal/metric/ClientMetricsCollector;", "videoClientStateController", "Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoClientStateController;", "urlRewriter", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "url", "Lcom/amazonaws/services/chime/sdk/meetings/session/URLRewriter;", "eventAnalyticsController", "Lcom/amazonaws/services/chime/sdk/meetings/analytics/EventAnalyticsController;", "(Landroid/content/Context;Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;Lcom/amazonaws/services/chime/sdk/meetings/internal/video/TURNRequestParams;Lcom/amazonaws/services/chime/sdk/meetings/internal/metric/ClientMetricsCollector;Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoClientStateController;Lkotlin/jvm/functions/Function1;Lcom/amazonaws/services/chime/sdk/meetings/analytics/EventAnalyticsController;)V", "TAG", "cachedRemoveVideoSources", "", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/RemoteVideoSource;", "dataMessageObserversByTopic", "", "Lcom/amazonaws/services/chime/sdk/meetings/realtime/datamessage/DataMessageObserver;", "primaryMeetingPromotionObserver", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/PrimaryMeetingPromotionObserver;", "getPrimaryMeetingPromotionObserver", "()Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/PrimaryMeetingPromotionObserver;", "setPrimaryMeetingPromotionObserver", "(Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/PrimaryMeetingPromotionObserver;)V", "uiScope", "Lkotlinx/coroutines/CoroutineScope;", "videoClientStateObservers", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/AudioVideoObserver;", "videoClientTileObservers", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoTileController;", "cameraSendIsAvailable", "", "client", "Lcom/xodee/client/video/VideoClient;", "available", "", "didConnect", "controlStatus", "", "didFail", "status", "didReceiveEvent", "event", "Lcom/xodee/client/video/VideoClientEvent;", "didReceiveFrame", "frame", "", "profileId", "displayId", "pauseType", "videoId", "didStop", "forEachVideoClientStateObserver", "observerFunction", "observer", "getAvailableDnsServers", "", "()[Ljava/lang/String;", "isConnecting", "notifyVideoTileObserver", "onCameraChanged", "onDataMessageReceived", "dataMessages", "Lcom/xodee/client/video/DataMessage;", "([Lcom/xodee/client/video/DataMessage;)V", "onLogMessage", "logLevel", "message", "onMetrics", "metrics", "", "values", "", "onPrimaryMeetingDemotion", "onPrimaryMeetingPromotion", "onRemoteVideoSourceAvailable", "sourcesInternal", "Lcom/xodee/client/video/RemoteVideoSourceInternal;", "([Lcom/xodee/client/video/RemoteVideoSourceInternal;)V", "onRemoteVideoSourceUnavailable", "onTurnURIsReceived", "", "uris", "pauseRemoteVideo", "display_id", "pause", "requestTurnCreds", "subscribeToReceiveDataMessage", "topic", "subscribeToVideoClientStateChange", "subscribeToVideoTileChange", "unsubscribeFromReceiveDataMessage", "unsubscribeFromVideoClientStateChange", "unsubscribeFromVideoTileChange", "amazon-chime-sdk_release"})
@SourceDebugExtension(value={"SMAP\nDefaultVideoClientObserver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultVideoClientObserver.kt\ncom/amazonaws/services/chime/sdk/meetings/internal/video/DefaultVideoClientObserver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,403:1\n1557#2:404\n1628#2,3:405\n1557#2:408\n1628#2,3:409\n11165#3:412\n11500#3,3:413\n11165#3:416\n11500#3,3:417\n381#4,7:420\n*S KotlinDebug\n*F\n+ 1 DefaultVideoClientObserver.kt\ncom/amazonaws/services/chime/sdk/meetings/internal/video/DefaultVideoClientObserver\n*L\n229#1:404\n229#1:405,3\n303#1:408\n303#1:409,3\n308#1:412\n308#1:413,3\n325#1:416\n325#1:417,3\n386#1:420,7\n*E\n"})
public final class DefaultVideoClientObserver
implements VideoClientObserver {
    @NotNull
    private final Context context;
    @NotNull
    private final Logger logger;
    @NotNull
    private final TURNRequestParams turnRequestParams;
    @NotNull
    private final ClientMetricsCollector clientMetricsCollector;
    @NotNull
    private final VideoClientStateController videoClientStateController;
    @NotNull
    private final Function1<String, String> urlRewriter;
    @NotNull
    private final EventAnalyticsController eventAnalyticsController;
    @NotNull
    private final String TAG;
    @NotNull
    private Set<AudioVideoObserver> videoClientStateObservers;
    @NotNull
    private Set<VideoTileController> videoClientTileObservers;
    @NotNull
    private Map<String, Set<DataMessageObserver>> dataMessageObserversByTopic;
    @NotNull
    private Set<RemoteVideoSource> cachedRemoveVideoSources;
    @Nullable
    private PrimaryMeetingPromotionObserver primaryMeetingPromotionObserver;
    @NotNull
    private final CoroutineScope uiScope;

    public DefaultVideoClientObserver(@NotNull Context context, @NotNull Logger logger, @NotNull TURNRequestParams turnRequestParams, @NotNull ClientMetricsCollector clientMetricsCollector, @NotNull VideoClientStateController videoClientStateController, @NotNull Function1<? super String, String> urlRewriter, @NotNull EventAnalyticsController eventAnalyticsController) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)turnRequestParams, (String)"turnRequestParams");
        Intrinsics.checkNotNullParameter((Object)clientMetricsCollector, (String)"clientMetricsCollector");
        Intrinsics.checkNotNullParameter((Object)videoClientStateController, (String)"videoClientStateController");
        Intrinsics.checkNotNullParameter(urlRewriter, (String)"urlRewriter");
        Intrinsics.checkNotNullParameter((Object)eventAnalyticsController, (String)"eventAnalyticsController");
        this.context = context;
        this.logger = logger;
        this.turnRequestParams = turnRequestParams;
        this.clientMetricsCollector = clientMetricsCollector;
        this.videoClientStateController = videoClientStateController;
        this.urlRewriter = urlRewriter;
        this.eventAnalyticsController = eventAnalyticsController;
        this.TAG = "DefaultVideoClientObserver";
        this.videoClientStateObservers = ConcurrentSet.Companion.createConcurrentSet();
        this.videoClientTileObservers = ConcurrentSet.Companion.createConcurrentSet();
        this.dataMessageObserversByTopic = new LinkedHashMap();
        this.cachedRemoveVideoSources = ConcurrentSet.Companion.createConcurrentSet();
        this.uiScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getMain()));
    }

    @Override
    @Nullable
    public PrimaryMeetingPromotionObserver getPrimaryMeetingPromotionObserver() {
        return this.primaryMeetingPromotionObserver;
    }

    @Override
    public void setPrimaryMeetingPromotionObserver(@Nullable PrimaryMeetingPromotionObserver primaryMeetingPromotionObserver) {
        this.primaryMeetingPromotionObserver = primaryMeetingPromotionObserver;
    }

    public void isConnecting(@Nullable VideoClient client) {
        this.logger.info(this.TAG, "isConnecting");
        this.forEachVideoClientStateObserver((Function1<? super AudioVideoObserver, Unit>)((Function1)isConnecting.1.INSTANCE));
    }

    public void didConnect(@Nullable VideoClient client, int controlStatus) {
        this.logger.info(this.TAG, "didConnect with controlStatus: " + controlStatus);
        this.videoClientStateController.updateState(VideoClientState.STARTED);
        if (controlStatus == 206) {
            this.forEachVideoClientStateObserver((Function1<? super AudioVideoObserver, Unit>)((Function1)didConnect.1.INSTANCE));
        } else {
            this.forEachVideoClientStateObserver((Function1<? super AudioVideoObserver, Unit>)((Function1)didConnect.2.INSTANCE));
        }
    }

    public void didFail(@Nullable VideoClient client, int status, int controlStatus) {
        this.logger.error(this.TAG, "didFail with status: " + status + ", controlStatus: " + controlStatus);
        this.forEachVideoClientStateObserver((Function1<? super AudioVideoObserver, Unit>)((Function1)didFail.1.INSTANCE));
    }

    public void didStop(@Nullable VideoClient client) {
        block0: {
            this.logger.info(this.TAG, "didStop");
            this.videoClientStateController.updateState(VideoClientState.STOPPED);
            this.forEachVideoClientStateObserver((Function1<? super AudioVideoObserver, Unit>)((Function1)didStop.1.INSTANCE));
            PrimaryMeetingPromotionObserver primaryMeetingPromotionObserver = this.getPrimaryMeetingPromotionObserver();
            if (primaryMeetingPromotionObserver == null) break block0;
            PrimaryMeetingPromotionObserver it = primaryMeetingPromotionObserver;
            boolean bl = false;
            it.onPrimaryMeetingDemotion(new MeetingSessionStatus(MeetingSessionStatusCode.AudioInternalServerError));
            this.setPrimaryMeetingPromotionObserver(null);
        }
    }

    public void cameraSendIsAvailable(@Nullable VideoClient client, boolean available) {
        this.logger.debug(this.TAG, "cameraSendIsAvailable: " + available);
        this.forEachVideoClientStateObserver((Function1<? super AudioVideoObserver, Unit>)((Function1)new Function1<AudioVideoObserver, Unit>(available){
            final /* synthetic */ boolean $available;
            {
                this.$available = $available;
                super(1);
            }

            public final void invoke(@NotNull AudioVideoObserver it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.onCameraSendAvailabilityUpdated(this.$available);
            }
        }));
    }

    public void didReceiveEvent(@Nullable VideoClient client, @Nullable VideoClientEvent event) {
        block5: {
            VideoClientEvent videoClientEvent = event;
            if (videoClientEvent == null) break block5;
            VideoClientEvent it = videoClientEvent;
            boolean bl = false;
            this.logger.info(this.TAG, "didReceiveEvent: " + it.eventType);
            VideoClientEventType videoClientEventType = it.eventType;
            switch (videoClientEventType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[videoClientEventType.ordinal()]) {
                case 1: {
                    this.logger.error(this.TAG, "Signaling dropped with error: " + it.signalingDroppedError);
                    VideoClientSignalingDroppedError videoClientSignalingDroppedError = it.signalingDroppedError;
                    Intrinsics.checkNotNullExpressionValue((Object)videoClientSignalingDroppedError, (String)"signalingDroppedError");
                    SignalingDroppedError error = SignalingDroppedError.Companion.fromVideoClientSignalingDroppedError(videoClientSignalingDroppedError);
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)EventAttributeName.signalingDroppedErrorMessage), (Object)((Object)error))};
                    Map attributes = MapsKt.mutableMapOf((Pair[])pairArray);
                    EventAnalyticsController.publishEvent$default(this.eventAnalyticsController, EventName.videoClientSignalingDropped, attributes, false, 4, null);
                    break;
                }
                case 2: {
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)EventAttributeName.signalingOpenDurationMs), (Object)it.signalingOpenDurationMs)};
                    Map attributes = MapsKt.mutableMapOf((Pair[])pairArray);
                    EventAnalyticsController.publishEvent$default(this.eventAnalyticsController, EventName.videoClientSignalingOpened, attributes, false, 4, null);
                    break;
                }
                case 3: {
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)EventAttributeName.iceGatheringDurationMs), (Object)it.iceGatheringDurationMs)};
                    Map attributes = MapsKt.mutableMapOf((Pair[])pairArray);
                    EventAnalyticsController.publishEvent$default(this.eventAnalyticsController, EventName.videoClientIceGatheringCompleted, attributes, false, 4, null);
                }
            }
        }
    }

    public void pauseRemoteVideo(@Nullable VideoClient client, int display_id, boolean pause) {
        this.logger.info(this.TAG, "pauseRemoteVideo");
    }

    public void onCameraChanged() {
        this.logger.info(this.TAG, "onCameraChanged");
    }

    public void didReceiveFrame(@Nullable VideoClient client, @Nullable Object frame, @Nullable String profileId, int displayId, int pauseType, int videoId) {
        block16: {
            com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoFrame videoFrame;
            VideoPauseState pauseState = switch (pauseType) {
                case 0 -> VideoPauseState.Unpaused;
                case 2 -> VideoPauseState.PausedByUserRequest;
                case 4 -> VideoPauseState.PausedForPoorConnection;
                default -> VideoPauseState.Unpaused;
            };
            VideoFrame videoFrame2 = frame instanceof VideoFrame ? (VideoFrame)frame : null;
            if (videoFrame2 != null) {
                VideoFrameBuffer videoFrameBuffer;
                VideoFrame it = videoFrame2;
                boolean bl = false;
                com.xodee.client.video.VideoFrameBuffer videoFrameBuffer2 = ((VideoFrame)frame).getBuffer();
                if (videoFrameBuffer2 instanceof com.xodee.client.video.VideoFrameTextureBuffer) {
                    com.xodee.client.video.VideoFrameBuffer videoFrameBuffer3 = ((VideoFrame)frame).getBuffer();
                    Intrinsics.checkNotNull((Object)videoFrameBuffer3, (String)"null cannot be cast to non-null type com.xodee.client.video.VideoFrameTextureBuffer");
                    buffer = (com.xodee.client.video.VideoFrameTextureBuffer)videoFrameBuffer3;
                    VideoFrameTextureBuffer.Type type = buffer.getType();
                    VideoFrameTextureBuffer.Type type2 = switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
                        case 1 -> VideoFrameTextureBuffer.Type.TEXTURE_OES;
                        case 2 -> VideoFrameTextureBuffer.Type.TEXTURE_2D;
                        default -> throw new InvalidParameterException("Unsupported texture buffer type");
                    };
                    buffer.retain();
                    videoFrameBuffer = new VideoFrameTextureBuffer(buffer.getWidth(), buffer.getHeight(), buffer.getTextureId(), buffer.getTransformMatrix(), type2, () -> DefaultVideoClientObserver.didReceiveFrame$lambda$4$lambda$2(buffer));
                } else if (videoFrameBuffer2 instanceof com.xodee.client.video.VideoFrameI420Buffer) {
                    com.xodee.client.video.VideoFrameBuffer videoFrameBuffer4 = ((VideoFrame)frame).getBuffer();
                    Intrinsics.checkNotNull((Object)videoFrameBuffer4, (String)"null cannot be cast to non-null type com.xodee.client.video.VideoFrameI420Buffer");
                    buffer = (com.xodee.client.video.VideoFrameI420Buffer)videoFrameBuffer4;
                    buffer.retain();
                    int n = buffer.getWidth();
                    int n2 = buffer.getHeight();
                    ByteBuffer byteBuffer = buffer.getDataY();
                    Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"getDataY(...)");
                    ByteBuffer byteBuffer2 = buffer.getDataU();
                    Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"getDataU(...)");
                    ByteBuffer byteBuffer3 = buffer.getDataV();
                    Intrinsics.checkNotNullExpressionValue((Object)byteBuffer3, (String)"getDataV(...)");
                    videoFrameBuffer = new VideoFrameI420Buffer(n, n2, byteBuffer, byteBuffer2, byteBuffer3, buffer.getStrideY(), buffer.getStrideU(), buffer.getStrideV(), () -> DefaultVideoClientObserver.didReceiveFrame$lambda$4$lambda$3((com.xodee.client.video.VideoFrameI420Buffer)buffer));
                } else {
                    throw new InvalidParameterException("Video frame must have non null I420 or texture buffer");
                }
                VideoFrameBuffer bufferAdapter = videoFrameBuffer;
                long l = ((VideoFrame)frame).getTimestampNs();
                VideoRotation videoRotation = VideoRotation.Companion.from(((VideoFrame)frame).getRotation());
                if (videoRotation == null) {
                    videoRotation = VideoRotation.Rotation0;
                }
                videoFrame = new com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoFrame(l, bufferAdapter, videoRotation);
            } else {
                videoFrame = null;
            }
            com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoFrame sdkFrame = videoFrame;
            this.notifyVideoTileObserver((Function1<? super VideoTileController, Unit>)((Function1)new Function1<VideoTileController, Unit>(sdkFrame, videoId, profileId, pauseState){
                final /* synthetic */ com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoFrame $sdkFrame;
                final /* synthetic */ int $videoId;
                final /* synthetic */ String $profileId;
                final /* synthetic */ VideoPauseState $pauseState;
                {
                    this.$sdkFrame = $sdkFrame;
                    this.$videoId = $videoId;
                    this.$profileId = $profileId;
                    this.$pauseState = $pauseState;
                    super(1);
                }

                public final void invoke(@NotNull VideoTileController observer) {
                    Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
                    observer.onReceiveFrame(this.$sdkFrame, this.$videoId, this.$profileId, this.$pauseState);
                }
            }));
            com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoFrame videoFrame3 = sdkFrame;
            if (videoFrame3 == null) break block16;
            videoFrame3.release();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onMetrics(@Nullable int[] metrics, @Nullable double[] values) {
        void $this$mapTo$iv$iv;
        if (metrics == null || values == null) {
            return;
        }
        Map metricMap = new LinkedHashMap();
        Iterable $this$map$iv = (Iterable)ArraysKt.getIndices((int[])metrics);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void i;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            metricMap.put(metrics[i], values[i]);
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        this.clientMetricsCollector.processVideoClientMetrics(metricMap);
    }

    public void onLogMessage(int logLevel, @Nullable String message) {
        if (message == null) {
            return;
        }
        switch (logLevel) {
            case 5: 
            case 6: {
                this.logger.error(this.TAG, message);
                break;
            }
            default: {
                this.logger.verbose(this.TAG, message);
            }
        }
    }

    public void requestTurnCreds(@Nullable VideoClient client) {
        this.logger.info(this.TAG, "requestTurnCreds");
        BuildersKt.launch$default((CoroutineScope)this.uiScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, client, null){
            int label;
            final /* synthetic */ DefaultVideoClientObserver this$0;
            final /* synthetic */ VideoClient $client;
            {
                this.this$0 = $receiver;
                this.$client = $client;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var22_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = TURNRequestUtils.INSTANCE.doTurnRequest(DefaultVideoClientObserver.access$getTurnRequestParams$p(this.this$0), DefaultVideoClientObserver.access$getLogger$p(this.this$0), (Continuation<? super TURNCredentials>)((Continuation)this));
                        if (v0 == var22_2) {
                            return var22_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        turnResponse = (TURNCredentials)v0;
                        var3_4 = this.$client;
                        var4_5 = this.this$0;
                        $this$invokeSuspend_u24lambda_u242 = turnResponse;
                        $i$a$-with-DefaultVideoClientObserver$requestTurnCreds$1$1 = false;
                        v1 = var3_4;
                        v2 = isActive = v1 != null ? v1.isActive() : false;
                        if ($this$invokeSuspend_u24lambda_u242 != null && isActive) {
                            $this$map$iv = $this$invokeSuspend_u24lambda_u242.getUris();
                            $i$f$map = false;
                            var10_11 = $this$map$iv;
                            destination$iv$iv = new ArrayList<E>($this$map$iv.length);
                            $i$f$mapTo = false;
                            var14_15 = ((void)$this$mapTo$iv$iv).length;
                            for (var13_14 = 0; var13_14 < var14_15; ++var13_14) {
                                var16_17 = item$iv$iv = $this$mapTo$iv$iv[var13_14];
                                var17_18 = destination$iv$iv;
                                $i$a$-map-DefaultVideoClientObserver$requestTurnCreds$1$1$newUris$1 = false;
                                if (url != null) {
                                    $i$a$-let-DefaultVideoClientObserver$requestTurnCreds$1$1$newUris$1$1 = false;
                                    v3 = (String)DefaultVideoClientObserver.access$getUrlRewriter$p(var4_5).invoke((Object)it);
                                } else {
                                    v3 = null;
                                }
                                var17_18.add(v3);
                            }
                            $this$toTypedArray$iv = (List)destination$iv$iv;
                            $i$f$toTypedArray = false;
                            thisCollection$iv = $this$toTypedArray$iv;
                            newUris = thisCollection$iv.toArray(new String[0]);
                            v4 = var3_4;
                            if (v4 != null) {
                                v4.updateTurnCredentials($this$invokeSuspend_u24lambda_u242.getUsername(), $this$invokeSuspend_u24lambda_u242.getPassword(), $this$invokeSuspend_u24lambda_u242.getTtl(), newUris, DefaultVideoClientObserver.access$getTurnRequestParams$p(var4_5).getSignalingUrl(), VideoClient.VideoClientTurnStatus.VIDEO_CLIENT_TURN_FEATURE_ON);
                            }
                        } else {
                            v5 = var3_4;
                            if (v5 != null) {
                                v5.updateTurnCredentials(null, null, null, null, null, VideoClient.VideoClientTurnStatus.VIDEO_CLIENT_TURN_STATUS_CCP_FAILURE);
                            }
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public String[] getAvailableDnsServers() {
        return DNSServerUtils.INSTANCE.getAvailableDnsServers(this.context, this.logger);
    }

    public void onDataMessageReceived(@Nullable com.xodee.client.video.DataMessage[] dataMessages) {
        if (dataMessages == null) {
            return;
        }
        this.logger.debug(this.TAG, "onDataMessageReceived with size: " + dataMessages.length);
        Iterator iterator = ArrayIteratorKt.iterator((Object[])dataMessages);
        while (iterator.hasNext()) {
            Set<DataMessageObserver> observers;
            com.xodee.client.video.DataMessage dataMessage = (com.xodee.client.video.DataMessage)iterator.next();
            if (!this.dataMessageObserversByTopic.containsKey(dataMessage.getTopic())) continue;
            long l = dataMessage.getTimestampMs();
            String string = dataMessage.getTopic();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTopic(...)");
            byte[] byArray = dataMessage.getData();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getData(...)");
            String string2 = dataMessage.getSenderAttendeeId();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSenderAttendeeId(...)");
            String string3 = dataMessage.getSenderExternalUserId();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getSenderExternalUserId(...)");
            DataMessage sdkDataMessage = new DataMessage(l, string, byArray, string2, string3, dataMessage.getThrottled());
            if (this.dataMessageObserversByTopic.get(dataMessage.getTopic()) == null) continue;
            boolean bl = false;
            ObserverUtils.Companion.notifyObserverOnMainThread(observers, (Function1)new Function1<DataMessageObserver, Unit>(sdkDataMessage){
                final /* synthetic */ DataMessage $sdkDataMessage;
                {
                    this.$sdkDataMessage = $sdkDataMessage;
                    super(1);
                }

                public final void invoke(@NotNull DataMessageObserver it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    it.onDataMessageReceived(this.$sdkDataMessage);
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> onTurnURIsReceived(@NotNull List<String> uris) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(uris, (String)"uris");
        Iterable iterable = uris;
        Function1<String, String> transform$iv = this.urlRewriter;
        boolean $i$f$map = false;
        void var5_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            destination$iv$iv.add(transform$iv.invoke(item$iv$iv));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public void onRemoteVideoSourceAvailable(@Nullable RemoteVideoSourceInternal[] sourcesInternal) {
        void $this$mapTo$iv$iv;
        if (sourcesInternal == null) {
            return;
        }
        RemoteVideoSourceInternal[] $this$map$iv = sourcesInternal;
        boolean $i$f$map = false;
        RemoteVideoSourceInternal[] remoteVideoSourceInternalArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            RemoteVideoSource remoteVideoSource;
            Collection collection;
            block3: {
                void internalSource;
                void item$iv$iv;
                void var11_10 = item$iv$iv = $this$mapTo$iv$iv[i];
                collection = destination$iv$iv;
                boolean bl = false;
                for (RemoteVideoSource cachedSource : this.cachedRemoveVideoSources) {
                    if (!Intrinsics.areEqual((Object)cachedSource.getAttendeeId(), (Object)internalSource.getAttendeeId())) continue;
                    remoteVideoSource = cachedSource;
                    break block3;
                }
                String string = internalSource.getAttendeeId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttendeeId(...)");
                RemoteVideoSource newSource = new RemoteVideoSource(string);
                this.cachedRemoveVideoSources.add(newSource);
                remoteVideoSource = newSource;
            }
            collection.add(remoteVideoSource);
        }
        List sources = (List)destination$iv$iv;
        this.forEachVideoClientStateObserver((Function1<? super AudioVideoObserver, Unit>)((Function1)new Function1<AudioVideoObserver, Unit>((List<RemoteVideoSource>)sources){
            final /* synthetic */ List<RemoteVideoSource> $sources;
            {
                this.$sources = $sources;
                super(1);
            }

            public final void invoke(@NotNull AudioVideoObserver observer) {
                Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
                observer.onRemoteVideoSourceAvailable(this.$sources);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    public void onRemoteVideoSourceUnavailable(@Nullable RemoteVideoSourceInternal[] sourcesInternal) {
        void $this$mapTo$iv$iv;
        if (sourcesInternal == null) {
            return;
        }
        RemoteVideoSourceInternal[] $this$map$iv = sourcesInternal;
        boolean $i$f$map = false;
        RemoteVideoSourceInternal[] remoteVideoSourceInternalArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            RemoteVideoSource remoteVideoSource;
            Collection collection;
            block3: {
                void internalSource;
                void item$iv$iv;
                void var11_10 = item$iv$iv = $this$mapTo$iv$iv[i];
                collection = destination$iv$iv;
                boolean bl = false;
                for (RemoteVideoSource cachedSource : this.cachedRemoveVideoSources) {
                    if (!Intrinsics.areEqual((Object)cachedSource.getAttendeeId(), (Object)internalSource.getAttendeeId())) continue;
                    this.cachedRemoveVideoSources.remove(cachedSource);
                    remoteVideoSource = cachedSource;
                    break block3;
                }
                this.logger.error(this.TAG, "Could not find cached source to remove");
                String string = internalSource.getAttendeeId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttendeeId(...)");
                remoteVideoSource = new RemoteVideoSource(string);
            }
            collection.add(remoteVideoSource);
        }
        List sources = (List)destination$iv$iv;
        this.forEachVideoClientStateObserver((Function1<? super AudioVideoObserver, Unit>)((Function1)new Function1<AudioVideoObserver, Unit>((List<RemoteVideoSource>)sources){
            final /* synthetic */ List<RemoteVideoSource> $sources;
            {
                this.$sources = $sources;
                super(1);
            }

            public final void invoke(@NotNull AudioVideoObserver observer) {
                Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
                observer.onRemoteVideoSourceUnavailable(this.$sources);
            }
        }));
    }

    public void onPrimaryMeetingPromotion(int status) {
        block7: {
            Unit unit;
            this.logger.info(this.TAG, "Primary meeting promotion for video completed with status " + status);
            MeetingSessionStatusCode translatedStatus = switch (status) {
                case 0 -> MeetingSessionStatusCode.OK;
                case 66 -> MeetingSessionStatusCode.AudioCallAtCapacity;
                case 65 -> MeetingSessionStatusCode.AudioAuthenticationRejected;
                default -> MeetingSessionStatusCode.AudioInternalServerError;
            };
            PrimaryMeetingPromotionObserver primaryMeetingPromotionObserver = this.getPrimaryMeetingPromotionObserver();
            if (primaryMeetingPromotionObserver != null) {
                primaryMeetingPromotionObserver.onPrimaryMeetingPromotion(new MeetingSessionStatus(translatedStatus));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block7;
            DefaultVideoClientObserver $this$onPrimaryMeetingPromotion_u24lambda_u249 = this;
            boolean bl = false;
            $this$onPrimaryMeetingPromotion_u24lambda_u249.logger.info($this$onPrimaryMeetingPromotion_u24lambda_u249.TAG, "Primary meeting promotion completed from video but no primary meeting promotion callback is set");
        }
    }

    public void onPrimaryMeetingDemotion(int status) {
        block7: {
            Unit unit;
            this.logger.info(this.TAG, "Primary meeting demotion for video occurred with status " + status);
            MeetingSessionStatusCode translatedStatus = switch (status) {
                case 0 -> MeetingSessionStatusCode.OK;
                case 66 -> MeetingSessionStatusCode.AudioCallAtCapacity;
                case 65 -> MeetingSessionStatusCode.AudioAuthenticationRejected;
                default -> MeetingSessionStatusCode.AudioInternalServerError;
            };
            PrimaryMeetingPromotionObserver primaryMeetingPromotionObserver = this.getPrimaryMeetingPromotionObserver();
            if (primaryMeetingPromotionObserver != null) {
                PrimaryMeetingPromotionObserver it = primaryMeetingPromotionObserver;
                boolean bl = false;
                it.onPrimaryMeetingDemotion(new MeetingSessionStatus(translatedStatus));
                this.setPrimaryMeetingPromotionObserver(null);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block7;
            DefaultVideoClientObserver $this$onPrimaryMeetingDemotion_u24lambda_u2411 = this;
            boolean bl = false;
            $this$onPrimaryMeetingDemotion_u24lambda_u2411.logger.info($this$onPrimaryMeetingDemotion_u24lambda_u2411.TAG, "Primary meeting demotion occurred from video but no primary meeting demotion callback is set");
        }
    }

    @Override
    public void subscribeToVideoClientStateChange(@NotNull AudioVideoObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        this.videoClientStateObservers.add(observer);
    }

    @Override
    public void unsubscribeFromVideoClientStateChange(@NotNull AudioVideoObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        this.videoClientStateObservers.remove(observer);
    }

    @Override
    public void subscribeToVideoTileChange(@NotNull VideoTileController observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        this.videoClientTileObservers.add(observer);
    }

    @Override
    public void unsubscribeFromVideoTileChange(@NotNull VideoTileController observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        this.videoClientTileObservers.remove(observer);
    }

    @Override
    public void subscribeToReceiveDataMessage(@NotNull String topic, @NotNull DataMessageObserver observer) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        Map<String, Set<DataMessageObserver>> $this$getOrPut$iv = this.dataMessageObserversByTopic;
        boolean $i$f$getOrPut = false;
        Set value$iv = $this$getOrPut$iv.get(topic);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = new LinkedHashSet();
            $this$getOrPut$iv.put(topic, answer$iv);
            set = answer$iv;
        } else {
            set = value$iv;
        }
        set.add((DataMessageObserver)observer);
    }

    @Override
    public void unsubscribeFromReceiveDataMessage(@NotNull String topic) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        this.dataMessageObserversByTopic.remove(topic);
    }

    @Override
    public void notifyVideoTileObserver(@NotNull Function1<? super VideoTileController, Unit> observerFunction) {
        Intrinsics.checkNotNullParameter(observerFunction, (String)"observerFunction");
        for (VideoTileController observer : this.videoClientTileObservers) {
            observerFunction.invoke((Object)observer);
        }
    }

    private final void forEachVideoClientStateObserver(Function1<? super AudioVideoObserver, Unit> observerFunction) {
        ObserverUtils.Companion.notifyObserverOnMainThread(this.videoClientStateObservers, observerFunction);
    }

    private static final void didReceiveFrame$lambda$4$lambda$2(com.xodee.client.video.VideoFrameTextureBuffer $buffer) {
        Intrinsics.checkNotNullParameter((Object)$buffer, (String)"$buffer");
        $buffer.release();
    }

    private static final void didReceiveFrame$lambda$4$lambda$3(com.xodee.client.video.VideoFrameI420Buffer $buffer) {
        Intrinsics.checkNotNullParameter((Object)$buffer, (String)"$buffer");
        $buffer.release();
    }

    public static final /* synthetic */ TURNRequestParams access$getTurnRequestParams$p(DefaultVideoClientObserver $this) {
        return $this.turnRequestParams;
    }

    public static final /* synthetic */ Logger access$getLogger$p(DefaultVideoClientObserver $this) {
        return $this.logger;
    }

    public static final /* synthetic */ Function1 access$getUrlRewriter$p(DefaultVideoClientObserver $this) {
        return $this.urlRewriter;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[VideoClientEventType.values().length];
            try {
                nArray[VideoClientEventType.SIGNALING_DROPPED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VideoClientEventType.SIGNALING_OPENED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VideoClientEventType.ICE_GATHERING_COMPLETED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VideoClientEventType.OTHER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[VideoFrameTextureBuffer.Type.values().length];
            try {
                nArray[VideoFrameTextureBuffer.Type.OES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VideoFrameTextureBuffer.Type.RGB.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

