/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.internal.video;

import android.content.Context;
import android.opengl.EGLContext;
import com.amazonaws.services.chime.sdk.meetings.analytics.EventAnalyticsController;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.PrimaryMeetingPromotionObserver;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.LocalVideoConfiguration;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.RemoteVideoSource;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoSource;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoSubscriptionConfiguration;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.capture.DefaultCameraCaptureSource;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.capture.DefaultSurfaceTextureCaptureSourceFactory;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.gl.EglCore;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.gl.EglCoreFactory;
import com.amazonaws.services.chime.sdk.meetings.device.MediaDevice;
import com.amazonaws.services.chime.sdk.meetings.internal.utils.AppInfoUtil;
import com.amazonaws.services.chime.sdk.meetings.internal.video.VideoClientController;
import com.amazonaws.services.chime.sdk.meetings.internal.video.VideoClientFactory;
import com.amazonaws.services.chime.sdk.meetings.internal.video.VideoClientLifecycleHandler;
import com.amazonaws.services.chime.sdk.meetings.internal.video.VideoClientObserver;
import com.amazonaws.services.chime.sdk.meetings.internal.video.VideoClientState;
import com.amazonaws.services.chime.sdk.meetings.internal.video.VideoClientStateController;
import com.amazonaws.services.chime.sdk.meetings.internal.video.VideoSourceAdapter;
import com.amazonaws.services.chime.sdk.meetings.session.MeetingSessionConfiguration;
import com.amazonaws.services.chime.sdk.meetings.session.MeetingSessionCredentials;
import com.amazonaws.services.chime.sdk.meetings.session.MeetingSessionStatus;
import com.amazonaws.services.chime.sdk.meetings.session.MeetingSessionStatusCode;
import com.amazonaws.services.chime.sdk.meetings.utils.logger.Logger;
import com.google.gson.Gson;
import com.xodee.client.video.RemoteVideoSourceInternal;
import com.xodee.client.video.VideoClient;
import com.xodee.client.video.VideoClientConfig;
import com.xodee.client.video.VideoClientConfigBuilder;
import com.xodee.client.video.VideoPriorityInternal;
import com.xodee.client.video.VideoResolutionInternal;
import com.xodee.client.video.VideoSubscriptionConfigurationInternal;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002BE\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\b\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u000200H\u0016J\n\u00102\u001a\u0004\u0018\u000103H\u0016J\b\u00104\u001a\u00020\fH\u0016J\b\u00105\u001a\u000200H\u0016J\u0018\u00106\u001a\u0002002\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0016J \u0010;\u001a\u0002002\u0006\u0010<\u001a\u00020\u00172\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\u0015H\u0016J\u0010\u0010@\u001a\u0002002\u0006\u0010A\u001a\u00020\u0015H\u0016J\u0018\u0010B\u001a\u0002002\u0006\u0010C\u001a\u00020(2\u0006\u0010D\u001a\u00020\u0015H\u0016J\b\u0010E\u001a\u000200H\u0016J\b\u0010F\u001a\u000200H\u0016J\u0010\u0010F\u001a\u0002002\u0006\u0010G\u001a\u00020HH\u0016J\u0010\u0010F\u001a\u0002002\u0006\u0010I\u001a\u00020JH\u0016J\u0018\u0010F\u001a\u0002002\u0006\u0010I\u001a\u00020J2\u0006\u0010G\u001a\u00020HH\u0016J\b\u0010K\u001a\u000200H\u0016J\b\u0010L\u001a\u000200H\u0016J\b\u0010M\u001a\u000200H\u0016J\b\u0010N\u001a\u000200H\u0002J\b\u0010O\u001a\u000200H\u0016J\b\u0010P\u001a\u000200H\u0016J\b\u0010Q\u001a\u000200H\u0016J\b\u0010R\u001a\u000200H\u0016J/\u0010S\u001a\u0002002\u0012\u0010T\u001a\u000e\u0012\u0004\u0012\u00020V\u0012\u0004\u0012\u00020W0U2\f\u0010X\u001a\b\u0012\u0004\u0012\u00020V0YH\u0016\u00a2\u0006\u0002\u0010ZR\u000e\u0010\u0014\u001a\u00020\u0015X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0015X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0015X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0015X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0015X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0015X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0015X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0015X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006["}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/video/DefaultVideoClientController;", "Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoClientController;", "Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoClientLifecycleHandler;", "context", "Landroid/content/Context;", "logger", "Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;", "videoClientStateController", "Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoClientStateController;", "videoClientObserver", "Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoClientObserver;", "configuration", "Lcom/amazonaws/services/chime/sdk/meetings/session/MeetingSessionConfiguration;", "videoClientFactory", "Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoClientFactory;", "eglCoreFactory", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/gl/EglCoreFactory;", "eventAnalyticsController", "Lcom/amazonaws/services/chime/sdk/meetings/analytics/EventAnalyticsController;", "(Landroid/content/Context;Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoClientStateController;Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoClientObserver;Lcom/amazonaws/services/chime/sdk/meetings/session/MeetingSessionConfiguration;Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoClientFactory;Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/gl/EglCoreFactory;Lcom/amazonaws/services/chime/sdk/meetings/analytics/EventAnalyticsController;)V", "DATA_MAX_SIZE", "", "TAG", "", "TOPIC_REGEX", "Lkotlin/text/Regex;", "VIDEO_CLIENT_FLAG_DISABLE_CAPTURER", "VIDEO_CLIENT_FLAG_DISABLE_SIMULCAST_P2P", "VIDEO_CLIENT_FLAG_ENABLE_INBAND_TURN_CREDS", "VIDEO_CLIENT_FLAG_ENABLE_SEND_SIDE_BWE", "VIDEO_CLIENT_FLAG_ENABLE_TWO_SIMULCAST_STREAMS", "VIDEO_CLIENT_FLAG_ENABLE_USE_HW_DECODE_AND_RENDER", "VIDEO_CLIENT_FLAG_EXCLUDE_SELF_CONTENT_IN_INDEX", "cameraCaptureSource", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/DefaultCameraCaptureSource;", "eglCore", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/gl/EglCore;", "gson", "Lcom/google/gson/Gson;", "isUsingInternalCaptureSource", "", "videoClient", "Lcom/xodee/client/video/VideoClient;", "videoClientStopMutex", "Lkotlinx/coroutines/sync/Mutex;", "videoSourceAdapter", "Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoSourceAdapter;", "demoteFromPrimaryMeeting", "", "destroyVideoClient", "getActiveCamera", "Lcom/amazonaws/services/chime/sdk/meetings/device/MediaDevice;", "getConfiguration", "initializeVideoClient", "promoteToPrimaryMeeting", "credentials", "Lcom/amazonaws/services/chime/sdk/meetings/session/MeetingSessionCredentials;", "observer", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/PrimaryMeetingPromotionObserver;", "sendDataMessage", "topic", "data", "", "lifetimeMs", "setMaxBitRateKbps", "maxBitRate", "setRemotePaused", "isPaused", "videoId", "start", "startLocalVideo", "config", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/LocalVideoConfiguration;", "source", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoSource;", "startRemoteVideo", "startVideoClient", "stopAndDestroy", "stopInternalCaptureSourceIfRunning", "stopLocalVideo", "stopRemoteVideo", "stopVideoClient", "switchCamera", "updateVideoSourceSubscriptions", "addedOrUpdated", "", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/RemoteVideoSource;", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoSubscriptionConfiguration;", "removed", "", "(Ljava/util/Map;[Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/RemoteVideoSource;)V", "amazon-chime-sdk_release"})
@SourceDebugExtension(value={"SMAP\nDefaultVideoClientController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultVideoClientController.kt\ncom/amazonaws/services/chime/sdk/meetings/internal/video/DefaultVideoClientController\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,322:1\n11165#2:323\n11500#2,3:324\n1#3:327\n*S KotlinDebug\n*F\n+ 1 DefaultVideoClientController.kt\ncom/amazonaws/services/chime/sdk/meetings/internal/video/DefaultVideoClientController\n*L\n250#1:323\n250#1:324,3\n*E\n"})
public final class DefaultVideoClientController
implements VideoClientController,
VideoClientLifecycleHandler {
    @NotNull
    private final Context context;
    @NotNull
    private final Logger logger;
    @NotNull
    private final VideoClientStateController videoClientStateController;
    @NotNull
    private final VideoClientObserver videoClientObserver;
    @NotNull
    private final MeetingSessionConfiguration configuration;
    @NotNull
    private final VideoClientFactory videoClientFactory;
    @NotNull
    private final EglCoreFactory eglCoreFactory;
    @NotNull
    private final EventAnalyticsController eventAnalyticsController;
    private final int DATA_MAX_SIZE;
    @NotNull
    private final Regex TOPIC_REGEX;
    @NotNull
    private final String TAG;
    private final int VIDEO_CLIENT_FLAG_ENABLE_SEND_SIDE_BWE;
    private final int VIDEO_CLIENT_FLAG_ENABLE_USE_HW_DECODE_AND_RENDER;
    private final int VIDEO_CLIENT_FLAG_ENABLE_TWO_SIMULCAST_STREAMS;
    private final int VIDEO_CLIENT_FLAG_DISABLE_SIMULCAST_P2P;
    private final int VIDEO_CLIENT_FLAG_DISABLE_CAPTURER;
    private final int VIDEO_CLIENT_FLAG_EXCLUDE_SELF_CONTENT_IN_INDEX;
    private final int VIDEO_CLIENT_FLAG_ENABLE_INBAND_TURN_CREDS;
    @NotNull
    private final Gson gson;
    @NotNull
    private final DefaultCameraCaptureSource cameraCaptureSource;
    @NotNull
    private VideoSourceAdapter videoSourceAdapter;
    private boolean isUsingInternalCaptureSource;
    @NotNull
    private final Mutex videoClientStopMutex;
    @Nullable
    private VideoClient videoClient;
    @Nullable
    private EglCore eglCore;

    public DefaultVideoClientController(@NotNull Context context, @NotNull Logger logger, @NotNull VideoClientStateController videoClientStateController, @NotNull VideoClientObserver videoClientObserver, @NotNull MeetingSessionConfiguration configuration, @NotNull VideoClientFactory videoClientFactory, @NotNull EglCoreFactory eglCoreFactory, @NotNull EventAnalyticsController eventAnalyticsController) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)videoClientStateController, (String)"videoClientStateController");
        Intrinsics.checkNotNullParameter((Object)videoClientObserver, (String)"videoClientObserver");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)videoClientFactory, (String)"videoClientFactory");
        Intrinsics.checkNotNullParameter((Object)eglCoreFactory, (String)"eglCoreFactory");
        Intrinsics.checkNotNullParameter((Object)eventAnalyticsController, (String)"eventAnalyticsController");
        this.context = context;
        this.logger = logger;
        this.videoClientStateController = videoClientStateController;
        this.videoClientObserver = videoClientObserver;
        this.configuration = configuration;
        this.videoClientFactory = videoClientFactory;
        this.eglCoreFactory = eglCoreFactory;
        this.eventAnalyticsController = eventAnalyticsController;
        this.DATA_MAX_SIZE = 2048;
        this.TOPIC_REGEX = new Regex("^[a-zA-Z0-9_-]{1,36}$");
        this.TAG = "DefaultVideoClientController";
        this.VIDEO_CLIENT_FLAG_ENABLE_SEND_SIDE_BWE = 32;
        this.VIDEO_CLIENT_FLAG_ENABLE_USE_HW_DECODE_AND_RENDER = 64;
        this.VIDEO_CLIENT_FLAG_ENABLE_TWO_SIMULCAST_STREAMS = 4096;
        this.VIDEO_CLIENT_FLAG_DISABLE_SIMULCAST_P2P = 16384;
        this.VIDEO_CLIENT_FLAG_DISABLE_CAPTURER = 0x100000;
        this.VIDEO_CLIENT_FLAG_EXCLUDE_SELF_CONTENT_IN_INDEX = 0x1000000;
        this.VIDEO_CLIENT_FLAG_ENABLE_INBAND_TURN_CREDS = 0x4000000;
        this.gson = new Gson();
        this.videoSourceAdapter = new VideoSourceAdapter();
        this.videoClientStopMutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
        this.videoClientStateController.bindLifecycleHandler(this);
        DefaultSurfaceTextureCaptureSourceFactory surfaceTextureCaptureSourceFactory = new DefaultSurfaceTextureCaptureSourceFactory(this.logger, this.eglCoreFactory);
        this.cameraCaptureSource = new DefaultCameraCaptureSource(this.context, this.logger, surfaceTextureCaptureSourceFactory, this.eventAnalyticsController, null, 16, null);
    }

    @Override
    public void setMaxBitRateKbps(int maxBitRate) {
        block0: {
            VideoClient videoClient = this.videoClient;
            if (videoClient == null) break block0;
            videoClient.setMaxBitRateKbps(maxBitRate);
        }
    }

    @Override
    public void start() {
        if (this.eglCore == null) {
            this.eglCore = this.eglCoreFactory.createEglCore();
        }
        this.videoClientStateController.start();
    }

    @Override
    public void stopAndDestroy() {
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ DefaultVideoClientController this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        DefaultVideoClientController.access$getVideoClientObserver$p(this.this$0).setPrimaryMeetingPromotionObserver(null);
                        var2_3 = DefaultVideoClientController.access$getVideoClientStopMutex$p(this.this$0);
                        var4_4 = this.this$0;
                        owner$iv = null;
                        $i$f$withLock = false;
                        this.L$0 = $this$withLock_u24default$iv;
                        this.L$1 = var4_4;
                        this.label = 1;
                        v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)this);
                        if (v0 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl25
                    }
                    case 1: {
                        $i$f$withLock = false;
                        var4_4 = (DefaultVideoClientController)this.L$1;
                        owner$iv = null;
                        $this$withLock_u24default$iv = (Mutex)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl25:
                        // 2 sources

                        try {
                            $i$a$-withLock$default-DefaultVideoClientController$stopAndDestroy$1$1 = false;
                            DefaultVideoClientController.access$getVideoClientStateController$p(var4_4).stop();
                            v1 = DefaultVideoClientController.access$getEglCore$p(var4_4);
                            if (v1 != null) {
                                v1.release();
                            }
                            DefaultVideoClientController.access$setEglCore$p(var4_4, null);
                            var7_10 = Unit.INSTANCE;
                        }
                        finally {
                            $this$withLock_u24default$iv.unlock(owner$iv);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    public void startLocalVideo() {
        LocalVideoConfiguration config = new LocalVideoConfiguration(0, 1, null);
        this.startLocalVideo(config);
    }

    @Override
    public void startLocalVideo(@NotNull LocalVideoConfiguration config) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            if (!this.videoClientStateController.canAct(VideoClientState.INITIALIZED)) {
                return;
            }
            this.videoSourceAdapter.setSource(this.cameraCaptureSource);
            this.logger.info(this.TAG, "Setting external video source in media client to internal camera source");
            VideoClient videoClient = this.videoClient;
            if (videoClient != null) {
                EglCore eglCore = this.eglCore;
                videoClient.setExternalVideoSource((com.xodee.client.video.VideoSource)this.videoSourceAdapter, (EGLContext)(eglCore != null ? eglCore.getEglContext() : null));
            }
            VideoClient videoClient2 = this.videoClient;
            if (videoClient2 != null) {
                videoClient2.setSending(Boolean.valueOf(true));
            }
            this.cameraCaptureSource.start();
            this.isUsingInternalCaptureSource = true;
            int it = config.getSafeMaxBitRateKbps();
            boolean bl = false;
            if (it <= 0) break block4;
            VideoClient videoClient3 = this.videoClient;
            if (videoClient3 != null) {
                videoClient3.setMaxBitRateKbps(it);
            }
        }
    }

    @Override
    public void startLocalVideo(@NotNull VideoSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        LocalVideoConfiguration config = new LocalVideoConfiguration(0, 1, null);
        this.startLocalVideo(source, config);
    }

    @Override
    public void startLocalVideo(@NotNull VideoSource source, @NotNull LocalVideoConfiguration config) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            if (!this.videoClientStateController.canAct(VideoClientState.INITIALIZED)) {
                return;
            }
            this.stopInternalCaptureSourceIfRunning();
            this.videoSourceAdapter.setSource(source);
            this.logger.info(this.TAG, "Setting external video source in media client to custom source");
            VideoClient videoClient = this.videoClient;
            if (videoClient != null) {
                EglCore eglCore = this.eglCore;
                videoClient.setExternalVideoSource((com.xodee.client.video.VideoSource)this.videoSourceAdapter, (EGLContext)(eglCore != null ? eglCore.getEglContext() : null));
            }
            VideoClient videoClient2 = this.videoClient;
            if (videoClient2 != null) {
                videoClient2.setSending(Boolean.valueOf(true));
            }
            int it = config.getSafeMaxBitRateKbps();
            boolean bl = false;
            if (it <= 0) break block4;
            VideoClient videoClient3 = this.videoClient;
            if (videoClient3 != null) {
                videoClient3.setMaxBitRateKbps(it);
            }
        }
    }

    @Override
    public void stopLocalVideo() {
        if (!this.videoClientStateController.canAct(VideoClientState.INITIALIZED)) {
            return;
        }
        this.logger.info(this.TAG, "Stopping local video");
        VideoClient videoClient = this.videoClient;
        if (videoClient != null) {
            videoClient.setSending(Boolean.valueOf(false));
        }
        this.stopInternalCaptureSourceIfRunning();
    }

    @Override
    public void startRemoteVideo() {
        block1: {
            if (!this.videoClientStateController.canAct(VideoClientState.INITIALIZED)) {
                return;
            }
            this.logger.info(this.TAG, "Starting remote video");
            VideoClient videoClient = this.videoClient;
            if (videoClient == null) break block1;
            videoClient.setReceiving(Boolean.valueOf(true));
        }
    }

    @Override
    public void stopRemoteVideo() {
        block1: {
            if (!this.videoClientStateController.canAct(VideoClientState.INITIALIZED)) {
                return;
            }
            this.logger.info(this.TAG, "Stopping remote video");
            VideoClient videoClient = this.videoClient;
            if (videoClient == null) break block1;
            videoClient.setReceiving(Boolean.valueOf(false));
        }
    }

    @Override
    @Nullable
    public MediaDevice getActiveCamera() {
        if (this.isUsingInternalCaptureSource) {
            return this.cameraCaptureSource.getDevice();
        }
        return null;
    }

    @Override
    public void switchCamera() {
        this.cameraCaptureSource.switchCamera();
    }

    @Override
    public void setRemotePaused(boolean isPaused, int videoId) {
        block1: {
            if (!this.videoClientStateController.canAct(VideoClientState.STARTED)) {
                return;
            }
            this.logger.info(this.TAG, "Set pause for videoId: " + videoId + ", isPaused: " + isPaused);
            VideoClient videoClient = this.videoClient;
            if (videoClient == null) break block1;
            videoClient.setRemotePause(videoId, isPaused);
        }
    }

    @Override
    @NotNull
    public MeetingSessionConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void sendDataMessage(@NotNull String topic, @NotNull Object data, int lifetimeMs) {
        block7: {
            Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (!this.videoClientStateController.canAct(VideoClientState.STARTED)) {
                return;
            }
            byte[] byArray = data instanceof byte[] ? (byte[])data : null;
            if (byArray == null) {
                if (data instanceof String) {
                    var5_4 = (String)data;
                    byte[] byArray2 = var5_4.getBytes(Charsets.UTF_8);
                    byArray = byArray2;
                    Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
                } else {
                    String string = this.gson.toJson(data);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
                    var5_4 = string;
                    byte[] byArray3 = var5_4.getBytes(Charsets.UTF_8);
                    byArray = byArray3;
                    Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getBytes(...)");
                }
            }
            byte[] byteArray = byArray;
            if (!this.TOPIC_REGEX.matches((CharSequence)topic)) {
                throw new InvalidParameterException("Invalid topic");
            }
            if (byteArray.length > this.DATA_MAX_SIZE) {
                throw new InvalidParameterException("Data size has to be less than or equal to 2048 bytes");
            }
            if (lifetimeMs < 0) {
                throw new InvalidParameterException("The life time of the message has to be non negative");
            }
            VideoClient videoClient = this.videoClient;
            if (videoClient == null) break block7;
            videoClient.sendDataMessage(topic, byteArray, lifetimeMs);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void updateVideoSourceSubscriptions(@NotNull Map<RemoteVideoSource, VideoSubscriptionConfiguration> addedOrUpdated, @NotNull RemoteVideoSource[] removed) {
        block5: {
            void $this$mapTo$iv$iv;
            Object config;
            Intrinsics.checkNotNullParameter(addedOrUpdated, (String)"addedOrUpdated");
            Intrinsics.checkNotNullParameter((Object)removed, (String)"removed");
            if (!this.videoClientStateController.canAct(VideoClientState.INITIALIZED)) {
                return;
            }
            for (RemoteVideoSource key : addedOrUpdated.keySet()) {
                VideoSubscriptionConfiguration videoSubscriptionConfiguration = addedOrUpdated.get(key);
                VideoSubscriptionConfiguration videoSubscriptionConfiguration2 = addedOrUpdated.get(key);
                this.logger.info(this.TAG, "Adding/updating video sources subscription: " + key.getAttendeeId() + " with priority: " + (videoSubscriptionConfiguration != null ? videoSubscriptionConfiguration.getPriority() : null) + " targetResolution: " + (videoSubscriptionConfiguration2 != null ? videoSubscriptionConfiguration2.getTargetResolution() : null));
            }
            int key = removed.length;
            for (int i = 0; i < key; ++i) {
                RemoteVideoSource remoteVideoSource = removed[i];
                this.logger.info(this.TAG, "Removing video source subscription: " + remoteVideoSource.getAttendeeId());
            }
            Map addedOrUpdatedInternal = new LinkedHashMap();
            for (Map.Entry<RemoteVideoSource, VideoSubscriptionConfiguration> entry : addedOrUpdated.entrySet()) {
                RemoteVideoSource source = entry.getKey();
                config = entry.getValue();
                addedOrUpdatedInternal.put(new RemoteVideoSourceInternal(source.getAttendeeId()), new VideoSubscriptionConfigurationInternal(new VideoPriorityInternal(((VideoSubscriptionConfiguration)config).getPriority().getValue()), new VideoResolutionInternal(((VideoSubscriptionConfiguration)config).getTargetResolution().getWidth(), ((VideoSubscriptionConfiguration)config).getTargetResolution().getHeight())));
            }
            RemoteVideoSource[] remoteVideoSourceArray = removed;
            boolean $i$f$map = false;
            config = remoteVideoSourceArray;
            Collection destination$iv$iv = new ArrayList(remoteVideoSourceArray.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void source;
                void item$iv$iv;
                void var13_21 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new RemoteVideoSourceInternal(source.getAttendeeId()));
            }
            List removedInternal = (List)destination$iv$iv;
            VideoClient videoClient = this.videoClient;
            if (videoClient == null) break block5;
            videoClient.updateVideoSourceSubscriptions(addedOrUpdatedInternal, removedInternal);
        }
    }

    @Override
    public void promoteToPrimaryMeeting(@NotNull MeetingSessionCredentials credentials, @NotNull PrimaryMeetingPromotionObserver observer) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
            Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
            if (!this.videoClientStateController.canAct(VideoClientState.INITIALIZED)) {
                observer.onPrimaryMeetingPromotion(new MeetingSessionStatus(MeetingSessionStatusCode.AudioServiceUnavailable));
                return;
            }
            this.videoClientObserver.setPrimaryMeetingPromotionObserver(observer);
            VideoClient videoClient = this.videoClient;
            if (videoClient == null) break block1;
            videoClient.promoteToPrimaryMeeting(credentials.getAttendeeId(), credentials.getExternalUserId(), credentials.getJoinToken());
        }
    }

    @Override
    public void demoteFromPrimaryMeeting() {
        block1: {
            if (!this.videoClientStateController.canAct(VideoClientState.INITIALIZED)) break block1;
            VideoClient videoClient = this.videoClient;
            if (videoClient != null) {
                videoClient.demoteFromPrimaryMeeting();
            }
        }
    }

    @Override
    public void initializeVideoClient() {
        this.logger.info(this.TAG, "Initializing video client");
        AppInfoUtil.INSTANCE.initializeVideoClientAppDetailedInfo(this.context);
        VideoClient.javaInitializeGlobals((Context)this.context);
        this.videoClient = this.videoClientFactory.getVideoClient(this.videoClientObserver);
    }

    @Override
    public void startVideoClient() {
        block2: {
            this.logger.info(this.TAG, "Starting video client");
            VideoClient videoClient = this.videoClient;
            if (videoClient != null) {
                videoClient.setReceiving(Boolean.valueOf(false));
            }
            int flag = 0;
            flag |= this.VIDEO_CLIENT_FLAG_ENABLE_SEND_SIDE_BWE;
            flag |= this.VIDEO_CLIENT_FLAG_ENABLE_USE_HW_DECODE_AND_RENDER;
            flag |= this.VIDEO_CLIENT_FLAG_ENABLE_TWO_SIMULCAST_STREAMS;
            flag |= this.VIDEO_CLIENT_FLAG_DISABLE_SIMULCAST_P2P;
            flag |= this.VIDEO_CLIENT_FLAG_DISABLE_CAPTURER;
            flag |= this.VIDEO_CLIENT_FLAG_EXCLUDE_SELF_CONTENT_IN_INDEX;
            VideoClientConfigBuilder videoClientConfigBuilder = new VideoClientConfigBuilder().setMeetingId(this.configuration.getMeetingId()).setToken(this.configuration.getCredentials().getJoinToken()).setFlags(flag |= this.VIDEO_CLIENT_FLAG_ENABLE_INBAND_TURN_CREDS);
            EglCore eglCore = this.eglCore;
            VideoClientConfig videoClientConfig = videoClientConfigBuilder.setSharedEglContext((EGLContext)(eglCore != null ? eglCore.getEglContext() : null)).setSignalingUrl(this.configuration.getUrls().getSignalingURL()).createVideoClientConfig();
            Intrinsics.checkNotNullExpressionValue((Object)videoClientConfig, (String)"createVideoClientConfig(...)");
            VideoClientConfig videoClientConfig2 = videoClientConfig;
            VideoClient videoClient2 = this.videoClient;
            if (videoClient2 != null) {
                videoClient2.start(videoClientConfig2);
            }
            VideoSourceAdapter it = this.videoSourceAdapter;
            boolean bl = false;
            VideoClient videoClient3 = this.videoClient;
            if (videoClient3 == null) break block2;
            EglCore eglCore2 = this.eglCore;
            videoClient3.setExternalVideoSource((com.xodee.client.video.VideoSource)it, (EGLContext)(eglCore2 != null ? eglCore2.getEglContext() : null));
        }
    }

    @Override
    public void stopVideoClient() {
        this.logger.info(this.TAG, "Stopping video client");
        VideoClient videoClient = this.videoClient;
        if (videoClient != null) {
            videoClient.javaStopService();
        }
        this.stopInternalCaptureSourceIfRunning();
    }

    @Override
    public void destroyVideoClient() {
        this.logger.info(this.TAG, "Destroying video client");
        VideoClient videoClient = this.videoClient;
        if (videoClient != null) {
            videoClient.destroy();
        }
        this.videoClient = null;
        VideoClient.finalizeGlobals();
    }

    private final void stopInternalCaptureSourceIfRunning() {
        if (this.isUsingInternalCaptureSource) {
            this.cameraCaptureSource.stop();
            this.isUsingInternalCaptureSource = false;
        }
    }

    public static final /* synthetic */ VideoClientObserver access$getVideoClientObserver$p(DefaultVideoClientController $this) {
        return $this.videoClientObserver;
    }

    public static final /* synthetic */ Mutex access$getVideoClientStopMutex$p(DefaultVideoClientController $this) {
        return $this.videoClientStopMutex;
    }

    public static final /* synthetic */ VideoClientStateController access$getVideoClientStateController$p(DefaultVideoClientController $this) {
        return $this.videoClientStateController;
    }

    public static final /* synthetic */ EglCore access$getEglCore$p(DefaultVideoClientController $this) {
        return $this.eglCore;
    }

    public static final /* synthetic */ void access$setEglCore$p(DefaultVideoClientController $this, EglCore eglCore) {
        $this.eglCore = eglCore;
    }
}

