/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.internal.ingestion.database;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.amazonaws.services.chime.sdk.meetings.internal.ingestion.database.DatabaseManager;
import com.amazonaws.services.chime.sdk.meetings.internal.ingestion.database.DatabaseTable;
import com.amazonaws.services.chime.sdk.meetings.internal.ingestion.database.SQLiteDatabaseManager;
import com.amazonaws.services.chime.sdk.meetings.utils.logger.Logger;
import java.io.Closeable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0016J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J&\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u0016H\u0016J/\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\b2\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0019H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0016J\u001e\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0016H\u0016J\u0012\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\"\u0010#\u001a\u00020 2\b\u0010$\u001a\u0004\u0018\u00010\"2\u0006\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020\fH\u0016J3\u0010'\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010)0(0\u00162\u0006\u0010\u000f\u001a\u00020\b2\b\u0010*\u001a\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0002\u0010+J\u001e\u0010,\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010)0(2\u0006\u0010-\u001a\u00020.H\u0002J\u001a\u0010/\u001a\u0004\u0018\u00010)2\u0006\u0010-\u001a\u00020.2\u0006\u00100\u001a\u00020\fH\u0002R\u000e\u0010\n\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/ingestion/database/SQLiteDatabaseManager;", "Landroid/database/sqlite/SQLiteOpenHelper;", "Lcom/amazonaws/services/chime/sdk/meetings/internal/ingestion/database/DatabaseManager;", "context", "Landroid/content/Context;", "logger", "Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;", "databaseName", "", "(Landroid/content/Context;Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;Ljava/lang/String;)V", "TAG", "invalidDeleteCount", "", "clear", "", "tableName", "createTable", "table", "Lcom/amazonaws/services/chime/sdk/meetings/internal/ingestion/database/DatabaseTable;", "delete", "keyName", "ids", "", "whereClause", "whereArgs", "", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)I", "dropTable", "insert", "contentValues", "Landroid/content/ContentValues;", "onCreate", "", "database", "Landroid/database/sqlite/SQLiteDatabase;", "onUpgrade", "db", "oldVersion", "newVersion", "query", "", "", "size", "(Ljava/lang/String;Ljava/lang/Integer;)Ljava/util/List;", "retrieveColumn", "cursor", "Landroid/database/Cursor;", "retrieveValue", "columnIndex", "amazon-chime-sdk_release"})
@SourceDebugExtension(value={"SMAP\nSQLiteDatabaseManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SQLiteDatabaseManager.kt\ncom/amazonaws/services/chime/sdk/meetings/internal/ingestion/database/SQLiteDatabaseManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,176:1\n1557#2:177\n1628#2,3:178\n37#3,2:181\n*S KotlinDebug\n*F\n+ 1 SQLiteDatabaseManager.kt\ncom/amazonaws/services/chime/sdk/meetings/internal/ingestion/database/SQLiteDatabaseManager\n*L\n48#1:177\n48#1:178,3\n130#1:181,2\n*E\n"})
public final class SQLiteDatabaseManager
extends SQLiteOpenHelper
implements DatabaseManager {
    @NotNull
    private final Logger logger;
    @NotNull
    private final String TAG;
    private final int invalidDeleteCount;

    public SQLiteDatabaseManager(@NotNull Context context, @NotNull Logger logger, @NotNull String databaseName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        super(context, databaseName, null, 1);
        this.logger = logger;
        this.TAG = "SQLiteDatabaseManager";
        this.invalidDeleteCount = -1;
    }

    public /* synthetic */ SQLiteDatabaseManager(Context context, Logger logger, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = "AmazonChimeSDKEvent.db";
        }
        this(context, logger, string);
    }

    public void onCreate(@Nullable SQLiteDatabase database) {
    }

    public void onUpgrade(@Nullable SQLiteDatabase db, int oldVersion, int newVersion) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean createTable(@NotNull DatabaseTable table) {
        boolean bl;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE TABLE IF NOT EXISTS " + table.getTableName() + " ");
        List primaryKeyList = CollectionsKt.listOf((Object)(table.getPrimaryKey().getFirst() + " " + table.getPrimaryKey().getSecond() + " PRIMARY KEY"));
        Iterable $this$map$iv = table.getColumns().entrySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void entry;
            Map.Entry entry2 = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(entry.getKey() + " " + entry.getValue());
        }
        List columnList = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        List keyList = CollectionsKt.plus((Collection)primaryKeyList, (Iterable)columnList);
        builder.append("(" + CollectionsKt.joinToString$default((Iterable)keyList, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + ")");
        try {
            this.getWritableDatabase().execSQL(builder.toString());
            bl = true;
        }
        catch (Exception exception) {
            this.logger.error(this.TAG, "Unable to create table " + builder + ": " + exception.getLocalizedMessage());
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<Map<String, Object>> query(@NotNull String tableName, @Nullable Integer size) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        List retrievedData = new ArrayList();
        try {
            Integer n = size;
            Cursor cursor = this.getWritableDatabase().query(tableName, null, null, null, null, null, null, n != null ? n.toString() : null);
            Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"query(...)");
            Cursor cursor2 = cursor;
            Closeable closeable = (Closeable)cursor2;
            Throwable throwable = null;
            try {
                Cursor it = (Cursor)closeable;
                boolean bl = false;
                while (it.moveToNext()) {
                    try {
                        retrievedData.add(this.retrieveColumn(it));
                    }
                    catch (Exception exception) {
                        this.logger.error(this.TAG, "Unable to query an item from " + tableName + ": " + exception.getLocalizedMessage());
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception exception) {
            this.logger.error(this.TAG, "Unable to obtain data from " + tableName + ": " + exception.getMessage());
        }
        return retrievedData;
    }

    @Override
    public boolean dropTable(@NotNull String tableName) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        try {
            this.getWritableDatabase().execSQL("DROP TABLE IF EXISTS " + tableName + ";");
            bl = true;
        }
        catch (Exception exception) {
            this.logger.error(this.TAG, "Unable to drop table " + tableName + ": " + exception.getLocalizedMessage());
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean insert(@NotNull String tableName, @NotNull List<ContentValues> contentValues) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter(contentValues, (String)"contentValues");
        this.logger.debug(this.TAG, "Inserting table " + tableName + " with contentValues: " + CollectionsKt.joinToString$default((Iterable)contentValues, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        if (contentValues.isEmpty()) {
            return true;
        }
        this.getWritableDatabase().beginTransaction();
        try {
            for (ContentValues contentValue : contentValues) {
                this.getWritableDatabase().insertOrThrow(tableName, null, contentValue);
            }
            this.getWritableDatabase().setTransactionSuccessful();
        }
        catch (Exception exception) {
            this.logger.error(this.TAG, "Unable to insert items into " + tableName + ": " + exception.getLocalizedMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            this.getWritableDatabase().endTransaction();
        }
        return true;
    }

    @Override
    public int delete(@NotNull String tableName, @NotNull String keyName, @NotNull List<String> ids) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter((Object)keyName, (String)"keyName");
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        this.logger.debug(this.TAG, "Deleting items from table " + tableName + " with ids: " + CollectionsKt.joinToString$default((Iterable)ids, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        if (ids.isEmpty()) {
            return 0;
        }
        Collection $this$toTypedArray$iv = ids;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] idsString = thisCollection$iv.toArray(new String[0]);
        String whereClause2 = CollectionsKt.joinToString$default((Iterable)ids, (CharSequence)",", null, null, (int)0, null, (Function1)delete.whereClause.1.INSTANCE, (int)30, null);
        return this.delete(tableName, keyName + " in (" + whereClause2 + ")", idsString);
    }

    @Override
    public boolean clear(@NotNull String tableName) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        return this.delete(tableName, (String)null, (String[])null) != this.invalidDeleteCount;
    }

    private final Map<String, Object> retrieveColumn(Cursor cursor) {
        Map column = new LinkedHashMap();
        int columnCount = cursor.getColumnCount();
        for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
            String string;
            if (cursor.isNull(columnIndex)) continue;
            Map map = column;
            Intrinsics.checkNotNullExpressionValue((Object)cursor.getColumnName(columnIndex), (String)"getColumnName(...)");
            Object object = this.retrieveValue(cursor, columnIndex);
            map.put(string, object);
        }
        return column;
    }

    private final Object retrieveValue(Cursor cursor, int columnIndex) {
        return switch (cursor.getType(columnIndex)) {
            case 0 -> null;
            case 2 -> Double.valueOf(cursor.getDouble(columnIndex));
            case 3 -> (Serializable)((Object)cursor.getString(columnIndex));
            case 1 -> Long.valueOf(cursor.getLong(columnIndex));
            case 4 -> (Serializable)cursor.getBlob(columnIndex);
            default -> null;
        };
    }

    private final int delete(String tableName, String whereClause2, String[] whereArgs) {
        int n;
        try {
            n = this.getWritableDatabase().delete(tableName, whereClause2, whereArgs);
        }
        catch (Exception exception) {
            this.logger.error(this.TAG, "Unable to delete from " + tableName + ", whereClause: " + whereClause2 + ", whereArgs: " + (whereArgs != null ? ArraysKt.joinToString$default((Object[])whereArgs, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) : null) + ": " + exception.getLocalizedMessage());
            n = this.invalidDeleteCount;
        }
        return n;
    }
}

