/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.internal.audio;

import com.amazonaws.services.chime.sdk.meetings.analytics.EventAnalyticsController;
import com.amazonaws.services.chime.sdk.meetings.analytics.EventAttributeName;
import com.amazonaws.services.chime.sdk.meetings.analytics.EventName;
import com.amazonaws.services.chime.sdk.meetings.analytics.MeetingStatsCollector;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.AttendeeInfo;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.AudioVideoObserver;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.PrimaryMeetingPromotionObserver;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.SignalStrength;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.SignalUpdate;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.Transcript;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.TranscriptAlternative;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.TranscriptEvent;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.TranscriptItem;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.TranscriptItemType;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.TranscriptionStatus;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.TranscriptionStatusType;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.VolumeLevel;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.VolumeUpdate;
import com.amazonaws.services.chime.sdk.meetings.ingestion.AppStateMonitor;
import com.amazonaws.services.chime.sdk.meetings.internal.AttendeeStatus;
import com.amazonaws.services.chime.sdk.meetings.internal.SessionStateControllerAction;
import com.amazonaws.services.chime.sdk.meetings.internal.audio.AudioClientObserver;
import com.amazonaws.services.chime.sdk.meetings.internal.audio.AudioClientState;
import com.amazonaws.services.chime.sdk.meetings.internal.audio.DefaultAudioClientController;
import com.amazonaws.services.chime.sdk.meetings.internal.audio.DefaultAudioClientObserver;
import com.amazonaws.services.chime.sdk.meetings.internal.metric.ClientMetricsCollector;
import com.amazonaws.services.chime.sdk.meetings.internal.utils.ConcurrentSet;
import com.amazonaws.services.chime.sdk.meetings.internal.utils.ObserverUtils;
import com.amazonaws.services.chime.sdk.meetings.realtime.RealtimeObserver;
import com.amazonaws.services.chime.sdk.meetings.realtime.TranscriptEventObserver;
import com.amazonaws.services.chime.sdk.meetings.session.MeetingSessionConfiguration;
import com.amazonaws.services.chime.sdk.meetings.session.MeetingSessionStatus;
import com.amazonaws.services.chime.sdk.meetings.session.MeetingSessionStatusCode;
import com.amazonaws.services.chime.sdk.meetings.utils.logger.Logger;
import com.xodee.client.audio.audioclient.AttendeeUpdate;
import com.xodee.client.audio.audioclient.AudioClient;
import com.xodee.client.audio.audioclient.transcript.TranscriptEntity;
import com.xodee.client.audio.audioclient.transcript.TranscriptLanguageWithScore;
import com.xodee.client.audio.audioclient.transcript.TranscriptResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ca\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u00103\u001a\u00020 2\u0006\u00104\u001a\u000205H\u0002J\u0012\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u00010$H\u0002J\u0012\u00109\u001a\u0002072\b\u00108\u001a\u0004\u0018\u00010$H\u0002J\u0012\u0010:\u001a\u0002072\b\u00108\u001a\u0004\u0018\u00010$H\u0002J+\u0010;\u001a\u0002072!\u0010<\u001a\u001d\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b>\u0012\b\b?\u0012\u0004\b\b(@\u0012\u0004\u0012\u0002070=H\u0016J\u0012\u0010A\u001a\u0002072\b\u00108\u001a\u0004\u0018\u00010$H\u0002J\u0012\u0010B\u001a\u0002072\b\u00108\u001a\u0004\u0018\u00010$H\u0002J\u001b\u0010C\u001a\u0002072\f\u0010D\u001a\b\u0012\u0004\u0012\u00020 0EH\u0002\u00a2\u0006\u0002\u0010FJ\u001b\u0010G\u001a\u0002072\f\u0010D\u001a\b\u0012\u0004\u0012\u00020 0EH\u0002\u00a2\u0006\u0002\u0010FJ\u001b\u0010H\u001a\u0002072\f\u0010D\u001a\b\u0012\u0004\u0012\u00020 0EH\u0002\u00a2\u0006\u0002\u0010FJ\u001c\u0010I\u001a\u0002072\u0012\u0010J\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001e0\u001bH\u0002J\u001f\u0010K\u001a\u0002072\u0010\u0010L\u001a\f\u0012\u0006\b\u0001\u0012\u000205\u0018\u00010EH\u0016\u00a2\u0006\u0002\u0010MJ\u0018\u0010N\u001a\u0002072\u0006\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020PH\u0016J\u0018\u0010R\u001a\u0002072\u0006\u0010S\u001a\u00020P2\u0006\u0010T\u001a\u00020PH\u0016J\u001a\u0010U\u001a\u0002072\u0006\u0010V\u001a\u00020P2\b\u0010W\u001a\u0004\u0018\u00010\u0012H\u0016J\u001c\u0010X\u001a\u0002072\b\u0010Y\u001a\u0004\u0018\u00010Z2\b\u0010[\u001a\u0004\u0018\u00010\\H\u0016J\u001f\u0010]\u001a\u0002072\u0010\u0010L\u001a\f\u0012\u0006\b\u0001\u0012\u000205\u0018\u00010EH\u0016\u00a2\u0006\u0002\u0010MJ\u001f\u0010^\u001a\u0002072\u0010\u0010_\u001a\f\u0012\u0006\b\u0001\u0012\u00020`\u0018\u00010EH\u0016\u00a2\u0006\u0002\u0010aJ\u001f\u0010b\u001a\u0002072\u0010\u0010L\u001a\f\u0012\u0006\b\u0001\u0012\u000205\u0018\u00010EH\u0016\u00a2\u0006\u0002\u0010MJ\u0012\u0010c\u001a\u00020d2\b\u0010Q\u001a\u0004\u0018\u00010$H\u0002J\u0010\u0010e\u001a\u0002072\u0006\u0010@\u001a\u00020\u0019H\u0016J\u0010\u0010f\u001a\u0002072\u0006\u0010@\u001a\u000200H\u0016J\u0010\u0010g\u001a\u0002072\u0006\u0010@\u001a\u000202H\u0016J\u001a\u0010h\u001a\u00020\"2\u0006\u0010i\u001a\u00020P2\b\u00108\u001a\u0004\u0018\u00010$H\u0002J\u0012\u0010j\u001a\u0004\u0018\u00010$2\u0006\u0010k\u001a\u00020PH\u0002J\u0010\u0010l\u001a\u0002072\u0006\u0010@\u001a\u00020\u0019H\u0016J\u0010\u0010m\u001a\u0002072\u0006\u0010@\u001a\u000200H\u0016J\u0010\u0010n\u001a\u0002072\u0006\u0010@\u001a\u000202H\u0016R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001e0\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010#\u001a\u0004\u0018\u00010$X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010)\u001a\u0004\u0018\u00010*X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u0014\u0010/\u001a\b\u0012\u0004\u0012\u0002000\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00101\u001a\b\u0012\u0004\u0012\u0002020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006o"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/audio/DefaultAudioClientObserver;", "Lcom/amazonaws/services/chime/sdk/meetings/internal/audio/AudioClientObserver;", "logger", "Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;", "clientMetricsCollector", "Lcom/amazonaws/services/chime/sdk/meetings/internal/metric/ClientMetricsCollector;", "configuration", "Lcom/amazonaws/services/chime/sdk/meetings/session/MeetingSessionConfiguration;", "meetingStatsCollector", "Lcom/amazonaws/services/chime/sdk/meetings/analytics/MeetingStatsCollector;", "eventAnalyticsController", "Lcom/amazonaws/services/chime/sdk/meetings/analytics/EventAnalyticsController;", "appStateMonitor", "Lcom/amazonaws/services/chime/sdk/meetings/ingestion/AppStateMonitor;", "audioClient", "Lcom/xodee/client/audio/audioclient/AudioClient;", "(Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;Lcom/amazonaws/services/chime/sdk/meetings/internal/metric/ClientMetricsCollector;Lcom/amazonaws/services/chime/sdk/meetings/session/MeetingSessionConfiguration;Lcom/amazonaws/services/chime/sdk/meetings/analytics/MeetingStatsCollector;Lcom/amazonaws/services/chime/sdk/meetings/analytics/EventAnalyticsController;Lcom/amazonaws/services/chime/sdk/meetings/ingestion/AppStateMonitor;Lcom/xodee/client/audio/audioclient/AudioClient;)V", "TAG", "", "getAudioClient", "()Lcom/xodee/client/audio/audioclient/AudioClient;", "setAudioClient", "(Lcom/xodee/client/audio/audioclient/AudioClient;)V", "audioClientStateObservers", "", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/AudioVideoObserver;", "currentAttendeeSignalMap", "", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/SignalUpdate;", "currentAttendeeVolumeMap", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/VolumeUpdate;", "currentAttendees", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/AttendeeInfo;", "currentAudioState", "Lcom/amazonaws/services/chime/sdk/meetings/internal/SessionStateControllerAction;", "currentAudioStatus", "Lcom/amazonaws/services/chime/sdk/meetings/session/MeetingSessionStatusCode;", "getCurrentAudioStatus", "()Lcom/amazonaws/services/chime/sdk/meetings/session/MeetingSessionStatusCode;", "setCurrentAudioStatus", "(Lcom/amazonaws/services/chime/sdk/meetings/session/MeetingSessionStatusCode;)V", "primaryMeetingPromotionObserver", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/PrimaryMeetingPromotionObserver;", "getPrimaryMeetingPromotionObserver", "()Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/PrimaryMeetingPromotionObserver;", "setPrimaryMeetingPromotionObserver", "(Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/PrimaryMeetingPromotionObserver;)V", "realtimeEventObservers", "Lcom/amazonaws/services/chime/sdk/meetings/realtime/RealtimeObserver;", "transcriptEventObservers", "Lcom/amazonaws/services/chime/sdk/meetings/realtime/TranscriptEventObserver;", "createAttendeeInfo", "attendeeUpdate", "Lcom/xodee/client/audio/audioclient/AttendeeUpdate;", "handleAudioClientStop", "", "statusCode", "handleAudioSessionEndedByServer", "handleOnAudioSessionFailed", "notifyAudioClientObserver", "observerFunction", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "observer", "notifyFailed", "notifyMeetingEnded", "onAttendeesDropped", "attendeeInfo", "", "([Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/AttendeeInfo;)V", "onAttendeesJoin", "onAttendeesLeft", "onAttendeesMuteStateChange", "volumesDelta", "onAttendeesPresenceChange", "attendeeUpdates", "([Lcom/xodee/client/audio/audioclient/AttendeeUpdate;)V", "onAudioClientPrimaryMeetingEvent", "type", "", "status", "onAudioClientStateChange", "newInternalAudioState", "newInternalAudioStatus", "onLogMessage", "logLevel", "message", "onMetrics", "metrics", "", "values", "", "onSignalStrengthChange", "onTranscriptEventsReceived", "events", "Lcom/xodee/client/audio/audioclient/transcript/TranscriptEvent;", "([Lcom/xodee/client/audio/audioclient/transcript/TranscriptEvent;)V", "onVolumeStateChange", "shouldCloseAndNotifyEndMeeting", "", "subscribeToAudioClientStateChange", "subscribeToRealTimeEvents", "subscribeToTranscriptEvent", "toAudioClientState", "internalAudioClientState", "toAudioStatus", "internalAudioStatus", "unsubscribeFromAudioClientStateChange", "unsubscribeFromRealTimeEvents", "unsubscribeFromTranscriptEvent", "amazon-chime-sdk_release"})
@SourceDebugExtension(value={"SMAP\nDefaultAudioClientObserver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultAudioClientObserver.kt\ncom/amazonaws/services/chime/sdk/meetings/internal/audio/DefaultAudioClientObserver\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 7 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,619:1\n11483#2,9:620\n13409#2:629\n13410#2:631\n11492#2:632\n11483#2,9:642\n13409#2:651\n13410#2:653\n11492#2:654\n13409#2:664\n13409#2:665\n13409#2:666\n13409#2,2:667\n11165#2:669\n11500#2,3:670\n13410#2:678\n11165#2:679\n11500#2,3:680\n13410#2:687\n13410#2:690\n10722#2:721\n10992#2,3:722\n10995#2,3:732\n1#3:630\n1#3:652\n1#3:675\n535#4:633\n520#4,6:634\n535#4:655\n520#4,6:656\n535#4:691\n520#4,6:692\n535#4:704\n520#4,6:705\n381#4,7:725\n37#5,2:640\n37#5,2:662\n37#5,2:673\n37#5,2:676\n37#5,2:683\n37#5,2:685\n37#5,2:688\n37#5,2:702\n37#5,2:715\n37#5,2:735\n37#5,2:737\n37#5,2:739\n126#6:698\n153#6,3:699\n126#6:711\n153#6,3:712\n1557#7:717\n1628#7,3:718\n*S KotlinDebug\n*F\n+ 1 DefaultAudioClientObserver.kt\ncom/amazonaws/services/chime/sdk/meetings/internal/audio/DefaultAudioClientObserver\n*L\n191#1:620,9\n191#1:629\n191#1:631\n191#1:632\n225#1:642,9\n225#1:651\n225#1:653\n225#1:654\n255#1:664\n269#1:665\n271#1:666\n273#1:667,2\n290#1:669\n290#1:670,3\n271#1:678\n309#1:679\n309#1:680,3\n269#1:687\n255#1:690\n405#1:721\n405#1:722,3\n405#1:732,3\n191#1:630\n225#1:652\n202#1:633\n202#1:634,6\n236#1:655\n236#1:656,6\n344#1:691\n344#1:692,6\n359#1:704\n359#1:705,6\n405#1:725,7\n209#1:640,2\n241#1:662,2\n299#1:673,2\n302#1:676,2\n314#1:683,2\n322#1:685,2\n328#1:688,2\n350#1:702,2\n365#1:715,2\n410#1:735,2\n416#1:737,2\n421#1:739,2\n350#1:698\n350#1:699,3\n365#1:711\n365#1:712,3\n391#1:717\n391#1:718,3\n*E\n"})
public final class DefaultAudioClientObserver
implements AudioClientObserver {
    @NotNull
    private final Logger logger;
    @NotNull
    private final ClientMetricsCollector clientMetricsCollector;
    @NotNull
    private final MeetingSessionConfiguration configuration;
    @NotNull
    private final MeetingStatsCollector meetingStatsCollector;
    @NotNull
    private final EventAnalyticsController eventAnalyticsController;
    @NotNull
    private final AppStateMonitor appStateMonitor;
    @Nullable
    private AudioClient audioClient;
    @NotNull
    private final String TAG;
    @NotNull
    private SessionStateControllerAction currentAudioState;
    @Nullable
    private MeetingSessionStatusCode currentAudioStatus;
    @NotNull
    private Set<AudioVideoObserver> audioClientStateObservers;
    @NotNull
    private Set<RealtimeObserver> realtimeEventObservers;
    @NotNull
    private Set<TranscriptEventObserver> transcriptEventObservers;
    @NotNull
    private Set<AttendeeInfo> currentAttendees;
    @NotNull
    private Map<String, VolumeUpdate> currentAttendeeVolumeMap;
    @NotNull
    private Map<String, SignalUpdate> currentAttendeeSignalMap;
    @Nullable
    private PrimaryMeetingPromotionObserver primaryMeetingPromotionObserver;

    public DefaultAudioClientObserver(@NotNull Logger logger, @NotNull ClientMetricsCollector clientMetricsCollector, @NotNull MeetingSessionConfiguration configuration, @NotNull MeetingStatsCollector meetingStatsCollector, @NotNull EventAnalyticsController eventAnalyticsController, @NotNull AppStateMonitor appStateMonitor, @Nullable AudioClient audioClient) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)clientMetricsCollector, (String)"clientMetricsCollector");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)meetingStatsCollector, (String)"meetingStatsCollector");
        Intrinsics.checkNotNullParameter((Object)eventAnalyticsController, (String)"eventAnalyticsController");
        Intrinsics.checkNotNullParameter((Object)appStateMonitor, (String)"appStateMonitor");
        this.logger = logger;
        this.clientMetricsCollector = clientMetricsCollector;
        this.configuration = configuration;
        this.meetingStatsCollector = meetingStatsCollector;
        this.eventAnalyticsController = eventAnalyticsController;
        this.appStateMonitor = appStateMonitor;
        this.audioClient = audioClient;
        this.TAG = "DefaultAudioClientObserver";
        this.currentAudioState = SessionStateControllerAction.Init;
        this.currentAudioStatus = MeetingSessionStatusCode.OK;
        this.audioClientStateObservers = ConcurrentSet.Companion.createConcurrentSet();
        this.realtimeEventObservers = ConcurrentSet.Companion.createConcurrentSet();
        this.transcriptEventObservers = ConcurrentSet.Companion.createConcurrentSet();
        this.currentAttendees = new LinkedHashSet();
        this.currentAttendeeVolumeMap = MapsKt.emptyMap();
        this.currentAttendeeSignalMap = MapsKt.emptyMap();
    }

    public /* synthetic */ DefaultAudioClientObserver(Logger logger, ClientMetricsCollector clientMetricsCollector, MeetingSessionConfiguration meetingSessionConfiguration, MeetingStatsCollector meetingStatsCollector, EventAnalyticsController eventAnalyticsController, AppStateMonitor appStateMonitor, AudioClient audioClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            audioClient = null;
        }
        this(logger, clientMetricsCollector, meetingSessionConfiguration, meetingStatsCollector, eventAnalyticsController, appStateMonitor, audioClient);
    }

    @Nullable
    public final AudioClient getAudioClient() {
        return this.audioClient;
    }

    public final void setAudioClient(@Nullable AudioClient audioClient) {
        this.audioClient = audioClient;
    }

    @Override
    @Nullable
    public MeetingSessionStatusCode getCurrentAudioStatus() {
        return this.currentAudioStatus;
    }

    @Override
    public void setCurrentAudioStatus(@Nullable MeetingSessionStatusCode meetingSessionStatusCode) {
        this.currentAudioStatus = meetingSessionStatusCode;
    }

    @Override
    @Nullable
    public PrimaryMeetingPromotionObserver getPrimaryMeetingPromotionObserver() {
        return this.primaryMeetingPromotionObserver;
    }

    @Override
    public void setPrimaryMeetingPromotionObserver(@Nullable PrimaryMeetingPromotionObserver primaryMeetingPromotionObserver) {
        this.primaryMeetingPromotionObserver = primaryMeetingPromotionObserver;
    }

    public void onAudioClientStateChange(int newInternalAudioState, int newInternalAudioStatus) {
        MeetingSessionStatusCode newAudioStatus = this.toAudioStatus(newInternalAudioStatus);
        SessionStateControllerAction newAudioState = this.toAudioClientState(newInternalAudioState, newAudioStatus);
        if (newAudioStatus == null) {
            this.logger.warn(this.TAG, "AudioClient State raw value: " + newInternalAudioState + " Unknown Status raw value: " + newInternalAudioStatus);
        } else {
            this.logger.info(this.TAG, "AudioClient State: " + newAudioState + " Status: " + newAudioStatus);
        }
        if (newAudioState == SessionStateControllerAction.Unknown) {
            return;
        }
        if (newAudioState == this.currentAudioState && newAudioStatus == this.getCurrentAudioStatus()) {
            return;
        }
        block0 : switch (WhenMappings.$EnumSwitchMapping$1[newAudioState.ordinal()]) {
            case 3: {
                switch (WhenMappings.$EnumSwitchMapping$1[this.currentAudioState.ordinal()]) {
                    case 1: {
                        this.meetingStatsCollector.updateMeetingStartTimeMs();
                        EventAnalyticsController.publishEvent$default(this.eventAnalyticsController, EventName.meetingStartSucceeded, null, false, 6, null);
                        this.notifyAudioClientObserver((Function1<? super AudioVideoObserver, Unit>)((Function1)onAudioClientStateChange.1.INSTANCE));
                        break;
                    }
                    case 2: {
                        this.meetingStatsCollector.incrementRetryCount();
                        this.meetingStatsCollector.updateMeetingReconnectedTimeMs();
                        EventAnalyticsController.publishEvent$default(this.eventAnalyticsController, EventName.meetingReconnected, null, false, 6, null);
                        this.notifyAudioClientObserver((Function1<? super AudioVideoObserver, Unit>)((Function1)new Function1<AudioVideoObserver, Unit>(this){
                            final /* synthetic */ DefaultAudioClientObserver this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull AudioVideoObserver observer) {
                                Unit unit;
                                Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
                                observer.onAudioSessionStarted(true);
                                PrimaryMeetingPromotionObserver primaryMeetingPromotionObserver = this.this$0.getPrimaryMeetingPromotionObserver();
                                if (primaryMeetingPromotionObserver != null) {
                                    primaryMeetingPromotionObserver.onPrimaryMeetingDemotion(new MeetingSessionStatus(MeetingSessionStatusCode.AudioInternalServerError));
                                    unit = Unit.INSTANCE;
                                } else {
                                    unit = null;
                                }
                                if (unit == null) {
                                    DefaultAudioClientObserver $this$invoke_u24lambda_u240 = this.this$0;
                                    boolean bl = false;
                                    DefaultAudioClientObserver.access$getLogger$p($this$invoke_u24lambda_u240).info(DefaultAudioClientObserver.access$getTAG$p($this$invoke_u24lambda_u240), "Primary meeting demotion occurred from audio (on reconnect) but no primary meeting demotion callback is set");
                                }
                                this.this$0.setPrimaryMeetingPromotionObserver(null);
                            }
                        }));
                        break;
                    }
                    case 3: {
                        MeetingSessionStatusCode meetingSessionStatusCode = newAudioStatus;
                        switch (meetingSessionStatusCode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[meetingSessionStatusCode.ordinal()]) {
                            case 1: {
                                if (this.getCurrentAudioStatus() != MeetingSessionStatusCode.NetworkBecamePoor) break block0;
                                this.notifyAudioClientObserver((Function1<? super AudioVideoObserver, Unit>)((Function1)onAudioClientStateChange.3.INSTANCE));
                                break;
                            }
                            case 2: {
                                if (this.getCurrentAudioStatus() != MeetingSessionStatusCode.OK) break block0;
                                this.meetingStatsCollector.incrementPoorConnectionCount();
                                this.notifyAudioClientObserver((Function1<? super AudioVideoObserver, Unit>)((Function1)onAudioClientStateChange.4.INSTANCE));
                                break;
                            }
                        }
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                this.meetingStatsCollector.updateMeetingStartReconnectingTimeMs();
                if (this.currentAudioState != SessionStateControllerAction.FinishConnecting) break;
                this.notifyAudioClientObserver((Function1<? super AudioVideoObserver, Unit>)((Function1)onAudioClientStateChange.5.INSTANCE));
                break;
            }
            case 4: {
                switch (WhenMappings.$EnumSwitchMapping$1[this.currentAudioState.ordinal()]) {
                    case 1: 
                    case 3: {
                        if (!this.shouldCloseAndNotifyEndMeeting(newAudioStatus)) break block0;
                        this.handleAudioSessionEndedByServer(newAudioStatus);
                        break;
                    }
                    case 2: {
                        this.notifyAudioClientObserver((Function1<? super AudioVideoObserver, Unit>)((Function1)onAudioClientStateChange.6.INSTANCE));
                        if (!this.shouldCloseAndNotifyEndMeeting(newAudioStatus)) break block0;
                        this.handleAudioSessionEndedByServer(newAudioStatus);
                        break;
                    }
                }
                break;
            }
            case 5: {
                switch (WhenMappings.$EnumSwitchMapping$1[this.currentAudioState.ordinal()]) {
                    case 1: 
                    case 3: {
                        this.handleOnAudioSessionFailed(newAudioStatus);
                        break block0;
                    }
                    case 2: {
                        this.notifyAudioClientObserver((Function1<? super AudioVideoObserver, Unit>)((Function1)onAudioClientStateChange.7.INSTANCE));
                        this.handleOnAudioSessionFailed(newAudioStatus);
                        break block0;
                    }
                }
                break;
            }
        }
        this.currentAudioState = newAudioState;
        this.setCurrentAudioStatus(newAudioStatus);
    }

    /*
     * WARNING - void declaration
     */
    public void onVolumeStateChange(@Nullable AttendeeUpdate[] attendeeUpdates) {
        void $this$filterTo$iv$iv;
        Map newAttendeeVolumeMap;
        void $this$mapNotNullTo$iv$iv;
        if (attendeeUpdates == null) {
            return;
        }
        AttendeeUpdate[] $this$mapNotNull$iv = attendeeUpdates;
        boolean $i$f$mapNotNull = false;
        AttendeeUpdate[] attendeeUpdateArray = $this$mapNotNull$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            Pair pair;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void attendeeUpdate = element$iv$iv;
            boolean bl2 = false;
            if (VolumeLevel.Companion.from(attendeeUpdate.getData()) != null) {
                VolumeLevel it;
                boolean bl3 = false;
                AttendeeInfo attendeeInfo = this.createAttendeeInfo((AttendeeUpdate)attendeeUpdate);
                pair = TuplesKt.to((Object)attendeeUpdate.getProfileId(), (Object)new VolumeUpdate(attendeeInfo, it));
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Map $this$filter$iv = newAttendeeVolumeMap = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            String key = (String)entry.getKey();
            VolumeUpdate value = (VolumeUpdate)entry.getValue();
            VolumeUpdate volumeUpdate = this.currentAttendeeVolumeMap.get(key);
            if (!(value.getVolumeLevel() != (volumeUpdate != null ? volumeUpdate.getVolumeLevel() : null))) continue;
            destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map changedAttendeeVolumeMap = destination$iv$iv2;
        this.onAttendeesMuteStateChange(changedAttendeeVolumeMap);
        if (!changedAttendeeVolumeMap.isEmpty()) {
            Collection $this$toTypedArray$iv = changedAttendeeVolumeMap.values();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            VolumeUpdate[] volumeUpdates = thisCollection$iv.toArray(new VolumeUpdate[0]);
            ObserverUtils.Companion.notifyObserverOnMainThread(this.realtimeEventObservers, (Function1)new Function1<RealtimeObserver, Unit>(volumeUpdates){
                final /* synthetic */ VolumeUpdate[] $volumeUpdates;
                {
                    this.$volumeUpdates = $volumeUpdates;
                    super(1);
                }

                public final void invoke(@NotNull RealtimeObserver it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    it.onVolumeChanged(this.$volumeUpdates);
                }
            });
        }
        this.currentAttendeeVolumeMap = newAttendeeVolumeMap;
    }

    /*
     * WARNING - void declaration
     */
    public void onSignalStrengthChange(@Nullable AttendeeUpdate[] attendeeUpdates) {
        void $this$filterTo$iv$iv;
        Map newAttendeeSignalMap;
        void $this$mapNotNullTo$iv$iv;
        if (attendeeUpdates == null) {
            return;
        }
        AttendeeUpdate[] $this$mapNotNull$iv = attendeeUpdates;
        boolean $i$f$mapNotNull = false;
        AttendeeUpdate[] attendeeUpdateArray = $this$mapNotNull$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            Pair pair;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void attendeeUpdate = element$iv$iv;
            boolean bl2 = false;
            if (SignalStrength.Companion.from(attendeeUpdate.getData()) != null) {
                SignalStrength it;
                boolean bl3 = false;
                AttendeeInfo attendeeInfo = this.createAttendeeInfo((AttendeeUpdate)attendeeUpdate);
                pair = TuplesKt.to((Object)attendeeUpdate.getProfileId(), (Object)new SignalUpdate(attendeeInfo, it));
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Map $this$filter$iv = newAttendeeSignalMap = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            String key = (String)entry.getKey();
            SignalUpdate value = (SignalUpdate)entry.getValue();
            SignalUpdate signalUpdate = this.currentAttendeeSignalMap.get(key);
            if (!(value.getSignalStrength() != (signalUpdate != null ? signalUpdate.getSignalStrength() : null))) continue;
            destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map changedAttendeeSignalMap = destination$iv$iv2;
        if (!changedAttendeeSignalMap.isEmpty()) {
            Collection $this$toTypedArray$iv = changedAttendeeSignalMap.values();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            SignalUpdate[] signalUpdates = thisCollection$iv.toArray(new SignalUpdate[0]);
            ObserverUtils.Companion.notifyObserverOnMainThread(this.realtimeEventObservers, (Function1)new Function1<RealtimeObserver, Unit>(signalUpdates){
                final /* synthetic */ SignalUpdate[] $signalUpdates;
                {
                    this.$signalUpdates = $signalUpdates;
                    super(1);
                }

                public final void invoke(@NotNull RealtimeObserver it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    it.onSignalStrengthChanged(this.$signalUpdates);
                }
            });
        }
        this.currentAttendeeSignalMap = newAttendeeSignalMap;
    }

    /*
     * WARNING - void declaration
     */
    public void onTranscriptEventsReceived(@Nullable com.xodee.client.audio.audioclient.transcript.TranscriptEvent[] events) {
        if (events == null) {
            return;
        }
        com.xodee.client.audio.audioclient.transcript.TranscriptEvent[] $this$forEach$iv = events;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            TranscriptEvent transcriptEvent;
            com.xodee.client.audio.audioclient.transcript.TranscriptEvent element$iv;
            com.xodee.client.audio.audioclient.transcript.TranscriptEvent rawEvent = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            TranscriptEvent event = null;
            com.xodee.client.audio.audioclient.transcript.TranscriptEvent transcriptEvent2 = rawEvent;
            if (transcriptEvent2 instanceof com.xodee.client.audio.audioclient.transcript.TranscriptionStatus) {
                TranscriptionStatusType transcriptionStatusType = TranscriptionStatusType.Companion.from(((com.xodee.client.audio.audioclient.transcript.TranscriptionStatus)rawEvent).getType().getValue());
                long l = ((com.xodee.client.audio.audioclient.transcript.TranscriptionStatus)rawEvent).getEventTimeMs();
                String string = ((com.xodee.client.audio.audioclient.transcript.TranscriptionStatus)rawEvent).getTranscriptionRegion();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTranscriptionRegion(...)");
                String string2 = ((com.xodee.client.audio.audioclient.transcript.TranscriptionStatus)rawEvent).getTranscriptionConfiguration();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTranscriptionConfiguration(...)");
                String string3 = ((com.xodee.client.audio.audioclient.transcript.TranscriptionStatus)rawEvent).getMessage();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getMessage(...)");
                event = new TranscriptionStatus(transcriptionStatusType, l, string, string2, string3);
            } else if (transcriptEvent2 instanceof com.xodee.client.audio.audioclient.transcript.Transcript) {
                List results = new ArrayList();
                TranscriptResult[] transcriptResultArray = ((com.xodee.client.audio.audioclient.transcript.Transcript)rawEvent).getResults();
                Intrinsics.checkNotNullExpressionValue((Object)transcriptResultArray, (String)"getResults(...)");
                Object[] $this$forEach$iv2 = transcriptResultArray;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    com.amazonaws.services.chime.sdk.meetings.audiovideo.TranscriptLanguageWithScore[] transcriptLanguageWithScoreArray;
                    void $this$toTypedArray$iv;
                    TranscriptLanguageWithScore[] items;
                    TranscriptResult rawResult = (TranscriptResult)element$iv2;
                    boolean bl2 = false;
                    List alternatives = new ArrayList();
                    com.xodee.client.audio.audioclient.transcript.TranscriptAlternative[] transcriptAlternativeArray = rawResult.getAlternatives();
                    Intrinsics.checkNotNullExpressionValue((Object)transcriptAlternativeArray, (String)"getAlternatives(...)");
                    Object[] $this$forEach$iv3 = transcriptAlternativeArray;
                    boolean $i$f$forEach32 = false;
                    for (Object element$iv3 : $this$forEach$iv3) {
                        com.amazonaws.services.chime.sdk.meetings.audiovideo.TranscriptEntity[] transcriptEntityArray;
                        Object item;
                        com.xodee.client.audio.audioclient.transcript.TranscriptAlternative rawAlternative = (com.xodee.client.audio.audioclient.transcript.TranscriptAlternative)element$iv3;
                        boolean bl3 = false;
                        items = (TranscriptLanguageWithScore[])new ArrayList();
                        com.xodee.client.audio.audioclient.transcript.TranscriptItem[] transcriptItemArray = rawAlternative.getItems();
                        Intrinsics.checkNotNullExpressionValue((Object)transcriptItemArray, (String)"getItems(...)");
                        Object[] $this$forEach$iv4 = transcriptItemArray;
                        boolean $i$f$forEach42 = false;
                        for (Object element$iv4 : $this$forEach$iv4) {
                            com.xodee.client.audio.audioclient.transcript.TranscriptItem rawItem = (com.xodee.client.audio.audioclient.transcript.TranscriptItem)element$iv4;
                            boolean bl4 = false;
                            TranscriptItemType transcriptItemType = TranscriptItemType.Companion.from(rawItem.getType().getValue());
                            long l = rawItem.getStartTimeMs();
                            long l2 = rawItem.getEndTimeMs();
                            String string = rawItem.getAttendee().getAttendeeId();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttendeeId(...)");
                            String string4 = rawItem.getAttendee().getExternalUserId();
                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getExternalUserId(...)");
                            AttendeeInfo attendeeInfo = new AttendeeInfo(string, string4);
                            String string5 = rawItem.getContent();
                            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getContent(...)");
                            item = new TranscriptItem(transcriptItemType, l, l2, attendeeInfo, string5, rawItem.getVocabularyFilterMatch(), rawItem.getConfidence(), rawItem.getStable());
                            items.add(item);
                        }
                        if ($i$f$forEach42 != null) {
                            void $this$mapTo$iv$iv;
                            TranscriptEntity[] $i$f$forEach42 = rawAlternative.getEntities();
                            Intrinsics.checkNotNull((Object)$i$f$forEach42);
                            TranscriptEntity[] it = $i$f$forEach42;
                            boolean bl5 = false;
                            Object $this$map$iv = it;
                            boolean $i$f$map = false;
                            item = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList(((TranscriptEntity[])$this$map$iv).length);
                            boolean $i$f$mapTo = false;
                            int n2 = ((void)$this$mapTo$iv$iv).length;
                            for (int j = 0; j < n2; ++j) {
                                void rawEntity;
                                void item$iv$iv;
                                void var41_63 = item$iv$iv = $this$mapTo$iv$iv[j];
                                Collection collection = destination$iv$iv;
                                boolean bl6 = false;
                                String string = rawEntity.getCategory();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCategory(...)");
                                double d = rawEntity.getConfidence();
                                String string6 = rawEntity.getContent();
                                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getContent(...)");
                                collection.add(new com.amazonaws.services.chime.sdk.meetings.audiovideo.TranscriptEntity(string, d, string6, rawEntity.getStartTimeMs(), rawEntity.getEndTimeMs(), rawEntity.getType()));
                            }
                            $this$map$iv = (List)destination$iv$iv;
                            boolean $i$f$toTypedArray = false;
                            void thisCollection$iv = $this$toTypedArray$iv;
                            transcriptEntityArray = thisCollection$iv.toArray(new com.amazonaws.services.chime.sdk.meetings.audiovideo.TranscriptEntity[0]);
                            if (transcriptEntityArray == null) {
                                DefaultAudioClientObserver $this$onTranscriptEventsReceived_u24lambda_u2416_u24lambda_u2414_u24lambda_u2410_u24lambda_u249_u24lambda_u248 = this;
                                boolean bl7 = false;
                                transcriptEntityArray = null;
                            }
                        } else {
                            transcriptEntityArray = null;
                        }
                        com.amazonaws.services.chime.sdk.meetings.audiovideo.TranscriptEntity[] entities = transcriptEntityArray;
                        Collection $this$toTypedArray$iv2 = (Collection)items;
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv2;
                        String string = rawAlternative.getTranscript();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTranscript(...)");
                        TranscriptAlternative alternative = new TranscriptAlternative(thisCollection$iv.toArray(new TranscriptItem[0]), entities, string);
                        alternatives.add(alternative);
                    }
                    if ($i$f$forEach32 != null) {
                        void $this$toTypedArray$iv3;
                        void $this$mapTo$iv$iv;
                        TranscriptLanguageWithScore[] $i$f$forEach32 = rawResult.getLanguageIdentification();
                        Intrinsics.checkNotNull((Object)$i$f$forEach32);
                        TranscriptLanguageWithScore[] it = $i$f$forEach32;
                        boolean bl8 = false;
                        Object $this$map$iv = it;
                        boolean $i$f$map = false;
                        items = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(((TranscriptLanguageWithScore[])$this$map$iv).length);
                        boolean $i$f$mapTo = false;
                        int n3 = ((void)$this$mapTo$iv$iv).length;
                        for (int j = 0; j < n3; ++j) {
                            void rawLanguageIdentification;
                            void item$iv$iv;
                            $this$toTypedArray$iv = item$iv$iv = $this$mapTo$iv$iv[j];
                            Collection collection = destination$iv$iv;
                            boolean bl9 = false;
                            String string = rawLanguageIdentification.getLanguageCode();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLanguageCode(...)");
                            collection.add(new com.amazonaws.services.chime.sdk.meetings.audiovideo.TranscriptLanguageWithScore(string, rawLanguageIdentification.getScore()));
                        }
                        $this$map$iv = (List)destination$iv$iv;
                        boolean $i$f$toTypedArray = false;
                        void thisCollection$iv = $this$toTypedArray$iv3;
                        transcriptLanguageWithScoreArray = thisCollection$iv.toArray(new com.amazonaws.services.chime.sdk.meetings.audiovideo.TranscriptLanguageWithScore[0]);
                        if (transcriptLanguageWithScoreArray == null) {
                            DefaultAudioClientObserver $this$onTranscriptEventsReceived_u24lambda_u2416_u24lambda_u2414_u24lambda_u2413_u24lambda_u2412 = this;
                            boolean bl10 = false;
                            transcriptLanguageWithScoreArray = null;
                        }
                    } else {
                        transcriptLanguageWithScoreArray = null;
                    }
                    com.amazonaws.services.chime.sdk.meetings.audiovideo.TranscriptLanguageWithScore[] languageIdentification = transcriptLanguageWithScoreArray;
                    String string = rawResult.getResultId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getResultId(...)");
                    String string7 = rawResult.getChannelId();
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getChannelId(...)");
                    Collection $this$toTypedArray$iv4 = alternatives;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv4;
                    com.amazonaws.services.chime.sdk.meetings.audiovideo.TranscriptResult result = new com.amazonaws.services.chime.sdk.meetings.audiovideo.TranscriptResult(string, string7, rawResult.isPartial(), rawResult.getStartTimeMs(), rawResult.getEndTimeMs(), thisCollection$iv.toArray(new TranscriptAlternative[0]), rawResult.getLanguageCode(), languageIdentification);
                    results.add(result);
                }
                Collection $this$toTypedArray$iv = results;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                event = new Transcript(thisCollection$iv.toArray(new com.amazonaws.services.chime.sdk.meetings.audiovideo.TranscriptResult[0]));
            } else {
                this.logger.error(this.TAG, "Received transcript event in unknown format");
                event = null;
            }
            if (event == null) continue;
            boolean bl11 = false;
            ObserverUtils.Companion.notifyObserverOnMainThread(this.transcriptEventObservers, (Function1)new Function1<TranscriptEventObserver, Unit>(transcriptEvent){
                final /* synthetic */ TranscriptEvent $transcriptEvent;
                {
                    this.$transcriptEvent = $transcriptEvent;
                    super(1);
                }

                public final void invoke(@NotNull TranscriptEventObserver it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    it.onTranscriptEventReceived(this.$transcriptEvent);
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void onAttendeesMuteStateChange(Map<String, VolumeUpdate> volumesDelta) {
        void $this$filterTo$iv$iv;
        Map<String, VolumeUpdate> thisCollection$iv;
        Collection collection;
        Object object;
        void $this$filterTo$iv$iv2;
        Map<String, VolumeUpdate> $this$filter$iv = volumesDelta;
        boolean $i$f$filter = false;
        Map<String, VolumeUpdate> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        for (Map.Entry entry : $this$filterTo$iv$iv2.entrySet()) {
            object = entry;
            boolean bl = false;
            VolumeUpdate value = (VolumeUpdate)object.getValue();
            if (!(value.getVolumeLevel() == VolumeLevel.Muted)) continue;
            destination$iv$iv.put(entry.getKey(), entry.getValue());
        }
        Map mutedAttendeeMap = destination$iv$iv;
        if (!mutedAttendeeMap.isEmpty()) {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            Object $this$map$iv = mutedAttendeeMap;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry bl = item$iv$iv = iterator.next();
                collection = destination$iv$iv2;
                boolean bl2 = false;
                VolumeUpdate value = (VolumeUpdate)bl.getValue();
                collection.add(value.getAttendeeInfo());
            }
            $this$map$iv = (List)destination$iv$iv2;
            boolean $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            AttendeeInfo[] mutedAttendeeInfo = thisCollection$iv.toArray(new AttendeeInfo[0]);
            ObserverUtils.Companion.notifyObserverOnMainThread(this.realtimeEventObservers, (Function1)new Function1<RealtimeObserver, Unit>(mutedAttendeeInfo){
                final /* synthetic */ AttendeeInfo[] $mutedAttendeeInfo;
                {
                    this.$mutedAttendeeInfo = $mutedAttendeeInfo;
                    super(1);
                }

                public final void invoke(@NotNull RealtimeObserver it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    it.onAttendeesMuted(this.$mutedAttendeeInfo);
                }
            });
        }
        Map<String, VolumeUpdate> $this$filter$iv2 = volumesDelta;
        boolean $i$f$filter2 = false;
        thisCollection$iv = $this$filter$iv2;
        Map destination$iv$iv3 = new LinkedHashMap();
        boolean $i$f$filterTo2 = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv3;
            Map.Entry bl = element$iv$iv3 = iterator.next();
            boolean bl3 = false;
            String key = (String)bl.getKey();
            VolumeUpdate volumeUpdate = this.currentAttendeeVolumeMap.get(key);
            if (!((volumeUpdate != null ? volumeUpdate.getVolumeLevel() : null) == VolumeLevel.Muted)) continue;
            destination$iv$iv3.put(element$iv$iv3.getKey(), element$iv$iv3.getValue());
        }
        Map unMutedAttendeeMap = destination$iv$iv3;
        if (!unMutedAttendeeMap.isEmpty()) {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            Object $this$map$iv = unMutedAttendeeMap;
            boolean $i$f$map = false;
            destination$iv$iv3 = $this$map$iv;
            Collection destination$iv$iv4 = new ArrayList($this$map$iv.size());
            boolean bl = false;
            object = $this$mapTo$iv$iv.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = (Map.Entry)object.next();
                collection = destination$iv$iv4;
                boolean bl2 = false;
                VolumeUpdate value = (VolumeUpdate)entry.getValue();
                collection.add(value.getAttendeeInfo());
            }
            $this$map$iv = (List)destination$iv$iv4;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv2 = $this$toTypedArray$iv;
            AttendeeInfo[] unMutedAttendeeInfo = thisCollection$iv2.toArray(new AttendeeInfo[0]);
            ObserverUtils.Companion.notifyObserverOnMainThread(this.realtimeEventObservers, (Function1)new Function1<RealtimeObserver, Unit>(unMutedAttendeeInfo){
                final /* synthetic */ AttendeeInfo[] $unMutedAttendeeInfo;
                {
                    this.$unMutedAttendeeInfo = $unMutedAttendeeInfo;
                    super(1);
                }

                public final void invoke(@NotNull RealtimeObserver it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    it.onAttendeesUnmuted(this.$unMutedAttendeeInfo);
                }
            });
        }
    }

    public void onLogMessage(int logLevel, @Nullable String message) {
        if (message == null) {
            return;
        }
        switch (logLevel) {
            case 5: 
            case 6: {
                this.logger.error(this.TAG, message);
                break;
            }
            default: {
                this.logger.verbose(this.TAG, message);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onMetrics(@Nullable int[] metrics, @Nullable double[] values) {
        void $this$mapTo$iv$iv;
        if (metrics == null || values == null) {
            return;
        }
        Map metricMap = new LinkedHashMap();
        Iterable $this$map$iv = (Iterable)ArraysKt.getIndices((int[])metrics);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void i;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            metricMap.put(metrics[i], values[i]);
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        this.clientMetricsCollector.processAudioClientMetrics(metricMap);
    }

    /*
     * WARNING - void declaration
     */
    public void onAttendeesPresenceChange(@Nullable AttendeeUpdate[] attendeeUpdates) {
        block7: {
            boolean $i$f$toTypedArray;
            List it;
            void $this$groupByTo$iv$iv;
            if (attendeeUpdates == null) {
                return;
            }
            AttendeeUpdate[] $this$groupBy$iv = attendeeUpdates;
            boolean $i$f$groupBy = false;
            AttendeeUpdate[] attendeeUpdateArray = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            int n = ((void)$this$groupByTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                Object object;
                void element$iv$iv;
                void it2 = element$iv$iv = $this$groupByTo$iv$iv[i];
                boolean bl = false;
                AttendeeStatus key$iv$iv = AttendeeStatus.Companion.from(it2.getData());
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get((Object)key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                it2 = element$iv$iv;
                List list = list$iv$iv;
                boolean bl3 = false;
                list.add(this.createAttendeeInfo((AttendeeUpdate)it2));
            }
            Map attendeesByStatus = destination$iv$iv;
            List list = (List)attendeesByStatus.get((Object)AttendeeStatus.Joined);
            if (list != null) {
                it = list;
                boolean bl = false;
                List attendeeJoined = CollectionsKt.minus((Iterable)it, (Iterable)this.currentAttendees);
                if (!((Collection)attendeeJoined).isEmpty()) {
                    Collection $this$toTypedArray$iv = attendeeJoined;
                    boolean $i$f$toTypedArray2 = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    this.onAttendeesJoin(thisCollection$iv.toArray(new AttendeeInfo[0]));
                    this.currentAttendees.addAll(attendeeJoined);
                }
            }
            List list2 = (List)attendeesByStatus.get((Object)AttendeeStatus.Left);
            if (list2 != null) {
                it = list2;
                boolean bl = false;
                Collection $this$toTypedArray$iv = it;
                $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                this.onAttendeesLeft(thisCollection$iv.toArray(new AttendeeInfo[0]));
                this.currentAttendees.removeAll(it);
            }
            List list3 = (List)attendeesByStatus.get((Object)AttendeeStatus.Dropped);
            if (list3 == null) break block7;
            it = list3;
            boolean bl = false;
            Collection $this$toTypedArray$iv = it;
            $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            this.onAttendeesDropped(thisCollection$iv.toArray(new AttendeeInfo[0]));
            this.currentAttendees.removeAll(it);
        }
    }

    private final AttendeeInfo createAttendeeInfo(AttendeeUpdate attendeeUpdate) {
        String string = attendeeUpdate.getExternalUserId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExternalUserId(...)");
        String externalUserId = ((CharSequence)string).length() == 0 && Intrinsics.areEqual((Object)attendeeUpdate.getProfileId(), (Object)this.configuration.getCredentials().getAttendeeId()) ? this.configuration.getCredentials().getExternalUserId() : attendeeUpdate.getExternalUserId();
        String string2 = attendeeUpdate.getProfileId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProfileId(...)");
        Intrinsics.checkNotNull((Object)externalUserId);
        return new AttendeeInfo(string2, externalUserId);
    }

    private final void onAttendeesJoin(AttendeeInfo[] attendeeInfo) {
        this.logger.debug(this.TAG, "Joined: " + ArraysKt.joinToString$default((Object[])attendeeInfo, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
        ObserverUtils.Companion.notifyObserverOnMainThread(this.realtimeEventObservers, (Function1)new Function1<RealtimeObserver, Unit>(attendeeInfo){
            final /* synthetic */ AttendeeInfo[] $attendeeInfo;
            {
                this.$attendeeInfo = $attendeeInfo;
                super(1);
            }

            public final void invoke(@NotNull RealtimeObserver it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.onAttendeesJoined(this.$attendeeInfo);
            }
        });
    }

    private final void onAttendeesLeft(AttendeeInfo[] attendeeInfo) {
        this.logger.debug(this.TAG, "Left: " + ArraysKt.joinToString$default((Object[])attendeeInfo, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
        ObserverUtils.Companion.notifyObserverOnMainThread(this.realtimeEventObservers, (Function1)new Function1<RealtimeObserver, Unit>(attendeeInfo){
            final /* synthetic */ AttendeeInfo[] $attendeeInfo;
            {
                this.$attendeeInfo = $attendeeInfo;
                super(1);
            }

            public final void invoke(@NotNull RealtimeObserver it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.onAttendeesLeft(this.$attendeeInfo);
            }
        });
    }

    private final void onAttendeesDropped(AttendeeInfo[] attendeeInfo) {
        this.logger.debug(this.TAG, "Dropped: " + ArraysKt.joinToString$default((Object[])attendeeInfo, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
        ObserverUtils.Companion.notifyObserverOnMainThread(this.realtimeEventObservers, (Function1)new Function1<RealtimeObserver, Unit>(attendeeInfo){
            final /* synthetic */ AttendeeInfo[] $attendeeInfo;
            {
                this.$attendeeInfo = $attendeeInfo;
                super(1);
            }

            public final void invoke(@NotNull RealtimeObserver it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.onAttendeesDropped(this.$attendeeInfo);
            }
        });
    }

    public void onAudioClientPrimaryMeetingEvent(int type, int status) {
        this.logger.info(this.TAG, "Primary meeting event for notified with type " + type + " and status " + status);
        MeetingSessionStatusCode sdkStatus = switch (status) {
            case 0 -> MeetingSessionStatusCode.OK;
            case 3 -> MeetingSessionStatusCode.AudioDisconnected;
            case 5 -> MeetingSessionStatusCode.AudioInternalServerError;
            case 2 -> MeetingSessionStatusCode.AudioAuthenticationRejected;
            case 4 -> MeetingSessionStatusCode.AudioDisconnectAudio;
            default -> MeetingSessionStatusCode.AudioInternalServerError;
        };
        switch (type) {
            case 1: {
                Unit unit;
                PrimaryMeetingPromotionObserver primaryMeetingPromotionObserver = this.getPrimaryMeetingPromotionObserver();
                if (primaryMeetingPromotionObserver != null) {
                    primaryMeetingPromotionObserver.onPrimaryMeetingPromotion(new MeetingSessionStatus(sdkStatus));
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit != null) break;
                DefaultAudioClientObserver $this$onAudioClientPrimaryMeetingEvent_u24lambda_u2427 = this;
                boolean bl = false;
                $this$onAudioClientPrimaryMeetingEvent_u24lambda_u2427.logger.info($this$onAudioClientPrimaryMeetingEvent_u24lambda_u2427.TAG, "Primary meeting promotion completed from audio but no primary meeting promotion callback is set");
                break;
            }
            case 2: {
                Unit unit;
                PrimaryMeetingPromotionObserver primaryMeetingPromotionObserver = this.getPrimaryMeetingPromotionObserver();
                if (primaryMeetingPromotionObserver != null) {
                    primaryMeetingPromotionObserver.onPrimaryMeetingDemotion(new MeetingSessionStatus(sdkStatus));
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit == null) {
                    DefaultAudioClientObserver $this$onAudioClientPrimaryMeetingEvent_u24lambda_u2428 = this;
                    boolean bl = false;
                    $this$onAudioClientPrimaryMeetingEvent_u24lambda_u2428.logger.info($this$onAudioClientPrimaryMeetingEvent_u24lambda_u2428.TAG, "Primary meeting demotion occurred from audio but no primary meeting demotion callback is set");
                }
                this.setPrimaryMeetingPromotionObserver(null);
            }
        }
    }

    @Override
    public void subscribeToAudioClientStateChange(@NotNull AudioVideoObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        this.audioClientStateObservers.add(observer);
    }

    @Override
    public void unsubscribeFromAudioClientStateChange(@NotNull AudioVideoObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        this.audioClientStateObservers.remove(observer);
    }

    @Override
    public void subscribeToRealTimeEvents(@NotNull RealtimeObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        this.realtimeEventObservers.add(observer);
    }

    @Override
    public void unsubscribeFromRealTimeEvents(@NotNull RealtimeObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        this.realtimeEventObservers.remove(observer);
    }

    @Override
    public void subscribeToTranscriptEvent(@NotNull TranscriptEventObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        this.transcriptEventObservers.add(observer);
    }

    @Override
    public void unsubscribeFromTranscriptEvent(@NotNull TranscriptEventObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        this.transcriptEventObservers.remove(observer);
    }

    @Override
    public void notifyAudioClientObserver(@NotNull Function1<? super AudioVideoObserver, Unit> observerFunction) {
        Intrinsics.checkNotNullParameter(observerFunction, (String)"observerFunction");
        ObserverUtils.Companion.notifyObserverOnMainThread(this.audioClientStateObservers, observerFunction);
    }

    private final SessionStateControllerAction toAudioClientState(int internalAudioClientState, MeetingSessionStatusCode statusCode) {
        if (this.shouldCloseAndNotifyEndMeeting(statusCode)) {
            return SessionStateControllerAction.FinishDisconnecting;
        }
        return switch (internalAudioClientState) {
            case -1 -> SessionStateControllerAction.Unknown;
            case 0 -> SessionStateControllerAction.Init;
            case 1 -> SessionStateControllerAction.Connecting;
            case 2 -> SessionStateControllerAction.FinishConnecting;
            case 3 -> SessionStateControllerAction.Reconnecting;
            case 5 -> SessionStateControllerAction.Disconnecting;
            case 6 -> SessionStateControllerAction.FinishDisconnecting;
            case 4, 7, 8 -> SessionStateControllerAction.Fail;
            default -> SessionStateControllerAction.Unknown;
        };
    }

    private final boolean shouldCloseAndNotifyEndMeeting(MeetingSessionStatusCode status) {
        return status == MeetingSessionStatusCode.AudioServerHungup || status == MeetingSessionStatusCode.AudioJoinedFromAnotherDevice;
    }

    private final MeetingSessionStatusCode toAudioStatus(int internalAudioStatus) {
        return switch (internalAudioStatus) {
            case 0 -> MeetingSessionStatusCode.OK;
            case 59 -> MeetingSessionStatusCode.NetworkBecamePoor;
            case 60 -> MeetingSessionStatusCode.AudioServerHungup;
            case 61 -> MeetingSessionStatusCode.AudioJoinedFromAnotherDevice;
            case 62 -> MeetingSessionStatusCode.AudioInternalServerError;
            case 63 -> MeetingSessionStatusCode.AudioAuthenticationRejected;
            case 64 -> MeetingSessionStatusCode.AudioCallAtCapacity;
            case 65 -> MeetingSessionStatusCode.AudioServiceUnavailable;
            case 69 -> MeetingSessionStatusCode.AudioDisconnectAudio;
            case 75 -> MeetingSessionStatusCode.AudioCallEnded;
            case 82 -> MeetingSessionStatusCode.AudioInputDeviceNotResponding;
            case 83 -> MeetingSessionStatusCode.AudioOutputDeviceNotResponding;
            default -> null;
        };
    }

    private final void handleOnAudioSessionFailed(MeetingSessionStatusCode statusCode) {
        if (this.audioClient != null) {
            this.notifyFailed(statusCode);
        }
        this.handleAudioClientStop(statusCode);
    }

    private final void handleAudioClientStop(MeetingSessionStatusCode statusCode) {
        if (this.audioClient != null) {
            BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, statusCode, null){
                int label;
                final /* synthetic */ DefaultAudioClientObserver this$0;
                final /* synthetic */ MeetingSessionStatusCode $statusCode;
                {
                    this.this$0 = $receiver;
                    this.$statusCode = $statusCode;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            AudioClient audioClient = this.this$0.getAudioClient();
                            if (audioClient != null) {
                                Boxing.boxInt((int)audioClient.stopSession());
                            }
                            DefaultAudioClientObserver.access$getAppStateMonitor$p(this.this$0).stop();
                            DefaultAudioClientController.Companion.setAudioClientState(AudioClientState.STOPPED);
                            this.this$0.notifyAudioClientObserver((Function1<? super AudioVideoObserver, Unit>)((Function1)new Function1<AudioVideoObserver, Unit>(this.$statusCode){
                                final /* synthetic */ MeetingSessionStatusCode $statusCode;
                                {
                                    this.$statusCode = $statusCode;
                                    super(1);
                                }

                                public final void invoke(@NotNull AudioVideoObserver observer) {
                                    Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
                                    observer.onAudioSessionStopped(new MeetingSessionStatus(this.$statusCode));
                                }
                            }));
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        } else {
            this.logger.error(this.TAG, "Failed to stop audio session since audioClient is null");
        }
    }

    private final void notifyFailed(MeetingSessionStatusCode statusCode) {
        Map map;
        MeetingSessionStatusCode meetingSessionStatusCode = statusCode;
        if (meetingSessionStatusCode != null) {
            MeetingSessionStatusCode it = meetingSessionStatusCode;
            boolean bl = false;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)EventAttributeName.meetingStatus), (Object)((Object)statusCode)), TuplesKt.to((Object)((Object)EventAttributeName.meetingErrorMessage), (Object)statusCode.toString())};
            map = MapsKt.mutableMapOf((Pair[])pairArray);
        } else {
            map = null;
        }
        Map attributes = map;
        EventAnalyticsController.publishEvent$default(this.eventAnalyticsController, EventName.meetingFailed, attributes, false, 4, null);
        this.meetingStatsCollector.resetMeetingStats();
    }

    private final void notifyMeetingEnded(MeetingSessionStatusCode statusCode) {
        Map map;
        MeetingSessionStatusCode meetingSessionStatusCode = statusCode;
        if (meetingSessionStatusCode != null) {
            MeetingSessionStatusCode it = meetingSessionStatusCode;
            boolean bl = false;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)EventAttributeName.meetingStatus), (Object)((Object)statusCode)), TuplesKt.to((Object)((Object)EventAttributeName.meetingErrorMessage), (Object)statusCode.toString())};
            map = MapsKt.mutableMapOf((Pair[])pairArray);
        } else {
            map = null;
        }
        Map attributes = map;
        EventAnalyticsController.publishEvent$default(this.eventAnalyticsController, EventName.meetingEnded, attributes, false, 4, null);
        this.meetingStatsCollector.resetMeetingStats();
    }

    private final void handleAudioSessionEndedByServer(MeetingSessionStatusCode statusCode) {
        if (DefaultAudioClientController.Companion.getAudioClientState() == AudioClientState.STOPPED) {
            return;
        }
        this.notifyMeetingEnded(statusCode);
        this.handleAudioClientStop(statusCode);
    }

    public static final /* synthetic */ Logger access$getLogger$p(DefaultAudioClientObserver $this) {
        return $this.logger;
    }

    public static final /* synthetic */ String access$getTAG$p(DefaultAudioClientObserver $this) {
        return $this.TAG;
    }

    public static final /* synthetic */ AppStateMonitor access$getAppStateMonitor$p(DefaultAudioClientObserver $this) {
        return $this.appStateMonitor;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[MeetingSessionStatusCode.values().length];
            try {
                nArray[MeetingSessionStatusCode.OK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MeetingSessionStatusCode.NetworkBecamePoor.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[SessionStateControllerAction.values().length];
            try {
                nArray[SessionStateControllerAction.Connecting.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SessionStateControllerAction.Reconnecting.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SessionStateControllerAction.FinishConnecting.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SessionStateControllerAction.FinishDisconnecting.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SessionStateControllerAction.Fail.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

