/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.internal.ingestion.database;

import android.content.ContentValues;
import com.amazonaws.services.chime.sdk.meetings.internal.ingestion.EventDao;
import com.amazonaws.services.chime.sdk.meetings.internal.ingestion.EventTypeConverters;
import com.amazonaws.services.chime.sdk.meetings.internal.ingestion.MeetingEventItem;
import com.amazonaws.services.chime.sdk.meetings.internal.ingestion.database.DatabaseManager;
import com.amazonaws.services.chime.sdk.meetings.internal.ingestion.database.DatabaseTable;
import com.amazonaws.services.chime.sdk.meetings.utils.logger.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0\u001e2\u0006\u0010$\u001a\u00020\u001cH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006%"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/ingestion/database/EventSQLiteDao;", "Lcom/amazonaws/services/chime/sdk/meetings/internal/ingestion/EventDao;", "Lcom/amazonaws/services/chime/sdk/meetings/internal/ingestion/database/DatabaseTable;", "databaseManager", "Lcom/amazonaws/services/chime/sdk/meetings/internal/ingestion/database/DatabaseManager;", "logger", "Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;", "eventTypeConverter", "Lcom/amazonaws/services/chime/sdk/meetings/internal/ingestion/EventTypeConverters;", "(Lcom/amazonaws/services/chime/sdk/meetings/internal/ingestion/database/DatabaseManager;Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;Lcom/amazonaws/services/chime/sdk/meetings/internal/ingestion/EventTypeConverters;)V", "TAG", "", "columns", "", "getColumns", "()Ljava/util/Map;", "dataColumnName", "dataColumnType", "idColumnName", "idColumnType", "primaryKey", "Lkotlin/Pair;", "getPrimaryKey", "()Lkotlin/Pair;", "tableName", "getTableName", "()Ljava/lang/String;", "deleteMeetingEventsByIds", "", "ids", "", "insertMeetingEvent", "", "event", "Lcom/amazonaws/services/chime/sdk/meetings/internal/ingestion/MeetingEventItem;", "listMeetingEventItems", "size", "amazon-chime-sdk_release"})
@SourceDebugExtension(value={"SMAP\nEventSQLiteDao.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventSQLiteDao.kt\ncom/amazonaws/services/chime/sdk/meetings/internal/ingestion/database/EventSQLiteDao\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n1557#2:62\n1628#2,3:63\n*S KotlinDebug\n*F\n+ 1 EventSQLiteDao.kt\ncom/amazonaws/services/chime/sdk/meetings/internal/ingestion/database/EventSQLiteDao\n*L\n40#1:62\n40#1:63,3\n*E\n"})
public final class EventSQLiteDao
implements EventDao,
DatabaseTable {
    @NotNull
    private final DatabaseManager databaseManager;
    @NotNull
    private final Logger logger;
    @NotNull
    private final EventTypeConverters eventTypeConverter;
    @NotNull
    private final String tableName;
    @NotNull
    private final String TAG;
    @NotNull
    private final String idColumnName;
    @NotNull
    private final String dataColumnName;
    @NotNull
    private final String idColumnType;
    @NotNull
    private final String dataColumnType;

    public EventSQLiteDao(@NotNull DatabaseManager databaseManager, @NotNull Logger logger, @NotNull EventTypeConverters eventTypeConverter) {
        Intrinsics.checkNotNullParameter((Object)databaseManager, (String)"databaseManager");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)eventTypeConverter, (String)"eventTypeConverter");
        this.databaseManager = databaseManager;
        this.logger = logger;
        this.eventTypeConverter = eventTypeConverter;
        this.tableName = "Events";
        this.TAG = "EventSQLiteDao";
        this.idColumnName = "id";
        this.dataColumnName = "data";
        this.idColumnType = "TEXT";
        this.dataColumnType = "TEXT NOT NULL";
        this.databaseManager.createTable(this);
    }

    @Override
    @NotNull
    public String getTableName() {
        return this.tableName;
    }

    @Override
    @NotNull
    public Map<String, String> getColumns() {
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)this.dataColumnName, (Object)this.dataColumnType));
    }

    @Override
    @NotNull
    public Pair<String, String> getPrimaryKey() {
        return TuplesKt.to((Object)this.idColumnName, (Object)this.idColumnType);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<MeetingEventItem> listMeetingEventItems(int size) {
        void $this$mapTo$iv$iv;
        List<Map<String, Object>> retrievedDataList = this.databaseManager.query(this.getTableName(), size);
        Iterable $this$map$iv = retrievedDataList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void retrievedData;
            Map map = (Map)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object v = retrievedData.get(this.idColumnName);
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
            String string = (String)v;
            Object v2 = retrievedData.get(this.dataColumnName);
            Intrinsics.checkNotNull(v2, (String)"null cannot be cast to non-null type kotlin.String");
            collection.add(new MeetingEventItem(string, this.eventTypeConverter.toMeetingEvent((String)v2)));
        }
        return (List)destination$iv$iv;
    }

    @Override
    public boolean insertMeetingEvent(@NotNull MeetingEventItem event) {
        ContentValues contentValues;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ContentValues $this$insertMeetingEvent_u24lambda_u241 = contentValues = new ContentValues();
        boolean bl = false;
        $this$insertMeetingEvent_u24lambda_u241.put(this.idColumnName, event.getId());
        $this$insertMeetingEvent_u24lambda_u241.put(this.dataColumnName, this.eventTypeConverter.fromMeetingEvent(event.getData()));
        ContentValues values = contentValues;
        return this.databaseManager.insert(this.getTableName(), CollectionsKt.listOf((Object)values));
    }

    @Override
    public int deleteMeetingEventsByIds(@NotNull List<String> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        return this.databaseManager.delete(this.getTableName(), this.idColumnName, ids);
    }
}

