/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.ingestion;

import android.content.Context;
import com.amazonaws.services.chime.sdk.meetings.ingestion.DefaultEventReporter;
import com.amazonaws.services.chime.sdk.meetings.ingestion.DefaultEventSender;
import com.amazonaws.services.chime.sdk.meetings.ingestion.DefaultMeetingEventBuffer;
import com.amazonaws.services.chime.sdk.meetings.ingestion.EventReporter;
import com.amazonaws.services.chime.sdk.meetings.ingestion.EventReporterFactory;
import com.amazonaws.services.chime.sdk.meetings.ingestion.IngestionConfiguration;
import com.amazonaws.services.chime.sdk.meetings.internal.ingestion.EventTypeConverters;
import com.amazonaws.services.chime.sdk.meetings.internal.ingestion.database.DirtyEventSQLiteDao;
import com.amazonaws.services.chime.sdk.meetings.internal.ingestion.database.EventSQLiteDao;
import com.amazonaws.services.chime.sdk.meetings.internal.ingestion.database.SQLiteDatabaseManager;
import com.amazonaws.services.chime.sdk.meetings.utils.logger.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/ingestion/DefaultMeetingEventReporterFactory;", "Lcom/amazonaws/services/chime/sdk/meetings/ingestion/EventReporterFactory;", "context", "Landroid/content/Context;", "ingestionConfiguration", "Lcom/amazonaws/services/chime/sdk/meetings/ingestion/IngestionConfiguration;", "logger", "Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;", "(Landroid/content/Context;Lcom/amazonaws/services/chime/sdk/meetings/ingestion/IngestionConfiguration;Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;)V", "createEventReporter", "Lcom/amazonaws/services/chime/sdk/meetings/ingestion/EventReporter;", "amazon-chime-sdk_release"})
public final class DefaultMeetingEventReporterFactory
implements EventReporterFactory {
    @NotNull
    private final Context context;
    @NotNull
    private final IngestionConfiguration ingestionConfiguration;
    @NotNull
    private final Logger logger;

    public DefaultMeetingEventReporterFactory(@NotNull Context context, @NotNull IngestionConfiguration ingestionConfiguration, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)ingestionConfiguration, (String)"ingestionConfiguration");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.context = context;
        this.ingestionConfiguration = ingestionConfiguration;
        this.logger = logger;
    }

    @Override
    @Nullable
    public EventReporter createEventReporter() {
        if (this.ingestionConfiguration.getDisabled()) {
            return null;
        }
        DefaultEventSender eventSender = new DefaultEventSender(this.ingestionConfiguration, this.logger);
        SQLiteDatabaseManager sqliteManager = new SQLiteDatabaseManager(this.context, this.logger, null, 4, null);
        EventTypeConverters eventTypeConverter = new EventTypeConverters(this.logger);
        EventSQLiteDao eventDao = new EventSQLiteDao(sqliteManager, this.logger, eventTypeConverter);
        DirtyEventSQLiteDao dirtyEventDao = new DirtyEventSQLiteDao(sqliteManager, this.logger, eventTypeConverter);
        DefaultMeetingEventBuffer eventBuffer = new DefaultMeetingEventBuffer(this.ingestionConfiguration, eventDao, dirtyEventDao, eventSender, this.logger, null, 32, null);
        return new DefaultEventReporter(this.ingestionConfiguration, eventBuffer, this.logger, null, 8, null);
    }
}

