/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.ingestion;

import android.app.ActivityManager;
import android.app.Application;
import android.os.BatteryManager;
import android.os.Handler;
import android.os.Looper;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ProcessLifecycleOwner;
import com.amazonaws.services.chime.sdk.meetings.ingestion.AppState;
import com.amazonaws.services.chime.sdk.meetings.ingestion.AppStateHandler;
import com.amazonaws.services.chime.sdk.meetings.ingestion.AppStateMonitor;
import com.amazonaws.services.chime.sdk.meetings.ingestion.BatteryState;
import com.amazonaws.services.chime.sdk.meetings.utils.logger.Logger;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u001f\u001a\u00020\u001eH\u0002J\u000f\u0010 \u001a\u0004\u0018\u00010!H\u0016\u00a2\u0006\u0002\u0010\"J\b\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010)\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010*\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010+\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010,\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010-\u001a\u00020\u001eH\u0016J\b\u0010.\u001a\u00020\u001eH\u0002J\b\u0010/\u001a\u00020\u001eH\u0016J\b\u00100\u001a\u00020\u001eH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/ingestion/DefaultAppStateMonitor;", "Lcom/amazonaws/services/chime/sdk/meetings/ingestion/AppStateMonitor;", "Landroidx/lifecycle/DefaultLifecycleObserver;", "logger", "Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;", "application", "Landroid/app/Application;", "memoryCheckIntervalMs", "", "(Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;Landroid/app/Application;J)V", "TAG", "", "value", "Lcom/amazonaws/services/chime/sdk/meetings/ingestion/AppState;", "_appState", "set_appState", "(Lcom/amazonaws/services/chime/sdk/meetings/ingestion/AppState;)V", "appState", "getAppState", "()Lcom/amazonaws/services/chime/sdk/meetings/ingestion/AppState;", "handler", "Lcom/amazonaws/services/chime/sdk/meetings/ingestion/AppStateHandler;", "isMemoryMonitoringActive", "", "memoryCheckRunnable", "Ljava/lang/Runnable;", "memoryHandler", "Landroid/os/Handler;", "shouldPostEvent", "bindHandler", "", "checkMemoryStatus", "getBatteryLevel", "", "()Ljava/lang/Float;", "getBatteryState", "Lcom/amazonaws/services/chime/sdk/meetings/ingestion/BatteryState;", "onCreate", "owner", "Landroidx/lifecycle/LifecycleOwner;", "onDestroy", "onPause", "onResume", "onStart", "onStop", "start", "startMemoryMonitoring", "stop", "stopMemoryMonitoring", "amazon-chime-sdk_release"})
@SourceDebugExtension(value={"SMAP\nDefaultAppStateMonitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultAppStateMonitor.kt\ncom/amazonaws/services/chime/sdk/meetings/ingestion/DefaultAppStateMonitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,211:1\n1#2:212\n*E\n"})
public final class DefaultAppStateMonitor
implements AppStateMonitor,
DefaultLifecycleObserver {
    @NotNull
    private final Logger logger;
    @Nullable
    private final Application application;
    private final long memoryCheckIntervalMs;
    @NotNull
    private final String TAG;
    @Nullable
    private AppStateHandler handler;
    private boolean shouldPostEvent;
    @NotNull
    private final Handler memoryHandler;
    @Nullable
    private Runnable memoryCheckRunnable;
    private boolean isMemoryMonitoringActive;
    @NotNull
    private AppState _appState;

    public DefaultAppStateMonitor(@NotNull Logger logger, @Nullable Application application, long memoryCheckIntervalMs) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        this.application = application;
        this.memoryCheckIntervalMs = memoryCheckIntervalMs;
        this.TAG = "DefaultAppStateMonitor";
        this.memoryHandler = new Handler(Looper.getMainLooper());
        this._appState = AppState.INACTIVE;
    }

    public /* synthetic */ DefaultAppStateMonitor(Logger logger, Application application, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            application = null;
        }
        if ((n & 4) != 0) {
            l = 5000L;
        }
        this(logger, application, l);
    }

    private final void set_appState(AppState value) {
        block1: {
            this._appState = value;
            this.logger.info(this.TAG, "Application entered state: " + value.getDescription());
            if (!this.shouldPostEvent) break block1;
            AppStateHandler appStateHandler = this.handler;
            if (appStateHandler != null) {
                appStateHandler.onAppStateChanged(value);
            }
        }
    }

    @Override
    @NotNull
    public AppState getAppState() {
        return this._appState;
    }

    @Override
    public void bindHandler(@NotNull AppStateHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.handler = handler;
    }

    @Override
    public void start() {
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getMain())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DefaultAppStateMonitor this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ProcessLifecycleOwner.Companion.get().getLifecycle().removeObserver((LifecycleObserver)this.this$0);
                        DefaultAppStateMonitor.access$stopMemoryMonitoring(this.this$0);
                        DefaultAppStateMonitor.access$setShouldPostEvent$p(this.this$0, true);
                        ProcessLifecycleOwner.Companion.get().getLifecycle().addObserver((LifecycleObserver)this.this$0);
                        DefaultAppStateMonitor.access$startMemoryMonitoring(this.this$0);
                        DefaultAppStateMonitor.access$getLogger$p(this.this$0).info(DefaultAppStateMonitor.access$getTAG$p(this.this$0), "Started monitoring app state and memory");
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    public void stop() {
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getMain())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DefaultAppStateMonitor this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        DefaultAppStateMonitor.access$setShouldPostEvent$p(this.this$0, false);
                        ProcessLifecycleOwner.Companion.get().getLifecycle().removeObserver((LifecycleObserver)this.this$0);
                        DefaultAppStateMonitor.access$stopMemoryMonitoring(this.this$0);
                        DefaultAppStateMonitor.access$getLogger$p(this.this$0).info(DefaultAppStateMonitor.access$getTAG$p(this.this$0), "Stopped monitoring app state and memory");
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public void onCreate(@NotNull LifecycleOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
    }

    public void onDestroy(@NotNull LifecycleOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
    }

    public void onStart(@NotNull LifecycleOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        this.set_appState(AppState.FOREGROUND);
    }

    public void onResume(@NotNull LifecycleOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        this.set_appState(AppState.ACTIVE);
    }

    public void onPause(@NotNull LifecycleOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        this.set_appState(AppState.INACTIVE);
    }

    public void onStop(@NotNull LifecycleOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        this.set_appState(AppState.BACKGROUND);
    }

    private final void startMemoryMonitoring() {
        if (this.isMemoryMonitoringActive) {
            return;
        }
        this.isMemoryMonitoringActive = true;
        Runnable runnable = this.memoryCheckRunnable = (Runnable)new Runnable(this){
            final /* synthetic */ DefaultAppStateMonitor this$0;
            {
                this.this$0 = $receiver;
            }

            public void run() {
                if (DefaultAppStateMonitor.access$isMemoryMonitoringActive$p(this.this$0)) {
                    DefaultAppStateMonitor.access$checkMemoryStatus(this.this$0);
                    DefaultAppStateMonitor.access$getMemoryHandler$p(this.this$0).postDelayed((Runnable)this, DefaultAppStateMonitor.access$getMemoryCheckIntervalMs$p(this.this$0));
                }
            }
        };
        if (runnable != null) {
            Runnable it = runnable;
            boolean bl = false;
            this.memoryHandler.post(it);
        }
        this.logger.info(this.TAG, "Started continuous memory monitoring (interval: " + this.memoryCheckIntervalMs + "ms)");
    }

    private final void stopMemoryMonitoring() {
        if (!this.isMemoryMonitoringActive) {
            return;
        }
        this.isMemoryMonitoringActive = false;
        Runnable runnable = this.memoryCheckRunnable;
        if (runnable != null) {
            Runnable it = runnable;
            boolean bl = false;
            this.memoryHandler.removeCallbacks(it);
        }
        this.memoryCheckRunnable = null;
        this.logger.info(this.TAG, "Stopped continuous memory monitoring");
    }

    private final void checkMemoryStatus() {
        block3: {
            ActivityManager activityManager;
            Application application = this.application;
            if (application == null) break block3;
            Application app = application;
            boolean bl = false;
            Object object = app.getSystemService("activity");
            ActivityManager activityManager2 = activityManager = object instanceof ActivityManager ? (ActivityManager)object : null;
            if (activityManager2 != null) {
                ActivityManager am = activityManager2;
                boolean bl2 = false;
                ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
                am.getMemoryInfo(memoryInfo);
                if (memoryInfo.lowMemory) {
                    this.logger.info(this.TAG, "Application detected low memory condition (available: " + memoryInfo.availMem / (long)(1024 * 1024) + "MB, threshold: " + memoryInfo.threshold / (long)(1024 * 1024) + "MB)");
                    AppStateHandler appStateHandler = this.handler;
                    if (appStateHandler != null) {
                        appStateHandler.onMemoryWarning();
                    }
                }
            }
        }
    }

    @Override
    @Nullable
    public Float getBatteryLevel() {
        Application application;
        block11: {
            block8: {
                Object object;
                block10: {
                    block9: {
                        Float f;
                        application = this.application;
                        if (application == null) break block8;
                        Application app = application;
                        boolean bl = false;
                        Object object2 = app.getSystemService("batterymanager");
                        BatteryManager batteryManager = object2 instanceof BatteryManager ? (BatteryManager)object2 : null;
                        object = batteryManager;
                        if (object == null) break block9;
                        BatteryManager bm = object;
                        boolean bl2 = false;
                        int batteryLevel = bm.getIntProperty(4);
                        boolean bl3 = 0 <= batteryLevel ? batteryLevel < 101 : false;
                        if (bl3) {
                            f = Float.valueOf((float)batteryLevel / 100.0f);
                        } else {
                            this.logger.warn(this.TAG, "Invalid battery level from BatteryManager: " + batteryLevel);
                            f = null;
                        }
                        object = f;
                        if (f != null) break block10;
                    }
                    DefaultAppStateMonitor $this$getBatteryLevel_u24lambda_u246_u24lambda_u245 = this;
                    boolean bl = false;
                    $this$getBatteryLevel_u24lambda_u246_u24lambda_u245.logger.warn($this$getBatteryLevel_u24lambda_u246_u24lambda_u245.TAG, "BatteryManager service not available");
                    object = null;
                }
                application = object;
                if (object != null) break block11;
            }
            DefaultAppStateMonitor $this$getBatteryLevel_u24lambda_u247 = this;
            boolean bl = false;
            $this$getBatteryLevel_u24lambda_u247.logger.warn($this$getBatteryLevel_u24lambda_u247.TAG, "Application context not available for battery level check");
            application = null;
        }
        return application;
    }

    @Override
    @NotNull
    public BatteryState getBatteryState() {
        Object object;
        block14: {
            block11: {
                Object object2;
                block13: {
                    block12: {
                        BatteryState batteryState;
                        object = this.application;
                        if (object == null) break block11;
                        Application app = object;
                        boolean bl = false;
                        Object object3 = app.getSystemService("batterymanager");
                        BatteryManager batteryManager = object3 instanceof BatteryManager ? (BatteryManager)object3 : null;
                        object2 = batteryManager;
                        if (object2 == null) break block12;
                        BatteryManager bm = object2;
                        boolean bl2 = false;
                        int status = bm.getIntProperty(6);
                        switch (status) {
                            case 2: {
                                batteryState = BatteryState.CHARGING;
                                break;
                            }
                            case 3: {
                                batteryState = BatteryState.DISCHARGING;
                                break;
                            }
                            case 4: {
                                batteryState = BatteryState.NOT_CHARGING;
                                break;
                            }
                            case 5: {
                                batteryState = BatteryState.FULL;
                                break;
                            }
                            case 1: {
                                batteryState = BatteryState.UNKNOWN;
                                break;
                            }
                            default: {
                                this.logger.warn(this.TAG, "Unknown battery status from BatteryManager: " + status);
                                batteryState = BatteryState.UNKNOWN;
                            }
                        }
                        object2 = batteryState;
                        if (batteryState != null) break block13;
                    }
                    DefaultAppStateMonitor $this$getBatteryState_u24lambda_u2410_u24lambda_u249 = this;
                    boolean bl = false;
                    $this$getBatteryState_u24lambda_u2410_u24lambda_u249.logger.warn($this$getBatteryState_u24lambda_u2410_u24lambda_u249.TAG, "BatteryManager service not available");
                    object2 = BatteryState.UNKNOWN;
                }
                object = object2;
                if (object2 != null) break block14;
            }
            DefaultAppStateMonitor $this$getBatteryState_u24lambda_u2411 = this;
            boolean bl = false;
            $this$getBatteryState_u24lambda_u2411.logger.warn($this$getBatteryState_u24lambda_u2411.TAG, "Application context not available for battery state check");
            object = BatteryState.UNKNOWN;
        }
        return object;
    }

    public static final /* synthetic */ void access$stopMemoryMonitoring(DefaultAppStateMonitor $this) {
        $this.stopMemoryMonitoring();
    }

    public static final /* synthetic */ void access$setShouldPostEvent$p(DefaultAppStateMonitor $this, boolean bl) {
        $this.shouldPostEvent = bl;
    }

    public static final /* synthetic */ void access$startMemoryMonitoring(DefaultAppStateMonitor $this) {
        $this.startMemoryMonitoring();
    }

    public static final /* synthetic */ Logger access$getLogger$p(DefaultAppStateMonitor $this) {
        return $this.logger;
    }

    public static final /* synthetic */ String access$getTAG$p(DefaultAppStateMonitor $this) {
        return $this.TAG;
    }

    public static final /* synthetic */ boolean access$isMemoryMonitoringActive$p(DefaultAppStateMonitor $this) {
        return $this.isMemoryMonitoringActive;
    }

    public static final /* synthetic */ void access$checkMemoryStatus(DefaultAppStateMonitor $this) {
        $this.checkMemoryStatus();
    }

    public static final /* synthetic */ Handler access$getMemoryHandler$p(DefaultAppStateMonitor $this) {
        return $this.memoryHandler;
    }

    public static final /* synthetic */ long access$getMemoryCheckIntervalMs$p(DefaultAppStateMonitor $this) {
        return $this.memoryCheckIntervalMs;
    }
}

