/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.device;

import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.util.Range;
import android.util.Size;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.capture.VideoCaptureFormat;
import com.amazonaws.services.chime.sdk.meetings.device.MediaDeviceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J)\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\fH\u00d6\u0001J\b\u0010\u0019\u001a\u00020\u0003H\u0016R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/device/MediaDevice;", "", "label", "", "type", "Lcom/amazonaws/services/chime/sdk/meetings/device/MediaDeviceType;", "id", "(Ljava/lang/String;Lcom/amazonaws/services/chime/sdk/meetings/device/MediaDeviceType;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getLabel", "order", "", "getOrder", "()I", "getType", "()Lcom/amazonaws/services/chime/sdk/meetings/device/MediaDeviceType;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "Companion", "amazon-chime-sdk_release"})
public final class MediaDevice {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String label;
    @NotNull
    private final MediaDeviceType type;
    @Nullable
    private final String id;
    private final int order;
    private static final int DEFAULT_MAX_VIDEO_FORMAT_FPS = 30;
    private static final int DEFAULT_MAX_VIDEO_WIDTH = 1280;
    private static final int DEFAULT_MAX_VIDEO_HEIGHT = 720;

    public MediaDevice(@NotNull String label, @NotNull MediaDeviceType type, @Nullable String id) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.label = label;
        this.type = type;
        this.id = id;
        this.order = switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1 -> 0;
            case 2 -> 1;
            case 3 -> 1;
            case 4 -> 2;
            case 5 -> 3;
            case 6 -> 4;
            case 7 -> 5;
            case 8 -> 6;
            default -> 99;
        };
    }

    public /* synthetic */ MediaDevice(String string, MediaDeviceType mediaDeviceType, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        this(string, mediaDeviceType, string2);
    }

    @NotNull
    public final String getLabel() {
        return this.label;
    }

    @NotNull
    public final MediaDeviceType getType() {
        return this.type;
    }

    @Nullable
    public final String getId() {
        return this.id;
    }

    public final int getOrder() {
        return this.order;
    }

    @NotNull
    public String toString() {
        return this.label;
    }

    @NotNull
    public final String component1() {
        return this.label;
    }

    @NotNull
    public final MediaDeviceType component2() {
        return this.type;
    }

    @Nullable
    public final String component3() {
        return this.id;
    }

    @NotNull
    public final MediaDevice copy(@NotNull String label, @NotNull MediaDeviceType type, @Nullable String id) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return new MediaDevice(label, type, id);
    }

    public static /* synthetic */ MediaDevice copy$default(MediaDevice mediaDevice, String string, MediaDeviceType mediaDeviceType, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = mediaDevice.label;
        }
        if ((n & 2) != 0) {
            mediaDeviceType = mediaDevice.type;
        }
        if ((n & 4) != 0) {
            string2 = mediaDevice.id;
        }
        return mediaDevice.copy(string, mediaDeviceType, string2);
    }

    public int hashCode() {
        int result = this.label.hashCode();
        result = result * 31 + this.type.hashCode();
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MediaDevice)) {
            return false;
        }
        MediaDevice mediaDevice = (MediaDevice)other;
        if (!Intrinsics.areEqual((Object)this.label, (Object)mediaDevice.label)) {
            return false;
        }
        if (this.type != mediaDevice.type) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.id, (Object)mediaDevice.id);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u00042\b\b\u0002\u0010\u000f\u001a\u00020\u00042\b\b\u0002\u0010\u0010\u001a\u00020\u0004J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\b2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/device/MediaDevice$Companion;", "", "()V", "DEFAULT_MAX_VIDEO_FORMAT_FPS", "", "DEFAULT_MAX_VIDEO_HEIGHT", "DEFAULT_MAX_VIDEO_WIDTH", "listSupportedVideoCaptureFormats", "", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/VideoCaptureFormat;", "cameraManager", "Landroid/hardware/camera2/CameraManager;", "mediaDevice", "Lcom/amazonaws/services/chime/sdk/meetings/device/MediaDevice;", "maxVideoFps", "maxVideoWidth", "maxVideoHeight", "listVideoDevices", "amazon-chime-sdk_release"})
    @SourceDebugExtension(value={"SMAP\nMediaDevice.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MediaDevice.kt\ncom/amazonaws/services/chime/sdk/meetings/device/MediaDevice$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,150:1\n11165#2:151\n11500#2,3:152\n11165#2:155\n11500#2,3:156\n3829#2:162\n4344#2,2:163\n774#3:159\n865#3,2:160\n1557#3:165\n1628#3,3:166\n*S KotlinDebug\n*F\n+ 1 MediaDevice.kt\ncom/amazonaws/services/chime/sdk/meetings/device/MediaDevice$Companion\n*L\n55#1:151\n55#1:152,3\n83#1:155\n83#1:156,3\n90#1:162\n90#1:163,2\n83#1:159\n83#1:160,2\n92#1:165\n92#1:166,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<MediaDevice> listVideoDevices(@NotNull CameraManager cameraManager) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)cameraManager, (String)"cameraManager");
            String[] stringArray = cameraManager.getCameraIdList();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getCameraIdList(...)");
            Object[] $this$map$iv = stringArray;
            boolean $i$f$map = false;
            Object[] objectArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                MediaDevice mediaDevice;
                CameraCharacteristics characteristics;
                void id;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)cameraManager.getCameraCharacteristics((String)id), (String)"getCameraCharacteristics(...)");
                if ((Integer)characteristics.get(CameraCharacteristics.LENS_FACING) != null) {
                    Integer it;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    MediaDeviceType type = MediaDeviceType.Companion.fromCameraMetadata(it);
                    mediaDevice = new MediaDevice((String)id + " (" + type + ")", type, (String)id);
                } else {
                    mediaDevice = new MediaDevice((String)id + " (" + MediaDeviceType.Companion + ".OTHER)", MediaDeviceType.OTHER, (String)id);
                }
                collection.add(mediaDevice);
            }
            return (List)destination$iv$iv;
        }

        /*
         * Could not resolve type clashes
         * Unable to fully structure code
         */
        @NotNull
        public final List<VideoCaptureFormat> listSupportedVideoCaptureFormats(@NotNull CameraManager cameraManager, @NotNull MediaDevice mediaDevice, int maxVideoFps, int maxVideoWidth, int maxVideoHeight) {
            Intrinsics.checkNotNullParameter((Object)cameraManager, (String)"cameraManager");
            Intrinsics.checkNotNullParameter((Object)mediaDevice, (String)"mediaDevice");
            v0 = mediaDevice.getId();
            if (v0 == null) {
                return CollectionsKt.emptyList();
            }
            v1 = cameraManager.getCameraCharacteristics(v0);
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getCameraCharacteristics(...)");
            characteristics = v1;
            var8_7 = (Range[])characteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
            if (var8_7 == null) ** GOTO lbl-1000
            var10_8 = var8_7;
            $i$f$map = false;
            var12_11 = $this$map$iv;
            destination$iv$iv = new ArrayList<E>($this$map$iv.length);
            $i$f$mapTo = false;
            var16_17 = ((void)$this$mapTo$iv$iv).length;
            for (var15_16 = 0; var15_16 < var16_17; ++var15_16) {
                var18_24 = item$iv$iv = $this$mapTo$iv$iv[var15_16];
                var21_28 = destination$iv$iv;
                $i$a$-map-MediaDevice$Companion$listSupportedVideoCaptureFormats$fps$1 = false;
                var21_28.add((Integer)it.getUpper());
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv /* !! */ ) {
                it = (Integer)element$iv$iv;
                $i$a$-filter-MediaDevice$Companion$listSupportedVideoCaptureFormats$fps$2 = false;
                Intrinsics.checkNotNull((Object)it);
                if (!(it <= maxVideoFps)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (Integer)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
            if ($this$filter$iv != null) {
                v2 = $this$filter$iv.intValue();
            } else lbl-1000:
            // 2 sources

            {
                v2 = MediaDevice.access$getDEFAULT_MAX_VIDEO_FORMAT_FPS$cp();
            }
            fps = v2;
            v3 = (StreamConfigurationMap)characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            if (v3 == null) {
                return CollectionsKt.emptyList();
            }
            streamMap = v3;
            $this$map$iv = streamMap.getOutputSizes(SurfaceTexture.class);
            if ($this$map$iv == null) {
                return CollectionsKt.emptyList();
            }
            nativeSizes = $this$map$iv;
            $this$filter$iv = nativeSizes;
            $i$f$filter = false;
            $this$filterTo$iv$iv /* !! */  = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            element$iv$iv = $this$filterTo$iv$iv /* !! */ .length;
            for (var16_19 = 0; var16_19 < element$iv$iv; ++var16_19) {
                it = element$iv$iv = $this$filterTo$iv$iv /* !! */ [var16_19];
                $i$a$-filter-MediaDevice$Companion$listSupportedVideoCaptureFormats$filteredList$1 = false;
                if (!(it.getWidth() <= maxVideoWidth && it.getHeight() <= maxVideoHeight)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            filteredList = (List)destination$iv$iv;
            $this$map$iv = filteredList;
            $i$f$map = false;
            $this$filterTo$iv$iv /* !! */  = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                element$iv$iv = (Size)item$iv$iv;
                var21_28 = destination$iv$iv;
                $i$a$-map-MediaDevice$Companion$listSupportedVideoCaptureFormats$1 = false;
                var21_28.add(new VideoCaptureFormat(size.getWidth(), size.getHeight(), fps));
            }
            return (List)destination$iv$iv;
        }

        public static /* synthetic */ List listSupportedVideoCaptureFormats$default(Companion companion, CameraManager cameraManager, MediaDevice mediaDevice, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 4) != 0) {
                n = DEFAULT_MAX_VIDEO_FORMAT_FPS;
            }
            if ((n4 & 8) != 0) {
                n2 = DEFAULT_MAX_VIDEO_WIDTH;
            }
            if ((n4 & 0x10) != 0) {
                n3 = DEFAULT_MAX_VIDEO_HEIGHT;
            }
            return companion.listSupportedVideoCaptureFormats(cameraManager, mediaDevice, n, n2, n3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MediaDeviceType.values().length];
            try {
                nArray[MediaDeviceType.AUDIO_BLUETOOTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MediaDeviceType.AUDIO_WIRED_HEADSET.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MediaDeviceType.AUDIO_USB_HEADSET.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MediaDeviceType.AUDIO_BUILTIN_SPEAKER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MediaDeviceType.AUDIO_HANDSET.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MediaDeviceType.VIDEO_FRONT_CAMERA.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MediaDeviceType.VIDEO_BACK_CAMERA.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MediaDeviceType.VIDEO_EXTERNAL_CAMERA.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

