/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.audiovideo.video;

import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoFrame;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoPauseState;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoRenderView;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoTile;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoTileState;
import com.amazonaws.services.chime.sdk.meetings.utils.logger.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u001bH\u0016R\u000e\u0010\r\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006#"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/DefaultVideoTile;", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoTile;", "logger", "Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;", "tileId", "", "attendeeId", "", "videoStreamContentWidth", "videoStreamContentHeight", "isLocalTile", "", "(Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;ILjava/lang/String;IIZ)V", "TAG", "state", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoTileState;", "getState", "()Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoTileState;", "setState", "(Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoTileState;)V", "videoRenderView", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoRenderView;", "getVideoRenderView", "()Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoRenderView;", "setVideoRenderView", "(Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoRenderView;)V", "bind", "", "onVideoFrameReceived", "frame", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoFrame;", "setPauseState", "pauseState", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoPauseState;", "unbind", "amazon-chime-sdk_release"})
public final class DefaultVideoTile
implements VideoTile {
    @NotNull
    private final Logger logger;
    @NotNull
    private final String TAG;
    @NotNull
    private VideoTileState state;
    @Nullable
    private VideoRenderView videoRenderView;

    public DefaultVideoTile(@NotNull Logger logger, int tileId, @NotNull String attendeeId, int videoStreamContentWidth, int videoStreamContentHeight, boolean isLocalTile) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)attendeeId, (String)"attendeeId");
        this.logger = logger;
        this.TAG = "DefaultVideoTile";
        this.state = new VideoTileState(tileId, attendeeId, videoStreamContentWidth, videoStreamContentHeight, VideoPauseState.Unpaused, isLocalTile);
    }

    @Override
    @NotNull
    public VideoTileState getState() {
        return this.state;
    }

    @Override
    public void setState(@NotNull VideoTileState videoTileState) {
        Intrinsics.checkNotNullParameter((Object)videoTileState, (String)"<set-?>");
        this.state = videoTileState;
    }

    @Override
    @Nullable
    public VideoRenderView getVideoRenderView() {
        return this.videoRenderView;
    }

    @Override
    public void setVideoRenderView(@Nullable VideoRenderView videoRenderView) {
        this.videoRenderView = videoRenderView;
    }

    @Override
    public void bind(@Nullable VideoRenderView videoRenderView) {
        this.logger.info(this.TAG, "Binding the View to Tile");
        this.setVideoRenderView(videoRenderView);
    }

    @Override
    public void onVideoFrameReceived(@NotNull VideoFrame frame) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            VideoRenderView videoRenderView = this.getVideoRenderView();
            if (videoRenderView == null) break block0;
            videoRenderView.onVideoFrameReceived(frame);
        }
    }

    @Override
    public void unbind() {
        this.logger.info(this.TAG, "Unbinding the View from Tile");
        this.setVideoRenderView(null);
    }

    @Override
    public void setPauseState(@NotNull VideoPauseState pauseState) {
        Intrinsics.checkNotNullParameter((Object)((Object)pauseState), (String)"pauseState");
        this.getState().setPauseState(pauseState);
    }
}

